/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.formservice.revcfm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.QuotationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.impt.AbstractBillImport;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;

public class RevCfmBillImportHelper
extends AbstractBillImport {
    protected Map<Long, Date> cachedDate = new HashMap<Long, Date>(8);
    private QuotationHelper quotationHelper;
    protected String isMaterial = "null";
    private Map<String, BigDecimal> convertRateMap = new HashMap<String, BigDecimal>(8);
    private final List<String> headFields = this.headRemoveFields();
    private final List<String> entryFields = this.entryRemoveFields();

    private QuotationHelper getQuotationHelper() {
        if (this.quotationHelper == null) {
            this.quotationHelper = new QuotationHelper();
        }
        return this.quotationHelper;
    }

    public RevCfmBillImportHelper(IDataModel model, IPageCache pageCache) {
        this.model = model;
        this.pageCache = pageCache;
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        if (e.getOption().get("importtype") != null) {
            this.isExcel = true;
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        boolean includetax = sourceData.get("isincludetax") != null ? (Boolean)sourceData.get("isincludetax") : false;
        boolean ispricetotal = sourceData.get("ispricetotal") != null ? (Boolean)sourceData.get("ispricetotal") : false;
        this.checkNull("currency", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01", (String)"RevCfmBillImportHelper_13", (String)"fi-ar-formplugin", (Object[])new Object[0]), sourceData);
        this.removeNoAssignField(sourceData, this.headFields);
        this.checkOrgF7NULL("org", ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7", (String)"RevCfmBillImportHelper_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), true, sourceData);
        this.checkConfirmWay(sourceData);
        List entryList = null;
        if (sourceData.get("entry") != null) {
            entryList = (List)sourceData.get("entry");
        }
        if (entryList != null) {
            for (int i = 0; i < entryList.size(); ++i) {
                Map entry = (Map)entryList.get(i);
                boolean ispresent = entry.get("e_ispresent") != null ? (Boolean)entry.get("e_ispresent") : false;
                this.checkPriceandAmount(ispresent, includetax, ispricetotal, entry, i);
                this.removeNoAssignField(entry, this.entryFields);
                this.checkDiscountmode(entry, i);
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        Map sourceDate = e.getSourceData();
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        if (ObjectUtils.isEmpty((Object)org)) {
            return;
        }
        Long orgPk = (Long)org.getPkValue();
        this.init = (InitHelper)this.initMap.get(orgPk);
        if (ObjectUtils.isEmpty((Object)this.init)) {
            this.init = new InitHelper(orgPk.longValue(), "ar_init");
            this.initMap.put(orgPk, this.init);
        }
        if (ObjectUtils.isEmpty((Object)this.init.getInit())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7ec4\u7ec7\u7684\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"RevCfmBillImportHelper_1", (String)"fi-ar-formplugin", (Object[])new Object[0]), org.getString("name")));
        }
        this.init.checkInit();
        BookDateHelper.checkBookDate((IDataModel)this.model, (boolean)true, (Map)this.cacheDateMap, (InitHelper)this.init);
        DynamicObject currency = (DynamicObject)this.model.getValue("currency");
        if (ObjectUtils.isEmpty((Object)currency)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RevCfmBillImportHelper_15", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
        this.createByInit();
        this.calculatorAmt(this.model);
    }

    private void checkDiscountmode(Map entry, int index) {
        String discountMode = (String)entry.get("e_discountmode");
        if ("PERCENT".equals(discountMode)) {
            BigDecimal discountRate = RevCfmBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_discountrate");
            if (discountRate.compareTo(BigDecimal.valueOf(100L)) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387\u201d\u65f6\uff0c\u6298\u6263\u7387\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"RevCfmBillImportHelper_2", (String)"fi-ar-formplugin", (Object[])new Object[]{index + 1}));
            }
        } else if ("PERUNIT".equals(discountMode)) {
            BigDecimal discountRate = RevCfmBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_discountrate");
            BigDecimal unitPrice = RevCfmBillImportHelper.getEntryBigDecimal((Map)entry, (String)"e_unitprice");
            if (unitPrice.compareTo(discountRate) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263\uff08\u7387\uff09\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u5355\u4ef7\u3002", (String)"RevCfmBillImportHelper_3", (String)"fi-ar-formplugin", (Object[])new Object[]{index + 1}));
            }
        } else if ("NULL".equals(discountMode)) {
            entry.remove("e_discountmode");
        }
    }

    private String checkOrgF7NULL(String key, String title, boolean required, Map data) {
        Map value = null;
        if (data.get(key) != null) {
            value = (Map)data.get(key);
        }
        if (value == null || value.get("number") == null && value.get("name") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8865\u5145%s\u3002", (String)"RevCfmBillImportHelper_4", (String)"fi-ar-formplugin", (Object[])new Object[]{title}));
        }
        return null;
    }

    private void createByInit() {
        DynamicObject cur = this.init.getStandardCurrency();
        this.model.setValue("basecurrency", cur.getPkValue());
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exchangerate")) || BigDecimal.ZERO.compareTo((BigDecimal)this.model.getValue("exchangerate")) == 0) {
            this.model.setValue("exchangerate", (Object)1);
        }
        if (ObjectUtils.isEmpty((Object)this.model.getValue("exratetable"))) {
            this.model.setValue("exratetable", this.init.getExrateTable().getPkValue());
        }
        FormServiceHelper.checkMeasureUnitRange((IDataModel)this.model, (String)"entry", (String)"e_material", (String)"e_measureunit");
        DynamicObject srcCurrency = (DynamicObject)this.model.getValue("currency");
        DynamicObject destCurrency = (DynamicObject)this.model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)srcCurrency) && !ObjectUtils.isEmpty((Object)destCurrency) && srcCurrency.getPkValue().equals(destCurrency.getPkValue())) {
            this.model.setValue("exchangerate", (Object)BigDecimal.ONE);
            this.model.setValue("quotation", (Object)"0");
        } else {
            this.getQuotationHelper().getExchangeRate4Import(this.model);
        }
    }

    private void checkConfirmWay(Map data) {
        String confirmWay = (String)data.get("confirmway");
        if ("RATE".equals(confirmWay)) {
            BigDecimal confirmRate = BigDecimal.valueOf(100L);
            if (data.get("confirmrate") != null) {
                confirmRate = new BigDecimal(data.get("confirmrate").toString());
            }
            if (confirmRate.compareTo(BigDecimal.ZERO) < 0 || confirmRate.compareTo(new BigDecimal("100")) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u786e\u8ba4\u6bd4\u7387%\u201d\u8d85\u51fa\u6570\u503c\u8303\u56f4\uff0c\u8bf7\u8f93\u51650\u81f3100\u4e4b\u95f4\u7684\u6570\u503c\u3002", (String)"RevCfmBillImportHelper_5", (String)"fi-ar-formplugin", (Object[])new Object[0]));
            }
        } else {
            data.remove("confirmrate");
        }
    }

    private void calculatorAmt(IDataModel model) {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxlocamt = BigDecimal.ZERO;
        BigDecimal pricetaxtotal = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal confirmAmt = BigDecimal.ZERO;
        BigDecimal confirmLocAmt = BigDecimal.ZERO;
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        int iCount = model.getEntryEntity("entry").size();
        Boolean includeTax = (Boolean)model.getValue("isincludetax");
        for (int i = 0; i < iCount; ++i) {
            Object disCountType = model.getValue("e_discountmode", i);
            BigDecimal disCountAmt = (BigDecimal)model.getValue("e_discountamount", i);
            BigDecimal qty = (BigDecimal)model.getValue("e_quantity", i);
            BigDecimal taxRate = (BigDecimal)model.getValue("e_taxrate", i);
            taxRate = taxRate.divide(BigDecimal.valueOf(100L));
            int pricePrecision = 4;
            if (DiscountModeEnum.NULL.getValue().equals(model.getValue("e_discountmode", i)) || DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
            } else if (DiscountModeEnum.TOTAL.getValue().equals(disCountType) && disCountAmt.compareTo(BigDecimal.ZERO) != 0) {
                if (currency != null) {
                    pricePrecision = currency.getInt("priceprecision");
                }
                BigDecimal discountRate = includeTax != false ? disCountAmt.divide(qty, pricePrecision, RoundingMode.HALF_UP) : disCountAmt.divide(qty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.add(taxRate), pricePrecision, RoundingMode.HALF_UP);
                model.setValue("e_discountrate", (Object)discountRate, i);
            }
            Boolean isPresent = (Boolean)model.getValue("e_ispresent", i);
            if (isPresent != null && isPresent.booleanValue()) {
                BigDecimal unitPrice = (BigDecimal)model.getValue("e_unitprice", i);
                if (BigDecimal.ZERO.compareTo(unitPrice) == 0) {
                    model.setValue("e_discountmode", (Object)"NULL", i);
                    model.setValue("e_discountrate", (Object)BigDecimal.ZERO, i);
                } else {
                    model.setValue("e_discountmode", (Object)"PERCENT", i);
                    model.setValue("e_discountrate", (Object)new BigDecimal(100), i);
                }
            }
            this.calculatorEntryAmt(model, i);
            amount = amount.add((BigDecimal)model.getValue("e_amount", i));
            localAmt = localAmt.add((BigDecimal)model.getValue("e_localamt", i));
            tax = tax.add((BigDecimal)model.getValue("e_tax", i));
            taxlocamt = taxlocamt.add((BigDecimal)model.getValue("e_taxlocalamt", i));
            pricetaxtotal = pricetaxtotal.add((BigDecimal)model.getValue("e_pricetaxtotal", i));
            pricetaxtotalbase = pricetaxtotalbase.add((BigDecimal)model.getValue("e_pricetaxtotalbase", i));
            confirmAmt = confirmAmt.add((BigDecimal)model.getValue("e_confirmamt", i));
            confirmLocAmt = confirmLocAmt.add((BigDecimal)model.getValue("e_confirmlocamt", i));
        }
        model.setValue("amount", (Object)amount);
        model.setValue("localamt", (Object)localAmt);
        model.setValue("tax", (Object)tax);
        model.setValue("taxlocamt", (Object)taxlocamt);
        model.setValue("pricetaxtotal", (Object)pricetaxtotal);
        model.setValue("pricetaxtotalbase", (Object)pricetaxtotalbase);
        model.setValue("confirmamt", (Object)confirmAmt);
        model.setValue("confirmlocamt", (Object)confirmLocAmt);
        model.setValue("unverifyamt", (Object)confirmAmt);
        BigDecimal confirmRate = amount.compareTo(BigDecimal.ZERO) != 0 ? confirmAmt.multiply(BigDecimal.valueOf(100L)).divide(amount, 2, 4) : BigDecimal.valueOf(100L);
        model.setValue("confirmrate", (Object)confirmRate);
    }

    private void calculatorEntryAmt(IDataModel model, int index) {
        this.setRowValue(model, index, true);
        DynamicObject matertialJson = (DynamicObject)model.getValue("e_material", index);
        if (matertialJson != null) {
            BigDecimal convertRate;
            DynamicObject measureUnit = (DynamicObject)model.getValue("e_measureunit", index);
            if (ObjectUtils.isEmpty((Object)measureUnit)) {
                measureUnit = matertialJson.getDynamicObject("baseunit");
                model.setValue("e_measureunit", (Object)measureUnit, index);
            }
            long materialID = (Long)matertialJson.getPkValue();
            long measureUnitID = (Long)measureUnit.getPkValue();
            DynamicObject baseunit = matertialJson.getDynamicObject("baseunit");
            if (!ObjectUtils.isEmpty((Object)baseunit)) {
                long baseUnitID = (Long)baseunit.getPkValue();
                BillModel billModel = BillModelFactory.getModel((String)"ar_revcfmbill");
                model.setValue(billModel.E_BASEUNIT, (Object)baseUnitID, index);
                convertRate = BigDecimal.ONE;
                if (measureUnitID != baseUnitID) {
                    convertRate = this.getConvertRate(materialID, measureUnitID, baseUnitID);
                }
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4%s\u7269\u6599\u7684\u57fa\u672c\u5355\u4f4d\u3002", (String)"RevCfmBillImportHelper_14", (String)"fi-ar-formplugin", (Object[])new Object[0]), matertialJson.getString("name")));
            }
            BigDecimal quantity = (BigDecimal)model.getValue("e_quantity", index);
            model.setValue("e_unitcoefficient", (Object)convertRate, index);
            model.setValue("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)convertRate, (DynamicObject)baseunit), index);
            model.setValue("e_unverifybaseqty", (Object)convertRate.multiply((BigDecimal)model.getValue("e_unverifyqty")), index);
            DynamicObject productline = matertialJson.getDynamicObject("productline");
            if (productline != null && ObjectUtils.isEmpty((Object)model.getValue("e_productline", index))) {
                model.setValue("e_productline", productline.getPkValue(), index);
            }
        }
    }

    private PriceLocalCalculator buildCalculator(IDataModel m, int index) {
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        boolean isPriceTotal = (Boolean)m.getValue("ispricetotal");
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
        BigDecimal discountAmt = (BigDecimal)m.getValue("e_discountamount", index);
        boolean ispresent = (Boolean)m.getValue("e_ispresent", index);
        boolean existProperty = EntityMetadataUtils.isExistProperty((DynamicObject)m.getDataEntity(), (String)"adjustamount");
        BigDecimal adjustamount = BigDecimal.ZERO;
        if (existProperty) {
            adjustamount = (BigDecimal)m.getValue("e_adjustamount", index);
        }
        int precision = 2;
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        int localPrecision = this.getLocalPrecision(m);
        TaxUnitPriceCalculator calculator = null;
        if (includeTax) {
            if (isPriceTotal && !ispresent) {
                BigDecimal recamount = (BigDecimal)m.getValue("e_pricetaxtotal", index);
                calculator = new PriceTaxTotalCalculator(qty, recamount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            } else {
                BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            }
        } else if (isPriceTotal && !ispresent) {
            BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        } else {
            BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        }
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, localPrecision, quotation);
        localCalculator.calculate();
        return localCalculator;
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }

    private void setRowValue(IDataModel m, int index, boolean isCalculatorAmtField) {
        BigDecimal confirmQty;
        BigDecimal confirmRate;
        BigDecimal confirmLocAmt;
        BigDecimal confirmLocTax;
        BigDecimal confirmLocPriceTaxTotal;
        BigDecimal confirmAmt;
        BigDecimal confirmTax;
        BigDecimal confirmPriceTaxTotal;
        boolean isBaseonAmt;
        if (isCalculatorAmtField) {
            PriceLocalCalculator localCalculator = this.buildCalculator(m, index);
            m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
            m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
            m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
            m.setValue("e_amount", (Object)localCalculator.getAmount(), index);
            m.setValue("e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal(), index);
            m.setValue("e_tax", (Object)localCalculator.getTax(), index);
            m.setValue("e_taxlocalamt", (Object)localCalculator.getTaxlocal(), index);
            m.setValue("e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal(), index);
            m.setValue("e_actunitprice", (Object)localCalculator.getActunitprice(), index);
            m.setValue("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice(), index);
            m.setValue("e_localamt", (Object)localCalculator.getAmountlocal(), index);
        }
        BigDecimal rate = (BigDecimal)m.getValue("exchangerate");
        String quotation = (String)m.getValue("quotation");
        if ("1".equals(quotation) && rate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        String confirmWay = (String)m.getValue("confirmway");
        DynamicObject payproperty = (DynamicObject)m.getValue("payproperty");
        boolean bl = isBaseonAmt = payproperty != null && payproperty.getBoolean("isbasedonamt");
        if (isBaseonAmt && "QUANTITY".equals(confirmWay)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6b3e\u9879\u6027\u8d28\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u4e3a\u662f\uff0c\u786e\u8ba4\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u201c\u6309\u6570\u91cf\u201d\u3002", (String)"RevCfmBillImportHelper_12", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (!isBaseonAmt && "AMOUNT".equals(confirmWay)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6b3e\u9879\u6027\u8d28\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u4e3a\u5426\uff0c\u786e\u8ba4\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u201c\u6309\u91d1\u989d\u201d\u3002", (String)"RevCfmBillImportHelper_11", (String)"fi-ar-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        BigDecimal quantity = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal amount = (BigDecimal)m.getValue("e_amount", index);
        BigDecimal pricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
        BigDecimal actunitprice = (BigDecimal)m.getValue("e_actunitprice", index);
        BigDecimal acttaxunitprice = (BigDecimal)m.getValue("e_acttaxunitprice", index);
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        BigDecimal taxrate = ((BigDecimal)m.getValue("e_taxrate", index)).divide(new BigDecimal("100"));
        int precision = this.getPrecision(m);
        int localCurrencyPrecison = this.getLocalPrecision(m);
        if ("AMOUNT".equals(confirmWay)) {
            boolean isPresent = (Boolean)m.getValue("e_ispresent", index);
            if (includeTax) {
                confirmPriceTaxTotal = (BigDecimal)m.getValue("e_cfmpricetax", index);
                if (pricetaxtotal.signum() != confirmPriceTaxTotal.signum() || confirmPriceTaxTotal.abs().compareTo(pricetaxtotal.abs()) > 0) {
                    confirmPriceTaxTotal = pricetaxtotal;
                }
                confirmTax = confirmPriceTaxTotal.multiply(taxrate).divide(BigDecimal.ONE.add(taxrate), precision, RoundingMode.HALF_UP);
                confirmAmt = confirmPriceTaxTotal.subtract(confirmTax);
                confirmLocPriceTaxTotal = this.getLocalAmt(confirmPriceTaxTotal, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocAmt = confirmLocPriceTaxTotal.subtract(confirmLocTax);
            } else {
                confirmAmt = (BigDecimal)m.getValue("e_confirmamt", index);
                if (amount.signum() != confirmAmt.signum() || confirmAmt.abs().compareTo(amount.abs()) > 0) {
                    confirmAmt = amount;
                }
                confirmTax = confirmAmt.multiply(taxrate).setScale(precision, RoundingMode.HALF_UP);
                confirmPriceTaxTotal = confirmAmt.add(confirmTax);
                confirmLocAmt = this.getLocalAmt(confirmAmt, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocPriceTaxTotal = confirmLocAmt.add(confirmLocTax);
            }
            confirmRate = isPresent ? BigDecimal.valueOf(100L) : (amount.compareTo(BigDecimal.ZERO) == 0 ? new BigDecimal(100) : confirmAmt.multiply(BigDecimal.valueOf(100L)).divide(amount, 2, 4));
            confirmQty = quantity.multiply(confirmRate).divide(BigDecimal.valueOf(100L));
            if (isBaseonAmt) {
                confirmQty = quantity;
            }
        } else if ("QUANTITY".equals(confirmWay)) {
            confirmQty = (BigDecimal)m.getValue("e_confirmqty", index);
            if (quantity.signum() != confirmQty.signum() || confirmQty.abs().compareTo(quantity.abs()) > 0) {
                confirmQty = quantity;
            }
            if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                confirmRate = new BigDecimal(100);
                confirmQty = BigDecimal.ZERO;
            } else {
                confirmRate = confirmQty.multiply(BigDecimal.valueOf(100L)).divide(quantity, 2, 4);
            }
            if (includeTax) {
                confirmPriceTaxTotal = confirmQty.multiply(acttaxunitprice).setScale(precision, RoundingMode.HALF_UP);
                confirmTax = confirmPriceTaxTotal.multiply(taxrate).divide(BigDecimal.ONE.add(taxrate), precision, RoundingMode.HALF_UP);
                confirmAmt = confirmPriceTaxTotal.subtract(confirmTax);
                confirmLocPriceTaxTotal = this.getLocalAmt(confirmPriceTaxTotal, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocAmt = confirmLocPriceTaxTotal.subtract(confirmLocTax);
            } else {
                confirmAmt = confirmQty.multiply(actunitprice).setScale(precision, RoundingMode.HALF_UP);
                confirmTax = confirmAmt.multiply(taxrate).setScale(precision, RoundingMode.HALF_UP);
                confirmPriceTaxTotal = confirmAmt.add(confirmTax);
                confirmLocAmt = this.getLocalAmt(confirmAmt, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocPriceTaxTotal = confirmLocAmt.add(confirmLocTax);
            }
        } else {
            confirmRate = (BigDecimal)m.getValue("confirmrate");
            BigDecimal cfmRate = confirmRate.divide(new BigDecimal("100"));
            DynamicObject measureUnit = (DynamicObject)m.getValue("e_measureunit", index);
            BigDecimal bigDecimal = confirmQty = isBaseonAmt ? quantity : quantity.multiply(cfmRate).setScale(UnitConvertHelper.getPrecision((DynamicObject)measureUnit), UnitConvertHelper.getPrecisionType((DynamicObject)measureUnit));
            if (includeTax) {
                confirmPriceTaxTotal = isBaseonAmt || quantity.compareTo(BigDecimal.ZERO) == 0 ? pricetaxtotal.multiply(cfmRate).setScale(precision, RoundingMode.HALF_UP) : confirmQty.multiply(acttaxunitprice).setScale(precision, RoundingMode.HALF_UP);
                confirmTax = confirmPriceTaxTotal.multiply(taxrate).divide(BigDecimal.ONE.add(taxrate), precision, RoundingMode.HALF_UP);
                confirmAmt = confirmPriceTaxTotal.subtract(confirmTax);
                confirmLocPriceTaxTotal = this.getLocalAmt(confirmPriceTaxTotal, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocAmt = confirmLocPriceTaxTotal.subtract(confirmLocTax);
            } else {
                confirmAmt = isBaseonAmt || quantity.compareTo(BigDecimal.ZERO) == 0 ? amount.multiply(cfmRate).setScale(precision, RoundingMode.HALF_UP) : confirmQty.multiply(actunitprice).setScale(precision, RoundingMode.HALF_UP);
                confirmTax = confirmAmt.multiply(taxrate).setScale(precision, RoundingMode.HALF_UP);
                confirmPriceTaxTotal = confirmAmt.add(confirmTax);
                confirmLocAmt = this.getLocalAmt(confirmAmt, quotation, rate, localCurrencyPrecison);
                confirmLocTax = this.getLocalAmt(confirmTax, quotation, rate, localCurrencyPrecison);
                confirmLocPriceTaxTotal = confirmLocAmt.add(confirmLocTax);
            }
        }
        m.setValue("e_confirmqty", (Object)confirmQty, index);
        m.setValue("e_confirmrate", (Object)confirmRate, index);
        m.setValue("e_confirmamt", (Object)confirmAmt, index);
        m.setValue("e_confirmtax", (Object)confirmTax, index);
        m.setValue("e_cfmpricetax", (Object)confirmPriceTaxTotal, index);
        m.setValue("e_confirmlocamt", (Object)confirmLocAmt, index);
        m.setValue("e_confirmloctax", (Object)confirmLocTax, index);
        m.setValue("e_cfmpricetaxbase", (Object)confirmLocPriceTaxTotal, index);
        m.setValue("e_unverifyamt", (Object)confirmAmt, index);
        m.setValue("e_unverifyqty", (Object)confirmQty, index);
        m.setValue("e_unverifybaseqty", (Object)confirmQty.multiply((BigDecimal)m.getValue("e_unitcoefficient", index)), index);
        DynamicObject baseunit = (DynamicObject)m.getValue("e_baseunitid", index);
        BigDecimal unitcoefficient = (BigDecimal)m.getValue("e_unitcoefficient", index);
        BigDecimal confirmBaseQty = UnitConvertHelper.getBaseunitqty((BigDecimal)confirmQty, (BigDecimal)unitcoefficient, (DynamicObject)baseunit);
        String sourceBillType = (String)m.getValue("sourcebilltype");
        if ("ar_finarbill".equals(sourceBillType)) {
            m.setValue("e_unrecqty", (Object)BigDecimal.ZERO, index);
            m.setValue("e_unrecbaseqty", (Object)BigDecimal.ZERO, index);
            m.setValue("e_recqty", (Object)confirmQty, index);
            m.setValue("e_recbaseqty", (Object)confirmBaseQty, index);
            m.setValue("e_unrecamt", (Object)BigDecimal.ZERO, index);
            m.setValue("e_recamt", (Object)confirmAmt, index);
        } else {
            m.setValue("e_unrecqty", (Object)confirmQty, index);
            m.setValue("e_unrecbaseqty", (Object)confirmBaseQty, index);
            m.setValue("e_recqty", (Object)BigDecimal.ZERO, index);
            m.setValue("e_recbaseqty", (Object)BigDecimal.ZERO, index);
            m.setValue("e_unrecamt", (Object)confirmAmt, index);
            m.setValue("e_recamt", (Object)BigDecimal.ZERO, index);
        }
        m.setValue("e_confirmbaseqty", (Object)confirmBaseQty, index);
        m.setValue("e_unverifybaseqty", (Object)confirmBaseQty, index);
    }

    protected int getPrecision(IDataModel model) {
        int precision = 2;
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }

    private int getLocalPrecision(IDataModel model) {
        int localPrecision = 2;
        DynamicObject baseCurrency = (DynamicObject)model.getValue("basecurrency");
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        return localPrecision;
    }

    private BigDecimal getConvertRate(Long materialId, Long srcUnitId, Long desUnitId) {
        String key = materialId + "_" + srcUnitId + "_" + desUnitId;
        BigDecimal value = this.convertRateMap.get(key);
        if (value != null) {
            return value;
        }
        BigDecimal unitRateConv = UnitConvertHelper.getUnitRateConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        this.convertRateMap.put(key, unitRateConv);
        return unitRateConv;
    }

    private void checkPriceandAmount(boolean ispresent, boolean includetax, boolean ispricetotal, Map entry, int index) {
        if (!ispresent) {
            if (includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("e_taxunitprice"), ResManager.loadKDString((String)"\u542b\u7a0e\u5355\u4ef7", (String)"RevCfmBillImportHelper_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && !ispricetotal) {
                this.checkEntryNull(entry.get("e_unitprice"), ResManager.loadKDString((String)"\u5355\u4ef7", (String)"RevCfmBillImportHelper_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            } else if (!includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_amount"), ResManager.loadKDString((String)"\u91d1\u989d", (String)"RevCfmBillImportHelper_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            } else if (includetax && ispricetotal) {
                this.checkEntryNull(entry.get("e_pricetaxtotal"), ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"RevCfmBillImportHelper_9", (String)"fi-ar-formplugin", (Object[])new Object[0]), index + 1);
            }
        }
    }

    private void checkEntryNull(Object value, String title, int index) {
        if (!this.isNull(value)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u4f53\u201d\u7b2c%1$s\u884c\uff0c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RevCfmBillImportHelper_10", (String)"fi-ar-formplugin", (Object[])new Object[0]), index, title));
        }
    }

    private boolean isNull(Object value) {
        boolean notNull = false;
        if (!ObjectUtils.isEmpty((Object)value)) {
            if (value instanceof Map) {
                Map vData = (Map)value;
                String importprop = (String)vData.get("importprop");
                if (StringUtils.isNotEmpty((String)importprop) && StringUtils.isNotEmpty((String)((String)vData.get(importprop)))) {
                    notNull = true;
                } else {
                    String vNum = (String)vData.get("number");
                    String vName = (String)vData.get("name");
                    if (!StringUtils.isEmpty((String)vNum) || !StringUtils.isEmpty((String)vName)) {
                        notNull = true;
                    }
                }
            }
            if (value instanceof String) {
                notNull = true;
            }
            if (value instanceof BigDecimal) {
                notNull = true;
            }
            if (value instanceof Double) {
                notNull = true;
            }
            if (value instanceof Integer) {
                notNull = true;
            }
        }
        return notNull;
    }

    private final List<String> headRemoveFields() {
        ArrayList<String> headFields = new ArrayList<String>(9);
        headFields.add("pricetaxtotal");
        headFields.add("pricetaxtotalbase");
        headFields.add("amount");
        headFields.add("localamt");
        headFields.add("tax");
        headFields.add("taxlocamt");
        headFields.add("unverifyamt");
        headFields.add("confirmamt");
        headFields.add("confirmlocamt");
        headFields.add("quotation");
        return headFields;
    }

    private final List<String> entryRemoveFields() {
        ArrayList<String> entryFields = new ArrayList<String>(18);
        entryFields.add("e_actunitprice");
        entryFields.add("e_acttaxunitprice");
        entryFields.add("e_verifiedamt");
        entryFields.add("e_unverifyamt");
        entryFields.add("e_verifiedqty");
        entryFields.add("e_unverifyqty");
        entryFields.add("e_verifybaseqty");
        entryFields.add("e_unverifybaseqty");
        entryFields.add("e_unrecqty");
        entryFields.add("e_recqty");
        entryFields.add("e_unrecbaseqty");
        entryFields.add("e_recbaseqty");
        entryFields.add("e_recamt");
        entryFields.add("e_unrecamt");
        entryFields.add("e_confirmbaseqty");
        entryFields.add("e_confirmtax");
        entryFields.add("e_confirmloctax");
        entryFields.add("e_cfmpricetax");
        entryFields.add("e_cfmpricetaxbase");
        return entryFields;
    }
}

