/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.enums.DiscountModeEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.impt.BillImportPlugin;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArInvoiceImport
extends BillImportPlugin {
    private static final String BILL_ENABLE = "1";

    public ArInvoiceImport() {
        super(true);
    }

    protected String bizCheck(JSONObject data) {
        String message = null;
        try {
            this.validateData(data);
            this.checkDataUsable(data);
        }
        catch (KDBizException e) {
            message = e.getMessage();
        }
        return message;
    }

    private void validateData(JSONObject data) {
        this.validateBuyer(data);
        this.validateSeller(data);
        this.validateIncludeTax(data);
        this.validateDiscountrate(data);
        this.validateInvoiceStatus(data);
        this.validateInvoiceType(data);
    }

    private void validateInvoiceType(JSONObject data) {
        Object invoicetypef7 = data.get((Object)"invoicetypef7");
        Object invoicetype = data.get((Object)"invoicetype");
        if (ObjectUtils.isEmpty((Object)invoicetype) && ObjectUtils.isEmpty((Object)invoicetypef7)) {
            throw new KDBizException(InvoiceTypeHelper.getValidateInfo());
        }
    }

    private void validateInvoiceStatus(JSONObject data) {
        Object isOffline = data.get((Object)"isoffline");
        boolean offline = EmptyUtils.isEmpty((Object)isOffline) ? false : isOffline.equals(Boolean.TRUE);
        String invoicestatus = data.getString("invoicestatus");
        if (!offline && BILL_ENABLE.equals(invoicestatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u7ebf\u4e0b\u5f00\u7968\u6570\u636e\uff0c\u5f00\u7968\u72b6\u6001\u4e0d\u80fd\u4e3a\u5df2\u5f00\u7968\u3002", (String)"ArInvoiceImport_18", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateDiscountrate(JSONObject data) {
        JSONArray entries = data.getJSONArray("entry");
        for (int i = 0; i < entries.size(); ++i) {
            JSONObject entry = entries.getJSONObject(i);
            entry.remove((Object)"e_diffamount");
            entry.remove((Object)"e_difftax");
            String discountMode = entry.getString("e_discountmode");
            if (!DiscountModeEnum.PERCENT.getValue().equals(discountMode)) {
                return;
            }
            BigDecimal discountTrate = entry.getBigDecimal("e_discountrate");
            if (EmptyUtils.isEmpty((Object)discountTrate)) {
                return;
            }
            if (discountTrate.compareTo(new BigDecimal(100)) <= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6298\u6263\u7387\u4e0b\u5355\u4f4d\u6298\u6263\u7387\u503c\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"ArInvoiceImport_17", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateBuyer(JSONObject data) {
        String buyerName = data.getString("buyername");
        JSONObject buyer = data.getJSONObject("buyer");
        if (EmptyUtils.isEmpty((Object)buyer) && EmptyUtils.isEmpty((Object)buyerName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0\u6570\u636e\u5217\u4e0d\u80fd\u5168\u4e3a\u7a7a\u3002", (String)"ArInvoiceImport_1", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateSeller(JSONObject data) {
        String buyerName = data.getString("sellername");
        JSONObject buyer = data.getJSONObject("seller");
        if (EmptyUtils.isEmpty((Object)buyer) && EmptyUtils.isEmpty((Object)buyerName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u65b9\u540d\u79f0\u6570\u636e\u5217\u4e0d\u80fd\u5168\u4e3a\u7a7a\u3002", (String)"ArInvoiceImport_2", (String)"fi-ar-formplugin", (Object[])new Object[0]));
        }
    }

    private void validateIncludeTax(JSONObject data) {
        String isIncludeTax = data.getString("isincludetax");
        JSONArray entries = data.getJSONArray("entry");
        if (String.valueOf(Boolean.TRUE).equals(isIncludeTax)) {
            entries.stream().map(entry -> (JSONObject)entry).forEach(this::validateRecAmount);
            return;
        }
        entries.stream().map(entry -> (JSONObject)entry).forEach(this::validateUnitPrice);
    }

    private void validateRecAmount(JSONObject entry) {
        boolean isPresent;
        String recAmount = entry.getString("e_recamount");
        boolean bl = isPresent = entry.getBoolean("e_ispresent") != null ? entry.getBoolean("e_ispresent") : false;
        if (!EmptyUtils.isEmpty((Object)recAmount) || isPresent) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u5f55\u5165\u4ef7\u7a0e\u5408\u8ba1\uff0c\u5f55\u5165\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ArInvoiceImport_3", (String)"fi-ar-formplugin", (Object[])new Object[0]));
    }

    private void validateUnitPrice(JSONObject entry) {
        boolean isPresent;
        String recAmount = entry.getString("e_unitprice");
        boolean bl = isPresent = entry.getBoolean("e_ispresent") != null ? entry.getBoolean("e_ispresent") : false;
        if (!EmptyUtils.isEmpty((Object)recAmount) || isPresent) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u5f55\u5165\u4ef7\u7a0e\u5408\u8ba1\uff0c\u8bf7\u8865\u5145\u5355\u4ef7\u3002", (String)"ArInvoiceImport_4", (String)"fi-ar-formplugin", (Object[])new Object[0]));
    }

    private Optional<DynamicObject> getDynamicObjectFromDb(String entityName, String properties, QFilter[] filters) {
        if (filters.length == 0) {
            return Optional.empty();
        }
        DynamicObject result = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)properties, (QFilter[])filters);
        return Optional.ofNullable(result);
    }

    private QFilter[] getQFilter(String entityName, String name, String number) {
        String numberName;
        QFilter filters = null;
        String string = numberName = "bd_operator".equals(entityName) ? "operatornumber" : "number";
        if (!EmptyUtils.isEmpty((Object)number)) {
            filters = new QFilter(numberName, "=", (Object)number);
        }
        if (!EmptyUtils.isEmpty((Object)name)) {
            QFilter nameFilter = new QFilter("name", "=", (Object)name);
            if (filters == null) {
                return nameFilter.toArray();
            }
            filters.and(nameFilter);
        }
        if (filters == null) {
            return new QFilter[0];
        }
        return filters.toArray();
    }

    private void checkDataUsable(JSONObject data) {
        this.checkBaseDataUsable((JSONObject)data.get((Object)"buyer"), ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u4fe1\u606f", (String)"ArInvoiceImport_5", (String)"fi-ar-formplugin", (Object[])new Object[0]), "bd_customer");
        this.checkBaseDataUsable((JSONObject)data.get((Object)"recorg"), ResManager.loadKDString((String)"\u6536\u6b3e\u7ec4\u7ec7\u4fe1\u606f", (String)"ArInvoiceImport_6", (String)"fi-ar-formplugin", (Object[])new Object[0]), "bos_org");
        this.checkBaseDataUsable((JSONObject)data.get((Object)"paycond"), ResManager.loadKDString((String)"\u6536\u6b3e\u6761\u4ef6\u4fe1\u606f", (String)"ArInvoiceImport_13", (String)"fi-ar-formplugin", (Object[])new Object[0]), "bd_reccondition");
        if (!EmptyUtils.isEmpty((Object)data.getString("asstacttype"))) {
            this.checkBaseDataUsable((JSONObject)data.get((Object)"asstact"), ResManager.loadKDString((String)"\u5f80\u6765\u6237\u4fe1\u606f", (String)"ArInvoiceImport_14", (String)"fi-ar-formplugin", (Object[])new Object[0]), data.getString("asstacttype"));
        }
        this.checkBaseDataUsable((JSONObject)data.get((Object)"salesorg"), ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u7ec7\u4fe1\u606f", (String)"ArInvoiceImport_7", (String)"fi-ar-formplugin", (Object[])new Object[0]), "bos_org");
        this.checkBaseDataUsable((JSONObject)data.get((Object)"salesgroup"), ResManager.loadKDString((String)"\u9500\u552e\u7ec4\u4fe1\u606f", (String)"ArInvoiceImport_8", (String)"fi-ar-formplugin", (Object[])new Object[0]), "bd_smoperatorgroup");
        this.checkBaseDataUsable((JSONObject)data.get((Object)"salesman"), ResManager.loadKDString((String)"\u9500\u552e\u5458\u4fe1\u606f", (String)"ArInvoiceImport_9", (String)"fi-ar-formplugin", (Object[])new Object[0]), "bos_user");
        this.checkBaseDataUsable((JSONObject)data.get((Object)"currency"), ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4fe1\u606f", (String)"ArInvoiceImport_10", (String)"fi-ar-formplugin", (Object[])new Object[0]), "bd_currency");
        this.checkBaseDataUsable((JSONObject)data.get((Object)"exratetable"), ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4fe1\u606f", (String)"ArInvoiceImport_11", (String)"fi-ar-formplugin", (Object[])new Object[0]), "bd_exratetable");
        this.checkBaseDataUsable((JSONObject)data.get((Object)"org"), ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4fe1\u606f", (String)"ArInvoiceImport_12", (String)"fi-ar-formplugin", (Object[])new Object[0]), "bos_org");
    }

    private void checkDataStatus(String errorMessage, String status) {
        if (BillStatusEnum.AUDIT.getValue().equals(status)) {
            return;
        }
        throw new KDBizException(errorMessage);
    }

    private void checkDataEnable(String errorMessage, String enable) {
        if (BILL_ENABLE.equals(enable)) {
            return;
        }
        throw new KDBizException(errorMessage);
    }

    private void checkBaseDataUsable(JSONObject baseData, String message, String entityName) {
        if (EmptyUtils.isEmpty((Object)baseData)) {
            return;
        }
        QFilter[] filters = this.getQFilter(entityName, baseData.getString("name"), baseData.getString("number"));
        Optional<DynamicObject> customerOptional = this.getDynamicObjectFromDb(entityName, "id,name,number,enable,status", filters);
        if (!customerOptional.isPresent()) {
            return;
        }
        this.checkDataEnable(String.format(ResManager.loadKDString((String)"%s\u5df2\u7981\u7528", (String)"ArInvoiceImport_15", (String)"fi-ar-formplugin", (Object[])new Object[0]), message), customerOptional.get().getString("enable"));
        this.checkDataStatus(String.format(ResManager.loadKDString((String)"%s\u672a\u5ba1\u6838", (String)"ArInvoiceImport_16", (String)"fi-ar-formplugin", (Object[])new Object[0]), message), customerOptional.get().getString("status"));
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            String invoiceType = data.getString("invoicetypef7");
            if (invoiceType != null) continue;
            String invoicetypeStr = data.getString("invoicetype");
            JSONObject typef7 = new JSONObject();
            typef7.put("number", (Object)InvoiceType.getTypeNo((String)invoicetypeStr));
            typef7.put("importprop", (Object)"number");
            data.put("invoicetypef7", (Object)typef7);
        }
        return super.save(rowdatas, logger);
    }
}

