/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.writeback.bill.DisposerInfo;
import kd.fi.arapcommon.service.writeback.bill.FinArLockWBServiceHelper;

public class FinArBillWriteBack
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(FinArBillWriteBack.class);
    private final Map<Long, List<DisposerInfo>> srcWriteBackFinArMap = new HashMap<Long, List<DisposerInfo>>(64);
    private final List<String> fieldKeys = Arrays.asList("e_unlockamt", "unplanlockamt");

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        if (!this.fieldKeys.contains(e.getSrcFieldKey())) {
            return;
        }
        String srcEntityKey = e.getSrcSubMainType().getName();
        DynamicObject srcBill = (DynamicObject)e.getSrcActiveRow().getParent();
        long sourceId = srcBill.getLong("id");
        long sourceEntryId = e.getSrcActiveRow().getLong("id");
        long tarRowId = e.getTargetRowId().getEntryId();
        BigDecimal disposeAmt = e.getCurrVal();
        if (this.isRelease()) {
            disposeAmt = disposeAmt.negate();
        }
        if ("ar_finarbill".equals(srcEntityKey)) {
            DisposerInfo info = new DisposerInfo(Long.valueOf(sourceId), Long.valueOf(sourceEntryId), disposeAmt);
            List disposerInfos = this.srcWriteBackFinArMap.getOrDefault(tarRowId, new ArrayList(8));
            disposerInfos.add(info);
            this.srcWriteBackFinArMap.put(tarRowId, disposerInfos);
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        logger.info("Baddebt FinArBillWriteBack afterSaveSourceBill start ");
        boolean isRelease = this.isRelease();
        Map writeBackFinArMap = ArApHelper.processWriteBackMap(this.srcWriteBackFinArMap);
        if (!this.srcWriteBackFinArMap.isEmpty()) {
            Set finArBillIds = writeBackFinArMap.values().stream().map(DisposerInfo::getSourceId).collect(Collectors.toSet());
            CommonSettleServiceHelper.settleAddMutexCtrlInTX(finArBillIds, (String)"ar_finarbill", (boolean)false);
            if (isRelease) {
                FinArLockWBServiceHelper.inverseWriteBack(finArBillIds, (Map)writeBackFinArMap);
            } else {
                FinArLockWBServiceHelper.directWriteBack(finArBillIds, (Map)writeBackFinArMap);
            }
        }
        logger.info("Baddebt FinArBillWriteBack afterSaveSourceBill end ");
    }

    private boolean isRelease() {
        String opType = this.getOpType();
        return "delete".equalsIgnoreCase(opType) || "invalid".equalsIgnoreCase(opType);
    }
}

