/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.writeback;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OriginalBillWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final String CLOSED = "1";
    private static final String NOT_CLOSED = "0";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        String srcName = e.getSrcMainType().getName();
        super.beforeReadSourceBill(e);
        if ("sim_original_bill".equals(srcName)) {
            List lst = e.getFieldKeys();
            lst.add("id");
            lst.add("closestatus");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        String srcName = e.getSrcSubMainType().getName();
        String opType = this.getOpType();
        DynamicObject[] bills = e.getSrcDataEntities();
        if ("sim_original_bill".equals(srcName)) {
            if ("Delete".equals(opType)) {
                Arrays.stream(bills).forEach(o -> o.set("closestatus", (Object)NOT_CLOSED));
            }
            if ("Save".equals(opType) || "Submit".equals(opType)) {
                Arrays.stream(bills).forEach(o -> o.set("closestatus", (Object)CLOSED));
            }
            SaveServiceHelper.update((DynamicObject[])bills);
        }
    }
}

