/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.formplugin.writeback;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterExcessCheckEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class SaleOutWriteBackByFinArPlugin
extends AbstractWriteBackPlugIn {
    private Map<Long, Boolean> arBusBillToleranceControl = new HashMap<Long, Boolean>(8);
    private Map<Long, BigDecimal> arBusBillToleranceAmt = new HashMap<Long, BigDecimal>(8);
    private String isBillNo = "";

    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        List lst = e.getFieldKeys();
        lst.add("billentry.qty");
        lst.add("billentry.baseqty");
        lst.add("billentry.remainjoinpriceqty");
        lst.add("billentry.remainjoinpricebaseqty");
        lst.add("billentry.joinpriceqty");
        lst.add("billentry.joinpricebaseqty");
        lst.add("id");
        lst.add("unrelateinvamt");
        lst.add("uninvoicedamt");
        lst.add("recamount");
        lst.add("org");
        lst.add("billno");
    }

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        super.afterCommitAmount(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String srcBillName = srcSubMainType.getName();
        if (!"im_saloutbill".equalsIgnoreCase(srcBillName)) {
            return;
        }
        DynamicObject srcActiveRow = e.getSrcActiveRow();
        DynamicObject targetActiveRow = e.getTargetActiveRow();
        if (srcActiveRow == null || targetActiveRow == null) {
            return;
        }
        String srcFieldKey = e.getSrcFieldKey();
        BigDecimal realVal = e.getRealVal();
        BigDecimal currVal = e.getCurrVal();
        boolean isAudit = true;
        if (BigDecimal.ZERO.compareTo(realVal) == 0) {
            isAudit = false;
        }
        if (!isAudit) {
            BigDecimal newJoinPriceBaseQty;
            BigDecimal joinPriceBaseQty;
            if ("joinpriceqty".equals(srcFieldKey)) {
                BigDecimal newJoinPriceQty = srcActiveRow.getBigDecimal("joinpriceqty");
                BigDecimal joinPriceQty = newJoinPriceQty.subtract(currVal);
                if (joinPriceQty.abs().compareTo(currVal.abs()) < 0) {
                    srcActiveRow.set(srcFieldKey, (Object)BigDecimal.ZERO);
                }
            } else if ("joinpricebaseqty".equals(srcFieldKey) && (joinPriceBaseQty = (newJoinPriceBaseQty = srcActiveRow.getBigDecimal("joinpricebaseqty")).subtract(currVal)).abs().compareTo(currVal.abs()) < 0) {
                srcActiveRow.set(srcFieldKey, (Object)BigDecimal.ZERO);
            }
        }
    }

    public void afterExcessCheck(AfterExcessCheckEventArgs e) {
        super.afterExcessCheck(e);
        this.finArSaveAboveAmountValidator(e);
    }

    private void finArSaveAboveAmountValidator(AfterExcessCheckEventArgs e) {
        String billno;
        String srcBillType = e.getSrcSubMainType().getName();
        if (!"ar_busbill".equals(srcBillType)) {
            return;
        }
        DynamicObject srcActiveRow = e.getSrcActiveRow();
        DynamicObject parent = (DynamicObject)srcActiveRow.getParent();
        Long orgId = parent.getLong("org.id");
        Boolean toleranceControl = this.arBusBillToleranceControl.get(orgId);
        BigDecimal toleranceAmt = this.arBusBillToleranceAmt.get(orgId);
        if (toleranceControl == null && toleranceAmt == null) {
            Map<String, Object> parameters = this.batchGetAppParameters(orgId, "ar_035", "ar_036");
            this.arBusBillToleranceControl.put(orgId, (Boolean)parameters.get("ar_035"));
            this.arBusBillToleranceAmt.put(orgId, parameters.get("ar_036") == null ? BigDecimal.ZERO : new BigDecimal(String.valueOf(parameters.get("ar_036"))));
        }
        if (this.arBusBillToleranceControl.get(orgId) == null || !this.arBusBillToleranceControl.get(orgId).booleanValue()) {
            return;
        }
        toleranceAmt = this.arBusBillToleranceAmt.get(orgId);
        BigDecimal uninvoicedamt = parent.getBigDecimal("uninvoicedamt");
        BigDecimal recamount = parent.getBigDecimal("recamount");
        if (recamount.compareTo(BigDecimal.ZERO) > 0) {
            String billno2;
            if (toleranceAmt.compareTo(uninvoicedamt.negate()) < 0 && !this.isBillNo.equals(billno2 = parent.getString("billno"))) {
                e.setExcess(true);
                this.isBillNo = billno2;
                e.setMessage(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\uff0c\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\u9650\u5236\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SaleOutWriteBackByFinArPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), billno2));
            }
        } else if (recamount.compareTo(BigDecimal.ZERO) < 0) {
            String billno3;
            if (toleranceAmt.compareTo(uninvoicedamt) < 0 && !this.isBillNo.equals(billno3 = parent.getString("billno"))) {
                e.setExcess(true);
                this.isBillNo = billno3;
                e.setMessage(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\uff0c\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\u9650\u5236\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SaleOutWriteBackByFinArPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), billno3));
            }
        } else if (toleranceAmt.compareTo(uninvoicedamt.abs()) < 0 && !this.isBillNo.equals(billno = parent.getString("billno"))) {
            e.setExcess(true);
            this.isBillNo = billno;
            e.setMessage(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\uff1a%s\uff0c\u4e0b\u63a8\u8d22\u52a1\u5e94\u6536\u5355\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\u9650\u5236\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SaleOutWriteBackByFinArPlugin_0", (String)"fi-ar-formplugin", (Object[])new Object[0]), billno));
        }
    }

    private Map<String, Object> batchGetAppParameters(Long orgId, String ... paramKey) {
        AppParam appParam = new AppParam();
        appParam.setOrgId(orgId);
        appParam.setAppId("/BBRH+122=39");
        appParam.setViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        Map systemParams = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        HashMap<String, Object> params = new HashMap<String, Object>(paramKey.length);
        if (!ObjectUtils.isEmpty((Object)systemParams)) {
            for (String keyItem : paramKey) {
                params.put(keyItem, systemParams.get(keyItem));
            }
        }
        return params;
    }
}

