/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.baddebt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.business.baddebt.IReserve;
import kd.fi.ar.business.baddebt.info.AccrualFilterParam;
import kd.fi.ar.enums.AccrualMethodEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.collections4.ListUtils;

public abstract class AbstractReserve
implements IReserve {
    private static final Log logger = LogFactory.getLog(AbstractReserve.class);
    protected String entityKey;
    protected DynamicObject policy;
    protected DynamicObject currPeriod;
    protected Long orgPk;
    protected String method;
    protected String frequency;
    protected boolean isFirst;
    protected DynamicObject prePeriod;
    protected Set<Long> idSet;
    protected Date currentDate = DateUtils.truncateDate((Date)new Date());
    protected MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"ar_baddebtreserve");
    protected String userID = String.valueOf(RequestContext.get().getCurrUserId());
    protected String selector4init = "id, org, policytype, sourcebillno, sourcebilltype, sourcebillid, bizdate, billstatus, asstacttype, asstact, sourcetype, currency, exchangerate, receivableamt, unsettleamt, unsettlelocalamt, baddebtreserveamt ";

    public AbstractReserve(String entityKey, DynamicObject policy, DynamicObject currPeriod, Long orgPk, String method, String frequency, Set<Long> idSet, boolean isFirst) {
        this.entityKey = entityKey;
        this.policy = policy;
        this.currPeriod = currPeriod;
        this.orgPk = orgPk;
        this.method = method;
        this.frequency = frequency;
        this.idSet = idSet;
        this.isFirst = isFirst;
        this.prePeriod = isFirst ? null : BaddebtHelper.getPrePeriod(frequency, currPeriod);
    }

    @Override
    public List<DynamicObject> genBaddebtReserve(AccrualFilterParam filterParam) {
        List<DynamicObject> destList4biz;
        ArrayList<DynamicObject> destList = new ArrayList<DynamicObject>();
        List<QFilter> commonList = this.getCommonFilter(filterParam, this.getDateField());
        DynamicObject[] inits = this.findInitBill(filterParam, commonList);
        List<DynamicObject> destList4init = this.getReserve4init(inits, filterParam);
        if (!destList4init.isEmpty()) {
            destList.addAll(destList4init);
        }
        if (!(destList4biz = this.findBizBill(filterParam, commonList)).isEmpty()) {
            destList.addAll(destList4biz);
        }
        return destList;
    }

    protected List<QFilter> getCommonFilter(AccrualFilterParam filterParam, String dateField) {
        ArrayList<QFilter> commonList = new ArrayList<QFilter>();
        commonList.add(new QFilter("org", "=", (Object)this.orgPk));
        if (AccrualMethodEnum.acctAgeAnalysis.name().equals(this.method)) {
            if ("acctagecalcdate".equals(dateField)) {
                commonList.add(new QFilter("bizdate", "<=", (Object)this.currPeriod.getDate("enddate")));
            }
            if (filterParam.getBeginDate() != null) {
                commonList.add(new QFilter(dateField, ">=", (Object)filterParam.getBeginDate()));
            }
            if (filterParam.getEndDate() != null) {
                commonList.add(new QFilter(dateField, "<=", (Object)filterParam.getEndDate()));
            }
        } else {
            commonList.add(new QFilter("bizdate", "<=", (Object)this.currPeriod.getDate("enddate")));
        }
        if (filterParam.getAsstactType() != null) {
            commonList.add(new QFilter("asstacttype", "=", (Object)filterParam.getAsstactType()));
        }
        if (filterParam.getAsstactList() != null && !filterParam.getAsstactList().isEmpty()) {
            commonList.add(new QFilter("asstact", "in", filterParam.getAsstactList()));
        }
        return commonList;
    }

    protected abstract String getDateField();

    protected DynamicObject[] findInitBill(AccrualFilterParam filterParam, List<QFilter> commonList) {
        List<DynamicObject> inits = this.queryInitBill(filterParam, commonList);
        List<Long> existsPks = inits.stream().map(i -> i.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> settledInits = this.queryPreInit(filterParam, commonList, existsPks);
        return ListUtils.union(inits, settledInits).toArray(new DynamicObject[0]);
    }

    private List<DynamicObject> queryInitBill(AccrualFilterParam filterParam, List<QFilter> commonList) {
        List<Long> srcPks = this.getInitSrcPks(filterParam, commonList, null);
        DynamicObject[] inits = this.getInitBills(srcPks);
        List<DynamicObject> initbills = this.reCalcUnsettledAmt(inits, false);
        return initbills;
    }

    private DynamicObject[] getInitBills(List<Long> srcPks) {
        if (srcPks.isEmpty()) {
            return null;
        }
        Object policytypePk = this.policy.getDynamicObject("policytype").getPkValue();
        ArrayList<QFilter> initList = new ArrayList<QFilter>();
        initList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        initList.add(new QFilter("policytype", "=", policytypePk));
        initList.add(new QFilter("sourcebilltype", "=", (Object)this.entityKey));
        initList.add(new QFilter("sourcebillid", "in", srcPks));
        return BusinessDataServiceHelper.load((String)"ar_baddebtreservebill", (String)this.selector4init, (QFilter[])initList.toArray(new QFilter[0]));
    }

    private List<DynamicObject> queryPreInit(AccrualFilterParam filterParam, List<QFilter> commonList, List<Long> existsPks) {
        List<DynamicObject> initbills = new ArrayList<DynamicObject>(0);
        List<Long> prePks = this.getPrePks(existsPks, true);
        if (prePks != null) {
            QFilter qFilter = new QFilter("id", "in", prePks);
            qFilter.and(new QFilter("sourcebilltype", "=", (Object)this.entityKey));
            DynamicObjectCollection preInits = QueryServiceHelper.query((String)"ar_baddebtreservebill", (String)"sourcebillid", (QFilter[])new QFilter[]{qFilter});
            if (!ObjectUtils.isEmpty((Object)preInits)) {
                List<Long> preSrcPks = preInits.stream().map(p -> p.getLong("sourcebillid")).collect(Collectors.toList());
                List<Long> srcPks = this.getInitSrcPks(filterParam, commonList, preSrcPks);
                DynamicObject[] inits = this.getInitBills(srcPks);
                initbills = this.reCalcUnsettledAmt(inits, true);
            }
        }
        return initbills;
    }

    protected List<Long> getPrePks(List<Long> existsPks, boolean isInit) {
        List prePks = null;
        if (!ObjectUtils.isEmpty((Object)this.prePeriod)) {
            DynamicObjectCollection preAccruals;
            QFilter cFilter = new QFilter("org", "=", (Object)this.orgPk);
            cFilter.and(new QFilter("arpolicy", "=", this.policy.getPkValue()));
            cFilter.and(new QFilter("period", "=", this.prePeriod.getPkValue()));
            cFilter.and(new QFilter("baseamount", ">", (Object)0));
            QFilter initFilter = new QFilter("sourcebilltype", "=", (Object)(isInit ? "ar_baddebtreservebill" : this.entityKey));
            if (!ObjectUtils.isEmpty(existsPks)) {
                initFilter.and(new QFilter("sourcebillid", "not in", existsPks));
            }
            if (!ObjectUtils.isEmpty((Object)(preAccruals = QueryServiceHelper.query((String)"ar_baddebtreserve", (String)"sourcebillid", (QFilter[])new QFilter[]{cFilter, initFilter})))) {
                prePks = preAccruals.stream().map(p -> p.getLong("sourcebillid")).collect(Collectors.toList());
            }
        }
        return prePks;
    }

    private List<DynamicObject> reCalcUnsettledAmt(DynamicObject[] inits, boolean containZero) {
        ArrayList<DynamicObject> initbills = new ArrayList<DynamicObject>(0);
        if (!ObjectUtils.isEmpty((Object[])inits)) {
            List<Long> srcPks = Stream.of(inits).map(r -> r.getLong("sourcebillid")).collect(Collectors.toList());
            Map<Object, Object> settledMap = new HashMap(0);
            if ("ar_busbill".equals(this.entityKey)) {
                settledMap = this.getWoffInvoicedAmt(srcPks);
            } else if ("ar_finarbill".equals(this.entityKey)) {
                settledMap = this.getSettledAmt(srcPks);
            }
            for (DynamicObject init : inits) {
                Long srcPk = init.getLong("sourcebillid");
                BigDecimal recAmt = init.getBigDecimal("receivableamt");
                BigDecimal value = (BigDecimal)settledMap.get(srcPk);
                BigDecimal settledAmt = value != null ? value : BigDecimal.ZERO;
                BigDecimal unSettleAmt = recAmt.subtract(settledAmt.abs());
                init.set("unsettleamt", (Object)unSettleAmt);
                if (!containZero && !AccrualMethodEnum.salesPct.name().equals(this.method)) {
                    if (unSettleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    initbills.add(init);
                    continue;
                }
                initbills.add(init);
            }
        }
        return initbills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Long, BigDecimal> getWoffInvoicedAmt(List<Long> srcPks) {
        HashMap<Long, BigDecimal> woffMap = new HashMap<Long, BigDecimal>(0);
        QFilter fixQf = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        fixQf.and(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        fixQf.and(new QFilter("writeoffbusiness", "=", (Object)Boolean.FALSE));
        QFilter qFilter = new QFilter("bizdate", "<=", (Object)this.currPeriod.getDate("enddate"));
        qFilter.and(new QFilter("entry.e_srcbillid", "in", srcPks));
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"baddebt.getWoffInvoicedAmt", (String)this.entityKey, (String)"entry.e_srcbillid, entry.e_recamount ", (QFilter[])new QFilter[]{fixQf, qFilter}, null);
            ds = ds.groupBy(new String[]{"entry.e_srcbillid"}).sum("entry.e_recamount", "frecamt").finish();
            for (Row data : ds) {
                woffMap.put(data.getLong("entry.e_srcbillid"), data.getBigDecimal("frecamt"));
            }
        }
        return woffMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Long, BigDecimal> getSettledAmt(List<Long> srcPks) {
        HashMap<Long, BigDecimal> settledMap = new HashMap<Long, BigDecimal>(0);
        QFilter qFilter = new QFilter("settledate", "<=", (Object)this.currPeriod.getDate("enddate"));
        ArrayList<QFilter> mFilters = new ArrayList<QFilter>(3);
        mFilters.add(qFilter);
        mFilters.add(new QFilter("billentity", "=", (Object)"ar_finarbill"));
        mFilters.add(new QFilter("mainbillid", "in", srcPks));
        DataSet mSettleRecords = QueryServiceHelper.queryDataSet((String)"baddebt.mainSettleRecords", (String)"ar_settlerecord", (String)"mainbillid, totalsettleamt", (QFilter[])mFilters.toArray(new QFilter[0]), null);
        ArrayList<QFilter> aFilters = new ArrayList<QFilter>(3);
        aFilters.add(qFilter);
        aFilters.add(new QFilter("entry.e_billentity", "=", (Object)"ar_finarbill"));
        aFilters.add(new QFilter("entry.billid", "in", srcPks));
        DataSet aSettleRecords = QueryServiceHelper.queryDataSet((String)"baddebt.asstSettleRecords", (String)"ap_settlerecord", (String)"entry.billid as mainbillid, entry.settleamt as totalsettleamt", (QFilter[])aFilters.toArray(new QFilter[0]), null);
        try (DataSet settleRecords = mSettleRecords.union(aSettleRecords).groupBy(new String[]{"mainbillid"}).sum("totalsettleamt", "fsettleamt").finish();){
            for (Row data : settleRecords) {
                settledMap.put(data.getLong("mainbillid"), data.getBigDecimal("fsettleamt"));
            }
        }
        finally {
            mSettleRecords.close();
            aSettleRecords.close();
        }
        return settledMap;
    }

    private List<DynamicObject> getReserve4init(DynamicObject[] inits, AccrualFilterParam filterParam) {
        ArrayList<DynamicObject> destList = new ArrayList<DynamicObject>();
        for (DynamicObject init : inits) {
            long srcPk = (Long)init.getPkValue();
            if (this.idSet.contains(srcPk)) continue;
            DynamicObject destBill = this.buildReserve4init(init, filterParam.getRate(), filterParam.getRange());
            destList.add(destBill);
            this.idSet.add(init.getLong("sourcebillid"));
        }
        return destList;
    }

    protected DynamicObject buildReserve4init(DynamicObject srcBill, BigDecimal rate, String range) {
        DynamicObject destBill = this.buildBaseReserve(srcBill, rate, range);
        destBill.set("sourcebillno", (Object)srcBill.getString("sourcebillno"));
        destBill.set("receivableamt", (Object)srcBill.getBigDecimal("receivableamt"));
        destBill.set("unsettleamt", (Object)srcBill.getBigDecimal("unsettleamt"));
        destBill.set("sourcetype", (Object)srcBill.getDynamicObject("sourcetype"));
        Object policytypePk = srcBill.getDynamicObject("policytype").getPkValue();
        if (this.isFirst) {
            destBill.set("preaccrualamt", (Object)srcBill.getBigDecimal("baddebtreserveamt"));
        } else {
            BigDecimal preaccrualamt = this.getPreAccrualAmt((Long)this.currPeriod.getPkValue(), (Long)srcBill.getPkValue(), policytypePk);
            if (srcBill.getBigDecimal("baddebtreserveamt").compareTo(BigDecimal.ZERO) != 0) {
                preaccrualamt = preaccrualamt.add(srcBill.getBigDecimal("baddebtreserveamt"));
            }
            destBill.set("preaccrualamt", (Object)preaccrualamt);
        }
        this.setAmtField(destBill, this.isFirst);
        return destBill;
    }

    protected DynamicObject buildBaseReserve(DynamicObject srcBill, BigDecimal rate, String range) {
        DynamicObject destBill = new DynamicObject((DynamicObjectType)this.dt);
        DynamicObject org = srcBill.getDynamicObject("org");
        destBill.set("org", org.getPkValue());
        String billno = CodeRuleServiceHelper.getNumber((String)"ar_baddebtreserve", (DynamicObject)destBill, (String)org.getPkValue().toString());
        if (ObjectUtils.isEmpty((Object)billno)) {
            billno = "ar_baddebtreservebill".equals(srcBill.getDataEntityType().getName()) ? srcBill.getString("sourcebillno") : srcBill.getString("billno");
        }
        destBill.set("billno", (Object)billno);
        destBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        destBill.set("period", this.currPeriod.getPkValue());
        destBill.set("accrualdate", (Object)this.currentDate);
        destBill.set("sourcebilltype", (Object)srcBill.getDataEntityType().getName());
        destBill.set("sourcebillid", srcBill.getPkValue());
        destBill.set("bizdate", (Object)srcBill.getDate("bizdate"));
        destBill.set("asstacttype", (Object)srcBill.getString("asstacttype"));
        destBill.set("asstact", srcBill.getDynamicObject("asstact").getPkValue());
        destBill.set("currency", srcBill.getDynamicObject("currency").getPkValue());
        destBill.set("exchangerate", (Object)srcBill.getBigDecimal("exchangerate"));
        destBill.set("accrualrate", (Object)rate);
        destBill.set("policytype", this.policy.getDynamicObject("policytype").getPkValue());
        destBill.set("arpolicy", this.policy.getPkValue());
        destBill.set("accrualscheme", this.policy.getDynamicObject("accrualscheme").getPkValue());
        destBill.set("accrualfrequency", (Object)this.frequency);
        destBill.set("range", (Object)BaddebtHelper.getRangeValue(range));
        destBill.set("creator", (Object)Long.valueOf(this.userID));
        destBill.set("createtime", (Object)this.currentDate);
        return destBill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BigDecimal getPreAccrualAmt(long currPeriodPk, long srcPk, Object policytypePk) {
        DynamicObject init;
        BigDecimal sumCurrentAmt = BigDecimal.ZERO;
        DynamicObject obj = QueryServiceHelper.queryOne((String)this.entityKey, (String)"isperiod", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcPk)});
        if (!ObjectUtils.isEmpty((Object)obj) && obj.getBoolean("isperiod") && !ObjectUtils.isEmpty((Object)(init = QueryServiceHelper.queryOne((String)"ar_baddebtreservebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)srcPk)})))) {
            srcPk = init.getLong("id");
        }
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)srcPk);
        qFilter.and(new QFilter("policytype", "=", policytypePk));
        qFilter.and(new QFilter("period", "!=", (Object)currPeriodPk));
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"ar.AccrualImpl.getPreAccrualAmt", (String)"ar_baddebtreserve", (String)"sourcebillid, currentaccrualamt", (QFilter[])new QFilter[]{qFilter}, null);
            ds = ds.groupBy(new String[]{"sourcebillid"}).sum("currentaccrualamt").finish();
            for (Row data : ds) {
                sumCurrentAmt = data.getBigDecimal("currentaccrualamt");
            }
        }
        return sumCurrentAmt;
    }

    protected void setAmtField(DynamicObject destBill, boolean isCurrent) {
        if (AccrualMethodEnum.salesPct.name().equals(this.method)) {
            destBill.set("baseamount", (Object)destBill.getBigDecimal("receivableamt"));
        } else {
            destBill.set("baseamount", (Object)destBill.getBigDecimal("unsettleamt"));
        }
        destBill.set("accruedamt", (Object)destBill.getBigDecimal("baseamount").multiply(destBill.getBigDecimal("accrualrate")).divide(new BigDecimal(100)));
        destBill.set("currentaccrualamt", (Object)destBill.getBigDecimal("accruedamt").subtract(destBill.getBigDecimal("preaccrualamt")));
        BigDecimal currentAmt = destBill.getBigDecimal("currentaccrualamt");
        if (currentAmt.compareTo(BigDecimal.ZERO) > 0) {
            destBill.set("additionalamt", (Object)currentAmt);
        } else {
            destBill.set("writeoffamt", (Object)currentAmt.negate());
        }
        destBill.set("balanceamt", (Object)destBill.getBigDecimal("preaccrualamt").add(destBill.getBigDecimal("additionalamt")).subtract(destBill.getBigDecimal("writeoffamt")));
    }

    protected abstract List<DynamicObject> findBizBill(AccrualFilterParam var1, List<QFilter> var2);

    protected abstract List<Long> getInitSrcPks(AccrualFilterParam var1, List<QFilter> var2, List<Long> var3);

    protected List<Long> convertToLongList(List<String> list) {
        ArrayList<Long> longList = new ArrayList<Long>(list.size());
        for (String item : list) {
            longList.add(Long.valueOf(item));
        }
        return longList;
    }
}

