/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.baddebt;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.baddebt.info.InitAmtPair;
import kd.fi.ar.enums.FrequencyEnum;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.init.info.AmtPair;
import kd.fi.arapcommon.init.info.InitEntryInfo;
import kd.fi.arapcommon.init.info.MergeKey;
import kd.fi.arapcommon.util.EmptyUtils;

public class BaddebtHelper {
    private static Log logger = LogFactory.getLog(BaddebtHelper.class);
    public static final String BD_PERIOD = "bd_period";
    private static Map<String, String> rangeValueMap = null;

    public static DynamicObject[] getPeriods(Object orgId) {
        DynamicObject[] periods = null;
        Map<String, Object> rowMap = BaddebtHelper.getMinPeriod(orgId);
        if (rowMap != null) {
            QFilter qFilter = new QFilter("periodtype", "=", rowMap.get("periodtype"));
            qFilter.and("isadjustperiod", "=", (Object)Boolean.FALSE);
            QFilter dateFilter = new QFilter("begindate", ">=", rowMap.get("begindate"));
            periods = BusinessDataServiceHelper.load((String)BD_PERIOD, (String)"id, name", (QFilter[])new QFilter[]{qFilter, dateFilter}, (String)"begindate");
        }
        return periods;
    }

    private static Map<String, Object> getMinPeriod(Object orgId) {
        HashMap<String, Object> rowMap = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" select policy.FPeriodTypeID, policy.FStartPeriodID, MIN(period.FBeginDate) AS FBeginDate ");
        sql.append(" from t_ar_policy policy ");
        sql.append(" LEFT JOIN t_bd_period period ON period.FTypeID = policy.FPeriodTypeID ");
        sql.append(" AND period.FID = policy.FStartPeriodID ");
        sql.append(" WHERE policy.FOrgID = ? ");
        sql.append(" AND policy.FStatus = 'C' AND policy.FEnable = '1' ");
        sql.append(" GROUP BY policy.FPeriodTypeID, policy.FStartPeriodID, period.FBeginDate; ");
        Object[] params = new Object[]{orgId};
        logger.info(MessageFormat.format("getMinPeriod.sql = {0}, params[] = {1}", sql.toString(), orgId.toString()));
        try (DataSet ds = DB.queryDataSet((String)BaddebtHelper.class.getName(), (DBRoute)DBRouteConst.AR, (String)sql.toString(), (Object[])params);){
            Iterator rowIterator = ds.iterator();
            if (rowIterator != null && rowIterator.hasNext()) {
                rowMap = new HashMap<String, Object>();
                Row row = (Row)rowIterator.next();
                rowMap.put("periodtype", row.get("FPeriodTypeID"));
                rowMap.put("startperiod", row.get("FStartPeriodID"));
                rowMap.put("begindate", row.get("FBeginDate"));
            }
        }
        return rowMap;
    }

    public static DynamicObjectCollection existsSlavePolicy(Object orgId) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        QFilter mFilter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE);
        mFilter.and(new QFilter("policytype.type", "=", (Object)"master"));
        boolean exists = QueryServiceHelper.exists((String)"ar_init", (QFilter[])new QFilter[]{qFilter, mFilter});
        DynamicObjectCollection coll = null;
        if (exists) {
            QFilter sFilter = new QFilter("isfinishinit", "=", (Object)Boolean.FALSE);
            sFilter.and(new QFilter("policytype.type", "=", (Object)"slave"));
            coll = QueryServiceHelper.query((String)"ar_init", (String)"id, policytype, startperiod.id, startperiod.begindate, policyid", (QFilter[])new QFilter[]{qFilter, sFilter});
        }
        return coll;
    }

    public static DynamicObject[] getPolicyType(Object orgId) {
        QFilter qFilter = new QFilter("org", "=", orgId);
        DynamicObject[] policyTypes = BusinessDataServiceHelper.load((String)"ar_policy", (String)"policytype.id, policytype.name", (QFilter[])new QFilter[]{qFilter});
        return policyTypes;
    }

    public static void buildBaseBaddebt(DynamicObject srcBill, DynamicObject destBill) {
        Map sourceTypeMap;
        destBill.set("org", srcBill.getDynamicObject("org").getPkValue());
        destBill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        destBill.set("sourcebillno", (Object)srcBill.getString("billno"));
        destBill.set("sourcebillid", srcBill.getPkValue());
        destBill.set("bizdate", (Object)srcBill.getDate("bizdate"));
        destBill.set("asstacttype", (Object)srcBill.getString("asstacttype"));
        destBill.set("asstact", srcBill.getDynamicObject("asstact").getPkValue());
        destBill.set("currency", srcBill.getDynamicObject("currency").getPkValue());
        destBill.set("receivableamt", (Object)srcBill.getBigDecimal("recamount"));
        String entityKey = srcBill.getDataEntityType().getName();
        destBill.set("sourcebilltype", (Object)entityKey);
        QFilter qFilter = new QFilter("entityobject", "=", (Object)entityKey);
        if (!EmptyUtils.isEmpty((Object)srcBill.getDynamicObject("billtype"))) {
            Object billTypeId = srcBill.getDynamicObject("billtype").getPkValue();
            qFilter.and(new QFilter("billtype", "=", (Object)billTypeId.toString()));
        }
        if ((sourceTypeMap = BusinessDataServiceHelper.loadFromCache((String)"ar_sourcetype", (String)"id, number", (QFilter[])new QFilter[]{qFilter})) != null && sourceTypeMap.size() > 0) {
            destBill.set("sourcetype", (Object)sourceTypeMap.values().toArray(new DynamicObject[0])[0]);
        }
        Date recDate = null;
        if ("ar_finarbill".equals(entityKey)) {
            DynamicObjectCollection planColl = srcBill.getDynamicObjectCollection("planentity");
            DynamicObject max = Collections.max(planColl, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    int comparator = -1;
                    if (!EmptyUtils.isEmpty((Object)o1.getDate("planduedate")) && !EmptyUtils.isEmpty((Object)o2.getDate("planduedate"))) {
                        comparator = o1.getDate("planduedate").after(o2.getDate("planduedate")) ? 1 : 0;
                    }
                    return comparator;
                }
            });
            recDate = max.getDate("planduedate");
        } else {
            recDate = srcBill.getDate("duedate");
        }
        destBill.set("receivabledate", (Object)recDate);
    }

    public static List<InitEntryInfo> merge(List<InitEntryInfo> recAmtDetail, List<InitEntryInfo> advancesAmtDetail, List<InitEntryInfo> baddebtAmtDetail, List<InitEntryInfo> bizAmtDetail) {
        InitAmtPair pair;
        MergeKey key;
        HashMap<MergeKey, InitAmtPair> mergeResult = new HashMap<MergeKey, InitAmtPair>();
        for (InitEntryInfo info : recAmtDetail) {
            key = info.getMergeKey();
            pair = (InitAmtPair)((Object)mergeResult.get(key));
            if (pair == null) {
                mergeResult.put(key, (InitAmtPair)info.getAmtPair());
                continue;
            }
            pair.addAndGetRecAmt(((InitAmtPair)info.getAmtPair()).getRecAmt());
        }
        for (InitEntryInfo info : advancesAmtDetail) {
            key = info.getMergeKey();
            pair = (InitAmtPair)((Object)mergeResult.get(key));
            if (pair == null) {
                mergeResult.put(key, (InitAmtPair)info.getAmtPair());
                continue;
            }
            pair.addAndGetAdvancesAmt(((InitAmtPair)info.getAmtPair()).getAdvancesAmt());
        }
        for (InitEntryInfo info : baddebtAmtDetail) {
            key = info.getMergeKey();
            pair = (InitAmtPair)((Object)mergeResult.get(key));
            if (pair == null) {
                mergeResult.put(key, (InitAmtPair)info.getAmtPair());
                continue;
            }
            pair.addAndGetBaddebtAmt(((InitAmtPair)info.getAmtPair()).getBaddebtAmt());
        }
        for (InitEntryInfo info : bizAmtDetail) {
            key = info.getMergeKey();
            pair = (InitAmtPair)((Object)mergeResult.get(key));
            if (pair == null) {
                mergeResult.put(key, (InitAmtPair)info.getAmtPair());
                continue;
            }
            pair.addAndGetBizAmt(((InitAmtPair)info.getAmtPair()).getBizAmt());
        }
        ArrayList<InitEntryInfo> result = new ArrayList<InitEntryInfo>(mergeResult.size());
        for (Map.Entry entry : mergeResult.entrySet()) {
            MergeKey key2 = (MergeKey)entry.getKey();
            InitAmtPair pair2 = (InitAmtPair)((Object)entry.getValue());
            InitEntryInfo info = new InitEntryInfo(key2, (AmtPair)pair2);
            result.add(info);
        }
        Collections.sort(result, (o1, o2) -> {
            if (o1.getMergeKey().getAsst() > o2.getMergeKey().getAsst()) {
                return 1;
            }
            if (o1.getMergeKey().getAsst() == o2.getMergeKey().getAsst()) {
                return 0;
            }
            return -1;
        });
        return result;
    }

    public static DynamicObject getNextPeriod(String frequency, Object periodPk) {
        DynamicObject nextPeriod = null;
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)periodPk, (String)BD_PERIOD);
        int periodYear = currPeriod.getInt("periodyear");
        int periodNumber = currPeriod.getInt("periodnumber");
        Object typePk = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter cFilter = new QFilter("periodtype", "=", typePk);
        cFilter.and("isadjustperiod", "=", (Object)Boolean.FALSE);
        if (FrequencyEnum.MONTH.getValue().equals(frequency)) {
            if (periodNumber < 12) {
                ++periodNumber;
            } else {
                ++periodYear;
                periodNumber = 1;
            }
            QFilter mFilter = new QFilter("periodyear", "=", (Object)periodYear);
            mFilter.and(new QFilter("periodnumber", "=", (Object)periodNumber));
            nextPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{cFilter, mFilter});
        } else if (FrequencyEnum.SEASON.getValue().equals(frequency)) {
            int periodQuarter = currPeriod.getInt("periodquarter");
            if (periodQuarter < 4) {
                ++periodQuarter;
            } else {
                ++periodYear;
                periodQuarter = 1;
            }
            QFilter qFilter = new QFilter("periodyear", "=", (Object)periodYear);
            qFilter.and(new QFilter("periodquarter", "=", (Object)periodQuarter));
            Map periodMap = BusinessDataServiceHelper.loadFromCache((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{cFilter, qFilter}, (String)"periodnumber desc");
            if (periodMap != null && periodMap.size() > 0) {
                nextPeriod = periodMap.values().toArray(new DynamicObject[0])[0];
            }
        } else if (FrequencyEnum.YEAR.getValue().equals(frequency)) {
            if (periodNumber < 12) {
                periodNumber = 12;
            } else {
                ++periodYear;
                periodNumber = 12;
            }
            QFilter yFilter = new QFilter("periodyear", "=", (Object)periodYear);
            yFilter.and(new QFilter("periodnumber", "=", (Object)periodNumber));
            nextPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{cFilter, yFilter});
        }
        return nextPeriod;
    }

    public static DynamicObject getCurrentPeriod(String frequency, Object periodPk) {
        DynamicObject thisPeriod = null;
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)periodPk, (String)BD_PERIOD);
        int periodYear = currPeriod.getInt("periodyear");
        int periodNumber = currPeriod.getInt("periodnumber");
        Object typePk = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter cFilter = new QFilter("periodtype", "=", typePk);
        cFilter.and("isadjustperiod", "=", (Object)Boolean.FALSE);
        if (FrequencyEnum.MONTH.getValue().equals(frequency)) {
            thisPeriod = currPeriod;
        } else if (FrequencyEnum.SEASON.getValue().equals(frequency)) {
            int periodQuarter = currPeriod.getInt("periodquarter");
            QFilter qFilter = new QFilter("periodyear", "=", (Object)periodYear);
            qFilter.and(new QFilter("periodquarter", "=", (Object)periodQuarter));
            Map periodMap = BusinessDataServiceHelper.loadFromCache((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{cFilter, qFilter}, (String)"periodnumber desc");
            if (periodMap != null && periodMap.size() > 0) {
                thisPeriod = periodMap.values().toArray(new DynamicObject[0])[0];
            }
        } else if (FrequencyEnum.YEAR.getValue().equals(frequency)) {
            if (periodNumber < 12) {
                periodNumber = 12;
            } else {
                ++periodYear;
                periodNumber = 12;
            }
            QFilter yFilter = new QFilter("periodyear", "=", (Object)periodYear);
            yFilter.and(new QFilter("periodnumber", "=", (Object)periodNumber));
            thisPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{cFilter, yFilter});
        }
        return thisPeriod;
    }

    public static DynamicObject getPrePeriod(String frequency, DynamicObject currPeriod) {
        DynamicObject prePeriod = null;
        int periodYear = currPeriod.getInt("periodyear");
        int periodNumber = currPeriod.getInt("periodnumber");
        Object typePk = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter cFilter = new QFilter("periodtype", "=", typePk);
        cFilter.and("isadjustperiod", "=", (Object)Boolean.FALSE);
        if (FrequencyEnum.MONTH.getValue().equals(frequency)) {
            if (periodNumber > 1) {
                --periodNumber;
            } else {
                periodNumber = 12;
                --periodYear;
            }
            QFilter mFilter = new QFilter("periodyear", "=", (Object)periodYear);
            mFilter.and(new QFilter("periodnumber", "=", (Object)periodNumber));
            prePeriod = BusinessDataServiceHelper.loadSingleFromCache((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{cFilter, mFilter});
        } else if (FrequencyEnum.SEASON.getValue().equals(frequency)) {
            int periodQuarter = currPeriod.getInt("periodquarter");
            if (periodQuarter > 1) {
                --periodQuarter;
            } else {
                --periodYear;
                periodQuarter = 4;
            }
            QFilter qFilter = new QFilter("periodyear", "=", (Object)periodYear);
            qFilter.and(new QFilter("periodquarter", "=", (Object)periodQuarter));
            Map periodMap = BusinessDataServiceHelper.loadFromCache((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{cFilter, qFilter}, (String)"periodnumber desc");
            if (periodMap != null && periodMap.size() > 0) {
                prePeriod = periodMap.values().toArray(new DynamicObject[0])[0];
            }
        } else if (FrequencyEnum.YEAR.getValue().equals(frequency)) {
            periodNumber = 12;
            QFilter yFilter = new QFilter("periodyear", "=", (Object)(--periodYear));
            yFilter.and(new QFilter("periodnumber", "=", (Object)periodNumber));
            prePeriod = BusinessDataServiceHelper.loadSingleFromCache((String)BD_PERIOD, (String)"id", (QFilter[])new QFilter[]{cFilter, yFilter});
        }
        return prePeriod;
    }

    public static Map<String, List<String>> getSourceTypeMap(List<Long> mulPks) {
        Map objs = null;
        if (mulPks == null || mulPks.isEmpty()) {
            QFilter qFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            objs = BusinessDataServiceHelper.loadFromCache((String)"ar_sourcetype", (String)"entityobject, billtype", (QFilter[])new QFilter[]{qFilter});
        } else {
            objs = BusinessDataServiceHelper.loadFromCache((Object[])mulPks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ar_sourcetype"));
        }
        HashMap<String, List<String>> sourceMap = new HashMap<String, List<String>>(objs.size());
        for (Map.Entry entrySet : objs.entrySet()) {
            DynamicObject obj = (DynamicObject)entrySet.getValue();
            String entityKey = obj.getDynamicObject("entityobject").getString("number");
            ArrayList<String> billTypes = (ArrayList<String>)sourceMap.get(entityKey);
            if (billTypes == null) {
                billTypes = new ArrayList<String>();
            }
            if (!ObjectUtils.isEmpty((Object)obj.getString("billtype"))) {
                billTypes.add(obj.getString("billtype"));
            }
            sourceMap.put(entityKey, billTypes);
        }
        return sourceMap;
    }

    @Deprecated
    public static List<DynamicObject> decomposeAmt(BigDecimal disposeAmt, BigDecimal exRate, String quotation, DynamicObjectCollection entries, boolean isPeriod, int precision) {
        ArrayList<DynamicObject> detailList = new ArrayList<DynamicObject>();
        BigDecimal decompAmt = disposeAmt;
        for (DynamicObject detail : entries) {
            BigDecimal applyAmt = detail.getBigDecimal("e_unlockamt");
            if (applyAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (applyAmt.compareTo(decompAmt) >= 0) {
                detail.set("e_baddebtamt", (Object)decompAmt);
                if (quotation.equals("0")) {
                    detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
                } else {
                    detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
                }
                if (!isPeriod) {
                    detail.set("e_unlockamt", (Object)detail.getBigDecimal("e_baddebtamt"));
                    detail.set("e_lockedamt", (Object)BigDecimal.ZERO);
                }
                detail.set("e_unsettleamt", (Object)detail.getBigDecimal("e_baddebtamt"));
                detailList.add(detail);
                break;
            }
            if (applyAmt.compareTo(decompAmt) >= 0) continue;
            detail.set("e_baddebtamt", (Object)applyAmt);
            if (quotation.equals("0")) {
                detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
            } else {
                detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
            }
            if (!isPeriod) {
                detail.set("e_unlockamt", (Object)detail.getBigDecimal("e_baddebtamt"));
                detail.set("e_lockedamt", (Object)BigDecimal.ZERO);
            }
            detail.set("e_unsettleamt", (Object)detail.getBigDecimal("e_baddebtamt"));
            decompAmt = decompAmt.subtract(applyAmt);
            detailList.add(detail);
        }
        return detailList;
    }

    public static void resolveDetailEntry(BigDecimal disposeAmt, BigDecimal exRate, String quotation, DynamicObjectCollection entries, boolean isPeriod, int precision) {
        Iterator detailItr = entries.iterator();
        BigDecimal detailDisposeAmt = disposeAmt;
        while (detailItr.hasNext()) {
            DynamicObject detail = (DynamicObject)detailItr.next();
            BigDecimal applyAmt = detail.getBigDecimal("e_unlockamt");
            if (applyAmt.compareTo(BigDecimal.ZERO) <= 0 || detailDisposeAmt.compareTo(BigDecimal.ZERO) == 0) {
                detailItr.remove();
                continue;
            }
            if (applyAmt.compareTo(detailDisposeAmt) >= 0) {
                detail.set("e_baddebtamt", (Object)detailDisposeAmt);
                if (quotation.equals("0")) {
                    detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
                } else {
                    detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
                }
                if (!isPeriod) {
                    detail.set("e_unlockamt", (Object)detail.getBigDecimal("e_baddebtamt"));
                    detail.set("e_lockedamt", (Object)BigDecimal.ZERO);
                }
                detail.set("e_unsettleamt", (Object)detail.getBigDecimal("e_baddebtamt"));
                detailDisposeAmt = BigDecimal.ZERO;
                continue;
            }
            if (applyAmt.compareTo(detailDisposeAmt) >= 0) continue;
            detail.set("e_baddebtamt", (Object)applyAmt);
            if (quotation.equals("0")) {
                detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
            } else {
                detail.set("e_baddebtlocamt", (Object)detail.getBigDecimal("e_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
            }
            if (!isPeriod) {
                detail.set("e_unlockamt", (Object)detail.getBigDecimal("e_baddebtamt"));
                detail.set("e_lockedamt", (Object)BigDecimal.ZERO);
            }
            detail.set("e_unsettleamt", (Object)detail.getBigDecimal("e_baddebtamt"));
            detailDisposeAmt = detailDisposeAmt.subtract(applyAmt);
        }
    }

    public static void resolvePlanEntry(BigDecimal disposeAmt, BigDecimal exRate, String quotation, DynamicObjectCollection entries, boolean isPeriod, int precision) {
        Iterator iterator = entries.iterator();
        BigDecimal decompAmt = disposeAmt;
        while (iterator.hasNext()) {
            DynamicObject entry = (DynamicObject)iterator.next();
            BigDecimal applyAmt = entry.getBigDecimal("p_unlockamt");
            if (applyAmt.compareTo(BigDecimal.ZERO) <= 0 || decompAmt.compareTo(BigDecimal.ZERO) == 0) {
                iterator.remove();
                continue;
            }
            if (applyAmt.compareTo(decompAmt) >= 0) {
                entry.set("p_baddebtamt", (Object)decompAmt);
                if (quotation.equals("0")) {
                    entry.set("p_baddebtlocamt", (Object)entry.getBigDecimal("p_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
                } else {
                    entry.set("p_baddebtlocamt", (Object)entry.getBigDecimal("p_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
                }
                entry.set("p_unlockamt", (Object)entry.getBigDecimal("p_baddebtamt"));
                entry.set("p_lockedamt", (Object)BigDecimal.ZERO);
                entry.set("p_unsettleamt", (Object)entry.getBigDecimal("p_baddebtamt"));
                decompAmt = BigDecimal.ZERO;
                continue;
            }
            if (applyAmt.compareTo(decompAmt) >= 0) continue;
            entry.set("p_baddebtamt", (Object)applyAmt);
            if (quotation.equals("0")) {
                entry.set("p_baddebtlocamt", (Object)entry.getBigDecimal("p_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
            } else {
                entry.set("p_baddebtlocamt", (Object)entry.getBigDecimal("p_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
            }
            entry.set("p_unlockamt", (Object)entry.getBigDecimal("p_baddebtamt"));
            entry.set("p_lockedamt", (Object)BigDecimal.ZERO);
            entry.set("p_unsettleamt", (Object)entry.getBigDecimal("p_baddebtamt"));
            decompAmt = decompAmt.subtract(applyAmt);
        }
    }

    @Deprecated
    public static List<DynamicObject> decomposeAmt2Plan(BigDecimal disposeAmt, BigDecimal exRate, String quotation, DynamicObjectCollection planEntries, boolean isPeriod, int precision) {
        ArrayList<DynamicObject> planList = new ArrayList<DynamicObject>();
        BigDecimal decompAmt = disposeAmt;
        for (DynamicObject detail : planEntries) {
            BigDecimal applyAmt = detail.getBigDecimal("p_unlockamt");
            if (applyAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (applyAmt.compareTo(decompAmt) >= 0) {
                detail.set("p_baddebtamt", (Object)decompAmt);
                if (quotation.equals("0")) {
                    detail.set("p_baddebtlocamt", (Object)detail.getBigDecimal("p_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
                } else {
                    detail.set("p_baddebtlocamt", (Object)detail.getBigDecimal("p_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
                }
                if (!isPeriod) {
                    detail.set("p_unlockamt", (Object)detail.getBigDecimal("p_baddebtamt"));
                    detail.set("p_lockedamt", (Object)BigDecimal.ZERO);
                }
                detail.set("p_unsettleamt", (Object)detail.getBigDecimal("p_baddebtamt"));
                planList.add(detail);
                break;
            }
            if (applyAmt.compareTo(decompAmt) >= 0) continue;
            detail.set("p_baddebtamt", (Object)applyAmt);
            if (quotation.equals("0")) {
                detail.set("p_baddebtlocamt", (Object)detail.getBigDecimal("p_baddebtamt").multiply(exRate).setScale(precision, RoundingMode.HALF_UP));
            } else {
                detail.set("p_baddebtlocamt", (Object)detail.getBigDecimal("p_baddebtamt").divide(exRate, precision, RoundingMode.HALF_UP));
            }
            if (!isPeriod) {
                detail.set("p_unlockamt", (Object)detail.getBigDecimal("p_baddebtamt"));
                detail.set("p_lockedamt", (Object)BigDecimal.ZERO);
            }
            detail.set("p_unsettleamt", (Object)detail.getBigDecimal("p_baddebtamt"));
            decompAmt = decompAmt.subtract(applyAmt);
            planList.add(detail);
        }
        return planList;
    }

    public static String getRangeValue(String rangeKey) {
        String value = null;
        if (rangeValueMap == null) {
            rangeValueMap = BaddebtHelper.getRangeMap();
        }
        value = !rangeValueMap.containsKey(rangeKey) ? rangeKey : rangeValueMap.get(rangeKey);
        return value;
    }

    private static Map<String, String> getRangeMap() {
        LinkedHashMap<String, String> rangeValueMap = new LinkedHashMap<String, String>(20);
        rangeValueMap.put("whole", ResManager.loadKDString((String)"\u6240\u6709\u533a\u95f4", (String)"BaddebtHelper_0", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m1", ResManager.loadKDString((String)"1 \u6708", (String)"BaddebtHelper_1", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m2", ResManager.loadKDString((String)"2 \u6708", (String)"BaddebtHelper_2", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m3", ResManager.loadKDString((String)"3 \u6708", (String)"BaddebtHelper_3", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m4", ResManager.loadKDString((String)"4 \u6708", (String)"BaddebtHelper_4", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m5", ResManager.loadKDString((String)"5 \u6708", (String)"BaddebtHelper_5", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m6", ResManager.loadKDString((String)"6 \u6708", (String)"BaddebtHelper_6", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m7", ResManager.loadKDString((String)"7 \u6708", (String)"BaddebtHelper_7", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m8", ResManager.loadKDString((String)"8 \u6708", (String)"BaddebtHelper_8", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m9", ResManager.loadKDString((String)"9 \u6708", (String)"BaddebtHelper_9", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m10", ResManager.loadKDString((String)"10 \u6708", (String)"BaddebtHelper_10", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m11", ResManager.loadKDString((String)"11 \u6708", (String)"BaddebtHelper_11", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("m12", ResManager.loadKDString((String)"12 \u6708", (String)"BaddebtHelper_12", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("q1", ResManager.loadKDString((String)"1 \u5b63\u5ea6", (String)"BaddebtHelper_13", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("q2", ResManager.loadKDString((String)"2 \u5b63\u5ea6", (String)"BaddebtHelper_14", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("q3", ResManager.loadKDString((String)"3 \u5b63\u5ea6", (String)"BaddebtHelper_15", (String)"fi-ar-business", (Object[])new Object[0]));
        rangeValueMap.put("q4", ResManager.loadKDString((String)"4 \u5b63\u5ea6", (String)"BaddebtHelper_16", (String)"fi-ar-business", (Object[])new Object[0]));
        return rangeValueMap;
    }

    public static void disposeReserveBill(List<Long> busPks) {
        Object[] initReserves;
        QFilter qf = new QFilter("id", "in", (Object)busPks.toArray());
        qf.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        DynamicObject[] busBills = BusinessDataServiceHelper.load((String)"ar_busbill", (String)"id, entry.e_recamount, entry.e_invoicedamt, entry.e_uninvoicedamt", (QFilter[])new QFilter[]{qf});
        QFilter qFilter = new QFilter("sourcebillid", "in", (Object)busPks.toArray());
        for (Object initReserve : initReserves = BusinessDataServiceHelper.load((String)"ar_baddebtreservebill", (String)"id, exchangerate, sourcebillid, unsettleamt, unsettlelocalamt, baddebtreserveamt, referencerate", (QFilter[])new QFilter[]{qFilter})) {
            BigDecimal exchangeRate = initReserve.getBigDecimal("exchangerate");
            int precision = exchangeRate.scale();
            long sourcebillid = initReserve.getLong("sourcebillid");
            for (DynamicObject busBill : busBills) {
                if (!busBill.getPkValue().equals(sourcebillid)) continue;
                BigDecimal actUnInvoicedAmt = BigDecimal.ZERO;
                for (DynamicObject entry : busBill.getDynamicObjectCollection("entry")) {
                    BigDecimal recamount = entry.getBigDecimal("e_recamount");
                    BigDecimal invoicedamt = entry.getBigDecimal("e_invoicedamt");
                    if (recamount.abs().compareTo(invoicedamt.abs()) <= 0) continue;
                    actUnInvoicedAmt = actUnInvoicedAmt.add(entry.getBigDecimal("e_uninvoicedamt"));
                }
                initReserve.set("unsettleamt", (Object)actUnInvoicedAmt);
                BigDecimal unSettleLocAmt = actUnInvoicedAmt.multiply(exchangeRate);
                initReserve.set("unsettlelocalamt", (Object)unSettleLocAmt);
                if (unSettleLocAmt.compareTo(BigDecimal.ZERO) != 0) {
                    initReserve.set("referencerate", (Object)initReserve.getBigDecimal("baddebtreserveamt").divide(initReserve.getBigDecimal("unsettlelocalamt"), 2 + precision, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(precision, RoundingMode.HALF_UP));
                    continue;
                }
                initReserve.set("referencerate", (Object)BigDecimal.ZERO);
            }
        }
        if (!ObjectUtils.isEmpty((Object[])initReserves)) {
            SaveServiceHelper.save((DynamicObject[])initReserves);
        }
    }
}

