/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.baddebt.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.baddebt.AbstractReserve;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.business.baddebt.IAccrual;
import kd.fi.ar.business.baddebt.impl.BusReserveImpl;
import kd.fi.ar.business.baddebt.impl.FinReserveImpl;
import kd.fi.ar.business.baddebt.info.AccrualFilterParam;
import kd.fi.ar.business.baddebt.info.AccrualSchemeEntryInfo;
import kd.fi.ar.business.baddebt.info.AccrualSchemeInfo;
import kd.fi.ar.enums.AccrualMethodEnum;
import kd.fi.ar.enums.FrequencyEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;

public class AccrualImpl
implements IAccrual {
    public static final String RANGE_ALL = "whole";

    @Override
    public AccrualSchemeInfo getSchemeInfo(Object accrualSchemePk, Object orgPk) {
        AccrualSchemeInfo scheme = new AccrualSchemeInfo();
        DynamicObject accrualScheme = BusinessDataServiceHelper.loadSingle((Object)accrualSchemePk, (String)"ar_accrualscheme");
        scheme.setOrgId(orgPk.toString());
        scheme.setMethod(accrualScheme.getString("accrualmethod"));
        scheme.setFrequency(accrualScheme.getString("accrualfrequency"));
        scheme.setSpread(accrualScheme.getBoolean("isspread"));
        DynamicObjectCollection entrys = accrualScheme.getDynamicObjectCollection("entryentity");
        ArrayList<AccrualSchemeEntryInfo> entries = new ArrayList<AccrualSchemeEntryInfo>();
        DynamicObjectCollection mapEntrys = accrualScheme.getDynamicObjectCollection("fieldmapentry");
        for (DynamicObject entry : entrys) {
            AccrualSchemeEntryInfo entryInfo = new AccrualSchemeEntryInfo();
            ArrayList<Map<String, List<Long>>> list = new ArrayList<Map<String, List<Long>>>();
            Iterator iterator = mapEntrys.iterator();
            while (iterator.hasNext()) {
                TreeMap map = new TreeMap();
                DynamicObject mapEntry = (DynamicObject)iterator.next();
                String key = mapEntry.getString("entityid");
                ArrayList<Long> mulPks = (ArrayList<Long>)map.get(key);
                if (mulPks == null) {
                    mulPks = new ArrayList<Long>();
                }
                String fieldKey = mapEntry.getString("fieldkey");
                DynamicObjectCollection mulbds = entry.getDynamicObjectCollection(fieldKey);
                for (DynamicObject mulbd : mulbds) {
                    mulPks.add(mulbd.getLong("fbasedataid_id"));
                }
                map.put(key, mulPks);
                list.add(map);
                if (mapEntrys.size() <= 1 || !"bd_customer".equals(key) || mulPks.isEmpty()) continue;
                entryInfo.setCustList(mulPks);
            }
            ArrayList<Long> mulPks = new ArrayList<Long>();
            DynamicObjectCollection mulbds = entry.getDynamicObjectCollection("mulbdfactor2");
            for (DynamicObject mulbd : mulbds) {
                mulPks.add(mulbd.getLong("fbasedataid_id"));
            }
            TreeMap<String, ArrayList<Long>> stMap = new TreeMap<String, ArrayList<Long>>();
            stMap.put("ar_sourcetype", mulPks);
            list.add(stMap);
            entryInfo.setList(list);
            entryInfo.setRange(entry.getString("range"));
            entryInfo.setRate(entry.getBigDecimal("accrualrate"));
            if (AccrualMethodEnum.acctAgeAnalysis.name().equals(scheme.getMethod())) {
                entryInfo.setDays(entry.getInt("days"));
                entryInfo.setAbove(entry.getBoolean("isabove"));
                if (!entry.getBoolean("isabove")) {
                    entryInfo.setEndDays(entry.getInt("enddays"));
                }
            }
            entries.add(entryInfo);
        }
        scheme.setEntries(entries);
        return scheme;
    }

    @Override
    public List<DynamicObject> genTargetBills(AccrualSchemeInfo schemeInfo, Object periodPk, DynamicObject policy, boolean isFirst) {
        ArrayList<DynamicObject> destList = new ArrayList<DynamicObject>();
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)periodPk, (String)"bd_period");
        String method = schemeInfo.getMethod();
        Long orgPk = Long.valueOf(schemeInfo.getOrgId());
        String frequency = schemeInfo.getFrequency();
        List<AccrualFilterParam> filterParamList = this.getFilterParamList(schemeInfo, currPeriod);
        HashSet<Long> idSet = new HashSet<Long>();
        for (AccrualFilterParam filterParam : filterParamList) {
            Map<String, List<String>> sourceMap = filterParam.getSourceMap();
            for (Map.Entry<String, List<String>> entry : sourceMap.entrySet()) {
                filterParam.setEntityKey(entry.getKey());
                filterParam.setBillTypeList(entry.getValue());
                AbstractReserve iReserve = null;
                iReserve = "ar_finarbill".equals(entry.getKey()) ? new FinReserveImpl(entry.getKey(), policy, currPeriod, orgPk, method, frequency, idSet, isFirst) : new BusReserveImpl(entry.getKey(), policy, currPeriod, orgPk, method, frequency, idSet, isFirst);
                List<DynamicObject> reserveList = iReserve.genBaddebtReserve(filterParam);
                if (reserveList.isEmpty()) continue;
                destList.addAll(reserveList);
            }
        }
        if (!destList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])destList.toArray(new DynamicObject[0]));
        }
        return destList;
    }

    private List<AccrualFilterParam> getFilterParamList(AccrualSchemeInfo schemeInfo, DynamicObject currPeriod) {
        ArrayList<AccrualFilterParam> filterParamList = new ArrayList<AccrualFilterParam>();
        Date endDate = currPeriod.getDate("enddate");
        String method = schemeInfo.getMethod();
        int rangeValue = 0;
        String frequency = schemeInfo.getFrequency();
        if (FrequencyEnum.SEASON.getValue().equals(frequency)) {
            rangeValue = currPeriod.getInt("periodquarter");
        } else if (FrequencyEnum.MONTH.getValue().equals(frequency)) {
            rangeValue = currPeriod.getInt("periodnumber");
        }
        List<AccrualSchemeEntryInfo> entries = schemeInfo.getEntries();
        ArrayList<AccrualSchemeEntryInfo> custEntries = null;
        for (AccrualSchemeEntryInfo entryInfo : entries) {
            if (ObjectUtils.isEmpty(entryInfo.getCustList())) continue;
            if (custEntries == null) {
                custEntries = new ArrayList<AccrualSchemeEntryInfo>();
            }
            custEntries.add(entryInfo);
        }
        for (AccrualSchemeEntryInfo entryInfo : entries) {
            AccrualFilterParam filterParam;
            String range = entryInfo.getRange();
            if (AccrualMethodEnum.acctAgeAnalysis.name().equals(method)) {
                filterParam = this.buildFilterParam(entryInfo, custEntries);
                int days = entryInfo.getDays();
                if (!entryInfo.isAbove()) {
                    int enddays = entryInfo.getEndDays() - 1;
                    filterParam.setBeginDate(DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)endDate, (int)(enddays * -1)), (boolean)true));
                    if (days == 0) {
                        filterParam.setEndDate(endDate);
                    } else {
                        filterParam.setEndDate(DateUtils.getNextDay((Date)endDate, (int)((days - 1) * -1)));
                    }
                } else if (days == 0) {
                    filterParam.setEndDate(endDate);
                } else {
                    filterParam.setEndDate(DateUtils.getNextDay((Date)endDate, (int)((days - 1) * -1)));
                }
                filterParam.setRange(range);
                filterParam.setRate(entryInfo.getRate());
                filterParamList.add(filterParam);
                continue;
            }
            if (!StringUtils.substring((String)range, (int)1).equals(rangeValue + "") && !RANGE_ALL.equals(range)) continue;
            filterParam = this.buildFilterParam(entryInfo, custEntries);
            filterParam.setRange(range);
            filterParam.setRate(entryInfo.getRate());
            filterParamList.add(filterParam);
        }
        return filterParamList;
    }

    private AccrualFilterParam buildFilterParam(AccrualSchemeEntryInfo entryInfo, List<AccrualSchemeEntryInfo> custEntries) {
        AccrualFilterParam filterParam = new AccrualFilterParam();
        List<Map<String, List<Long>>> list = entryInfo.getList();
        for (Map<String, List<Long>> map : list) {
            for (Map.Entry<String, List<Long>> entry : map.entrySet()) {
                List<Long> mulPks = entry.getValue();
                if ("ar_sourcetype".equals(entry.getKey())) {
                    Map<String, List<String>> sourceMap = BaddebtHelper.getSourceTypeMap(mulPks);
                    filterParam.setSourceMap(sourceMap);
                    continue;
                }
                if (mulPks == null || mulPks.size() <= 0) continue;
                if ("bd_customer".equals(entry.getKey())) {
                    filterParam.setAsstactType(entry.getKey());
                    QFilter qf = new QFilter("masterid", "in", mulPks);
                    DynamicObjectCollection customers = QueryServiceHelper.query((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{qf});
                    if (!ObjectUtils.isEmpty((Object)customers)) {
                        filterParam.setAsstactList(ArApHelper.getPks((Object)customers));
                        continue;
                    }
                    filterParam.setAsstactList(mulPks);
                    continue;
                }
                List<Long> custPks = new ArrayList<Long>();
                BaseDataHelper.getCustomerPks(mulPks, custPks);
                if (!custPks.isEmpty()) {
                    filterParam.setAsstactType("bd_customer");
                    if (!ObjectUtils.isEmpty(custEntries)) {
                        for (AccrualSchemeEntryInfo custEntry : custEntries) {
                            custPks = ListUtils.subtract(custPks, custEntry.getCustList());
                        }
                    }
                    filterParam.setAsstactList(custPks);
                    continue;
                }
                custPks.add(0L);
                filterParam.setAsstactList(custPks);
            }
        }
        return filterParam;
    }
}

