/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.baddebt.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.baddebt.AbstractReserve;
import kd.fi.ar.business.baddebt.info.AccrualFilterParam;
import kd.fi.ar.enums.AccrualMethodEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.collections4.ListUtils;

public class BusReserveImpl
extends AbstractReserve {
    private String selector4biz = "id, org, billno, bizdate, asstacttype, asstact, currency, exchangerate, recamount, uninvoicedamt, entry.id, entry.e_recamount, entry.e_uninvoicedamt, isperiod ";

    public BusReserveImpl(String entityKey, DynamicObject policy, DynamicObject currPeriod, Long orgPk, String method, String frequency, Set<Long> idSet, boolean isFirst) {
        super(entityKey, policy, currPeriod, orgPk, method, frequency, idSet, isFirst);
    }

    @Override
    protected List<DynamicObject> findBizBill(AccrualFilterParam filterParam, List<QFilter> commonList) {
        ArrayList<DynamicObject> destList = new ArrayList<DynamicObject>();
        List<DynamicObject> bills = this.queryBizBill(filterParam, commonList);
        List<Long> existsPks = bills.stream().map(b -> b.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> settledBills = this.queryPreBill(filterParam, commonList, existsPks);
        List merges = ListUtils.union(bills, settledBills);
        Object policytypePk = this.policy.getDynamicObject("policytype").getPkValue();
        for (DynamicObject srcBill : merges) {
            long srcPk = (Long)srcBill.getPkValue();
            if (!this.idSet.add(srcPk)) continue;
            DynamicObject destBill = this.buildReserve4biz(srcBill, filterParam.getRate(), filterParam.getRange(), policytypePk);
            destList.add(destBill);
        }
        return destList;
    }

    private List<DynamicObject> queryBizBill(AccrualFilterParam filterParam, List<QFilter> commonList) {
        List<String> billTypeList;
        List<QFilter> bizList = this.getFilter(filterParam, commonList, Boolean.FALSE);
        if (!this.isFirst && !AccrualMethodEnum.salesPct.name().equals(this.method)) {
            bizList.add(new QFilter("unwoffamt", ">", (Object)0));
        }
        if ((billTypeList = filterParam.getBillTypeList()) != null) {
            this.selector4biz = this.selector4biz + ", billtype ";
        }
        DynamicObject[] busBills = BusinessDataServiceHelper.load((String)this.entityKey, (String)this.selector4biz, (QFilter[])bizList.toArray(new QFilter[0]));
        List<DynamicObject> busList = this.reCalcUnsettleAmt(busBills, false);
        return busList;
    }

    private List<DynamicObject> reCalcUnsettleAmt(DynamicObject[] bills, boolean containZero) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(0);
        if (!ObjectUtils.isEmpty((Object[])bills)) {
            List pks = ArApHelper.getPks((Object)bills);
            Map<Long, BigDecimal> settledMap = this.getWoffInvoicedAmt(pks);
            for (DynamicObject bill : bills) {
                Long pk = bill.getLong("id");
                BigDecimal recAmt = bill.getBigDecimal("recamount");
                BigDecimal value = settledMap.get(pk);
                BigDecimal settledAmt = value != null ? value : BigDecimal.ZERO;
                BigDecimal unSettleAmt = recAmt.subtract(settledAmt.abs());
                bill.set("uninvoicedamt", (Object)unSettleAmt);
                if (!containZero && !AccrualMethodEnum.salesPct.name().equals(this.method)) {
                    if (unSettleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    billList.add(bill);
                    continue;
                }
                billList.add(bill);
            }
        }
        return billList;
    }

    private List<DynamicObject> queryPreBill(AccrualFilterParam filterParam, List<QFilter> commonList, List<Long> existsPks) {
        List<DynamicObject> busList = new ArrayList<DynamicObject>(0);
        List<Long> prePks = this.getPrePks(existsPks, false);
        if (prePks != null) {
            List<QFilter> bizList = this.getFilter(filterParam, commonList, Boolean.FALSE);
            bizList.add(new QFilter("id", "in", prePks));
            bizList.add(new QFilter("unwoffamt", "=", (Object)0));
            List<String> billTypeList = filterParam.getBillTypeList();
            if (billTypeList != null) {
                this.selector4biz = this.selector4biz + ", billtype ";
            }
            DynamicObject[] busbills = BusinessDataServiceHelper.load((String)this.entityKey, (String)this.selector4biz, (QFilter[])bizList.toArray(new QFilter[0]));
            busList = this.reCalcUnsettleAmt(busbills, true);
        }
        return busList;
    }

    private DynamicObject buildReserve4biz(DynamicObject srcBill, BigDecimal rate, String range, Object policytypePk) {
        BigDecimal initbaddebtreserveamt;
        DynamicObject init;
        Map sourceTypeMap;
        DynamicObject destBill = this.buildBaseReserve(srcBill, rate, range);
        QFilter qFilter = new QFilter("entityobject", "=", (Object)this.entityKey);
        if (!EmptyUtils.isEmpty((Object)srcBill.getDynamicObject("billtype"))) {
            qFilter.and(new QFilter("billtype", "=", (Object)String.valueOf(srcBill.getDynamicObject("billtype").getPkValue())));
        }
        if ((sourceTypeMap = BusinessDataServiceHelper.loadFromCache((String)"ar_sourcetype", (String)"id, number", (QFilter[])new QFilter[]{qFilter}, (String)"isdefault desc")) != null && sourceTypeMap.size() > 0) {
            destBill.set("sourcetype", (Object)sourceTypeMap.values().toArray(new DynamicObject[0])[0]);
        }
        destBill.set("sourcebillno", (Object)srcBill.getString("billno"));
        destBill.set("receivableamt", (Object)srcBill.getBigDecimal("recamount"));
        destBill.set("unsettleamt", (Object)srcBill.getBigDecimal("uninvoicedamt"));
        destBill.set("preaccrualamt", (Object)this.getPreAccrualAmt((Long)this.currPeriod.getPkValue(), (Long)srcBill.getPkValue(), policytypePk));
        if (srcBill.getBoolean("isperiod") && (init = QueryServiceHelper.queryOne((String)"ar_baddebtreservebill", (String)"baddebtreserveamt", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", srcBill.getPkValue())})) != null && (initbaddebtreserveamt = init.getBigDecimal("baddebtreserveamt")) != null) {
            destBill.set("preaccrualamt", (Object)destBill.getBigDecimal("preaccrualamt").add(initbaddebtreserveamt));
        }
        this.setAmtField(destBill, false);
        return destBill;
    }

    @Override
    protected String getDateField() {
        return "bizdate";
    }

    @Override
    protected List<Long> getInitSrcPks(AccrualFilterParam filterParam, List<QFilter> commonList, List<Long> preSrcPks) {
        List<QFilter> bizList = this.getFilter(filterParam, commonList, Boolean.TRUE);
        if (preSrcPks != null) {
            bizList.add(new QFilter("id", "in", preSrcPks));
            if (!AccrualMethodEnum.salesPct.name().equals(this.method)) {
                bizList.add(new QFilter("unwoffamt", "=", (Object)0));
            }
        } else if (!this.isFirst && !AccrualMethodEnum.salesPct.name().equals(this.method)) {
            bizList.add(new QFilter("unwoffamt", ">", (Object)0));
        }
        DynamicObjectCollection inits = QueryServiceHelper.query((String)this.entityKey, (String)"id", (QFilter[])bizList.toArray(new QFilter[0]));
        return ArApHelper.getPks((Object)inits);
    }

    private List<QFilter> getFilter(AccrualFilterParam filterParam, List<QFilter> commonList, Boolean isPeriod) {
        ArrayList<QFilter> bizList = new ArrayList<QFilter>(2);
        bizList.addAll(commonList);
        bizList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        bizList.add(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
        bizList.add(new QFilter("isperiod", "=", (Object)isPeriod));
        List<String> billTypeList = filterParam.getBillTypeList();
        if (billTypeList != null) {
            bizList.add(new QFilter("billtype", "in", this.convertToLongList(billTypeList)));
        }
        return bizList;
    }
}

