/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.baddebt.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.baddebt.info.InitAmtPair;
import kd.fi.arapcommon.init.AbstractInitAsstactDetail;
import kd.fi.arapcommon.init.info.AmtPair;
import kd.fi.arapcommon.init.info.InitEntryInfo;
import kd.fi.arapcommon.init.info.MergeKey;

public class InitAsstactBaddebtAmtDetail
extends AbstractInitAsstactDetail {
    public InitAsstactBaddebtAmtDetail(long orgPk) {
        super("ar_baddebtlossbill", orgPk);
    }

    public String getSelector() {
        return "asstacttype, asstact, currency, baddebtamt";
    }

    public String[] getGroupBys() {
        return new String[]{"asstacttype", "asstact", "currency"};
    }

    protected String getAmountField() {
        return "baddebtamt";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InitEntryInfo> getAsstDetail() {
        ArrayList<InitEntryInfo> result = new ArrayList<InitEntryInfo>();
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)this.orgPk), new QFilter("isperiod", "=", (Object)Boolean.TRUE)};
        ArrayList asstTypes = new ArrayList();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ar.getAsstDetail.asstType", (String)this.entityName, (String)"asstacttype", (QFilter[])filters, null).groupBy(new String[]{"asstacttype"}).finish();){
            dataSet.forEach(row -> asstTypes.add(row.getString("asstacttype")));
        }
        if (!asstTypes.isEmpty()) {
            try (DataSet ds = null;){
                DataSet bizDS = QueryServiceHelper.queryDataSet((String)InitAsstactBaddebtAmtDetail.class.toString(), (String)this.entityName, (String)this.getSelector(), (QFilter[])filters, null);
                DataSet bdDS = this.getAsstDataSet(asstTypes);
                DataSet dataSet = bizDS.copy().leftJoin(bdDS).on("asstact", "id").select(new String[]{"asstacttype", "masterid", "currency", "baddebtamt"}).finish();
                ds = dataSet.groupBy(new String[]{"asstacttype", "masterid", "currency"}).sum("baddebtamt").finish();
                ds.forEach(row -> {
                    String asstactType = row.getString("asstacttype");
                    long asstact = row.getLong("masterid");
                    long currency = row.getLong("currency");
                    BigDecimal badDebtAmt = row.getBigDecimal("baddebtamt");
                    MergeKey mergeKey = new MergeKey(asstactType, asstact, currency);
                    InitAmtPair pair = new InitAmtPair(null, null, badDebtAmt, null);
                    InitEntryInfo info = new InitEntryInfo(mergeKey, (AmtPair)pair);
                    result.add(info);
                });
            }
        }
        return result;
    }
}

