/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ar.business.invoice.InvoiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.util.AES128;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ConfigRequestAction
extends AbstractAction {
    private static Log logger = LogFactory.getLog(ConfigRequestAction.class);
    private Map<String, Object> map;

    public ConfigRequestAction(String taxNo, Map<String, Object> map) {
        this.taxRegNum = taxNo;
        this.map = map;
    }

    public String execute() {
        String response;
        if (InvoiceHelper.isMicroService()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("identifytype", "config");
            map.put("data", this.map);
            String jsonStr = JsonUtils.objToJson(map);
            logger.info("ConfigRequestAction -- jsonStr:" + jsonStr);
            String url = InvoiceHelper.getBaseBizUrl();
            return this.doPost(url, jsonStr);
        }
        String domain = KingdeeInvoiceCloudConfig.getDomain();
        String url = domain + "/m17/bill/encrypt/url/config?encry_type=GCM&access_token=" + this.token;
        String jsonStr = JsonUtils.objToJson(this.map);
        logger.info("ConfigRequestAction -- jsonStr:" + jsonStr);
        DynamicObject clientConfig = KingdeeInvoiceCloudConfig.getClientConfig((String)this.taxRegNum);
        String encrypt_key = clientConfig.getString("encrypt_key");
        String jsonEncrypt = "";
        try {
            jsonEncrypt = AES128.encrypt((String)jsonStr, (String)encrypt_key);
            if (StringUtils.isEmpty((String)jsonEncrypt)) {
                throw new KDBizException("The length of the Key is not 16!");
            }
        }
        catch (Exception e) {
            throw new KDBizException("AES128 Encryption message error!");
        }
        try {
            response = this.doPost(url, jsonEncrypt);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u914d\u7f6e\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u534f\u52a9\u68c0\u67e5\u3002", (String)"ConfigRequestAction_0", (String)"fi-ar-business", (Object[])new Object[0]));
        }
        return response;
    }

    public String desc() {
        return "ConfigRequestAction";
    }
}

