/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.ar.business.invoice.InvoiceData;
import kd.fi.ar.business.invoice.InvoiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.util.AES128;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvalidInvoiceAction
extends AbstractAction {
    private static Log logger = LogFactory.getLog(InvalidInvoiceAction.class);
    private InvoiceData invoiceData;

    public InvalidInvoiceAction(String taxNo, InvoiceData invoiceData) {
        this.taxRegNum = taxNo;
        this.invoiceData = invoiceData;
    }

    public String execute() {
        String response;
        if (InvoiceHelper.isMicroService()) {
            String response2;
            String jsonStr = JSONObject.toJSONString((Object)this.invoiceData);
            logger.info("InvalidInvoiceAction -- jsonStr:" + jsonStr);
            try {
                response2 = (String)DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"FiInvoiceCancelServiceImpl", (String)"doBusiness", (Object[])new Object[]{jsonStr});
            }
            catch (Exception e) {
                throw new KDBizException("Abnormal interface for voiding invoice:" + e.getMessage());
            }
            return response2;
        }
        String domain = KingdeeInvoiceCloudConfig.getDomain();
        String url = domain + "/m17/bill/encrypt/openinvoice/invalid?encry_type=GCM&access_token=" + this.token;
        String jsonStr = JsonUtils.objToJson((Object)this.invoiceData);
        logger.info("InvalidInvoiceAction -- jsonStr:" + jsonStr);
        DynamicObject clientConfig = KingdeeInvoiceCloudConfig.getClientConfig((String)this.taxRegNum);
        String encrypt_key = clientConfig.getString("encrypt_key");
        String jsonEncrypt = "";
        try {
            jsonEncrypt = AES128.encrypt((String)jsonStr, (String)encrypt_key);
            if (StringUtils.isEmpty((String)jsonEncrypt)) {
                throw new KDBizException("The length of the Key is not 16!");
            }
        }
        catch (Exception e) {
            throw new KDBizException("AES128 Encryption message error!");
        }
        try {
            response = this.doPost(url, jsonEncrypt);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u4f5c\u5e9f\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"InvalidInvoiceAction_0", (String)"fi-ar-business", (Object[])new Object[0]));
        }
        return response;
    }

    public String desc() {
        return "InvalidInvoiceAction";
    }
}

