/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.invoice.InvoiceSplitter;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCloudCallBackService {
    private static Log logger = LogFactory.getLog(InvoiceCloudCallBackService.class);
    private String splitStr = ",";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void issueCallBack(List<Map<String, Object>> issueCallBackParams) {
        Map<String, Object> issueCallBackParam = issueCallBackParams.get(0);
        DynamicObject invoice = this.loadInvoiceForIssue(issueCallBackParam);
        if (invoice == null) {
            throw new KDBizException("None invoice was found.");
        }
        HashSet<Long> keySet = new HashSet<Long>(1);
        keySet.add(invoice.getLong("id"));
        MutexLockHelper.requireMutex((String)"ar_invoice", keySet, (String)"issuecallback", (String)"In progress, try again later...");
        try (TXHandle txHandle = TX.required();){
            try {
                InvoiceSplitter invoiceSplitter;
                if (issueCallBackParams.size() == 1) {
                    invoiceSplitter = new InvoiceSplitter();
                    if (invoiceSplitter.isErrData(issueCallBackParam) || "9".equals(invoice.get("invoicestatus"))) {
                        if (ObjectUtils.isEmpty((Object)issueCallBackParam.get("interfaceCode"))) return;
                        if (!"BILL_WITH_DRAW".equals(issueCallBackParam.get("interfaceCode"))) return;
                        invoice.set("invoicestatus", (Object)"0");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
                        return;
                    }
                    JSONObject json = (JSONObject)JSON.parseObject((String)JSON.toJSONString(issueCallBackParam), JSONObject.class);
                    BigDecimal totalAmount = json.getBigDecimal("totalAmount");
                    Object isPartErr = issueCallBackParam.get("isPartErr");
                    if (isPartErr == null && totalAmount.compareTo(invoice.getBigDecimal("recamount")) < 0) {
                        invoiceSplitter.handlePartErr(invoice);
                        return;
                    }
                    invoice.set("invoicestatus", (Object)"1");
                    if (isPartErr == null) {
                        invoiceSplitter.writeBackInvoice(invoice, issueCallBackParam);
                    }
                    OpLogServiceHelper.addLog((String)"IssueCallBack", issueCallBackParam, (DynamicObject[])new DynamicObject[]{invoice}, (boolean)false);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
                    this.writeBackBusBill(new DynamicObject[]{invoice});
                } else {
                    invoiceSplitter = new InvoiceSplitter(issueCallBackParams);
                    List<DynamicObject> splitList = invoiceSplitter.split();
                    if (splitList != null) {
                        DynamicObject[] invoices = splitList.toArray(new DynamicObject[splitList.size()]);
                        this.writeBackBusBill(invoices);
                        OpLogServiceHelper.addLog((String)"IssueCallBack", issueCallBackParams, (DynamicObject[])invoices, (boolean)false);
                        invoice = invoices[invoices.length - 1];
                    }
                }
                if (invoice == null) return;
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"issuecallback", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{invoice}, null);
                if (opResult.isSuccess()) return;
                logger.info("------operationResult.Message------" + opResult.getMessage());
                OperationHelper.assertResult((OperationResult)opResult);
                return;
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
            finally {
                MutexLockHelper.batchRelease((String)"ar_invoice", keySet, (String)"issuecallback");
            }
        }
    }

    private DynamicObject loadInvoiceForIssue(Map<String, Object> issueCallBackParam) {
        String billNo = (String)issueCallBackParam.get("billNo");
        QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)billNo)};
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("serialno");
        selectors.add("invoicecode");
        selectors.add("invoiceno");
        selectors.add("pdfurl");
        selectors.add("invoicestatus");
        selectors.add("bizdate");
        selectors.add("drawer");
        selectors.add("recamount");
        selectors.add("auditor");
        selectors.add("redinvoice");
        selectors.add("invoicetype");
        selectors.add("invoicetypef7");
        selectors.add("redinfono");
        selectors.add("varianceamount");
        selectors.add("entry.id");
        return BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)String.join((CharSequence)",", selectors), (QFilter[])filters);
    }

    public Map<String, String> findSourceBillEntryId(List<BFRow> loadSourceRowIds, long targetBillEntryId, long arBusbillId) {
        Map<String, String> sourceBillEntryIdmap = new HashMap<String, String>();
        if (sourceBillEntryIdmap.get(String.valueOf(targetBillEntryId)) != null) {
            return sourceBillEntryIdmap;
        }
        for (BFRow bfRow : loadSourceRowIds) {
            if (targetBillEntryId != bfRow.getId().getEntryId()) continue;
            if (bfRow.getSId().getBillId() == arBusbillId) {
                sourceBillEntryIdmap.put("sourceId", String.valueOf(bfRow.getSId().getEntryId()));
                break;
            }
            sourceBillEntryIdmap = this.findSourceBillEntryId(loadSourceRowIds, bfRow.getSId().getEntryId(), arBusbillId);
        }
        return sourceBillEntryIdmap;
    }

    public void writeBackBusBill(DynamicObject[] invoices) {
        logger.info("writeBackBusBill begin");
        Map linkBills = BFTrackerServiceHelper.findSourceBills((String)"ar_invoice", (Long[])new Long[]{invoices[invoices.length - 1].getLong("id")});
        HashSet srcBusIds = (HashSet)linkBills.get("ar_busbill");
        if (ObjectUtils.isEmpty((Object)srcBusIds)) {
            return;
        }
        Long srcBusId = (Long)srcBusIds.iterator().next();
        logger.info("srcBusIds:" + srcBusId);
        DynamicObject srcBus = BusinessDataServiceHelper.loadSingle((String)"ar_busbill", (String)"id,entry.invoicecode,entry.invoiceno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcBusId)});
        for (DynamicObject invoice : invoices) {
            Object entry2;
            ArrayList<Map<String, String>> sourceAndTarget = new ArrayList<Map<String, String>>();
            DynamicObjectCollection entrys = invoice.getDynamicObjectCollection("entry");
            for (Object entry2 : entrys) {
                long entryId = (Long)entry2.get("id");
                List loadSourceRowIds = BFTrackerServiceHelper.loadSourceRowIds((String)"ar_invoice", (String)"entry", (Long[])new Long[]{entryId});
                Map<String, String> entryMap = this.findSourceBillEntryId(loadSourceRowIds, entryId, srcBusId);
                if (ObjectUtils.isEmpty(entryMap)) continue;
                sourceAndTarget.add(entryMap);
            }
            logger.info("srcBusIds:" + srcBusId + ",sourceAndTarget:" + sourceAndTarget);
            StringBuilder entryIdsStr = new StringBuilder();
            entry2 = sourceAndTarget.iterator();
            while (entry2.hasNext()) {
                Map entryIdMap = (Map)entry2.next();
                if (entryIdsStr.toString().contains((CharSequence)entryIdMap.get("sourceId"))) continue;
                entryIdsStr.append((String)entryIdMap.get("sourceId"));
                entryIdsStr.append(',');
            }
            logger.info(MessageFormat.format("srcBusIds:{0},entryIds:{1}", String.valueOf(srcBusId), entryIdsStr.toString()));
            String invoicecode = "";
            String invoiceno = "";
            DynamicObjectCollection busEntrys = srcBus.getDynamicObjectCollection("entry");
            for (DynamicObject entry3 : busEntrys) {
                if (!entryIdsStr.toString().contains(entry3.get("id").toString())) continue;
                invoicecode = StringUtils.isEmpty((CharSequence)entry3.getString("invoicecode")) ? entry3.getString("invoicecode") + invoice.getString("invoicecode") : entry3.getString("invoicecode") + "," + invoice.getString("invoicecode");
                entry3.set("invoicecode", (Object)invoicecode);
                invoiceno = StringUtils.isEmpty((CharSequence)entry3.getString("invoiceno")) ? entry3.getString("invoiceno") + invoice.getString("invoiceno") : entry3.getString("invoiceno") + "," + invoice.getString("invoiceno");
                entry3.set("invoiceno", (Object)invoiceno);
            }
            logger.info("invoicecode:" + invoicecode);
            logger.info("invoiceno:" + invoiceno);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBus});
        logger.info("writeBackBusBill end");
    }

    public void writeoffCallBack(Map<String, Object> writeoffCallBackParam) {
        logger.info("writeoffCallBack \uff1a Can you see me\uff1f ");
        String billNo = (String)writeoffCallBackParam.get("billNo");
        QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)billNo)};
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)"id,invoicestatus,entry.e_unverifiedwriteoffamt", (QFilter[])filters);
        if (invoice == null) {
            throw new KDBizException("Invoice was not been found. billNo=" + billNo);
        }
        QFilter[] redInvoiceFilters = new QFilter[]{new QFilter("sourcebillid", "=", (Object)invoice.getPkValue().toString()), new QFilter("redinvoice", "=", (Object)Boolean.TRUE), new QFilter("invoicestatus", "!=", (Object)"3")};
        boolean existsRedInvoice = QueryServiceHelper.exists((String)"ar_invoice", (QFilter[])redInvoiceFilters);
        if (existsRedInvoice) {
            Object invoicestatus = invoice.get("invoicestatus");
            if ("8".equals(invoicestatus) || "7".equals(invoicestatus)) {
                return;
            }
            invoice.set("invoicestatus", (Object)"8");
            DynamicObjectCollection entries = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                if (BigDecimal.ZERO.compareTo(entry.getBigDecimal("e_unverifiedwriteoffamt")) >= 0) continue;
                invoice.set("invoicestatus", (Object)"7");
                break;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
            return;
        }
    }

    public void abandonCallBack(Map<String, Object> abandonCallBackParam) {
        logger.info("abandonCallBack \uff1a Can you see me\uff1f ");
        Object invoiceStatus = abandonCallBackParam.get("invoiceStatus");
        if ("2".equals(invoiceStatus)) {
            String invoiceCode = (String)abandonCallBackParam.get("invoiceCode");
            String invoiceNo = (String)abandonCallBackParam.get("invoiceNo");
            QFilter filter = new QFilter("invoicecode", "=", (Object)invoiceCode);
            filter.and(new QFilter("invoiceno", "=", (Object)invoiceNo));
            DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)"billno,invoicestatus,invoicecode,invoiceno", (QFilter[])filter.toArray());
            if (invoice == null) {
                throw new KDBizException("Invoice was not been found. invoiceNo=" + invoiceNo);
            }
            this.invalidCallBack(invoice);
        }
    }

    public void clearSrcBusBill(DynamicObject invoice) {
        Map linkBills = BFTrackerServiceHelper.findSourceBills((String)"ar_invoice", (Long[])new Long[]{invoice.getLong("id")});
        HashSet srcBusIds = (HashSet)linkBills.get("ar_busbill");
        if (ObjectUtils.isEmpty((Object)srcBusIds)) {
            return;
        }
        Long srcBusId = (Long)srcBusIds.iterator().next();
        logger.info("srcBusIds:" + srcBusId);
        DynamicObject srcBus = BusinessDataServiceHelper.loadSingle((String)"ar_busbill", (String)"id,entry.invoicecode,entry.invoiceno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcBusId)});
        ArrayList<Map<String, String>> sourceAndTarget = new ArrayList<Map<String, String>>();
        DynamicObjectCollection entrys = invoice.getDynamicObjectCollection("entry");
        ArrayList<Long> entryIdArray = new ArrayList<Long>();
        for (Object entry : entrys) {
            long entryId = (Long)entry.get("id");
            entryIdArray.add(entryId);
        }
        List loadSourceRowIds = BFTrackerServiceHelper.loadSourceRowIds((String)"ar_invoice", (String)"entry", (Long[])entryIdArray.toArray(new Long[entryIdArray.size()]));
        for (Long entryId : entryIdArray) {
            Map<String, String> map = this.findSourceBillEntryId(loadSourceRowIds, entryId, srcBusId);
            if (ObjectUtils.isEmpty(map)) continue;
            sourceAndTarget.add(map);
        }
        StringBuilder entryIdsStr = new StringBuilder();
        for (Map map : sourceAndTarget) {
            if (entryIdsStr.toString().contains((CharSequence)map.get("sourceId"))) continue;
            entryIdsStr.append((String)map.get("sourceId"));
            entryIdsStr.append(',');
        }
        String invoicecode = invoice.getString("invoicecode");
        String string = invoice.getString("invoiceno");
        DynamicObjectCollection busEntrys = srcBus.getDynamicObjectCollection("entry");
        for (DynamicObject entry : busEntrys) {
            String invcodes;
            int invoicenoNum = 0;
            if (!entryIdsStr.toString().contains(entry.get("id").toString())) continue;
            String invoicenos = entry.getString("invoiceno");
            if (!StringUtils.isEmpty((CharSequence)invoicenos)) {
                String entryInvoiceNo = entry.getString("invoiceno");
                String[] entryInvoiceNos = entryInvoiceNo.split(this.splitStr);
                if (entryInvoiceNos.length == 1 && string.equals(entryInvoiceNos[0])) {
                    entry.set("invoiceno", null);
                } else {
                    StringBuilder entryInvoiceNoBuf = new StringBuilder();
                    for (int i = 0; i < entryInvoiceNos.length; ++i) {
                        if (string.equals(entryInvoiceNos[i])) {
                            invoicenoNum = i;
                            continue;
                        }
                        entryInvoiceNoBuf.append(entryInvoiceNos[i]).append(this.splitStr);
                    }
                    if (entryInvoiceNoBuf.length() > 0) {
                        entry.set("invoiceno", (Object)entryInvoiceNoBuf.substring(0, entryInvoiceNoBuf.length() - this.splitStr.length()));
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)(invcodes = entry.getString("invoicecode")))) continue;
            String[] entryInvoiceCodes = invcodes.split(this.splitStr);
            if (entryInvoiceCodes.length == 1 && invoicecode.equals(entryInvoiceCodes[0])) {
                entry.set("invoicecode", null);
                continue;
            }
            StringBuilder entryInvoiceCodeBuf = new StringBuilder();
            String[] entryInvoiceCodeList = this.delete(invoicenoNum, entryInvoiceCodes);
            if (entryInvoiceCodeList.length <= 0) continue;
            for (int i = 0; i < entryInvoiceCodeList.length; ++i) {
                entryInvoiceCodeBuf.append(entryInvoiceCodeList[i]).append(this.splitStr);
            }
            entry.set("invoicecode", (Object)entryInvoiceCodeBuf.substring(0, entryInvoiceCodeBuf.length() - this.splitStr.length()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{srcBus});
    }

    public void invalidCallBack(DynamicObject invoice) {
        HashSet<Long> keySet = new HashSet<Long>(1);
        keySet.add(invoice.getLong("id"));
        MutexLockHelper.requireMutex((String)"ar_invoice", keySet, (String)"invalidcallback", (String)"In progress, try again later......");
        try (TXHandle txHandle = TX.required();){
            try {
                String srcbillno;
                invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"ar_invoice");
                Object status = invoice.get("invoicestatus");
                logger.info("invalidCallBack: Status " + status);
                if ("1".equals(status)) {
                    invoice.set("invoicestatus", (Object)"3");
                    OperationResult saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{invoice}, null);
                    if (!saveResult.isSuccess()) {
                        logger.info("------operationResult.Message------" + saveResult.getMessage());
                        OperationHelper.assertResult((OperationResult)saveResult);
                    } else {
                        this.clearSrcBusBill(invoice);
                    }
                }
                if (!StringUtils.isEmpty((CharSequence)(srcbillno = invoice.getString("srcbillno")))) {
                    String propStr = "id,org,invoicestatus,reopen,srcbillno,billno,recamount";
                    QFilter filter = new QFilter("srcbillno", "=", (Object)srcbillno);
                    DynamicObject[] invoiceArr = BusinessDataServiceHelper.load((String)"ar_invoice", (String)propStr, (QFilter[])filter.toArray());
                    HashSet<DynamicObject> saveSet = new HashSet<DynamicObject>(invoiceArr.length);
                    BigDecimal addAmt = BigDecimal.ZERO;
                    for (DynamicObject inv : invoiceArr) {
                        if (srcbillno.equals(inv.getString("billno")) || !"3".equals(inv.get("invoicestatus"))) continue;
                        addAmt = addAmt.add(inv.getBigDecimal("recamount"));
                        inv.set("reopen", (Object)1);
                        saveSet.add(inv);
                    }
                    QFilter momFilter = new QFilter("billno", "=", (Object)srcbillno);
                    DynamicObject momBill = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)propStr, (QFilter[])momFilter.toArray());
                    if (momBill != null && addAmt.compareTo(momBill.getBigDecimal("recamount")) == 0) {
                        momBill.set("invoicestatus", (Object)"3");
                        saveSet.add(momBill);
                        SaveServiceHelper.save((DynamicObject[])saveSet.toArray(new DynamicObject[0]));
                        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (Object[])new Object[]{momBill.get("id")}, null);
                        if (!saveResult.isSuccess()) {
                            logger.info("------operationResult.Message------" + saveResult.getMessage());
                            OperationHelper.assertResult((OperationResult)saveResult);
                        }
                    }
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
            finally {
                MutexLockHelper.batchRelease((String)"ar_invoice", keySet, (String)"invalidcallback");
            }
        }
    }

    public void unInvalidCallBack(DynamicObject invoice) {
        invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"ar_invoice");
        Object status = invoice.get("invoicestatus");
        logger.info("invalidCallBack: Status " + status);
        if ("3".equals(invoice.get("invoicestatus")) && "C".equals(invoice.get("billstatus")) && invoice.getBoolean("isoffline")) {
            invoice.set("invoicestatus", (Object)"1");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{invoice}, null);
            if (!saveResult.isSuccess()) {
                logger.info("------operationResult.Message------" + saveResult.getMessage());
                OperationHelper.assertResult((OperationResult)saveResult);
            } else {
                this.writeBackBusBill(new DynamicObject[]{invoice});
            }
        }
    }

    public String[] delete(int index, String[] entryInvoiceCodes) {
        String[] arrNew = new String[entryInvoiceCodes.length - 1];
        for (int i = index; i < entryInvoiceCodes.length - 1; ++i) {
            entryInvoiceCodes[i] = entryInvoiceCodes[i + 1];
        }
        System.arraycopy(entryInvoiceCodes, 0, arrNew, 0, arrNew.length);
        return arrNew;
    }
}

