/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.enums.AsstactTypeEnum;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.invoice.vo.AmtInfo;
import kd.fi.arapcommon.invoice.vo.BaseInfo;
import kd.fi.arapcommon.invoice.vo.BuyerInfo;
import kd.fi.arapcommon.invoice.vo.FinInfo;
import kd.fi.arapcommon.invoice.vo.Invoice;
import kd.fi.arapcommon.invoice.vo.OtherInfo;
import kd.fi.arapcommon.invoice.vo.RecEntry;
import kd.fi.arapcommon.invoice.vo.SellerInfo;
import kd.fi.arapcommon.invoice.vo.SystemInfo;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceConvertVOHelper {
    public static final BigDecimal ONE = new BigDecimal("1");
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Invoice dynamicObject2VO(DynamicObject inv) {
        DynamicObject modifier;
        String buyerName;
        Invoice vo = new Invoice();
        vo.setBillType("01");
        vo.setSplitOrMergeFlag(inv.getBoolean("splitormergeflag") ? "2" : "0");
        boolean hasTaxationStyle = EntityMetadataUtils.isExistProperty((DynamicObject)inv, (String)"taxationstyle");
        BaseInfo baseInfo = new BaseInfo();
        DynamicObject org = inv.getDynamicObject("org");
        baseInfo.setOrgId(org.getString("id"));
        baseInfo.setOrgNumber(org.getString("number"));
        baseInfo.setApplyDate(inv.getDate("applydate"));
        baseInfo.setBillNo(inv.getString("billno"));
        baseInfo.setInventoryFlag(inv.getBoolean("inventoryflag") ? "1" : "0");
        baseInfo.setInventoryProjectName(ResManager.loadKDString((String)"\u9500\u552e\u8d27\u7269\u6216\u8005\u63d0\u4f9b\u5e94\u7a0e\u52b3\u52a1\u6e05\u5355", (String)"InvoiceConvertVOHelper_6", (String)"fi-ar-business", (Object[])new Object[0]));
        baseInfo.setBlueinvoiceCode(inv.getString("blueinvoicecode"));
        baseInfo.setBlueinvoiceNo(inv.getString("blueinvoiceno"));
        String typeNo = InvoiceType.getTypeNo((String)inv.getString("invoicetype"));
        if (EmptyUtils.isEmpty((Object)typeNo)) {
            typeNo = inv.getString("invoicetype");
        }
        baseInfo.setInvoiceType(typeNo);
        baseInfo.setType(inv.getBoolean("redinvoice") ? "1" : "0");
        if (hasTaxationStyle) {
            baseInfo.setTaxationStyle(inv.getString("taxationstyle"));
        }
        vo.setBaseInfo(baseInfo);
        SellerInfo sellerInfo = new SellerInfo();
        sellerInfo.setSalerAccount(inv.getString("sellerbank") + " " + inv.getString("selleracct"));
        sellerInfo.setSalerAddress(inv.getString("selleraddr"));
        sellerInfo.setSalerName(inv.getString("sellername"));
        sellerInfo.setSalerPhone(inv.getString("sellertel"));
        sellerInfo.setSalerTaxNo(inv.getString("sellertin"));
        vo.setSellerInfo(sellerInfo);
        BuyerInfo buyerInfo = new BuyerInfo();
        buyerInfo.setBuyerAccount(inv.getString("buyerbank") + " " + inv.getString("buyeracct"));
        String buyerAddr = inv.getString("buyeraddr");
        buyerInfo.setBuyerAddress(buyerAddr);
        buyerInfo.setBuyerEmail(inv.getString("email"));
        String buyerTel = inv.getString("buyertel");
        buyerInfo.setBuyerFixedTelephone(buyerTel);
        if (StringUtils.isEmpty((String)buyerTel)) {
            buyerInfo.setBuyerAddAndTel(buyerAddr);
        }
        if (EmptyUtils.isEmpty((Object)(buyerName = inv.getString("buyername")))) {
            buyerName = inv.getDynamicObject("buyer").getLocaleString("name").getLocaleValue();
        }
        buyerInfo.setBuyerName(buyerName);
        buyerInfo.setBuyerTaxNo(inv.getString("buyertin"));
        vo.setBuyerInfo(buyerInfo);
        AmtInfo amtInfo = new AmtInfo();
        amtInfo.setCurrency(inv.getDynamicObject("currency").getLocaleString("name").getLocaleValue());
        amtInfo.setExchangeDate(inv.getDate("exratedate"));
        amtInfo.setExchangeRate(InvoiceConvertVOHelper.getRealValue(inv.getBigDecimal("exchangerate"), 6));
        amtInfo.setInvoiceAmount(InvoiceConvertVOHelper.getRealValue(inv.getBigDecimal("amount"), 6));
        amtInfo.setTotalAmount(InvoiceConvertVOHelper.getRealValue(inv.getBigDecimal("recamount"), 6));
        amtInfo.setTotalTaxAmount(InvoiceConvertVOHelper.getRealValue(inv.getBigDecimal("tax"), 6));
        DynamicObjectCollection invEntries = inv.getDynamicObjectCollection("entry");
        ArrayList<RecEntry> entries = new ArrayList<RecEntry>(invEntries.size());
        for (DynamicObject invEntry : invEntries) {
            String vat;
            String name;
            RecEntry entry = new RecEntry();
            if (invEntry.getBoolean("e_ispresent")) continue;
            String bizType = inv.getString("biztype");
            if (!EmptyUtils.isEmpty((Object)invEntry.getString("e_itemname"))) {
                if ("SAL".equals(bizType)) {
                    entry.setMaterial(invEntry.getString("e_itemname"));
                } else {
                    entry.setExpenseItem(invEntry.getString("e_itemname"));
                }
            } else if ("SAL".equals(bizType)) {
                if (null == invEntry.getDynamicObject("e_material")) throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u9500\u552e\u4e14\u5f00\u7968\u540d\u79f0\u4e3a\u7a7a\u7684\u60c5\u51b5\u4e0b\uff0c\u7269\u6599\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"InvoiceConvertVOHelper_7", (String)"fi-ar-business", (Object[])new Object[0]));
                name = invEntry.getDynamicObject("e_material").getLocaleString("name").getLocaleValue();
                entry.setMaterial(name);
            } else {
                if (null == invEntry.getDynamicObject("e_expenseitem")) throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u8d39\u7528\u4e14\u5f00\u7968\u540d\u79f0\u4e3a\u7a7a\u7684\u60c5\u51b5\u4e0b\uff0c\u8d39\u7528\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"InvoiceConvertVOHelper_8", (String)"fi-ar-business", (Object[])new Object[0]));
                name = invEntry.getDynamicObject("e_expenseitem").getLocaleString("name").getLocaleValue();
                entry.setExpenseItem(name);
            }
            if (null != invEntry.getDynamicObject("e_measureunit")) {
                name = invEntry.getDynamicObject("e_measureunit").getLocaleString("name").getLocaleValue();
                entry.setUnit(name);
            }
            if (StringUtils.isNotEmpty((String)invEntry.getString("e_invoiceunit"))) {
                entry.setUnit(invEntry.getString("e_invoiceunit"));
            }
            entry.setItemRemark(invEntry.getString("e_remark"));
            entry.setItemID(invEntry.getString("id"));
            entry.setSpecModel(invEntry.getString("e_spectype"));
            if (StringUtils.isNotEmpty((String)invEntry.getString("e_invspectype"))) {
                entry.setSpecModel(invEntry.getString("e_invspectype"));
            }
            DynamicObject taxClass = invEntry.getDynamicObject("e_taxclass");
            entry.setGoodsCode(taxClass.getString("mergecode"));
            switch (vat = taxClass.getString("vatspecialmanagement").trim()) {
                case "": {
                    entry.setZeroTaxRateFlag("");
                    entry.setPreferentialPolicy("0");
                    break;
                }
                case "\u514d\u7a0e": {
                    entry.setZeroTaxRateFlag("1");
                    entry.setPreferentialPolicy("1");
                    break;
                }
                case "\u4e0d\u5f81\u7a0e": {
                    entry.setZeroTaxRateFlag("2");
                    entry.setPreferentialPolicy("1");
                    break;
                }
                case "\u666e\u901a\u96f6\u7a0e\u7387": {
                    entry.setZeroTaxRateFlag("3");
                    entry.setPreferentialPolicy("1");
                    break;
                }
                default: {
                    entry.setZeroTaxRateFlag("");
                    entry.setPreferentialPolicy("1");
                }
            }
            entry.setVatException(vat);
            BigDecimal quantity = invEntry.getBigDecimal("e_quantity");
            entry.setNum(InvoiceConvertVOHelper.getRealValue(quantity, 8));
            BigDecimal taxRate = invEntry.getBigDecimal("e_taxrate").divide(ONE_HUNDRED, RoundingMode.HALF_UP);
            entry.setTaxRate(InvoiceConvertVOHelper.getRealValue(taxRate, 2));
            entry.setTaxFlag("0");
            boolean hasDeduction = EntityMetadataUtils.isExistProperty((DynamicObject)invEntry, (String)"deduction");
            String rowType = invEntry.getString("e_rowtype");
            if (StringUtils.isNotEmpty((String)rowType) && !"0".equals(rowType)) {
                entry.setTaxAmount(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_tax"), 2));
                entry.setDetailAmount(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_amount"), 2));
                entry.setUnitPrice(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_unitprice"), 10));
                entry.setDiscountType(rowType);
                entries.add(entry);
            } else if ("NULL".equals(invEntry.getString("e_discountmode")) || invEntry.getBigDecimal("e_discountamount").compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal taxAmount = InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_tax"), 2);
                entry.setTaxAmount(taxAmount);
                entry.setDetailAmount(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_amount"), 2));
                entry.setUnitPrice(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_unitprice"), 10));
                entry.setDiscountType("0");
                entries.add(entry);
            } else if (inv.getBoolean("redinvoice")) {
                entry.setTaxAmount(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_tax"), 2));
                entry.setDetailAmount(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_amount"), 2));
                entry.setUnitPrice(InvoiceConvertVOHelper.getRealValue(entry.getDetailAmount().divide(entry.getNum(), 10, RoundingMode.HALF_UP), 10));
                entry.setDiscountType("0");
                entries.add(entry);
            } else {
                BigDecimal discountAmtWithTax = invEntry.getBigDecimal("e_discountamount");
                BigDecimal unitPrice = invEntry.getBigDecimal("e_unitprice");
                BigDecimal taxAmount = unitPrice.multiply(taxRate).multiply(quantity);
                BigDecimal amount = unitPrice.multiply(quantity);
                entry.setTaxAmount(InvoiceConvertVOHelper.getRealValue(taxAmount, 2));
                entry.setDetailAmount(InvoiceConvertVOHelper.getRealValue(amount, 2));
                entry.setUnitPrice(InvoiceConvertVOHelper.getRealValue(unitPrice, 10));
                entry.setDiscountType("2");
                entries.add(entry);
                try {
                    RecEntry clone = entry.clone();
                    clone.setNum(InvoiceConvertVOHelper.getRealValue(quantity.negate(), 8));
                    BigDecimal discountAmt = discountAmtWithTax.divide(ONE.add(taxRate), 2, RoundingMode.HALF_UP);
                    clone.setTaxAmount(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_tax").subtract(taxAmount), 2));
                    clone.setDetailAmount(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("e_amount").subtract(amount), 2));
                    clone.setUnitPrice(InvoiceConvertVOHelper.getRealValue(discountAmt.divide(quantity, 10, RoundingMode.HALF_UP), 10));
                    clone.setDiscountType("1");
                    if (hasDeduction) {
                        clone.setDeduction(InvoiceConvertVOHelper.getRealValue(invEntry.getBigDecimal("deduction"), 2));
                    }
                    entries.add(clone);
                }
                catch (CloneNotSupportedException e) {
                    throw new KDBizException("Clone invoice entry failed!");
                }
            }
            if (!hasDeduction) continue;
            BigDecimal deduction = invEntry.getBigDecimal("deduction");
            entry.setDeduction(InvoiceConvertVOHelper.getRealValue(deduction, 2));
            if (hasTaxationStyle || BigDecimal.ZERO.compareTo(deduction) == 0) continue;
            vo.getBaseInfo().setTaxationStyle("2");
        }
        for (RecEntry entry : entries) {
            BigDecimal unitPrice;
            BigDecimal detailAmount = entry.getDetailAmount();
            BigDecimal num = entry.getNum();
            BigDecimal calAmount = num.multiply(unitPrice = entry.getUnitPrice());
            if (InvoiceConvertVOHelper.getRealValue(calAmount, 2).compareTo(detailAmount) == 0) continue;
            BigDecimal calUnitPrice = InvoiceConvertVOHelper.getRealValue(detailAmount.divide(num, 10, RoundingMode.HALF_UP), 10);
            entry.setUnitPrice(calUnitPrice);
        }
        amtInfo.setRecentrys(entries);
        vo.setAmtInfo(amtInfo);
        FinInfo finInfo = new FinInfo();
        finInfo.setAsstact(inv.getDynamicObject("asstact").getLocaleString("name").getLocaleValue());
        finInfo.setAsstactType(AsstactTypeEnum.valueOf((String)inv.getString("asstacttype")).getName());
        finInfo.setDueDate(inv.getDate("duedate"));
        finInfo.setPayMode("CASH".equals(inv.getString("paymode")) ? ResManager.loadKDString((String)"\u73b0\u9500", (String)"InvoiceConvertVOHelper_1", (String)"fi-ar-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d4a\u9500", (String)"InvoiceConvertVOHelper_2", (String)"fi-ar-business", (Object[])new Object[0]));
        if (null != inv.getDynamicObject("paycond")) {
            finInfo.setPaycond(inv.getDynamicObject("paycond").getLocaleString("name").getLocaleValue());
        }
        if (null != inv.getDynamicObject("recorg")) {
            finInfo.setRecorg(inv.getDynamicObject("recorg").getLocaleString("name").getLocaleValue());
        }
        if (null != inv.getDynamicObject("salesgroup")) {
            finInfo.setSalesgroup(inv.getDynamicObject("salesgroup").getLocaleString("name").getLocaleValue());
        }
        if (null != inv.getDynamicObject("salesman")) {
            finInfo.setSalesman(inv.getDynamicObject("salesman").getLocaleString("operatorname").getLocaleValue());
        }
        if (null != inv.getDynamicObject("salesorg")) {
            finInfo.setSalesorg(inv.getDynamicObject("salesorg").getLocaleString("name").getLocaleValue());
        }
        vo.setFinInfo(finInfo);
        OtherInfo otherInfo = new OtherInfo();
        if (null == inv.getString("drawer") || "".equals(inv.getString("drawer").trim())) {
            otherInfo.setDrawer(RequestContext.get().getUserName());
        } else {
            otherInfo.setDrawer(inv.getString("drawer"));
        }
        otherInfo.setPayee(inv.getString("payer"));
        otherInfo.setReviewer(inv.getString("checker"));
        otherInfo.setRemark(inv.getString("remark"));
        vo.setOtherInfo(otherInfo);
        SystemInfo systemInfo = new SystemInfo();
        DynamicObject auditor = inv.getDynamicObject("auditor");
        if (auditor != null) {
            systemInfo.setAuditor(auditor.getLocaleString("name").getLocaleValue());
        }
        systemInfo.setAuditTime(inv.getDate("auditdate"));
        systemInfo.setCreateTime(inv.getDate("createtime"));
        DynamicObject creator = inv.getDynamicObject("creator");
        if (creator != null) {
            systemInfo.setCreator(creator.getLocaleString("name").getLocaleValue());
        }
        if ((modifier = inv.getDynamicObject("modifier")) != null) {
            systemInfo.setModifier(modifier.getLocaleString("name").getLocaleValue());
        }
        systemInfo.setModifyTime(inv.getDate("modifytime"));
        vo.setSystemInfo(systemInfo);
        return vo;
    }

    private static BigDecimal getRealValue(BigDecimal srcVal, int scale) {
        BigDecimal tgtVal = BigDecimal.ZERO;
        if (srcVal.compareTo(tgtVal) == 0) {
            return tgtVal;
        }
        if (scale < 0) {
            return srcVal;
        }
        return srcVal.setScale(scale, RoundingMode.HALF_UP);
    }
}

