/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.fi.ar.business.invoice.AbandonInvoiceAction;
import kd.fi.ar.business.invoice.AbandonParam;
import kd.fi.ar.business.invoice.ConfigRequestAction;
import kd.fi.ar.business.invoice.InvalidInvoiceAction;
import kd.fi.ar.business.invoice.InvoiceCloudCallBackService;
import kd.fi.ar.business.invoice.InvoiceData;
import kd.fi.ar.business.invoice.InvoiceHelper;
import kd.fi.ar.business.invoice.IssueInvoiceAction;
import kd.fi.ar.business.invoice.PrintInvoiceAction;
import kd.fi.ar.business.invoice.PrintParam;
import kd.fi.ar.business.invoice.SyncInvoiceAction;
import kd.fi.ar.business.invoice.WriteoffInvoiceAction;
import kd.fi.ar.business.invoice.WriteoffParam;
import kd.fi.arapcommon.business.piaozone.kingdee.APIHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AuthCodeAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.UidAction;
import kd.fi.arapcommon.dev.beanfactory.Scope;
import kd.fi.arapcommon.dev.beanfactory.Service;
import kd.fi.arapcommon.invoice.InvoiceResult;
import kd.fi.arapcommon.invoice.IssueResult;
import kd.fi.arapcommon.invoice.vo.Invoice;
import kd.fi.arapcommon.util.JsonUtils;

@Service(scope=Scope.Singleton)
public class InvoiceFacade {
    public InvoiceResult issue(Invoice[] invoices) {
        String taxNo = invoices[0].getSellerInfo().getSalerTaxNo();
        IssueResult issueResult = new IssueResult();
        Map resultMap = null;
        IssueInvoiceAction action = new IssueInvoiceAction(taxNo, Arrays.asList(invoices));
        if (InvoiceHelper.isMicroService()) {
            String executeResult = action.execute();
            resultMap = (Map)JsonUtils.jsonToObj((String)executeResult, Map.class);
        } else {
            resultMap = APIHelper.invokeAction((AbstractAction)action);
        }
        this.wapResult((InvoiceResult)issueResult, resultMap);
        return issueResult;
    }

    public InvoiceResult query(String taxNo, String billNo) {
        IssueResult issueResult = new IssueResult();
        Map resultMap = null;
        SyncInvoiceAction action = new SyncInvoiceAction(taxNo, billNo);
        if (InvoiceHelper.isMicroService()) {
            String executeResult = action.execute();
            resultMap = (Map)JsonUtils.jsonToObj((String)executeResult, Map.class);
        } else {
            resultMap = APIHelper.invokeAction((AbstractAction)action);
        }
        this.wapResult((InvoiceResult)issueResult, resultMap);
        return issueResult;
    }

    public InvoiceResult configRequest(String taxRegNum, Map<String, Object> map) {
        Map queryMap = null;
        ConfigRequestAction action = new ConfigRequestAction(taxRegNum, map);
        if (InvoiceHelper.isMicroService()) {
            String executeResult = action.execute();
            queryMap = (Map)JsonUtils.jsonToObj((String)executeResult, Map.class);
        } else {
            queryMap = APIHelper.invokeAction((AbstractAction)action);
        }
        IssueResult issueResult = new IssueResult();
        this.wapResult((InvoiceResult)issueResult, queryMap);
        return issueResult;
    }

    private void wapResult(InvoiceResult result, Map<String, Object> shotMap) {
        if (InvoiceHelper.isMicroService()) {
            result.setErrorCode((String)shotMap.get("errorCode"));
            result.setMessgae((String)shotMap.get("message"));
        } else {
            result.setErrorCode((String)shotMap.get("errcode"));
            result.setMessgae((String)shotMap.get("description"));
        }
        result.setOriginalResult(shotMap);
        if ("0000".equals(result.getErrorCode())) {
            result.setSuccess(true);
        }
    }

    public String getUid(String taxRegNum, List<String> serialNums) {
        UidAction uidAction = new UidAction(taxRegNum, serialNums);
        Map invokeAction = APIHelper.invokeAction((AbstractAction)uidAction);
        Object errCode = invokeAction.get("errcode");
        if ("0000".equals(errCode)) {
            return (String)invokeAction.get("data");
        }
        String message = (String)invokeAction.get("description");
        throw new KDBizException("Get Uid Error:" + message + "(" + errCode + ")");
    }

    public String getAuthCode(String taxRegNum) {
        AuthCodeAction authCodeAction = new AuthCodeAction(taxRegNum);
        String execute = authCodeAction.execute();
        Map authCodeResult = (Map)JsonUtils.jsonToObj((String)execute, Map.class);
        String errCode = (String)authCodeResult.get("errcode");
        if ("0000".equals(errCode)) {
            return (String)authCodeResult.get("auth_code");
        }
        String message = (String)authCodeResult.get("description");
        throw new KDBizException("Get Auth Code Error:" + message + "(" + errCode + ")");
    }

    public void issueCallBack(List<Map<String, Object>> issueCallBackParams) {
        InvoiceCloudCallBackService invoiceCloudCallBackService = new InvoiceCloudCallBackService();
        invoiceCloudCallBackService.issueCallBack(issueCallBackParams);
    }

    public void writeoffCallBack(Map<String, Object> writeoffCallBackParam) {
        InvoiceCloudCallBackService invoiceCloudCallBackService = new InvoiceCloudCallBackService();
        invoiceCloudCallBackService.writeoffCallBack(writeoffCallBackParam);
    }

    public void abandonCallBack(Map<String, Object> abandonCallBackParam) {
        InvoiceCloudCallBackService invoiceCloudCallBackService = new InvoiceCloudCallBackService();
        invoiceCloudCallBackService.abandonCallBack(abandonCallBackParam);
    }

    public InvoiceResult writeoff(String taxNo, WriteoffParam writeoffParam) {
        Map invokeAction = APIHelper.invokeAction((AbstractAction)new WriteoffInvoiceAction(taxNo, writeoffParam));
        IssueResult issueResult = new IssueResult();
        this.wapResult((InvoiceResult)issueResult, invokeAction);
        return issueResult;
    }

    public InvoiceResult abandon(String taxNo, AbandonParam abandonParam) {
        Map invokeAction = APIHelper.invokeAction((AbstractAction)new AbandonInvoiceAction(taxNo, abandonParam));
        IssueResult issueResult = new IssueResult();
        this.wapResult((InvoiceResult)issueResult, invokeAction);
        return issueResult;
    }

    public InvoiceResult invalid(String taxNo, InvoiceData invoiceData) {
        IssueResult issueResult = new IssueResult();
        Map resultMap = null;
        InvalidInvoiceAction action = new InvalidInvoiceAction(taxNo, invoiceData);
        if (InvoiceHelper.isMicroService()) {
            String executeResult = action.execute();
            resultMap = (Map)JsonUtils.jsonToObj((String)executeResult, Map.class);
        } else {
            resultMap = APIHelper.invokeAction((AbstractAction)action);
        }
        this.wapResult((InvoiceResult)issueResult, resultMap);
        return issueResult;
    }

    public InvoiceResult print(String taxNo, List<PrintParam> paramList) {
        Map invokeAction = APIHelper.invokeAction((AbstractAction)new PrintInvoiceAction(taxNo, paramList));
        InvoiceResult issueResult = new InvoiceResult();
        this.wapResult(issueResult, invokeAction);
        return issueResult;
    }
}

