/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.business.piaozone.kingdee.HttpServiceHelper;
import kd.fi.arapcommon.helper.SettingMapperHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceHelper {
    private static Log logger = LogFactory.getLog(InvoiceHelper.class);
    public static final String baseAppUrl = "/api/getAppToken.do";
    public static final String baseAccessUrl = "/api/login.do";
    public static final String baseBizUrl = "/kapi/app/bdm/interfaceservice";

    public static boolean isMicroService() {
        String isMservice = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"ismicroservice");
        return StringUtils.isNotEmpty((String)isMservice) && "true".equalsIgnoreCase(isMservice.trim());
    }

    public static String getBaseICU() {
        return SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"baseurl");
    }

    public static String getAppTokenUrl() {
        return InvoiceHelper.getBaseICU() + baseAppUrl;
    }

    public static String getAccountId() {
        String accountId = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"accountid");
        if (StringUtils.isEmpty((String)accountId)) {
            accountId = RequestContext.get().getAccountId();
        }
        return accountId;
    }

    public static String getTenantId() {
        String tenantId = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"tenantid");
        if (StringUtils.isEmpty((String)tenantId)) {
            tenantId = RequestContext.get().getTenantId();
        }
        return tenantId;
    }

    public static String getAppId() {
        String appId = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"appid");
        if (StringUtils.isEmpty((String)appId)) {
            appId = "invoiceupload";
        }
        return appId;
    }

    public static String getAppSecuret() {
        String appSecuret = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"appsecuret");
        if (StringUtils.isEmpty((String)appSecuret)) {
            appSecuret = SettingMapperHelper.getValueFromCache((String)"invoiceCloudDefaultValue", (String)"appvalue");
            if (EmptyUtils.isEmpty((Object)appSecuret)) {
                throw new KDBizException("invoiceCloudDefaultAppSecuret is null");
            }
            return appSecuret;
        }
        return appSecuret;
    }

    public static String getAppToken() {
        HttpServiceHelper httpServiceHelper = new HttpServiceHelper();
        JSONObject map = new JSONObject();
        String appId = InvoiceHelper.getAppId();
        map.put("appId", (Object)appId);
        map.put("appSecuret", (Object)InvoiceHelper.getAppSecuret());
        map.put("accountId", (Object)InvoiceHelper.getAccountId());
        map.put("tenantid", (Object)InvoiceHelper.getTenantId());
        map.put("language", (Object)"zh_CN");
        String appTokenUrl = InvoiceHelper.getAppTokenUrl();
        logger.info("InvoiceHelper getAppToken url:" + appTokenUrl);
        String jsonString = JSON.toJSONString((Object)map);
        logger.info("InvoiceHelper getAppToken request:" + jsonString);
        String originResponse = httpServiceHelper.doPost_returnOriginResponse(appTokenUrl, jsonString);
        logger.info("InvoiceHelper getAppToken response:" + originResponse);
        JSONObject response = (JSONObject)JSON.parseObject((String)originResponse, JSONObject.class);
        if (response != null) {
            String state = response.getString("state");
            if ("success".equals(state)) {
                JSONObject data = response.getJSONObject("data");
                return data.getString("app_token");
            }
            if ("error".equals(state)) {
                throw new KDBizException(response.getString("errorMsg"));
            }
        }
        return "";
    }

    public static String getAccessTokenUrl() {
        return InvoiceHelper.getBaseICU() + baseAccessUrl;
    }

    public static String getUsertype() {
        String usertype = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"usertype");
        if (StringUtils.isEmpty((String)usertype)) {
            usertype = "UserName";
        }
        return usertype;
    }

    public static String getAccessToken() {
        HttpServiceHelper httpServiceHelper = new HttpServiceHelper();
        String accessTokenUrl = InvoiceHelper.getAccessTokenUrl();
        logger.info("InvoiceHelper getAccessToken url:" + accessTokenUrl);
        JSONObject map = new JSONObject();
        map.put("user", (Object)InvoiceHelper.getUser());
        map.put("accountId", (Object)InvoiceHelper.getAccountId());
        map.put("usertype", (Object)InvoiceHelper.getUsertype());
        map.put("apptoken", (Object)InvoiceHelper.getAppToken());
        String jsonString = JSON.toJSONString((Object)map);
        logger.info("InvoiceHelper getAccessToken request:" + jsonString);
        String originResponse = httpServiceHelper.doPost_returnOriginResponse(accessTokenUrl, jsonString);
        logger.info("InvoiceHelper getAccessToken response:" + originResponse);
        JSONObject response = (JSONObject)JSON.parseObject((String)originResponse, JSONObject.class);
        if (response != null) {
            String state = response.getString("state");
            if ("success".equals(state)) {
                JSONObject data = response.getJSONObject("data");
                return data.getString("access_token");
            }
            if ("error".equals(state)) {
                throw new KDBizException(response.getString("errorMsg"));
            }
        }
        return "";
    }

    public static String getBaseBizUrl() {
        return InvoiceHelper.getBaseICU() + baseBizUrl + "?access_token=" + InvoiceHelper.getFinalAccessToken();
    }

    public static String getLogintype() {
        String logintype = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"logintype");
        if (StringUtils.isEmpty((String)logintype)) {
            logintype = "2";
        }
        return logintype;
    }

    public static boolean isPsdLogin() {
        String logintype = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"logintype");
        return StringUtils.isNotEmpty((String)logintype);
    }

    public static String getUser() {
        String user = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"user");
        if (StringUtils.isEmpty((String)user)) {
            user = "disanfangfapiaoshangchuan";
        }
        return user;
    }

    public static String getPassword() {
        String password = SettingMapperHelper.getValueFromCache((String)"invoicecloud", (String)"password");
        if (password == null) {
            password = SettingMapperHelper.getValueFromCache((String)"invoiceCloudDefaultValue", (String)"value");
            if (EmptyUtils.isEmpty((Object)password)) {
                throw new KDBizException("invoiceCloudDefaultPassword is null");
            }
            return password;
        }
        return password;
    }

    public static String getFinalAccessToken() {
        if (InvoiceHelper.isPsdLogin()) {
            logger.info("InvoiceHelper getFinalAccessToken getAccessToken4Password().");
            return InvoiceHelper.getAccessToken4Password();
        }
        logger.info("InvoiceHelper getFinalAccessToken getAccessToken().");
        return InvoiceHelper.getAccessToken();
    }

    public static String getAccessToken4Password() {
        HttpServiceHelper httpServiceHelper = new HttpServiceHelper();
        JSONObject map = new JSONObject();
        map.put("user", (Object)InvoiceHelper.getUser());
        map.put("password", (Object)InvoiceHelper.getPassword());
        map.put("apptoken", (Object)InvoiceHelper.getAppToken());
        map.put("accountId", (Object)InvoiceHelper.getAccountId());
        map.put("logintype", (Object)InvoiceHelper.getLogintype());
        map.put("language", (Object)"zh_CN");
        String accessTokenUrl = InvoiceHelper.getAccessTokenUrl();
        logger.info("InvoiceHelper getAccessToken4Password url:" + accessTokenUrl);
        String jsonString = JSON.toJSONString((Object)map);
        logger.info("InvoiceHelper getAccessToken4Password request:" + jsonString);
        String originResponse = httpServiceHelper.doPost_returnOriginResponse(accessTokenUrl, jsonString);
        logger.info("InvoiceHelper getAccessToken4Password response:" + originResponse);
        JSONObject response = (JSONObject)JSON.parseObject((String)originResponse, JSONObject.class);
        if (response != null) {
            String state = response.getString("state");
            if ("success".equals(state)) {
                JSONObject data = response.getJSONObject("data");
                return data.getString("access_token");
            }
            if ("error".equals(state)) {
                throw new KDBizException(response.getString("errorMsg"));
            }
        }
        return "";
    }
}

