/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.MutexLockHelper;

public class InvoiceSourceAppointor {
    private static final Log logger = LogFactory.getLog(InvoiceSourceAppointor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appoint(Long invoiceId, Long[] sourceBillIds) {
        Set sourceBillIdSet = Arrays.stream(sourceBillIds).collect(Collectors.toSet());
        Set<Long> invoiceIdSet = Collections.singleton(invoiceId);
        MutexLockHelper.requireMutex((String)"ar_finarbill", sourceBillIdSet, (String)"appointsrc", (String)ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u8d22\u52a1\u5e94\u6536\u5355\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u7a0d\u540e\u518d\u8bd5\u3002", (String)"InvoiceSourceAppointor_6", (String)"fi-ar-business", (Object[])new Object[0]));
        MutexLockHelper.requireMutex((String)"ar_invoice", invoiceIdSet, (String)"appointsrc", (String)ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u5f00\u7968\u5355\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u7a0d\u540e\u518d\u8bd5\u3002", (String)"InvoiceSourceAppointor_7", (String)"fi-ar-business", (Object[])new Object[0]));
        try (TXHandle tx = TX.required();){
            try {
                QFilter sourceBillFilter = new QFilter("id", "in", (Object)sourceBillIds);
                List<String> sourceRequiredFields = this.getSourceRequiredFields();
                DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", sourceRequiredFields), (QFilter[])new QFilter[]{sourceBillFilter});
                QFilter invoiceFilter = new QFilter("id", "=", (Object)invoiceId);
                List<String> invoiceRequiredFields = this.getInvoiceRequiredFields();
                DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)String.join((CharSequence)",", invoiceRequiredFields), (QFilter[])new QFilter[]{invoiceFilter});
                if (this.isOldAppoint(invoice, sourceBills).booleanValue()) {
                    this.appoint(invoice, sourceBills);
                } else {
                    this.appointNew(invoice, sourceBills);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        finally {
            MutexLockHelper.batchRelease((String)"ar_finarbill", sourceBillIdSet, (String)"appointsrc");
            MutexLockHelper.batchRelease((String)"ar_invoice", invoiceIdSet, (String)"appointsrc");
        }
    }

    private Boolean isOldAppoint(DynamicObject invoice, DynamicObject[] sourceBills) {
        String messgae;
        BigDecimal invoiceAmt = invoice.getBigDecimal("associatedamt");
        Boolean sourceBillAmtZero = true;
        for (DynamicObject sourceBill : sourceBills) {
            BigDecimal finBillAmt = sourceBill.getBigDecimal("invoicedamt");
            if (finBillAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            sourceBillAmtZero = false;
        }
        if (invoiceAmt.compareTo(BigDecimal.ZERO) == 0 && sourceBillAmtZero.booleanValue()) {
            return false;
        }
        QFilter invoiceFilter = new QFilter("invoiceid", "=", (Object)invoice.getLong("id"));
        QFilter sourceFilter = new QFilter("arfinbillid", "in", Arrays.stream(sourceBills).map(sb -> sb.getLong("id")).collect(Collectors.toSet()));
        DynamicObject[] invoiceAppointRecords = BusinessDataServiceHelper.load((String)"ar_appoint_record", (String)String.join((CharSequence)",", this.getRecordRequiredFields()), (QFilter[])new QFilter[]{invoiceFilter});
        DynamicObject[] finBillAppointRecords = BusinessDataServiceHelper.load((String)"ar_appoint_record", (String)String.join((CharSequence)",", this.getRecordRequiredFields()), (QFilter[])new QFilter[]{sourceFilter});
        Map<String, BigDecimal> invoiceMap = this.getInvoiceAppointAmtMap(invoiceAppointRecords, new String[]{"invoiceid"});
        BigDecimal invoiceRecordAmt = invoiceMap.get(String.valueOf(invoice.getLong("id"))) == null ? BigDecimal.ZERO : invoiceMap.get(String.valueOf(invoice.getLong("id")));
        Boolean invoiceHasRecord = false;
        if (invoiceRecordAmt.compareTo(BigDecimal.ZERO) != 0) {
            invoiceHasRecord = true;
        }
        Boolean isOldInvoice = false;
        if (invoiceAmt.compareTo(invoiceRecordAmt) != 0) {
            isOldInvoice = true;
        }
        Map<String, BigDecimal> sourceBillMap = this.getInvoiceAppointAmtMap(finBillAppointRecords, new String[]{"arfinbillid"});
        Boolean arHasRecord = false;
        Boolean isOldAr = false;
        for (DynamicObject sourceBill : sourceBills) {
            BigDecimal finBillRecordAmt;
            BigDecimal finBillAmt = sourceBill.getBigDecimal("invoicedamt");
            BigDecimal bigDecimal = finBillRecordAmt = sourceBillMap.get(String.valueOf(sourceBill.getLong("id"))) == null ? BigDecimal.ZERO : sourceBillMap.get(String.valueOf(sourceBill.getLong("id")));
            if (finBillRecordAmt.compareTo(BigDecimal.ZERO) != 0) {
                arHasRecord = true;
            }
            if (finBillAmt.compareTo(finBillRecordAmt) == 0) continue;
            isOldAr = true;
        }
        if (isOldInvoice.booleanValue() && arHasRecord.booleanValue()) {
            messgae = ResManager.loadKDString((String)"\u5f00\u7968\u5355\u4e3a\u5386\u53f2\u6570\u636e\uff0c\u4e0d\u80fd\u6307\u5b9a\u6709\u660e\u7ec6\u5173\u7cfb\u8bb0\u5f55\u7684\u5e94\u6536\u5355\uff0c\u8bf7\u53d6\u6d88\u53d1\u7968\u6307\u5b9a\u540e\u91cd\u65b0\u6307\u5b9a", (String)"InvoiceSourceAppointor_10", (String)"fi-ar-business", (Object[])new Object[0]);
            throw new KDBizException(messgae);
        }
        if (isOldAr.booleanValue() && invoiceHasRecord.booleanValue()) {
            messgae = ResManager.loadKDString((String)"\u5e94\u6536\u5355\u5305\u542b\u5386\u53f2\u6570\u636e\uff0c\u4e0d\u80fd\u88ab\u6709\u660e\u7ec6\u5173\u7cfb\u8bb0\u5f55\u7684\u5f00\u7968\u5355\u6307\u5b9a\uff0c\u8bf7\u53d6\u6d88\u53d1\u7968\u6307\u5b9a\u540e\u91cd\u65b0\u6307\u5b9a", (String)"InvoiceSourceAppointor_11", (String)"fi-ar-business", (Object[])new Object[0]);
            throw new KDBizException(messgae);
        }
        if (isOldAr.booleanValue() || isOldInvoice.booleanValue()) {
            return true;
        }
        return false;
    }

    public void appointNew(DynamicObject invoice, DynamicObject[] sourceBills) {
        this.appointValidate(invoice, sourceBills);
        LinkedList<Long> relationIdList = new LinkedList<Long>();
        this.disposeSourceBillNew(invoice, sourceBills, relationIdList);
        String sourceEntityKey = sourceBills[0].getDataEntityType().getName();
        BOTPHelper.saveApRation4Unite((DynamicObject)invoice, (String)sourceEntityKey, relationIdList);
    }

    private BigDecimal calcLocalAmt4Invoice(DynamicObject invoice, BigDecimal amt) {
        String quotation = invoice.getString("quotation");
        int precision = invoice.getInt("basecurrency.amtprecision");
        BigDecimal exchangeRate = invoice.getBigDecimal("exchangerate");
        BigDecimal amtLocal = BigDecimal.ZERO;
        amtLocal = "1".equals(quotation) ? amt.divide(exchangeRate, precision, RoundingMode.HALF_UP) : amt.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
        return amtLocal;
    }

    private Map<String, BigDecimal> disposeSourceBillEntry(DynamicObject row, BigDecimal unAassociatedAmt, BigDecimal unAassociatedLocAmt, boolean isDiffSigNum) {
        BigDecimal entryRowDisposeLocAmt;
        boolean isSameSigNum;
        BigDecimal uninvoiceAmt = row.getBigDecimal("e_uninvoicedamt");
        boolean bl = isSameSigNum = uninvoiceAmt.signum() == unAassociatedAmt.signum();
        if (isSameSigNum && isDiffSigNum || !isSameSigNum && !isDiffSigNum) {
            return new HashMap<String, BigDecimal>();
        }
        BigDecimal uninvoiceLocAmt = row.getBigDecimal("e_uninvoicedlocalamt");
        BigDecimal entryRowDisposeAmt = BigDecimal.ZERO;
        if (isDiffSigNum || unAassociatedAmt.abs().compareTo(uninvoiceAmt.abs()) >= 0) {
            entryRowDisposeAmt = uninvoiceAmt;
            entryRowDisposeLocAmt = uninvoiceLocAmt;
        } else {
            entryRowDisposeAmt = unAassociatedAmt;
            entryRowDisposeLocAmt = unAassociatedLocAmt;
        }
        BigDecimal invoicedAmt = row.getBigDecimal("e_invoicedamt").add(entryRowDisposeAmt);
        row.set("e_invoicedamt", (Object)invoicedAmt);
        BigDecimal invoicedLocAmt = row.getBigDecimal("e_invoicedlocalamt").add(entryRowDisposeLocAmt);
        row.set("e_invoicedlocalamt", (Object)invoicedLocAmt);
        BigDecimal uninvoicedAmt = row.getBigDecimal("e_uninvoicedamt").subtract(entryRowDisposeAmt);
        row.set("e_uninvoicedamt", (Object)uninvoicedAmt);
        BigDecimal uninvoicedLocAmt = row.getBigDecimal("e_uninvoicedlocalamt").subtract(entryRowDisposeLocAmt);
        row.set("e_uninvoicedlocalamt", (Object)uninvoicedLocAmt);
        BigDecimal qty = row.getBigDecimal("e_quantity");
        if (uninvoicedAmt.compareTo(BigDecimal.ZERO) == 0) {
            row.set("e_invoicedqty", (Object)qty);
            row.set("e_uninvoicedqty", (Object)BigDecimal.ZERO);
        } else {
            BigDecimal actualTaxPrice = row.getBigDecimal("e_acttaxunitprice");
            if (actualTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal invoicedQty = invoicedAmt.divide(actualTaxPrice, qty.scale(), RoundingMode.HALF_UP);
                row.set("e_invoicedqty", (Object)invoicedQty);
                row.set("e_uninvoicedqty", (Object)qty.subtract(invoicedQty));
            }
        }
        HashMap<String, BigDecimal> disposeAmt = new HashMap<String, BigDecimal>();
        disposeAmt.put("entryRowDisposeAmt", entryRowDisposeAmt);
        disposeAmt.put("entryRowDisposeLocAmt", entryRowDisposeLocAmt);
        return disposeAmt;
    }

    private void disposeSourceBillNew(DynamicObject invoice, DynamicObject[] sourceBills, List<Long> relationIdList) {
        BigDecimal entryUnAssociatedAmt;
        BigDecimal entryAssociatedAmt;
        BigDecimal entryRecAmount;
        DynamicObject row;
        int i;
        logger.info("dispose new start.");
        Arrays.sort(sourceBills, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date bizDate1 = o1.getDate("bizdate");
                Date bizDate2 = o2.getDate("bizdate");
                return bizDate1.compareTo(bizDate2);
            }
        });
        BigDecimal associatedAmt = invoice.getBigDecimal("associatedamt");
        BigDecimal unAassociatedAmt = invoice.getBigDecimal("recamount").subtract(associatedAmt);
        BigDecimal currentAssociatedAmt = BigDecimal.ZERO;
        BigDecimal associatedLocamt = this.calcLocalAmt4Invoice(invoice, associatedAmt);
        BigDecimal unAassociatedLocAmt = invoice.getBigDecimal("reclocalamt").subtract(associatedLocamt);
        LinkedList<DynamicObject> invoiceRecordList = new LinkedList<DynamicObject>();
        for (DynamicObject sourceBill : sourceBills) {
            Map<String, BigDecimal> disposeAmtMap;
            if (unAassociatedAmt.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal billDisposeAmt = BigDecimal.ZERO;
            BigDecimal billDisposeLocAmt = BigDecimal.ZERO;
            DynamicObjectCollection entry = sourceBill.getDynamicObjectCollection("entry");
            for (DynamicObject row2 : entry) {
                if (unAassociatedAmt.compareTo(BigDecimal.ZERO) == 0) break;
                disposeAmtMap = this.disposeSourceBillEntry(row2, unAassociatedAmt, unAassociatedLocAmt, true);
                if (disposeAmtMap.isEmpty()) continue;
                billDisposeAmt = billDisposeAmt.add(disposeAmtMap.get("entryRowDisposeAmt"));
                unAassociatedAmt = unAassociatedAmt.subtract(disposeAmtMap.get("entryRowDisposeAmt"));
                billDisposeLocAmt = billDisposeLocAmt.add(disposeAmtMap.get("entryRowDisposeLocAmt"));
                unAassociatedLocAmt = unAassociatedLocAmt.subtract(disposeAmtMap.get("entryRowDisposeLocAmt"));
            }
            for (DynamicObject row2 : entry) {
                if (unAassociatedAmt.compareTo(BigDecimal.ZERO) == 0) break;
                disposeAmtMap = this.disposeSourceBillEntry(row2, unAassociatedAmt, unAassociatedLocAmt, false);
                if (disposeAmtMap.isEmpty()) continue;
                billDisposeAmt = billDisposeAmt.add(disposeAmtMap.get("entryRowDisposeAmt"));
                unAassociatedAmt = unAassociatedAmt.subtract(disposeAmtMap.get("entryRowDisposeAmt"));
                billDisposeLocAmt = billDisposeLocAmt.add(disposeAmtMap.get("entryRowDisposeLocAmt"));
                unAassociatedLocAmt = unAassociatedLocAmt.subtract(disposeAmtMap.get("entryRowDisposeLocAmt"));
            }
            logger.info("\u6267\u884c\u65b0\u53cd\u5199\u903b\u8f91:\u6e90\u5355\u5355\u53f7\u4e3a:{},\u672a\u5f00\u7968\u91d1\u989d:{},\u53cd\u5199\u603b\u91d1\u989d:{}.", new Object[]{sourceBill.getString("billno"), sourceBill.getBigDecimal("uninvoicedamt"), billDisposeAmt});
            sourceBill.set("invoicedamt", (Object)sourceBill.getBigDecimal("invoicedamt").add(billDisposeAmt));
            sourceBill.set("uninvoicedamt", (Object)sourceBill.getBigDecimal("uninvoicedamt").subtract(billDisposeAmt));
            sourceBill.set("invoicedlocalamt", (Object)sourceBill.getBigDecimal("invoicedlocalamt").add(billDisposeLocAmt));
            sourceBill.set("uninvoicedlocalamt", (Object)sourceBill.getBigDecimal("uninvoicedlocalamt").subtract(billDisposeLocAmt));
            currentAssociatedAmt = currentAssociatedAmt.add(billDisposeAmt);
            DynamicObject invoiceRecord = BusinessDataServiceHelper.newDynamicObject((String)"ar_appoint_record");
            invoiceRecord.set("arfinbillid", sourceBill.get("id"));
            invoiceRecord.set("invoiceid", invoice.get("id"));
            invoiceRecord.set("createtime", (Object)new Time(new Date().getTime()));
            invoiceRecord.set("associatedamt", (Object)billDisposeAmt);
            invoiceRecordList.add(invoiceRecord);
            relationIdList.add(sourceBill.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])invoiceRecordList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])sourceBills);
        logger.info("Save sourceBills and record success.");
        BigDecimal restofCurrentAssociatedAmt = currentAssociatedAmt;
        DynamicObjectCollection invoiceEntry = invoice.getDynamicObjectCollection("entry");
        for (i = 0; i < invoiceEntry.size(); ++i) {
            boolean isSameSigNum;
            row = (DynamicObject)invoiceEntry.get(i);
            entryRecAmount = row.getBigDecimal("e_recamount");
            entryAssociatedAmt = row.getBigDecimal("e_associatedamt");
            entryUnAssociatedAmt = entryRecAmount.subtract(entryAssociatedAmt);
            boolean bl = isSameSigNum = restofCurrentAssociatedAmt.signum() == entryRecAmount.signum();
            if (isSameSigNum) continue;
            row.set("e_associatedamt", (Object)entryUnAssociatedAmt);
            restofCurrentAssociatedAmt = restofCurrentAssociatedAmt.subtract(entryUnAssociatedAmt);
        }
        for (i = 0; i < invoiceEntry.size(); ++i) {
            boolean isSameSigNum;
            row = (DynamicObject)invoiceEntry.get(i);
            entryRecAmount = row.getBigDecimal("e_recamount");
            entryAssociatedAmt = row.getBigDecimal("e_associatedamt");
            entryUnAssociatedAmt = entryRecAmount.subtract(entryAssociatedAmt);
            BigDecimal entryCurrentAssociatedAmt = BigDecimal.ZERO;
            boolean bl = isSameSigNum = restofCurrentAssociatedAmt.signum() == entryRecAmount.signum();
            if (!isSameSigNum || restofCurrentAssociatedAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            if (restofCurrentAssociatedAmt.abs().compareTo(entryUnAssociatedAmt.abs()) >= 0) {
                entryCurrentAssociatedAmt = entryCurrentAssociatedAmt.add(entryUnAssociatedAmt);
                row.set("e_associatedamt", (Object)entryRecAmount);
            } else {
                entryCurrentAssociatedAmt = restofCurrentAssociatedAmt;
                row.set("e_associatedamt", (Object)entryAssociatedAmt.add(restofCurrentAssociatedAmt));
            }
            restofCurrentAssociatedAmt = restofCurrentAssociatedAmt.subtract(entryCurrentAssociatedAmt);
        }
        logger.info("\u6267\u884c\u65b0\u53cd\u5199\u903b\u8f91:\u53d1\u7968\u5355\u53f7\u4e3a:{},\u5173\u8054\u5f00\u7968\u91d1\u989d:{},\u53cd\u5199\u603b\u91d1\u989d:{}.", new Object[]{invoice.getString("billno"), invoice.getBigDecimal("associatedamt"), currentAssociatedAmt});
        invoice.set("associatedamt", (Object)invoice.getBigDecimal("associatedamt").add(currentAssociatedAmt));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
    }

    @Deprecated
    public void appoint(DynamicObject invoice, DynamicObject[] sourceBills) {
        this.appointValidate(invoice, sourceBills);
        this.recordRelation(invoice, sourceBills);
        this.disposeSourceBill(invoice, sourceBills);
    }

    public void appointValidate(Long invoiceId) {
        QFilter invoiceFilter = new QFilter("id", "=", (Object)invoiceId);
        List<String> invoiceRequiredFields = this.getInvoiceRequiredFields();
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)String.join((CharSequence)",", invoiceRequiredFields), (QFilter[])new QFilter[]{invoiceFilter});
        this.appointValidate(invoice, new DynamicObject[0]);
    }

    public void appointValidate(DynamicObject invoice, DynamicObject[] sourceBills) {
        String billStatus = invoice.getString("billstatus");
        if (!"C".equals(billStatus)) {
            String messgae = ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u53d1\u7968\u624d\u80fd\u6307\u5b9a\u6e90\u5355\u3002", (String)"InvoiceSourceAppointor_4", (String)"fi-ar-business", (Object[])new Object[0]);
            throw new KDBizException(messgae);
        }
        BigDecimal associatedAmt = invoice.getBigDecimal("associatedamt");
        BigDecimal recAmt = invoice.getBigDecimal("recamount");
        if (recAmt.abs().compareTo(associatedAmt.abs()) <= 0) {
            String messgae = ResManager.loadKDString((String)"\u53d1\u7968\u91d1\u989d\u5df2\u7ecf\u5168\u90e8\u6307\u5b9a\u6e90\u5355\u3002 ", (String)"InvoiceSourceAppointor_3", (String)"fi-ar-business", (Object[])new Object[0]);
            throw new KDBizException(messgae);
        }
        for (DynamicObject sourceBill : sourceBills) {
            BigDecimal unInvoicedAmt = sourceBill.getBigDecimal("uninvoicedamt");
            if (BigDecimal.ZERO.compareTo(unInvoicedAmt.abs()) >= 0) {
                String messgae = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\uff1a%s \u5df2\u7ecf\u5168\u90e8\u5f00\u7968\uff0c\u4e0d\u80fd\u518d\u5173\u8054\u53d1\u7968\u3002", (String)"InvoiceSourceAppointor_2", (String)"fi-ar-business", (Object[])new Object[0]);
                throw new KDBizException(String.format(messgae, sourceBill.getString("billno")));
            }
            if (BillStatusEnum.AUDIT.getValue().equals(sourceBill.getString("billstatus"))) continue;
            String messgae = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\uff1a%s \u975e\u5ba1\u6838\u6001\u5355\u636e\uff0c\u4e0d\u80fd\u5173\u8054\u53d1\u7968\u3002", (String)"InvoiceSourceAppointor_8", (String)"fi-ar-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(messgae, sourceBill.getString("billno")));
        }
    }

    private void recordRelation(DynamicObject invoice, DynamicObject[] sourceBills) {
        String sourceEntityKey = sourceBills[0].getDataEntityType().getName();
        List sourceBillIds = Arrays.stream(sourceBills).map(sb -> sb.getLong("id")).collect(Collectors.toList());
        BOTPHelper.saveApRation4Unite((DynamicObject)invoice, (String)sourceEntityKey, sourceBillIds);
    }

    private void disposeSourceBill(DynamicObject invoice, DynamicObject[] sourceBills) {
        logger.info("dispose start.");
        Arrays.sort(sourceBills, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date bizDate1 = o1.getDate("bizdate");
                Date bizDate2 = o2.getDate("bizdate");
                return bizDate1.compareTo(bizDate2);
            }
        });
        BigDecimal associatedAmt = invoice.getBigDecimal("associatedamt");
        BigDecimal unAassociatedAmt = invoice.getBigDecimal("recamount").subtract(associatedAmt);
        BigDecimal currentAssociatedAmt = BigDecimal.ZERO;
        String quotation = invoice.getString("quotation");
        int precision = invoice.getInt("basecurrency.amtprecision");
        BigDecimal exchangeRate = invoice.getBigDecimal("exchangerate");
        BigDecimal associatedLocamt = BigDecimal.ZERO;
        associatedLocamt = "1".equals(quotation) ? associatedAmt.divide(exchangeRate, precision, RoundingMode.HALF_UP) : associatedAmt.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
        BigDecimal unAassociatedLocAmt = invoice.getBigDecimal("reclocalamt").subtract(associatedLocamt);
        for (DynamicObject sourceBill : sourceBills) {
            BigDecimal billDisposeAmt = BigDecimal.ZERO;
            BigDecimal billDisposeLocAmt = BigDecimal.ZERO;
            DynamicObjectCollection entry = sourceBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal entryRowDisposeLocAmt;
                BigDecimal uninvoiceAmt = row.getBigDecimal("e_uninvoicedamt");
                BigDecimal uninvoiceLocAmt = row.getBigDecimal("e_uninvoicedlocalamt");
                BigDecimal entryRowDisposeAmt = BigDecimal.ZERO;
                if (unAassociatedAmt.compareTo(uninvoiceAmt) >= 0) {
                    entryRowDisposeAmt = uninvoiceAmt;
                    entryRowDisposeLocAmt = uninvoiceLocAmt;
                } else {
                    entryRowDisposeAmt = unAassociatedAmt;
                    entryRowDisposeLocAmt = unAassociatedLocAmt;
                }
                BigDecimal invoicedAmt = row.getBigDecimal("e_invoicedamt").add(entryRowDisposeAmt);
                row.set("e_invoicedamt", (Object)invoicedAmt);
                BigDecimal invoicedLocAmt = row.getBigDecimal("e_invoicedlocalamt").add(entryRowDisposeLocAmt);
                row.set("e_invoicedlocalamt", (Object)invoicedLocAmt);
                BigDecimal uninvoicedAmt = row.getBigDecimal("e_uninvoicedamt").subtract(entryRowDisposeAmt);
                row.set("e_uninvoicedamt", (Object)uninvoicedAmt);
                BigDecimal uninvoicedLocAmt = row.getBigDecimal("e_uninvoicedlocalamt").subtract(entryRowDisposeLocAmt);
                row.set("e_uninvoicedlocalamt", (Object)uninvoicedLocAmt);
                BigDecimal qty = row.getBigDecimal("e_quantity");
                if (uninvoicedAmt.compareTo(BigDecimal.ZERO) == 0) {
                    row.set("e_invoicedqty", (Object)qty);
                    row.set("e_uninvoicedqty", (Object)BigDecimal.ZERO);
                } else {
                    BigDecimal actualTaxPrice = row.getBigDecimal("e_acttaxunitprice");
                    if (actualTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal invoicedQty = invoicedAmt.divide(actualTaxPrice, qty.scale(), RoundingMode.HALF_UP);
                        row.set("e_invoicedqty", (Object)invoicedQty);
                        row.set("e_uninvoicedqty", (Object)qty.subtract(invoicedQty));
                    }
                }
                billDisposeAmt = billDisposeAmt.add(entryRowDisposeAmt);
                unAassociatedAmt = unAassociatedAmt.subtract(entryRowDisposeAmt);
                billDisposeLocAmt = billDisposeLocAmt.add(entryRowDisposeLocAmt);
                unAassociatedLocAmt = unAassociatedLocAmt.subtract(entryRowDisposeLocAmt);
            }
            logger.info("\u6e90\u5355\u5355\u53f7\u4e3a:{},\u672a\u5f00\u7968\u91d1\u989d:{},\u53cd\u5199\u603b\u91d1\u989d:{}.", new Object[]{sourceBill.getString("billno"), sourceBill.getBigDecimal("uninvoicedamt"), billDisposeAmt});
            sourceBill.set("invoicedamt", (Object)sourceBill.getBigDecimal("invoicedamt").add(billDisposeAmt));
            sourceBill.set("uninvoicedamt", (Object)sourceBill.getBigDecimal("uninvoicedamt").subtract(billDisposeAmt));
            sourceBill.set("invoicedlocalamt", (Object)sourceBill.getBigDecimal("invoicedlocalamt").add(billDisposeLocAmt));
            sourceBill.set("uninvoicedlocalamt", (Object)sourceBill.getBigDecimal("uninvoicedlocalamt").subtract(billDisposeLocAmt));
            currentAssociatedAmt = currentAssociatedAmt.add(billDisposeAmt);
        }
        SaveServiceHelper.save((DynamicObject[])sourceBills);
        logger.info("Save sourceBills success.");
        BigDecimal restofCurrentAssociatedAmt = currentAssociatedAmt;
        DynamicObjectCollection invoiceEntry = invoice.getDynamicObjectCollection("entry");
        for (DynamicObject row : invoiceEntry) {
            BigDecimal entryRecAmount = row.getBigDecimal("e_recamount");
            BigDecimal entryAssociatedAmt = row.getBigDecimal("e_associatedamt");
            BigDecimal entryUnAssociatedAmt = entryRecAmount.subtract(entryAssociatedAmt);
            BigDecimal entryCurrentAssociatedAmt = BigDecimal.ZERO;
            if (restofCurrentAssociatedAmt.compareTo(entryUnAssociatedAmt) >= 0) {
                row.set("e_associatedamt", (Object)entryRecAmount);
            } else {
                row.set("e_associatedamt", (Object)entryAssociatedAmt.add(restofCurrentAssociatedAmt));
            }
            restofCurrentAssociatedAmt = restofCurrentAssociatedAmt.subtract(entryCurrentAssociatedAmt);
        }
        logger.info("\u53d1\u7968\u5355\u53f7\u4e3a:{},\u5173\u8054\u5f00\u7968\u91d1\u989d:{},\u53cd\u5199\u603b\u91d1\u989d:{}.", new Object[]{invoice.getString("billno"), invoice.getBigDecimal("associatedamt"), currentAssociatedAmt});
        invoice.set("associatedamt", (Object)invoice.getBigDecimal("associatedamt").add(currentAssociatedAmt));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void antiAppoint(Long invoiceId) {
        Map sourceBillInfos = BFTrackerServiceHelper.findSourceBills((String)"ar_invoice", (Long[])new Long[]{invoiceId});
        HashSet sourceBillIds = (HashSet)sourceBillInfos.get("ar_finarbill");
        if (sourceBillIds == null || sourceBillIds.isEmpty()) {
            return;
        }
        Set<Long> invoiceIdSet = Collections.singleton(invoiceId);
        MutexLockHelper.requireMutex((String)"ar_finarbill", (Set)sourceBillIds, (String)"appointsrc", (String)ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u8d22\u52a1\u5e94\u6536\u5355\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u7a0d\u540e\u518d\u8bd5\u3002", (String)"InvoiceSourceAppointor_6", (String)"fi-ar-business", (Object[])new Object[0]));
        MutexLockHelper.requireMutex((String)"ar_invoice", invoiceIdSet, (String)"appointsrc", (String)ResManager.loadKDString((String)"\u5e76\u53d1\u51b2\u7a81\uff0c\u5f00\u7968\u5355\u7533\u8bf7\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u7a0d\u540e\u518d\u8bd5\u3002", (String)"InvoiceSourceAppointor_7", (String)"fi-ar-business", (Object[])new Object[0]));
        try (TXHandle tx = TX.required();){
            try {
                QFilter invoiceFilter = new QFilter("id", "=", (Object)invoiceId);
                List<String> invoiceRequiredFields = this.getInvoiceRequiredFields();
                DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)String.join((CharSequence)",", invoiceRequiredFields), (QFilter[])new QFilter[]{invoiceFilter});
                QFilter idFilter = new QFilter("id", "in", (Object)sourceBillIds);
                List<String> sourceRequiredFields = this.getSourceRequiredFields();
                DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", sourceRequiredFields), (QFilter[])new QFilter[]{idFilter});
                if (this.isOldAppoint(invoice, sourceBills).booleanValue()) {
                    this.antiAppoint(invoice, sourceBillIds);
                } else {
                    this.antiAppointNew(invoice, sourceBills);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        finally {
            MutexLockHelper.batchRelease((String)"ar_finarbill", (Set)sourceBillIds, (String)"appointsrc");
            MutexLockHelper.batchRelease((String)"ar_invoice", invoiceIdSet, (String)"appointsrc");
        }
    }

    public void antiAppointNew(DynamicObject invoice, DynamicObject[] sourceBills) {
        Set<Long> sourceBillIds = Arrays.stream(sourceBills).map(sb -> sb.getLong("id")).collect(Collectors.toSet());
        this.antiAppointValidate(invoice);
        DynamicObject[] appointRecords = this.getInvoiceAppointRecord(invoice.getLong("id"), sourceBillIds);
        Map<String, BigDecimal> appointRecordMap = this.getInvoiceAppointAmtMap(appointRecords, new String[]{"invoiceid", "arfinbillid"});
        this.reverseSourceBillNew(invoice, sourceBills, appointRecordMap);
        QFilter recordFilter = new QFilter("id", "in", Arrays.stream(appointRecords).map(sb -> sb.getLong("id")).collect(Collectors.toSet()));
        DeleteServiceHelper.delete((String)"ar_appoint_record", (QFilter[])new QFilter[]{recordFilter});
        for (Long srcBillId : sourceBillIds) {
            BOTPHelper.deleteRelation((String)"ar_invoice", (Long)invoice.getLong("id"), (Long)srcBillId);
        }
    }

    private Map<String, BigDecimal> reverseSourceBillEntry(DynamicObject row, BigDecimal restofAmt, BigDecimal restofLocAmt, boolean isDiffSigNum) {
        BigDecimal entryRowDisposeLocAmt;
        boolean isSameSigNum;
        BigDecimal oldInvoicedAmt = row.getBigDecimal("e_invoicedamt");
        BigDecimal oldInvoicedLocAmt = row.getBigDecimal("e_invoicedlocalamt");
        boolean bl = isSameSigNum = restofAmt.signum() == oldInvoicedAmt.signum();
        if (isSameSigNum && isDiffSigNum || !isSameSigNum && !isDiffSigNum) {
            return new HashMap<String, BigDecimal>();
        }
        BigDecimal entryRowDisposeAmt = BigDecimal.ZERO;
        if (isDiffSigNum || restofAmt.abs().compareTo(oldInvoicedAmt.abs()) >= 0) {
            entryRowDisposeAmt = oldInvoicedAmt;
            entryRowDisposeLocAmt = oldInvoicedLocAmt;
        } else {
            entryRowDisposeAmt = restofAmt;
            entryRowDisposeLocAmt = restofLocAmt;
        }
        BigDecimal currentUninvoicedAmt = row.getBigDecimal("e_uninvoicedamt").add(entryRowDisposeAmt);
        row.set("e_uninvoicedamt", (Object)currentUninvoicedAmt);
        BigDecimal currentUninvoicedLocAmt = row.getBigDecimal("e_uninvoicedlocalamt").add(entryRowDisposeLocAmt);
        row.set("e_uninvoicedlocalamt", (Object)currentUninvoicedLocAmt);
        BigDecimal currentInvoicedAmt = row.getBigDecimal("e_invoicedamt").subtract(entryRowDisposeAmt);
        row.set("e_invoicedamt", (Object)currentInvoicedAmt);
        BigDecimal currentInvoicedLocAmt = row.getBigDecimal("e_invoicedlocalamt").subtract(entryRowDisposeLocAmt);
        row.set("e_invoicedlocalamt", (Object)currentInvoicedLocAmt);
        BigDecimal qty = row.getBigDecimal("e_quantity");
        if (currentInvoicedAmt.compareTo(BigDecimal.ZERO) == 0) {
            row.set("e_invoicedqty", (Object)BigDecimal.ZERO);
            row.set("e_uninvoicedqty", (Object)qty);
        } else {
            BigDecimal actualTaxPrice = row.getBigDecimal("e_acttaxunitprice");
            if (actualTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal invoicedQty = currentInvoicedAmt.divide(actualTaxPrice, qty.scale(), RoundingMode.HALF_UP);
                row.set("e_invoicedqty", (Object)invoicedQty);
                row.set("e_uninvoicedqty", (Object)qty.subtract(invoicedQty));
            }
        }
        HashMap<String, BigDecimal> reverseAmt = new HashMap<String, BigDecimal>();
        reverseAmt.put("entryRowDisposeAmt", entryRowDisposeAmt);
        reverseAmt.put("entryRowDisposeLocAmt", entryRowDisposeLocAmt);
        return reverseAmt;
    }

    private void reverseSourceBillNew(DynamicObject invoice, DynamicObject[] sourceBills, Map<String, BigDecimal> appointRecord) {
        logger.info("reverse new start.");
        for (DynamicObject sourceBill : sourceBills) {
            Map<String, BigDecimal> disposeAmtMap;
            BigDecimal billDisposeAmt = BigDecimal.ZERO;
            BigDecimal billDisposeLocAmt = BigDecimal.ZERO;
            DynamicObjectCollection entry = sourceBill.getDynamicObjectCollection("entry");
            String key = invoice.get("id") + "_" + sourceBill.get("id");
            BigDecimal restofAmt = appointRecord.get(key);
            BigDecimal restofLocAmt = this.calcLocalAmt4Invoice(invoice, restofAmt);
            for (DynamicObject row : entry) {
                if (restofAmt.compareTo(BigDecimal.ZERO) == 0) break;
                disposeAmtMap = this.reverseSourceBillEntry(row, restofAmt, restofLocAmt, true);
                if (disposeAmtMap.isEmpty()) continue;
                billDisposeAmt = billDisposeAmt.add(disposeAmtMap.get("entryRowDisposeAmt"));
                restofAmt = restofAmt.subtract(disposeAmtMap.get("entryRowDisposeAmt"));
                billDisposeLocAmt = billDisposeLocAmt.add(disposeAmtMap.get("entryRowDisposeLocAmt"));
                restofLocAmt = restofLocAmt.subtract(disposeAmtMap.get("entryRowDisposeLocAmt"));
            }
            for (DynamicObject row : entry) {
                if (restofAmt.compareTo(BigDecimal.ZERO) == 0) break;
                disposeAmtMap = this.reverseSourceBillEntry(row, restofAmt, restofLocAmt, false);
                if (disposeAmtMap.isEmpty()) continue;
                billDisposeAmt = billDisposeAmt.add(disposeAmtMap.get("entryRowDisposeAmt"));
                restofAmt = restofAmt.subtract(disposeAmtMap.get("entryRowDisposeAmt"));
                billDisposeLocAmt = billDisposeLocAmt.add(disposeAmtMap.get("entryRowDisposeLocAmt"));
                restofLocAmt = restofLocAmt.subtract(disposeAmtMap.get("entryRowDisposeLocAmt"));
            }
            logger.info("\u6267\u884c\u65b0\u53cd\u5199\u903b\u8f91:\u6e90\u5355\u5355\u53f7\u4e3a:{},\u672a\u5f00\u7968\u91d1\u989d:{},\u53cd\u5199\u603b\u91d1\u989d:{}.", new Object[]{sourceBill.getString("billno"), sourceBill.getBigDecimal("uninvoicedamt"), billDisposeAmt});
            sourceBill.set("uninvoicedamt", (Object)sourceBill.getBigDecimal("uninvoicedamt").add(billDisposeAmt));
            sourceBill.set("invoicedamt", (Object)sourceBill.getBigDecimal("invoicedamt").subtract(billDisposeAmt));
            sourceBill.set("uninvoicedlocalamt", (Object)sourceBill.getBigDecimal("uninvoicedlocalamt").add(billDisposeLocAmt));
            sourceBill.set("invoicedlocalamt", (Object)sourceBill.getBigDecimal("invoicedlocalamt").subtract(billDisposeLocAmt));
        }
        SaveServiceHelper.save((DynamicObject[])sourceBills);
        logger.info("Save new sourceBills success.");
        logger.info("\u6267\u884c\u65b0\u53cd\u5199\u903b\u8f91:\u53d1\u7968\u5355\u53f7\u4e3a:{},\u5173\u8054\u5f00\u7968\u91d1\u989d:{}.", (Object)invoice.getString("billno"), (Object)invoice.getBigDecimal("associatedamt"));
        invoice.set("associatedamt", (Object)BigDecimal.ZERO);
        DynamicObjectCollection invoiceEntry = invoice.getDynamicObjectCollection("entry");
        for (DynamicObject row : invoiceEntry) {
            row.set("e_associatedamt", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
    }

    private DynamicObject[] getInvoiceAppointRecord(Long invoiceId, Set<Long> sourceBillIds) {
        QFilter invoiceFilter = new QFilter("invoiceid", "=", (Object)invoiceId);
        QFilter sourceFilter = new QFilter("arfinbillid", "in", sourceBillIds);
        List<String> recordRequiredFields = this.getRecordRequiredFields();
        DynamicObject[] appointRecords = BusinessDataServiceHelper.load((String)"ar_appoint_record", (String)String.join((CharSequence)",", recordRequiredFields), (QFilter[])new QFilter[]{invoiceFilter, sourceFilter});
        return appointRecords;
    }

    private Map<String, BigDecimal> getInvoiceAppointAmtMap(DynamicObject[] appointRecords, String[] keyFields) {
        HashMap<String, BigDecimal> appointRecordMap = new HashMap<String, BigDecimal>();
        for (DynamicObject appointRecord : appointRecords) {
            StringBuilder key = new StringBuilder();
            for (int i = 0; i < keyFields.length; ++i) {
                if (i > 0) {
                    key.append("_");
                }
                key.append(appointRecord.get(keyFields[i]));
            }
            String keyStr = key.toString();
            if (appointRecordMap.get(keyStr) == null) {
                appointRecordMap.put(keyStr, appointRecord.getBigDecimal("associatedamt"));
                continue;
            }
            appointRecordMap.put(keyStr, ((BigDecimal)appointRecordMap.get(keyStr)).add(appointRecord.getBigDecimal("associatedamt")));
        }
        return appointRecordMap;
    }

    public List<String> getRecordRequiredFields() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("arfinbillid");
        selectors.add("invoiceid");
        selectors.add("createtime");
        selectors.add("associatedamt");
        return selectors;
    }

    @Deprecated
    public void antiAppoint(DynamicObject invoice, HashSet<Long> sourceBillIds) {
        QFilter idFilter = new QFilter("id", "in", sourceBillIds);
        List<String> sourceRequiredFields = this.getSourceRequiredFields();
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", sourceRequiredFields), (QFilter[])new QFilter[]{idFilter});
        this.antiAppointValidate(invoice);
        this.reverseSourceBill(invoice, sourceBills);
        for (Long srcBillId : sourceBillIds) {
            BOTPHelper.deleteRelation((String)"ar_invoice", (Long)invoice.getLong("id"), (Long)srcBillId);
        }
    }

    public void antiAppoint(DynamicObject invoice) {
        long invoiceId = invoice.getLong("id");
        Map sourceBillInfos = BFTrackerServiceHelper.findSourceBills((String)"ar_invoice", (Long[])new Long[]{invoiceId});
        HashSet sourceBillIds = (HashSet)sourceBillInfos.get("ar_finarbill");
        if (sourceBillIds == null || sourceBillIds.isEmpty()) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", (Object)sourceBillIds);
        List<String> sourceRequiredFields = this.getSourceRequiredFields();
        DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", sourceRequiredFields), (QFilter[])new QFilter[]{idFilter});
        this.antiAppointValidate(invoice);
        this.reverseSourceBill(invoice, sourceBills);
        for (Long srcBillId : sourceBillIds) {
            BOTPHelper.deleteRelation((String)"ar_invoice", (Long)invoiceId, (Long)srcBillId);
        }
    }

    public void antiAppointValidate(Long invoiceId) {
        QFilter invoiceFilter = new QFilter("id", "=", (Object)invoiceId);
        List<String> invoiceRequiredFields = this.getInvoiceRequiredFields();
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)String.join((CharSequence)",", invoiceRequiredFields), (QFilter[])new QFilter[]{invoiceFilter});
        this.antiAppointValidate(invoice);
    }

    public void antiAppointValidate(DynamicObject invoice) {
        if (invoice.getBigDecimal("associatedamt").compareTo(BigDecimal.ZERO) == 0) {
            String messgae = ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u672a\u6307\u5b9a\u6e90\u5355\uff0c\u65e0\u9700\u53d6\u6d88\u6307\u5b9a\u6e90\u5355\u3002 ", (String)"InvoiceSourceAppointor_5", (String)"fi-ar-business", (Object[])new Object[0]);
            throw new KDBizException(messgae);
        }
        String srcBillType = invoice.getString("sourcebilltype");
        Long srcBillId = invoice.getLong("sourcebillid");
        if ("ar_finarbill".equals(srcBillType) && srcBillId != 0L) {
            String messgae = ResManager.loadKDString((String)"\u6e90\u5355\u4e3a\u8d22\u52a1\u5e94\u6536\u5355\u7684\u5f00\u7968\u5355\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u6307\u5b9a\u3002", (String)"InvoiceSourceAppointor_9", (String)"fi-ar-business", (Object[])new Object[0]);
            throw new KDBizException(messgae);
        }
        Set tarBillIds = BOTPHelper.findTarBillIds((String)"ar_invoice", (Long)((Long)invoice.getPkValue()), (String)"ar_finarbill");
        if (!ObjectUtils.isEmpty((Object)tarBillIds)) {
            String messgae = ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u672a\u6307\u5b9a\u6e90\u5355\uff0c\u65e0\u9700\u53d6\u6d88\u6307\u5b9a\u6e90\u5355\u3002 ", (String)"InvoiceSourceAppointor_5", (String)"fi-ar-business", (Object[])new Object[0]);
            throw new KDBizException(messgae);
        }
    }

    private void reverseSourceBill(DynamicObject invoice, DynamicObject[] sourceBills) {
        logger.info("reverse start.");
        BigDecimal restofAmt = invoice.getBigDecimal("recamount");
        BigDecimal restofLocAmt = invoice.getBigDecimal("reclocalamt");
        for (DynamicObject sourceBill : sourceBills) {
            BigDecimal billDisposeAmt = BigDecimal.ZERO;
            BigDecimal billDisposeLocAmt = BigDecimal.ZERO;
            DynamicObjectCollection entry = sourceBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal entryRowDisposeLocAmt;
                BigDecimal oldInvoicedAmt = row.getBigDecimal("e_invoicedamt");
                BigDecimal oldInvoicedLocAmt = row.getBigDecimal("e_invoicedlocalamt");
                BigDecimal entryRowDisposeAmt = BigDecimal.ZERO;
                if (restofAmt.compareTo(oldInvoicedAmt) >= 0) {
                    entryRowDisposeAmt = oldInvoicedAmt;
                    entryRowDisposeLocAmt = oldInvoicedLocAmt;
                } else {
                    entryRowDisposeAmt = restofAmt;
                    entryRowDisposeLocAmt = restofLocAmt;
                }
                BigDecimal currentUninvoicedAmt = row.getBigDecimal("e_uninvoicedamt").add(entryRowDisposeAmt);
                row.set("e_uninvoicedamt", (Object)currentUninvoicedAmt);
                BigDecimal currentUninvoicedLocAmt = row.getBigDecimal("e_uninvoicedlocalamt").add(entryRowDisposeLocAmt);
                row.set("e_uninvoicedlocalamt", (Object)currentUninvoicedLocAmt);
                BigDecimal currentInvoicedAmt = row.getBigDecimal("e_invoicedamt").subtract(entryRowDisposeAmt);
                row.set("e_invoicedamt", (Object)currentInvoicedAmt);
                BigDecimal currentInvoicedLocAmt = row.getBigDecimal("e_invoicedlocalamt").subtract(entryRowDisposeLocAmt);
                row.set("e_invoicedlocalamt", (Object)currentInvoicedLocAmt);
                BigDecimal qty = row.getBigDecimal("e_quantity");
                if (currentInvoicedAmt.compareTo(BigDecimal.ZERO) == 0) {
                    row.set("e_invoicedqty", (Object)BigDecimal.ZERO);
                    row.set("e_uninvoicedqty", (Object)qty);
                } else {
                    BigDecimal actualTaxPrice = row.getBigDecimal("e_acttaxunitprice");
                    if (actualTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal invoicedQty = currentInvoicedAmt.divide(actualTaxPrice, qty.scale(), RoundingMode.HALF_UP);
                        row.set("e_invoicedqty", (Object)invoicedQty);
                        row.set("e_uninvoicedqty", (Object)qty.subtract(invoicedQty));
                    }
                }
                billDisposeAmt = billDisposeAmt.add(entryRowDisposeAmt);
                restofAmt = restofAmt.subtract(entryRowDisposeAmt);
                billDisposeLocAmt = billDisposeLocAmt.add(entryRowDisposeLocAmt);
                restofLocAmt = restofLocAmt.subtract(entryRowDisposeLocAmt);
            }
            logger.info("\u6e90\u5355\u5355\u53f7\u4e3a:{},\u672a\u5f00\u7968\u91d1\u989d:{},\u53cd\u5199\u603b\u91d1\u989d:{}.", new Object[]{sourceBill.getString("billno"), sourceBill.getBigDecimal("uninvoicedamt"), billDisposeAmt});
            sourceBill.set("uninvoicedamt", (Object)sourceBill.getBigDecimal("uninvoicedamt").add(billDisposeAmt));
            sourceBill.set("invoicedamt", (Object)sourceBill.getBigDecimal("invoicedamt").subtract(billDisposeAmt));
            sourceBill.set("uninvoicedlocalamt", (Object)sourceBill.getBigDecimal("uninvoicedlocalamt").add(billDisposeLocAmt));
            sourceBill.set("invoicedlocalamt", (Object)sourceBill.getBigDecimal("invoicedlocalamt").subtract(billDisposeLocAmt));
        }
        SaveServiceHelper.save((DynamicObject[])sourceBills);
        logger.info("Save sourceBills success.");
        logger.info("\u53d1\u7968\u5355\u53f7\u4e3a:{},\u5173\u8054\u5f00\u7968\u91d1\u989d:{}.", (Object)invoice.getString("billno"), (Object)invoice.getBigDecimal("associatedamt"));
        invoice.set("associatedamt", (Object)BigDecimal.ZERO);
        DynamicObjectCollection invoiceEntry = invoice.getDynamicObjectCollection("entry");
        for (DynamicObject row : invoiceEntry) {
            row.set("e_associatedamt", (Object)BigDecimal.ZERO);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
    }

    public List<String> getInvoiceRequiredFields() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("billno");
        selectors.add("e_recamount");
        selectors.add("e_reclocalamt");
        selectors.add("recamount");
        selectors.add("reclocalamt");
        selectors.add("associatedamt");
        selectors.add("e_associatedamt");
        selectors.add("sourcebilltype");
        selectors.add("billstatus");
        selectors.add("basecurrency");
        selectors.add("exchangerate");
        selectors.add("quotation");
        selectors.add("asstacttype");
        selectors.add("asstact");
        selectors.add("currency");
        selectors.add("sourcebilltype");
        selectors.add("sourcebillid");
        return selectors;
    }

    public List<String> getSourceRequiredFields() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("bizdate");
        selectors.add("billno");
        selectors.add("billstatus");
        selectors.add("invoicedamt");
        selectors.add("invoicedlocalamt");
        selectors.add("uninvoicedamt");
        selectors.add("uninvoicedlocalamt");
        selectors.add("e_invoicedamt");
        selectors.add("e_invoicedlocalamt");
        selectors.add("e_uninvoicedamt");
        selectors.add("e_uninvoicedlocalamt");
        selectors.add("e_quantity");
        selectors.add("e_invoicedqty");
        selectors.add("e_uninvoicedqty");
        selectors.add("e_acttaxunitprice");
        return selectors;
    }
}

