/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.invoice.SplitMappingVO;
import kd.fi.arapcommon.business.piaozone.Invoice;
import kd.fi.arapcommon.business.piaozone.InvoiceItem;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BillRelationBuilder;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.tx.AsyncTx;
import kd.fi.arapcommon.tx.AsyncTxAlarmer;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceSplitter {
    private static Log logger = LogFactory.getLog(InvoiceSplitter.class);
    private DynamicObject invoice;
    private HashMap<String, SplitMappingVO> mappingMap = new HashMap();
    private boolean isApointed = false;
    private HashMap<String, BigDecimal> associatedAmtMap = new HashMap();
    private boolean isPushed = true;
    private List<Map<String, Object>> params;
    private boolean hasItemID = true;
    private boolean isContinue = true;

    public static final String partErrMsg() {
        return ResManager.loadKDString((String)"\u62c6\u7968\u8fc7\u7a0b\u4e2d\u90e8\u5206\u5f00\u7968\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u53d1\u7968\u4e91\u7ba1\u7406\u754c\u9762\u5904\u7406\u3002", (String)"InvoiceSplitter_0", (String)"fi-ar-business", (Object[])new Object[0]);
    }

    public InvoiceSplitter() {
    }

    public InvoiceSplitter(List<Map<String, Object>> params) {
        this.params = params;
        this.init();
    }

    private void init() {
        Map<String, Object> firstParam = this.params.get(0);
        String billNo = (String)firstParam.get("billNo");
        QFilter[] filters = new QFilter[]{new QFilter("billno", "=", (Object)billNo)};
        this.invoice = BusinessDataServiceHelper.loadSingle((String)"ar_invoice", (String)"id", (QFilter[])filters);
        if (this.invoice == null) {
            throw new KDBizException("none invoice was found");
        }
        this.invoice = BusinessDataServiceHelper.loadSingle((Object)this.invoice.getPkValue(), (String)"ar_invoice");
        String srcBillType = this.invoice.getString("sourcebilltype");
        logger.info(this.invoice.getString("billno") + " srcBillType: " + srcBillType);
        if (StringUtils.isEmpty((String)srcBillType)) {
            this.isPushed = false;
            logger.info(this.invoice.getString("billno") + " isPushed: " + this.isPushed);
        } else {
            Set findSouBillIds = BOTPHelper.findSouBillIds((String)"ar_invoice", (Long)((Long)this.invoice.getPkValue()), (String)srcBillType);
            if (findSouBillIds.size() > 1) {
                this.hasItemID = false;
            }
        }
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (Map<String, Object> param : this.params) {
            Invoice invoiceVO = (Invoice)JSON.parseObject((String)JSON.toJSONString(param), Invoice.class);
            totalAmt = totalAmt.add(invoiceVO.getTotalAmount());
            InvoiceItem invoiceItem = (InvoiceItem)invoiceVO.getItems().get(0);
            if (!"2".equals(invoiceVO.getSplitOrMergeFlag()) && !"3".equals(invoiceVO.getSplitOrMergeFlag()) && !StringUtils.isEmpty((String)invoiceItem.getItemID())) continue;
            this.hasItemID = false;
        }
        if (totalAmt.compareTo(this.invoice.getBigDecimal("recamount")) < 0) {
            this.handlePartErr(this.invoice);
            this.isContinue = false;
            return;
        }
        DynamicObjectCollection invoiceColl = this.invoice.getDynamicObjectCollection("entry");
        for (DynamicObject item : invoiceColl) {
            String key = item.getString(this.isPushed ? "e_sourcebillentryid" : "id");
            SplitMappingVO mappingVO = new SplitMappingVO();
            mappingVO.setTaxClass(item.getDynamicObject("e_taxclass"));
            mappingVO.setItemName(item.getString("e_itemname"));
            mappingVO.setSpectype(item.getString("e_invspectype"));
            mappingVO.setItemUnit(item.getString("e_invoiceunit"));
            mappingVO.setRemark(item.getString("e_remark"));
            this.mappingMap.put(key, mappingVO);
            this.associatedAmtMap.put(item.getString(this.isPushed ? "e_sourcebillentryid" : "id"), item.getBigDecimal("e_associatedamt"));
        }
        if (this.invoice.getBigDecimal("associatedamt").compareTo(BigDecimal.ZERO) != 0) {
            this.isApointed = true;
        }
    }

    public void handlePartErr(DynamicObject invoice) {
        invoice.set("invoicestatus", (Object)"0");
        invoice.set("invoicecode", (Object)"");
        invoice.set("invoiceno", (Object)"");
        invoice.set("serialno", (Object)"");
        invoice.set("pdfurl", (Object)"");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice});
        AsyncTx asyncTx = new AsyncTx();
        asyncTx.setGroup("ar_invoice");
        asyncTx.setAction("split");
        asyncTx.setXid(invoice.getPkValue().toString());
        asyncTx.setErrorMessage(InvoiceSplitter.partErrMsg());
        AsyncTxAlarmer.sendMessage((AsyncTx)asyncTx, (Long)((Long)invoice.getDynamicObject("auditor").getPkValue()));
    }

    public List<DynamicObject> split() {
        List<DynamicObject> list = null;
        if (!this.isContinue || !"0".equals(this.invoice.get("invoicestatus")) && !"2".equals(this.invoice.get("invoicestatus"))) {
            return null;
        }
        if (this.hasItemID) {
            if (this.isPushed) {
                logger.info("splitByBOTP...");
                list = this.splitByBOTP();
            } else {
                logger.info("splitByClone...");
                list = this.splitByClone();
            }
            this.appointSourceBill(list);
        } else {
            logger.info("split4Merge...");
            list = this.split4Merge();
        }
        return list;
    }

    private void modifyEntity(DynamicObject entity, InvoiceItem invoiceItem, BigDecimal exchangeRate) {
        entity.set("e_quantity", (Object)invoiceItem.getNum());
        this.setBaseUnitQty(entity);
        entity.set("e_unitprice", (Object)invoiceItem.getUnitPrice());
        entity.set("e_actunitprice", (Object)invoiceItem.getUnitPrice());
        if (invoiceItem.getUnitPrice() != null) {
            entity.set("e_taxunitprice", (Object)BigDecimal.ONE.add(invoiceItem.getTaxRate()).multiply(invoiceItem.getUnitPrice()));
            entity.set("e_acttaxunitprice", (Object)BigDecimal.ONE.add(invoiceItem.getTaxRate()).multiply(invoiceItem.getUnitPrice()));
        }
        entity.set("e_amount", (Object)invoiceItem.getDetailAmount());
        entity.set("e_localamt", (Object)invoiceItem.getDetailAmount().multiply(exchangeRate));
        entity.set("e_tax", (Object)invoiceItem.getTaxAmount());
        entity.set("e_recamount", (Object)invoiceItem.getDetailAmount().add(invoiceItem.getTaxAmount()));
        entity.set("e_reclocalamt", (Object)entity.getBigDecimal("e_recamount").multiply(exchangeRate));
        entity.set("e_associatedamt", entity.get("e_recamount"));
        entity.set("e_unverifiedwriteoffamt", entity.get("e_recamount"));
        entity.set("e_unverifiedwriteoffqty", (Object)invoiceItem.getNum());
    }

    private List<DynamicObject> split4Merge() {
        HashMap<String, String> entryIDMap = new HashMap<String, String>();
        DynamicObjectCollection entries = this.invoice.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            entryIDMap.put(entry.getString("e_sourcebillentryid"), entry.getString("id"));
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(this.params.size());
        DynamicObject org = this.invoice.getDynamicObject("org");
        CloneUtils utils = new CloneUtils(true, true);
        for (int i = 0; i < this.params.size(); ++i) {
            Map<String, Object> param = this.params.get(i);
            Invoice invoiceVO = (Invoice)JSON.parseObject((String)JSON.toJSONString(param), Invoice.class);
            DynamicObject clone = (DynamicObject)utils.clone((IDataEntityBase)this.invoice);
            String billno = CodeRuleServiceHelper.getNumber((String)"ar_invoice", (DynamicObject)clone, (String)org.getPkValue().toString());
            clone.set("billno", (Object)billno);
            clone.set("srcbillno", this.invoice.get("billno"));
            clone.set("invoicestatus", (Object)(this.isErrData(param) ? "0" : "1"));
            if (this.isErrData(param)) {
                clone.set("billstatus", (Object)"A");
            }
            this.writeBackInvoice(clone, param);
            if ("1".equals(invoiceVO.getSplitOrMergeFlag()) && StringUtils.isNotEmpty((String)((InvoiceItem)invoiceVO.getItems().get(0)).getItemID())) {
                this.modifyInvoice(clone, invoiceVO, entryIDMap);
                DynamicObjectCollection entities = clone.getDynamicObjectCollection("entry");
                for (DynamicObject entity : entities) {
                    entity.set("e_associatedamt", entity.get("e_recamount"));
                }
                clone.set("associatedamt", clone.get("recamount"));
            } else {
                this.modifyInvoice4Merge(clone, invoiceVO);
            }
            saveList.add(clone);
        }
        Date invoiceDate = this.parseDate(this.params.get(0).get("invoiceDate"));
        if (invoiceDate != null) {
            this.invoice.set("bizdate", (Object)invoiceDate);
        }
        this.invoice.set("invoicestatus", (Object)"9");
        saveList.add(this.invoice);
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        ArrayList<Long> invoicePks = new ArrayList<Long>(saveList.size() - 1);
        for (int i = 0; i < saveList.size() - 1; ++i) {
            Object pkValue = ((DynamicObject)saveList.get(i)).getPkValue();
            invoicePks.add(Long.valueOf(pkValue.toString()));
        }
        BillRelationBuilder billRelationBuilder = new BillRelationBuilder("ar_invoice", "ar_invoice");
        billRelationBuilder.saveRelation(Long.valueOf(this.invoice.getPkValue().toString()), invoicePks);
        return saveList;
    }

    private void appointSourceBill(List<DynamicObject> list) {
        if (this.isApointed) {
            BillRelationBuilder billRelationBuilder;
            ArrayList<Long> invoicePks = new ArrayList<Long>();
            for (DynamicObject inv : list) {
                if (this.invoice.getPkValue().equals(inv.getPkValue())) continue;
                invoicePks.add(inv.getLong("id"));
            }
            if (!"ar_finarbill".equals(this.invoice.get("sourcebilltype"))) {
                Set souBillIds = BOTPHelper.findSouBillIds((String)"ar_invoice", (Long)this.invoice.getLong("id"), (String)"ar_finarbill");
                Iterator souIterator = souBillIds.iterator();
                while (souIterator.hasNext()) {
                    billRelationBuilder = new BillRelationBuilder("ar_finarbill", "ar_invoice");
                    billRelationBuilder.saveRelation((Long)souIterator.next(), invoicePks);
                }
            }
            Set tarBillIds = BOTPHelper.findTarBillIds((String)"ar_invoice", (Long)this.invoice.getLong("id"), (String)"ar_finarbill");
            Iterator tarIterator = tarBillIds.iterator();
            while (tarIterator.hasNext()) {
                billRelationBuilder = new BillRelationBuilder("ar_invoice", "ar_finarbill");
                billRelationBuilder.saveRelation(invoicePks, (Long)tarIterator.next());
            }
        }
    }

    private List<DynamicObject> splitByClone() {
        DynamicObjectCollection entries = this.invoice.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            entry.set("e_sourcebillentryid", entry.get("id"));
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(this.params.size());
        Map<String, Object> firstParam = this.params.get(0);
        DynamicObject org = this.invoice.getDynamicObject("org");
        CloneUtils utils = new CloneUtils(true, true);
        for (int i = 1; i < this.params.size(); ++i) {
            Map<String, Object> param = this.params.get(i);
            Invoice invoiceVO = (Invoice)JSON.parseObject((String)JSON.toJSONString(param), Invoice.class);
            DynamicObject clone = (DynamicObject)utils.clone((IDataEntityBase)this.invoice);
            String billno = CodeRuleServiceHelper.getNumber((String)"ar_invoice", (DynamicObject)clone, (String)org.getPkValue().toString());
            clone.set("billno", (Object)billno);
            clone.set("srcbillno", firstParam.get("billNo"));
            clone.set("invoicestatus", (Object)(this.isErrData(param) ? "0" : "1"));
            if (this.isErrData(param)) {
                clone.set("billstatus", (Object)"A");
            }
            this.writeBackInvoice(clone, param);
            this.modifyInvoice(clone, invoiceVO, null);
            saveList.add(clone);
        }
        Invoice invoiceVO = (Invoice)JSON.parseObject((String)JSON.toJSONString(firstParam), Invoice.class);
        this.writeBackInvoice(this.invoice, firstParam);
        this.modifyInvoice(this.invoice, invoiceVO, null);
        this.invoice.set("invoicestatus", (Object)(this.isErrData(firstParam) ? "0" : "1"));
        if (this.isErrData(firstParam)) {
            this.invoice.set("billstatus", (Object)"A");
        }
        this.invoice.set("srcbillno", firstParam.get("billNo"));
        saveList.add(this.invoice);
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        return saveList;
    }

    private List<DynamicObject> splitByBOTP() {
        int i;
        DynamicObject auditor = this.invoice.getDynamicObject("auditor");
        HashMap<String, String> entryIDMap = new HashMap<String, String>();
        DynamicObjectCollection entries = this.invoice.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            entryIDMap.put(entry.getString("e_sourcebillentryid"), entry.getString("id"));
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(this.params.size() + 1);
        Map<String, Object> firstParam = this.params.get(0);
        this.invoice.set("srcbillno", firstParam.get("billNo"));
        this.writeBackInvoice(this.invoice, firstParam);
        this.modifyInvoice(this.invoice, (Invoice)JSON.parseObject((String)JSON.toJSONString(firstParam), Invoice.class), entryIDMap);
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])new DynamicObject[]{this.invoice}, null);
        if (!saveResult.isSuccess()) {
            logger.info("------operationResult.Message------" + saveResult.getMessage());
            OperationHelper.assertResult((OperationResult)saveResult);
        }
        saveList.add(this.invoice);
        ArrayList<Long> srcBillIDs = new ArrayList<Long>();
        srcBillIDs.add(this.invoice.getLong("sourcebillid"));
        for (i = 1; i < this.params.size(); ++i) {
            Map map = BOTPHelper.push4Result((String)this.invoice.getString("sourcebilltype"), (String)"ar_invoice", null, srcBillIDs);
            List trgBills = null;
            Object target = map.get("convertResult");
            if (target != null) {
                ConvertOperationResult convertResult = (ConvertOperationResult)target;
                String convertReport = BOTPHelper.getConvertReport((ConvertOperationResult)convertResult);
                logger.error("------botp.ConvertReport------" + convertReport);
                ErrorCode ec = new ErrorCode("botp", convertReport);
                throw new KDBizException(ec, new Object[0]);
            }
            trgBills = (List)map.get("trgBills");
            Map<String, Object> param = this.params.get(i);
            Invoice invoiceVO = (Invoice)JSON.parseObject((String)JSON.toJSONString(param), Invoice.class);
            ((DynamicObject)trgBills.get(0)).set("srcbillno", firstParam.get("billNo"));
            this.fillInfo((DynamicObject)trgBills.get(0));
            this.writeBackInvoice((DynamicObject)trgBills.get(0), param);
            this.modifyInvoice((DynamicObject)trgBills.get(0), invoiceVO, entryIDMap);
            saveList.add((DynamicObject)trgBills.get(0));
        }
        for (i = 0; i < saveList.size(); ++i) {
            DynamicObject inv = (DynamicObject)saveList.get(i);
            inv.set("billstatus", (Object)"C");
            inv.set("auditor", (Object)auditor);
            inv.set("auditdate", (Object)new Date());
            inv.set("invoicestatus", (Object)(this.isErrData(this.params.get(i)) ? "0" : "1"));
            if (!this.isErrData(this.params.get(i))) continue;
            inv.set("billstatus", (Object)"A");
        }
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"nocontrolsave", (String)"ar_invoice", (DynamicObject[])saveList.toArray(new DynamicObject[0]), null);
        if (!submitResult.isSuccess()) {
            logger.info("------operationResult.Message------" + submitResult.getMessage());
            OperationHelper.assertResult((OperationResult)submitResult);
        }
        return saveList;
    }

    private void fillInfo(DynamicObject obj) {
        obj.set("invoicetype", this.invoice.get("invoicetype"));
        obj.set("invoicetypef7", this.invoice.get("invoicetypef7"));
        obj.set("buyer", this.invoice.get("buyer"));
        obj.set("buyeracct", this.invoice.get("buyeracct"));
        obj.set("buyeraddr", this.invoice.get("buyeraddr"));
        obj.set("buyerbank", this.invoice.get("buyerbank"));
        obj.set("buyertel", this.invoice.get("buyertel"));
        obj.set("buyertin", this.invoice.get("buyertin"));
        obj.set("seller", this.invoice.get("seller"));
        obj.set("selleracct", this.invoice.get("selleracct"));
        obj.set("selleraddr", this.invoice.get("selleraddr"));
        obj.set("sellerbank", this.invoice.get("sellerbank"));
        obj.set("sellername", this.invoice.get("sellername"));
        obj.set("sellertel", this.invoice.get("sellertel"));
        obj.set("sellertin", this.invoice.get("sellertin"));
        obj.set("checker", this.invoice.get("checker"));
        obj.set("drawer", this.invoice.get("drawer"));
        obj.set("payer", this.invoice.get("payer"));
        obj.set("email", this.invoice.get("email"));
        obj.set("remark", this.invoice.get("remark"));
        DynamicObjectCollection objColl = obj.getDynamicObjectCollection("entry");
        for (DynamicObject item : objColl) {
            SplitMappingVO mappingVO = this.mappingMap.get(item.getString("e_sourcebillentryid"));
            if (mappingVO == null) continue;
            item.set("e_taxclass", (Object)mappingVO.getTaxClass());
            item.set("e_itemname", (Object)mappingVO.getItemName());
            item.set("e_invspectype", (Object)mappingVO.getSpectype());
            item.set("e_invoiceunit", (Object)mappingVO.getItemUnit());
            item.set("e_remark", (Object)mappingVO.getRemark());
        }
    }

    public void writeBackInvoice(DynamicObject invoice, Map<String, Object> param) {
        boolean hasVarianceAmt;
        if (this.isErrData(param)) {
            return;
        }
        Object serialNo = param.get("serialNo");
        invoice.set("serialno", serialNo);
        Object invoiceCode = param.get("invoiceCode");
        invoice.set("invoicecode", invoiceCode);
        Object invoiceNo = param.get("invoiceNo");
        invoice.set("invoiceno", invoiceNo);
        Object pdfUrl = param.get("pdfUrl");
        invoice.set("pdfurl", pdfUrl);
        Object drawer = param.get("drawer");
        invoice.set("drawer", drawer);
        Date invoiceDate = this.parseDate(param.get("invoiceDate"));
        if (invoiceDate != null) {
            invoice.set("bizdate", (Object)invoiceDate);
        }
        if (hasVarianceAmt = EntityMetadataUtils.isExistProperty((DynamicObject)invoice, (String)"varianceamount")) {
            invoice.set("varianceamount", param.get("mergeDifferTaxAmount"));
        }
    }

    public boolean isErrData(Map<String, Object> param) {
        return ObjectUtils.isEmpty((Object)param.get("invoiceCode")) && ObjectUtils.isEmpty((Object)param.get("invoiceNo"));
    }

    public Date parseDate(Object rawDate) {
        if (rawDate == null) {
            return null;
        }
        if (rawDate instanceof Long) {
            return new Date((Long)rawDate);
        }
        if (rawDate instanceof String) {
            if ("".equals(((String)rawDate).trim())) {
                return null;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                return simpleDateFormat.parse((String)rawDate);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (rawDate instanceof Date) {
            return (Date)rawDate;
        }
        return null;
    }

    private void modifyInvoice4Merge(DynamicObject invoiceDO, Invoice invoiceVO) {
        DynamicObjectCollection entities = invoiceDO.getDynamicObjectCollection("entry");
        List items = invoiceVO.getItems();
        HashMap itemMap = new HashMap(8);
        for (InvoiceItem invoiceItem : items) {
            String[] goodsName = invoiceItem.getGoodsName().split("\\*");
            String specModel = invoiceItem.getSpecModel();
            String itemMapKey = "";
            itemMapKey = specModel == null || "null".equals(specModel) ? goodsName[goodsName.length - 1] + invoiceItem.getGoodsCode() : goodsName[goodsName.length - 1] + invoiceItem.getGoodsCode() + invoiceItem.getSpecModel();
            logger.info("modifyInvoice4Merge itemKeyVO: " + itemMapKey);
            List targets = (List)itemMap.get(itemMapKey);
            if (targets != null) {
                targets.add(invoiceItem);
                continue;
            }
            ArrayList<InvoiceItem> invoiceItems = new ArrayList<InvoiceItem>();
            invoiceItems.add(invoiceItem);
            itemMap.put(itemMapKey, invoiceItems);
        }
        BigDecimal exchangeRate = invoiceDO.getBigDecimal("exchangerate");
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            DynamicObject entity = (DynamicObject)iterator.next();
            String specType = entity.getString("e_invspectype");
            String key = "";
            key = StringUtils.isNotEmpty((String)specType) ? entity.getString("e_itemname") + entity.getDynamicObject("e_taxclass").getString("mergecode") + entity.getString("e_invspectype") : entity.getString("e_itemname") + entity.getDynamicObject("e_taxclass").getString("mergecode");
            logger.info("modifyInvoice4Merge itemKeyDO: " + key);
            List invoiceItems = (List)itemMap.get(key);
            if (invoiceItems == null || invoiceItems.size() == 0) {
                iterator.remove();
                continue;
            }
            itemMap.remove(key);
            InvoiceItem invoiceItem = (InvoiceItem)invoiceItems.get(0);
            if (invoiceItems.size() > 1) {
                InvoiceItem disItem = (InvoiceItem)invoiceItems.get(1);
                entity.set("e_quantity", (Object)invoiceItem.getNum());
                this.setBaseUnitQty(entity);
                entity.set("e_unitprice", (Object)invoiceItem.getUnitPrice());
                BigDecimal amount = invoiceItem.getDetailAmount().add(disItem.getDetailAmount());
                entity.set("e_amount", (Object)amount);
                entity.set("e_localamt", (Object)amount.multiply(exchangeRate));
                BigDecimal tax = invoiceItem.getTaxAmount().add(disItem.getTaxAmount());
                entity.set("e_tax", (Object)tax);
                BigDecimal discountAmt = "1".equals(disItem.getDiscountType()) ? disItem.getDetailAmount().add(disItem.getTaxAmount()).abs() : invoiceItem.getDetailAmount().add(invoiceItem.getTaxAmount()).abs();
                entity.set("e_discountamount", (Object)discountAmt);
                entity.set("e_discountlocalamt", (Object)discountAmt.multiply(exchangeRate));
                BigDecimal recAmt = amount.add(tax);
                entity.set("e_recamount", (Object)recAmt);
                entity.set("e_reclocalamt", (Object)recAmt.multiply(exchangeRate));
                entity.set("e_associatedamt", entity.get("e_recamount"));
                entity.set("e_unverifiedwriteoffamt", (Object)recAmt);
                entity.set("e_unverifiedwriteoffqty", (Object)invoiceItem.getNum());
                continue;
            }
            this.modifyEntity(entity, invoiceItem, exchangeRate);
        }
        invoiceDO.set("tax", (Object)invoiceVO.getTotalTaxAmount());
        invoiceDO.set("amount", (Object)invoiceVO.getTotalAmount().subtract(invoiceVO.getTotalTaxAmount()));
        invoiceDO.set("recamount", (Object)invoiceVO.getTotalAmount());
        invoiceDO.set("reclocalamt", (Object)invoiceVO.getTotalAmount().multiply(exchangeRate));
        invoiceDO.set("localamt", (Object)invoiceDO.getBigDecimal("amount").multiply(exchangeRate));
        invoiceDO.set("associatedamt", invoiceDO.get("recamount"));
        invoiceDO.set("splitormergeflag", (Object)Boolean.FALSE);
    }

    private void modifyInvoice(DynamicObject invoiceDO, Invoice invoiceVO, Map<String, String> entryIDMap) {
        DynamicObjectCollection entities = invoiceDO.getDynamicObjectCollection("entry");
        List items = invoiceVO.getItems();
        HashMap itemMap = new HashMap();
        for (InvoiceItem invoiceItem : items) {
            String itemID = invoiceItem.getItemID();
            List targets = (List)itemMap.get(itemID);
            if (targets != null) {
                targets.add(invoiceItem);
                continue;
            }
            ArrayList<InvoiceItem> invoiceItems = new ArrayList<InvoiceItem>();
            invoiceItems.add(invoiceItem);
            itemMap.put(itemID, invoiceItems);
        }
        BigDecimal associatedAmt = BigDecimal.ZERO;
        BigDecimal exchangeRate = invoiceDO.getBigDecimal("exchangerate");
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            DynamicObject entity = (DynamicObject)iterator.next();
            String idStr = entity.getString("e_sourcebillentryid");
            String key = this.isPushed ? entryIDMap.get(idStr) : idStr;
            List invoiceItems = (List)itemMap.get(key);
            if (invoiceItems == null || invoiceItems.size() == 0) {
                iterator.remove();
                continue;
            }
            InvoiceItem invoiceItem = (InvoiceItem)invoiceItems.get(0);
            if (invoiceItems.size() > 1) {
                InvoiceItem disItem = (InvoiceItem)invoiceItems.get(1);
                entity.set("e_quantity", (Object)invoiceItem.getNum());
                this.setBaseUnitQty(entity);
                entity.set("e_unitprice", (Object)invoiceItem.getUnitPrice());
                BigDecimal amount = invoiceItem.getDetailAmount().add(disItem.getDetailAmount());
                entity.set("e_amount", (Object)amount);
                entity.set("e_localamt", (Object)amount.multiply(exchangeRate));
                BigDecimal tax = invoiceItem.getTaxAmount().add(disItem.getTaxAmount());
                entity.set("e_tax", (Object)tax);
                BigDecimal discountAmt = "1".equals(disItem.getDiscountType()) ? disItem.getDetailAmount().add(disItem.getTaxAmount()).abs() : invoiceItem.getDetailAmount().add(invoiceItem.getTaxAmount()).abs();
                entity.set("e_discountamount", (Object)discountAmt);
                entity.set("e_discountlocalamt", (Object)discountAmt.multiply(exchangeRate));
                BigDecimal recAmt = amount.add(tax);
                entity.set("e_recamount", (Object)recAmt);
                entity.set("e_reclocalamt", (Object)recAmt.multiply(exchangeRate));
                if (this.associatedAmtMap.get(idStr) != null) {
                    if (this.associatedAmtMap.get(idStr).compareTo(recAmt) >= 0) {
                        entity.set("e_associatedamt", entity.get("e_recamount"));
                        this.associatedAmtMap.put(idStr, this.associatedAmtMap.get(idStr).subtract(recAmt));
                    } else {
                        entity.set("e_associatedamt", (Object)this.associatedAmtMap.get(idStr));
                        this.associatedAmtMap.put(idStr, BigDecimal.ZERO);
                    }
                    associatedAmt = associatedAmt.add(entity.getBigDecimal("e_associatedamt"));
                }
                entity.set("e_unverifiedwriteoffamt", (Object)recAmt);
                entity.set("e_unverifiedwriteoffqty", (Object)invoiceItem.getNum());
                continue;
            }
            this.modifyEntity(entity, invoiceItem, exchangeRate);
            if (this.associatedAmtMap.get(idStr) == null) continue;
            if (this.associatedAmtMap.get(idStr).compareTo(entity.getBigDecimal("e_recamount")) >= 0) {
                entity.set("e_associatedamt", entity.get("e_recamount"));
                this.associatedAmtMap.put(idStr, this.associatedAmtMap.get(idStr).subtract(entity.getBigDecimal("e_recamount")));
            } else {
                entity.set("e_associatedamt", (Object)this.associatedAmtMap.get(idStr));
                this.associatedAmtMap.put(idStr, BigDecimal.ZERO);
            }
            associatedAmt = associatedAmt.add(entity.getBigDecimal("e_associatedamt"));
        }
        invoiceDO.set("tax", (Object)invoiceVO.getTotalTaxAmount());
        invoiceDO.set("amount", (Object)invoiceVO.getTotalAmount().subtract(invoiceVO.getTotalTaxAmount()));
        invoiceDO.set("recamount", (Object)invoiceVO.getTotalAmount());
        invoiceDO.set("reclocalamt", (Object)invoiceVO.getTotalAmount().multiply(exchangeRate));
        invoiceDO.set("localamt", (Object)invoiceDO.getBigDecimal("amount").multiply(exchangeRate));
        invoiceDO.set("associatedamt", (Object)associatedAmt);
    }

    private void setBaseUnitQty(DynamicObject entry) {
        BigDecimal quantity;
        if (entry == null) {
            return;
        }
        DynamicObject material = entry.getDynamicObject("e_material");
        BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
        DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
        DynamicObject baseUnit = null;
        if (!ObjectUtils.isEmpty((Object)material)) {
            baseUnit = material.getDynamicObject("baseunit");
            if (measureUnit == null) {
                measureUnit = baseUnit;
            }
            if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                covertRate = UnitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)measureUnit.getLong("id"), (Long)baseUnit.getLong("id"));
                covertRate = covertRate == null ? BigDecimal.ONE : covertRate;
            }
        } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        if ((quantity = entry.getBigDecimal("e_quantity")) != null && baseUnit != null) {
            entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit));
        }
    }
}

