/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.ar.business.invoice.InvoiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.invoice.vo.Invoice;
import kd.fi.arapcommon.util.AES128;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class IssueInvoiceAction
extends AbstractAction {
    private static Log logger = LogFactory.getLog(IssueInvoiceAction.class);
    private List<Invoice> invoices;

    public IssueInvoiceAction(String taxRegNum, List<Invoice> invoices) {
        this.taxRegNum = taxRegNum;
        this.invoices = invoices;
    }

    public String execute() {
        String response;
        if (InvoiceHelper.isMicroService()) {
            String response2;
            String jsonStr = JSONObject.toJSONString(this.invoices);
            logger.info("IssueInvoiceAction -- jsonStr:" + jsonStr);
            try {
                response2 = (String)DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"FiBillPushServiceImpl", (String)"doBusiness", (Object[])new Object[]{jsonStr});
            }
            catch (Exception e) {
                throw new KDBizException("Abnormal Invoicing interface:" + e.getMessage());
            }
            return response2;
        }
        String domain = KingdeeInvoiceCloudConfig.getDomain();
        String url = domain + "/m17/bill/encrypt/bizdata/sys?encry_type=GCM&access_token=" + this.token;
        DynamicObject clientConfig = KingdeeInvoiceCloudConfig.getClientConfig((String)this.taxRegNum);
        String encrypt_key = clientConfig.getString("encrypt_key");
        logger.info("IssueInvoiceAction -- encrypt_key\uff1a" + encrypt_key);
        String jsonStr = JsonUtils.coll2String(this.invoices);
        logger.info("IssueInvoiceAction -- jsonStr\uff1a" + jsonStr);
        String jsonEncrypt = "";
        try {
            jsonEncrypt = AES128.encrypt((String)jsonStr, (String)encrypt_key);
            if (StringUtils.isEmpty((String)jsonEncrypt)) {
                throw new KDBizException("The length of the Key is not 16!");
            }
        }
        catch (Exception e) {
            throw new KDBizException("AES128 Encryption message error!");
        }
        try {
            response = this.doPost(url, jsonEncrypt);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"IssueInvoiceAction_0", (String)"fi-ar-business", (Object[])new Object[0]));
        }
        return response;
    }

    public String desc() {
        return "IssueInvoiceAction";
    }
}

