/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.fi.ar.business.invoice.InvoiceFacade;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.tx.AsyncTx;
import kd.fi.arapcommon.tx.AsyncTxService;
import kd.fi.arapcommon.tx.IAsyncExecutor;
import kd.fi.arapcommon.util.JsonUtils;

public class IssueInvoiceApiPlugin
implements IBillWebApiPlugin,
IAsyncExecutor {
    private static Log logger = LogFactory.getLog(IssueInvoiceApiPlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        logger.info(JsonUtils.objToJson(params));
        List datas = (List)params.get("datas");
        HashMap seperateDatas = new HashMap();
        for (Object data : datas) {
            String string = (String)data.get("billNo");
            List targets = (List)seperateDatas.get(string);
            if (targets != null) {
                targets.add(data);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>(64);
            list.add(data);
            seperateDatas.put(string, list);
        }
        ArrayList<AsyncTx> txs = new ArrayList<AsyncTx>(seperateDatas.size());
        for (Map.Entry entry : seperateDatas.entrySet()) {
            AsyncTx asyncTx = new AsyncTx();
            asyncTx.setGroup("ar_invoice");
            asyncTx.setAction("IssueCallBack");
            asyncTx.setTask("IssueCallBack");
            asyncTx.setParam(entry.getValue());
            asyncTx.setXid((String)entry.getKey());
            asyncTx.setExecuteClass(IssueInvoiceApiPlugin.class.getName());
            txs.add(asyncTx);
        }
        AsyncTxService asyncTxService = new AsyncTxService();
        asyncTxService.save(txs.toArray(new AsyncTx[0]));
        ThreadPools.executeOnceIncludeRequestContext((String)"Invoice.Issue.CallBack", () -> {
            for (AsyncTx tx : txs) {
                asyncTxService.executeWithTx(tx);
            }
        });
        ApiResult apiResult = new ApiResult();
        apiResult.setSuccess(true);
        apiResult.setMessage("Issue Invoice Success");
        return apiResult;
    }

    public void execute(AsyncTx tx) {
        List param = (List)tx.getParam(List.class);
        InvoiceFacade invoiceFacade = (InvoiceFacade)BeanFactory.getBean(InvoiceFacade.class, (Object[])new Object[0]);
        try {
            invoiceFacade.issueCallBack(param);
        }
        catch (KDBizException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355\u4e0b\u63a8\u5f00\u7968\u5355\u5931\u8d25 : %s", (String)"IssueInvoiceApiPlugin_0", (String)"fi-ar-business", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

