/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.ar.business.invoice.PrintParam;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.util.AES128;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class PrintInvoiceAction
extends AbstractAction {
    private List<PrintParam> paramList;

    public PrintInvoiceAction(String taxRegNum, List<PrintParam> paramList) {
        this.taxRegNum = taxRegNum;
        this.paramList = paramList;
    }

    public String execute() {
        String response;
        String domain = KingdeeInvoiceCloudConfig.getDomain();
        String url = domain + "/m17/bill/encrypt/invoice/print?encry_type=GCM&access_token=" + this.token;
        logger.info("PrintInvoiceAction -- url\uff1a" + url);
        DynamicObject clientConfig = KingdeeInvoiceCloudConfig.getClientConfig((String)this.taxRegNum);
        String encrypt_key = clientConfig.getString("encrypt_key");
        HashMap<String, List<PrintParam>> dataMap = new HashMap<String, List<PrintParam>>();
        dataMap.put("invoiceDatas", this.paramList);
        String jsonStr = JsonUtils.objToJson(dataMap);
        logger.info("PrintInvoiceAction -- jsonStr\uff1a" + jsonStr);
        String jsonEncrypt = "";
        try {
            jsonEncrypt = AES128.encrypt((String)jsonStr, (String)encrypt_key);
            if (StringUtils.isEmpty((String)jsonEncrypt)) {
                throw new KDBizException("The length of the Key is not 16!");
            }
        }
        catch (Exception e) {
            throw new KDBizException("AES128 Encryption message error!");
        }
        try {
            response = this.doPost(url, jsonEncrypt);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u6253\u5370\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"PrintInvoiceAction_0", (String)"fi-ar-business", (Object[])new Object[0]));
        }
        return response;
    }

    public String desc() {
        return "PrintInvoiceAction";
    }
}

