/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.invoice;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TaxClassMatcher {
    private Map<Long, Long> taxClassMap;
    private Map<String, DynamicObject> taxClassInfoMap;
    private Long asstactPk;

    public TaxClassMatcher(DynamicObject asstact, Collection<DynamicObject> materials) {
        DynamicObject[] taxClasses;
        String asstactType;
        this.taxClassMap = new HashMap<Long, Long>(materials.size());
        this.taxClassInfoMap = new HashMap<String, DynamicObject>(materials.size());
        boolean firstRow = true;
        String matchType = null;
        HashSet<Long> ids = new HashSet<Long>(materials.size());
        for (DynamicObject material : materials) {
            if (material == null) continue;
            if (firstRow) {
                String name = material.getDataEntityType().getName();
                matchType = "bd_material".equals(name) ? "materiel" : "expenseitem";
                firstRow = false;
            }
            ids.add(material.getLong("id"));
        }
        if (ids.isEmpty()) {
            return;
        }
        this.asstactPk = 0L;
        if (asstact != null && "bd_customer".equals(asstactType = asstact.getDynamicObjectType().getName())) {
            this.asstactPk = asstact.getLong("id");
        }
        QFilter[] filters = new QFilter[]{new QFilter(matchType, "in", ids), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        for (DynamicObject taxClass : taxClasses = BusinessDataServiceHelper.load((String)"ar_goodslinktaxtype", (String)("id,customer,spectype,invname,taxrate,taxratef7,taxsupertypenum," + matchType), (QFilter[])filters)) {
            long itemId = taxClass.getLong(matchType + ".id");
            long cusId = taxClass.getLong("customer.id");
            this.taxClassInfoMap.put(String.valueOf(itemId) + "::" + String.valueOf(cusId), taxClass);
            this.taxClassMap.put(itemId, taxClass.getLong("taxsupertypenum.id"));
        }
    }

    public long match(DynamicObject material) {
        long id = material.getLong("id");
        Long taxClassId = this.taxClassMap.get(id);
        return taxClassId == null ? 0L : taxClassId;
    }

    public DynamicObject getTaxClassMappingInfo(DynamicObject match) {
        if (match == null) {
            return null;
        }
        DynamicObject taxClass = this.taxClassInfoMap.get(String.valueOf(match.getLong("id")) + "::" + String.valueOf(this.asstactPk));
        if (taxClass == null) {
            taxClass = this.taxClassInfoMap.get(String.valueOf(match.getLong("id")) + "::" + String.valueOf(0L));
        }
        return taxClass;
    }

    public DynamicObject getTaxClassMappingInfo(Long asstactId, DynamicObject match) {
        if (match == null) {
            return null;
        }
        DynamicObject taxClass = this.taxClassInfoMap.get(String.valueOf(match.getLong("id")) + "::" + String.valueOf(asstactId));
        if (taxClass == null) {
            taxClass = this.taxClassInfoMap.get(String.valueOf(match.getLong("id")) + "::" + String.valueOf(0L));
        }
        return taxClass;
    }
}

