/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.journal;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.journal.convert.JournalAutoConverter;

public class ArJournalPushJournalConverter
extends JournalAutoConverter {
    protected Object getValue(String journalField, DynamicObject sourceBill, DynamicObject row) {
        if ("bizdate".equals(journalField)) {
            Long orgId = sourceBill.getLong("org.id");
            Date journalDate = sourceBill.getDate("bizdate");
            InitHelper initHelper = new InitHelper(orgId.longValue(), "ar_init");
            Date currentDate = initHelper.getCurrentDate();
            if (currentDate != null && journalDate != null) {
                return journalDate.after(currentDate) ? journalDate : currentDate;
            }
            return journalDate;
        }
        if ("iswrittenoff".equals(journalField)) {
            return Boolean.TRUE;
        }
        if ("sourcejournalid".equals(journalField)) {
            return sourceBill.getLong("id");
        }
        if ("sourcebilltype".equals(journalField)) {
            return "cas_recbill";
        }
        if ("sourcebillid".equals(journalField)) {
            return sourceBill.getLong("sourcebillid");
        }
        if ("sourceentryid".equals(journalField)) {
            return sourceBill.getLong("sourceentryid");
        }
        if ("receivedamt".equals(journalField)) {
            return sourceBill.getBigDecimal("receivedamt").negate();
        }
        if ("localreceivedamt".equals(journalField)) {
            return sourceBill.getBigDecimal("localreceivedamt").negate();
        }
        return super.getValue(journalField, sourceBill, row);
    }

    protected Set<String> getSourceBillSelectors() {
        HashSet<String> selectors = new HashSet<String>();
        selectors.add("bizdate");
        selectors.add("iswrittenoff");
        selectors.add("sourcejournalid");
        selectors.add("sourcebilltype");
        selectors.add("sourcebillid");
        selectors.add("sourceentryid");
        selectors.add("receivedamt");
        selectors.add("localreceivedamt");
        selectors.addAll(this.getSourceBillDefaultSelectors());
        return selectors;
    }
}

