/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.journal.BizDescriptionEnum;
import kd.fi.arapcommon.journal.convert.BasedataBatchReader;
import kd.fi.arapcommon.journal.convert.JournalAutoConverter;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class RecBillPushJournalConverter
extends JournalAutoConverter {
    private BasedataBatchReader basedataReader = new BasedataBatchReader();
    private String dateFieldKey = null;
    private final Map<Long, InitHelper> initHelperMap = new HashMap<Long, InitHelper>(8);

    protected String getJournalType(String sourceEntityKey) {
        return "ar_journal";
    }

    public List<DynamicObject> convert(DynamicObject[] sourceBills) {
        for (DynamicObject sourceBill : sourceBills) {
            if (!this.isPrereceived(sourceBill)) continue;
            String payerType = sourceBill.getString("payertype");
            this.basedataReader.addParam(payerType, (Object)sourceBill.getLong("payer"));
        }
        return super.convert(sourceBills);
    }

    protected List<DynamicObject> convert(DynamicObject recBill) {
        if (this.isPrereceived(recBill)) {
            this.entryKey = "entry";
            DynamicObjectCollection entry = recBill.getDynamicObjectCollection(this.entryKey);
            entry.removeIf(row -> !row.getBoolean("e_receivingtype.ispartreceivable"));
            return super.convert(recBill);
        }
        return new ArrayList<DynamicObject>();
    }

    protected boolean isPrereceived(DynamicObject recBill) {
        return recBill.getBoolean("receivingtype.ispartreceivable");
    }

    protected Object getValue(String journalField, DynamicObject sourceBill, DynamicObject row) {
        DynamicObjectCollection entrys = sourceBill.getDynamicObjectCollection("entry");
        BigDecimal receivableAmt = BigDecimal.ZERO;
        BigDecimal receivableLocAmt = BigDecimal.ZERO;
        long settleOrgId = 0L;
        if (EmptyUtils.isNotEmpty((Object)entrys)) {
            settleOrgId = ((DynamicObject)entrys.get(0)).getLong("e_settleorg.id");
            if (row == null) {
                for (DynamicObject entry : entrys) {
                    receivableAmt = receivableAmt.add(entry.getBigDecimal("e_receivableamt"));
                    receivableLocAmt = receivableLocAmt.add(entry.getBigDecimal("e_receivablelocamt"));
                }
            }
        }
        if ("biztype".equals(journalField)) {
            return sourceBill.getString("biztype");
        }
        if ("org".equals(journalField)) {
            if (row != null) {
                return row.getLong("e_settleorg.id");
            }
            return settleOrgId;
        }
        if ("receivedamt".equals(journalField)) {
            if (row != null) {
                return row.getBigDecimal("e_receivableamt");
            }
            return receivableAmt;
        }
        if ("localreceivedamt".equals(journalField)) {
            if (row != null) {
                return row.getBigDecimal("e_receivablelocamt");
            }
            return receivableLocAmt;
        }
        if ("asstacttype".equals(journalField)) {
            return sourceBill.get("payertype");
        }
        if ("asstact".equals(journalField)) {
            Object payerId;
            String payerType = sourceBill.getString("payertype");
            DynamicObject payer = this.basedataReader.read(payerType, payerId = sourceBill.get("payer"));
            if (payer != null) {
                return payer;
            }
            return payerId;
        }
        if ("bizdate".equals(journalField)) {
            Date currentDate;
            Long orgId = row != null ? Long.valueOf(row.getLong("e_settleorg.id")) : Long.valueOf(sourceBill.getLong("org.id"));
            Date journalDate = this.getJournalDate(sourceBill, row);
            InitHelper initHelper = this.initHelperMap.get(orgId);
            if (initHelper == null) {
                initHelper = new InitHelper(orgId.longValue(), "ar_init");
                this.initHelperMap.put(orgId, initHelper);
            }
            if ((currentDate = initHelper.getCurrentDate()) != null && journalDate != null) {
                return journalDate.compareTo(currentDate) > 0 ? journalDate : currentDate;
            }
            return journalDate;
        }
        if ("bizdescription".equals(journalField)) {
            if (row != null) {
                return "101".equals(row.getString("e_receivingtype.biztype")) ? BizDescriptionEnum.received.name() : BizDescriptionEnum.rec.name();
            }
            return "101".equals(sourceBill.getString("receivingtype.biztype")) ? BizDescriptionEnum.received.name() : BizDescriptionEnum.rec.name();
        }
        return super.getValue(journalField, sourceBill, row);
    }

    private Date getJournalDate(DynamicObject sourceBill, DynamicObject row) {
        long orgId;
        long l = orgId = row != null ? row.getLong("e_settleorg.id") : sourceBill.getLong("org.id");
        if (StringUtils.isEmpty((String)this.dateFieldKey)) {
            Object casParam = SystemParameterHelper.getCasParam((Long)orgId, (String)"cs104");
            this.dateFieldKey = Objects.equals(casParam, "2") ? "payeedate" : "bizdate";
        }
        return sourceBill.getDate(this.dateFieldKey);
    }

    protected Set<String> getSourceBillSelectors() {
        HashSet<String> selectors = new HashSet<String>();
        if (this.entryKey != null) {
            selectors.add("e_actamt");
            selectors.add("e_localamt");
        } else {
            selectors.add("actrecamt");
            selectors.add("localamt");
        }
        selectors.add("e_receivableamt");
        selectors.add("e_receivablelocamt");
        selectors.add("e_settleorg");
        selectors.add("biztype");
        selectors.add("payertype");
        selectors.add("payer");
        selectors.add("bizdate");
        selectors.add("payeedate");
        selectors.add("receivingtype");
        selectors.add("e_receivingtype");
        selectors.addAll(this.getSourceBillDefaultSelectors());
        return selectors;
    }
}

