/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.piaozone;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.business.piaozone.Invoice;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.util.AES128;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class CreateEleAction
extends AbstractAction {
    private static Log logger = LogFactory.getLog(CreateEleAction.class);
    private Invoice invoice;

    public CreateEleAction(String taxRegNum, Invoice invoice) {
        this.taxRegNum = taxRegNum;
        this.invoice = invoice;
    }

    public String execute() {
        String response;
        String domain = KingdeeInvoiceCloudConfig.getDomain();
        String url = null;
        if (!this.invoice.isEleFlag()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7eb8\u8d28\u53d1\u7968\u76f8\u5173\u540e\u7eed\u652f\u6301\uff0c\u656c\u8bf7\u671f\u5f85\u2026\u2026", (String)"CreateEleAction_0", (String)"fi-ar-business", (Object[])new Object[0]));
        }
        url = domain + "/m5/bill/invoice/create?encry_type=GCM&access_token=" + this.token;
        logger.info("\u4e00\u952e\u5f00\u7968\u8bf7\u6c42\u5730\u5740\uff1a" + url);
        DynamicObject clientConfig = KingdeeInvoiceCloudConfig.getClientConfig((String)this.taxRegNum);
        String encrypt_key = clientConfig.getString("encrypt_key");
        logger.info("\u4e00\u952e\u5f00\u7968encrypt_key\uff1a" + encrypt_key);
        String jsonStr = JsonUtils.objToJson((Object)this.invoice);
        logger.info("\u4e00\u952e\u5f00\u7968\u4f20\u5165json\uff1a" + jsonStr);
        String jsonEncrypt = "";
        try {
            jsonEncrypt = AES128.encrypt((String)jsonStr, (String)encrypt_key);
            if (StringUtils.isEmpty((String)jsonEncrypt)) {
                throw new KDBizException(ResManager.loadKDString((String)"Key\u957f\u5ea6\u4e0d\u662f16\u4f4d", (String)"CreateEleAction_1", (String)"fi-ar-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"AES128\u52a0\u5bc6\u62a5\u6587\u51fa\u73b0\u9519\u8bef\u3002", (String)"CreateEleAction_2", (String)"fi-ar-business", (Object[])new Object[0]));
        }
        try {
            response = this.doPost(url, jsonEncrypt);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7535\u5b50\u53d1\u7968\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"CreateEleAction_4", (String)"fi-ar-business", (Object[])new Object[0]));
        }
        return response;
    }

    public String desc() {
        String fmt = ResManager.loadKDString((String)"\u5f00\u5177\u5355\u636e\u5173\u8054\u53d1\u7968\uff1a{SerialNo:%s}", (String)"CreateEleAction_3", (String)"fi-ar-business", (Object[])new Object[0]);
        return String.format(fmt, this.invoice.getSerialNo());
    }
}

