/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.piaozone;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.business.piaozone.Invoice;
import kd.fi.arapcommon.business.piaozone.InvoiceItem;

public class InvoiceConvertUtil {
    public static final BigDecimal ONE = new BigDecimal("1");
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100");

    public static DynamicObject convertModel2Dyn(Invoice invoice) {
        DynamicObject inv = BusinessDataServiceHelper.newDynamicObject((String)"ar_invoice");
        EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)inv.getDataEntityType().getName()).findProperty("entry");
        DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
        List items = invoice.getItems();
        for (InvoiceItem invoiceItem : items) {
            DynamicObject invEntry = new DynamicObject(dt);
            invEntry.set("e_amount", (Object)invoiceItem.getDetailAmount());
            inv.getDynamicObjectCollection("entry").add((Object)invEntry);
        }
        return inv;
    }

    public static Invoice convertDyn2Model(DynamicObject inv) {
        Invoice invoice = new Invoice();
        Object type = inv.get("invoicetype");
        if ("ELE".equals(type)) {
            invoice.setEleFlag(true);
        } else if ("SP".equals(type) || "GE".equals(type)) {
            invoice.setEleFlag(false);
        }
        invoice.setType(inv.getBoolean("redinvoice") ? "1" : "0");
        invoice.setOriginalInvoiceCode(inv.getString("blueinvoicecode"));
        invoice.setOriginalInvoiceNo(inv.getString("blueinvoiceno"));
        invoice.setInventoryFlag(inv.getBoolean("inventoryflag") ? "1" : "0");
        invoice.setInventoryProjectName(ResManager.loadKDString((String)"\uff08\u8be6\u89c1\u9500\u8d27\u6e05\u5355\uff09", (String)"InvoiceConvertUtil_0", (String)"fi-ar-business", (Object[])new Object[0]));
        invoice.setBuyerEmail(inv.getString("email"));
        invoice.setSerialNo(inv.getString("serialno"));
        invoice.setBuyerAccount(inv.getString("buyeracct"));
        invoice.setBuyerAddress(inv.getString("buyeraddr"));
        invoice.setBuyerFixedTelephone(inv.getString("buyertel"));
        invoice.setBuyerName(inv.getDynamicObject("buyer").getLocaleString("name").getLocaleValue());
        invoice.setBuyerTaxNo(inv.getString("buyertin"));
        invoice.setPayee(inv.getString("payer"));
        invoice.setDrawer(inv.getString("drawer"));
        invoice.setReviewer(inv.getString("checker"));
        invoice.setRemark(inv.getString("remark"));
        invoice.setTaxFlag(inv.getBigDecimal("tax").compareTo(BigDecimal.ZERO) == 0 ? "0" : "1");
        invoice.setTotalAmount(InvoiceConvertUtil.getRealValue(inv.getBigDecimal("recamount"), 6));
        invoice.setInvoiceAmount(InvoiceConvertUtil.getRealValue(inv.getBigDecimal("amount"), 6));
        invoice.setTotalTaxAmount(InvoiceConvertUtil.getRealValue(inv.getBigDecimal("tax"), 6));
        DynamicObjectCollection invEntries = inv.getDynamicObjectCollection("entry");
        for (DynamicObject invEntry : invEntries) {
            String vat;
            boolean isRed = inv.getBoolean("redinvoice");
            boolean isPresent = invEntry.getBoolean("e_ispresent");
            if (isRed && isPresent) continue;
            InvoiceItem item = new InvoiceItem();
            if (null != invEntry.getDynamicObject("e_measureunit")) {
                String name = invEntry.getDynamicObject("e_measureunit").getLocaleString("name").getLocaleValue();
                item.setUnit(name);
            }
            item.setSpecModel(invEntry.getString("e_spectype"));
            DynamicObject taxClass = invEntry.getDynamicObject("e_taxclass");
            item.setGoodsCode(taxClass.getString("mergecode"));
            item.setGoodsName(taxClass.getLocaleString("name").getLocaleValue());
            switch (vat = taxClass.getString("vatspecialmanagement").trim()) {
                case "": {
                    item.setZeroTaxRateFlag("");
                    item.setPreferentialPolicy("0");
                    item.setVatException("2");
                    break;
                }
                case "\u514d\u7a0e": {
                    item.setZeroTaxRateFlag("1");
                    item.setPreferentialPolicy("1");
                    item.setVatException("1");
                    break;
                }
                case "\u4e0d\u5f81\u7a0e": {
                    item.setZeroTaxRateFlag("2");
                    item.setPreferentialPolicy("1");
                    item.setVatException("1");
                    break;
                }
                case "\u666e\u901a\u96f6\u7a0e\u7387": {
                    item.setZeroTaxRateFlag("3");
                    item.setPreferentialPolicy("1");
                    item.setVatException("1");
                    break;
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8d39\u7528\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u7684\u589e\u503c\u7a0e\u7279\u6b8a\u7ba1\u7406\u5b57\u6bb5\u53d6\u503c\u9519\u8bef\uff0c\u9519\u8bef\u503c\u4e3a\u201c%s\u201d", (String)"InvoiceConvertUtil_1", (String)"fi-ar-business", (Object[])new Object[]{vat}));
                }
            }
            item.setUnitPrice(InvoiceConvertUtil.getRealValue(invEntry.getBigDecimal("e_taxunitprice"), 6));
            BigDecimal quantity = invEntry.getBigDecimal("e_quantity");
            item.setNum(InvoiceConvertUtil.getRealValue(quantity, 6));
            String mode = invEntry.getString("e_discountmode");
            BigDecimal taxRate = invEntry.getBigDecimal("e_taxrate").divide(ONE_HUNDRED);
            item.setTaxRate(InvoiceConvertUtil.getRealValue(taxRate, 6));
            if ("NULL".equals(mode)) {
                item.setDiscountType("0");
                item.setTaxAmount(InvoiceConvertUtil.getRealValue(invEntry.getBigDecimal("e_tax"), 2));
                item.setDetailAmount(InvoiceConvertUtil.getRealValue(invEntry.getBigDecimal("e_recamount"), 2));
                invoice.addItem(item);
                continue;
            }
            BigDecimal discountAmt = invEntry.getBigDecimal("e_discountamount");
            BigDecimal unitPrice = invEntry.getBigDecimal("e_unitprice");
            BigDecimal unitPriceWithTax = invEntry.getBigDecimal("e_taxunitprice");
            BigDecimal taxAmount = unitPrice.multiply(taxRate).multiply(quantity);
            BigDecimal detailAmount = unitPriceWithTax.multiply(quantity);
            item.setNum(InvoiceConvertUtil.getRealValue(quantity, 6));
            if (isRed) {
                item.setDiscountType("0");
                BigDecimal redDetailAmt = detailAmount.subtract(discountAmt);
                BigDecimal redUnitPriceWithTax = redDetailAmt.divide(quantity, 10, RoundingMode.HALF_UP);
                BigDecimal redTaxAmt = redDetailAmt.divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP).multiply(taxRate);
                item.setDetailAmount(InvoiceConvertUtil.getRealValue(redDetailAmt, 2));
                item.setUnitPrice(InvoiceConvertUtil.getRealValue(redUnitPriceWithTax, 6));
                item.setTaxAmount(InvoiceConvertUtil.getRealValue(redTaxAmt, 2));
                invoice.addItem(item);
                continue;
            }
            item.setDiscountType("2");
            item.setTaxAmount(InvoiceConvertUtil.getRealValue(taxAmount, 2));
            item.setUnitPrice(InvoiceConvertUtil.getRealValue(unitPriceWithTax, 6));
            item.setDetailAmount(InvoiceConvertUtil.getRealValue(detailAmount, 2));
            invoice.addItem(item);
            try {
                InvoiceItem clone = item.clone();
                clone.setNum(InvoiceConvertUtil.getRealValue(quantity.negate(), 6));
                clone.setDiscountType("1");
                BigDecimal discountTaxAmt = discountAmt.divide(ONE.add(taxRate), 2, RoundingMode.HALF_DOWN).multiply(taxRate);
                clone.setTaxAmount(InvoiceConvertUtil.getRealValue(discountTaxAmt.negate(), 2));
                clone.setDetailAmount(InvoiceConvertUtil.getRealValue(discountAmt.negate(), 2));
                clone.setUnitPrice(InvoiceConvertUtil.getRealValue(discountAmt.divide(quantity, 10, RoundingMode.HALF_UP), 6));
                invoice.addItem(clone);
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u514b\u9686\u53d1\u7968\u5206\u5f55\u5931\u8d25\u3002", (String)"InvoiceConvertUtil_2", (String)"fi-ar-business", (Object[])new Object[0]));
            }
        }
        return invoice;
    }

    private static BigDecimal getRealValue(BigDecimal srcVal, int scale) {
        BigDecimal tgtVal = BigDecimal.ZERO;
        if (srcVal.compareTo(tgtVal) == 0) {
            return tgtVal;
        }
        if (scale < 0) {
            return srcVal;
        }
        return srcVal.setScale(scale, RoundingMode.HALF_UP);
    }
}

