/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.baddebtnew;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.service.baddebtnew.AbstractBadDebtBillHandler;
import kd.fi.ar.business.service.baddebtnew.AbstractBadDebtOffsetHandler;
import kd.fi.ar.business.service.baddebtnew.BadDebtContext;
import kd.fi.ar.business.service.baddebtnew.BusArBadDebtBillHandler;
import kd.fi.ar.business.service.baddebtnew.FinArBadDebtBillHandler;
import kd.fi.ar.business.service.baddebtnew.PaidBadDebtBillHandler;
import kd.fi.ar.business.service.baddebtnew.PaymentBadDebtBillHandler;
import kd.fi.ar.business.service.baddebtnew.RecBillOffsetHandler;
import kd.fi.ar.business.service.baddebtnew.ReceivedBillOffsetHandler;
import kd.fi.ar.business.service.baddebtnew.RevcfmBadDebtBillHandler;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.baddebtnew.AccrualResult;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.ar.vo.baddebtnew.BadDebtCalculateVO;
import kd.fi.ar.vo.baddebtnew.BadDebtCommonVO;
import kd.fi.ar.vo.baddebtnew.BadDebtPrepareBillEntryVO;
import kd.fi.ar.vo.baddebtnew.BadDebtPrepareBillVO;
import kd.fi.ar.vo.baddebtnew.OffsetBillSumVO;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.BillFieldMappingVO;
import org.apache.commons.lang.StringUtils;

public class BadDebtAccrualService {
    protected static final Log logger = LogFactory.getLog(BadDebtAccrualService.class);
    protected BadDebtContext context = null;
    protected final String BADDEBT = "ar_baddebtpreparebill";
    protected long orgId;
    protected long periodId;
    protected Map<String, Set<Long>> preparebillIds = new HashMap<String, Set<Long>>(32);
    protected Map<String, Set<Long>> schemePreparebillIds = new HashMap<String, Set<Long>>(32);
    private Set<Long> needMergeSrcBillIds = new HashSet<Long>(16);
    private Map<String, Set<Long>> schemePrepareBillSrcEntryIds = new HashMap<String, Set<Long>>(32);
    private Map<String, Set<Long>> individualPrepareBillSrcEntryIds = new HashMap<String, Set<Long>>(32);
    protected Map<Object, BadDebtCalculateVO> offsetBillVOs = new HashMap<Object, BadDebtCalculateVO>(32);
    protected Map<String, OffsetBillSumVO> offsetBillSumVOs = new HashMap<String, OffsetBillSumVO>(32);
    protected Map<Object, BadDebtCalculateVO> lossBillCalculateVO = new HashMap<Object, BadDebtCalculateVO>(32);
    protected Map<Long, Long> lastBillsSrcAndIdMap = new HashMap<Long, Long>(32);
    protected Map<String, List<Long>> mappingMap = new HashMap<String, List<Long>>(16);
    private Map<Long, Integer> currencyAndPrecision = new HashMap<Long, Integer>(8);

    public BadDebtAccrualService(Long orgId, Long periodId) {
        this.orgId = orgId;
        this.periodId = periodId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccrualResult badDebtAccrual(Long prePeriodId, List<AccrualScheme> accrualSchemeList, boolean isPeriod, Long exrateTableId, Date exrateDate) {
        AccrualResult accrualResult = new AccrualResult();
        accrualResult.setOrgId(Long.valueOf(this.orgId));
        accrualResult.setPeriodId(Long.valueOf(this.periodId));
        if (accrualSchemeList.isEmpty()) {
            accrualResult.setSuccess(false);
            accrualResult.setErrorMsg(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u8ba1\u63d0\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u8ba1\u63d0\u5931\u8d25\u3002", (String)"BadDebtAccrualService_9", (String)"fi-ar-business", (Object[])new Object[0]));
            return accrualResult;
        }
        HashSet<Long> keySet = new HashSet<Long>(8);
        try {
            long mutexKey = "baddebtaccrual".hashCode();
            keySet.add(mutexKey += this.orgId);
            MutexLockHelper.requireMutex((String)"ar_baddebtaccrue", keySet, (String)"baddebtaccrual", (String)ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6b63\u5728\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"BadDebtAccrualService_0", (String)"fi-ar-business", (Object[])new Object[0]));
            String errorMsg = this.validate();
            if (errorMsg != null) {
                accrualResult.setSuccess(false);
                accrualResult.setErrorMsg(errorMsg);
                AccrualResult accrualResult2 = accrualResult;
                return accrualResult2;
            }
            this.deleteDatas(this.orgId, this.periodId);
            LinkedHashMap<String, List<AccrualScheme>> schemeMap = new LinkedHashMap<String, List<AccrualScheme>>(8);
            for (AccrualScheme accrualScheme : accrualSchemeList) {
                String entityKey = accrualScheme.getEntityKey();
                List<AccrualScheme> accrualSchemes = schemeMap.get(entityKey);
                if (accrualSchemes != null) {
                    accrualSchemes.add(accrualScheme);
                    continue;
                }
                accrualSchemes = new ArrayList<AccrualScheme>(1);
                accrualSchemes.add(accrualScheme);
                schemeMap.put(entityKey, accrualSchemes);
            }
            this.addSchemeForAllEntity(schemeMap);
            boolean isSelectOffsetBill = true;
            boolean includePeriod = false;
            for (Map.Entry<String, List<AccrualScheme>> e : schemeMap.entrySet()) {
                List<AccrualScheme> value = e.getValue();
                block22: for (int i = 0; i < value.size(); ++i) {
                    AccrualScheme accrualScheme = value.get(i);
                    if ("2".equals(accrualScheme.getAccrualType()) && accrualScheme.isOffset()) {
                        if (accrualScheme.isIncludePeriod()) {
                            accrualScheme.getOffsetFieldForReceivedBill().add("currency");
                        }
                        accrualScheme.getOffsetFieldForRecBill().add("currency");
                        accrualScheme.getOffsetedField().add("currency");
                    }
                    if (this.context == null) {
                        this.context = new BadDebtContext(this.orgId, this.periodId, prePeriodId, accrualScheme, isPeriod);
                        this.context.setExrateTableId(exrateTableId);
                        this.context.setExrateDate(exrateDate);
                        for (int j = 0; j < accrualSchemeList.size(); ++j) {
                            AccrualScheme scheme = accrualSchemeList.get(j);
                            if (!"2".equals(scheme.getAccrualType()) || !scheme.isOffset()) continue;
                            this.context.getOffsetFieldSelectorForRec().addAll(scheme.getOffsetFieldForRecBill());
                            if (!scheme.isIncludePeriod()) continue;
                            includePeriod = true;
                            this.context.getOffsetFieldSelectorForReceived().addAll(scheme.getOffsetFieldForReceivedBill());
                        }
                        this.context.getOffsetFieldSelectorForRec().add("currency");
                        if (includePeriod) {
                            this.context.getOffsetFieldSelectorForReceived().add("currency");
                        }
                    } else {
                        this.context.setAccrualScheme(value.get(i));
                    }
                    isSelectOffsetBill = this.handleOffsetBill(accrualScheme, isSelectOffsetBill, includePeriod);
                    boolean firstTime = i == 0;
                    boolean groupLastTime = i == value.size() - 1;
                    switch (accrualScheme.getEntityKey()) {
                        case "ar_busbill": {
                            this.accrualBill(new BusArBadDebtBillHandler(this.context), firstTime, groupLastTime);
                            continue block22;
                        }
                        case "ar_finarbill": {
                            this.accrualBill(new FinArBadDebtBillHandler(this.context), firstTime, groupLastTime);
                            continue block22;
                        }
                        case "ap_paidbill": {
                            this.accrualBill(new PaidBadDebtBillHandler(this.context), firstTime, groupLastTime);
                            continue block22;
                        }
                        case "cas_paybill": {
                            this.accrualBill(new PaymentBadDebtBillHandler(this.context), firstTime, groupLastTime);
                            continue block22;
                        }
                        case "ar_revcfmbill": {
                            this.accrualBill(new RevcfmBadDebtBillHandler(this.context), firstTime, groupLastTime);
                        }
                    }
                }
            }
            this.offsetBillVOs.clear();
            this.context = null;
            accrualResult.setSuccess(true);
            AccrualResult accrualResult3 = accrualResult;
            return accrualResult3;
        }
        catch (Exception e) {
            if (e.getStackTrace() != null) {
                logger.error("--------BadDebtAccrualService.error:" + StringUtils.join((Object[])e.getStackTrace(), (String)"\n"));
            }
            accrualResult.setSuccess(false);
            accrualResult.setErrorMsg(e.getMessage());
            AccrualResult accrualResult4 = accrualResult;
            return accrualResult4;
        }
        finally {
            logger.info("--------\u5b9e\u4f53\u540d\uff1aar_baddebtaccrue\uff0c\u91ca\u653e\u4e92\u65a5\u9501--------");
            MutexLockHelper.batchRelease((String)"ar_baddebtaccrue", keySet, (String)"baddebtaccrual");
        }
    }

    private void addSchemeForAllEntity(LinkedHashMap<String, List<AccrualScheme>> schemeMap) {
        ArrayList<String> entities = new ArrayList<String>(8);
        entities.add("ar_busbill");
        entities.add("ar_finarbill");
        entities.add("ap_paidbill");
        entities.add("cas_paybill");
        entities.add("ar_revcfmbill");
        Set noSchemeSet = entities.stream().filter(entity -> schemeMap.get(entity) == null).collect(Collectors.toSet());
        if (!noSchemeSet.isEmpty()) {
            for (String entity2 : noSchemeSet) {
                ArrayList<AccrualScheme> schemeList = new ArrayList<AccrualScheme>(1);
                AccrualScheme scheme = new AccrualScheme();
                scheme.setOffset(false);
                scheme.setEntityKey(entity2);
                scheme.setOnlyByLastPrepareBill(true);
                schemeList.add(scheme);
                schemeMap.put(entity2, schemeList);
            }
        }
    }

    private boolean handleOffsetBill(AccrualScheme accrualScheme, boolean isSelectOffsetBill, boolean includePeriod) {
        boolean isOffset = accrualScheme.isOffset();
        if (isOffset && accrualScheme.getOffsetFieldForRecBill() != null && accrualScheme.getOffsetedField() != null) {
            if (isSelectOffsetBill) {
                if (includePeriod && accrualScheme.getOffsetFieldForReceivedBill() != null) {
                    this.offsetBillVOs.putAll(this.getOffsetBill(new ReceivedBillOffsetHandler(this.context)));
                }
                this.offsetBillVOs.putAll(this.getOffsetBill(new RecBillOffsetHandler(this.context)));
                isSelectOffsetBill = false;
            } else {
                this.updateOffsetField(accrualScheme.isIncludePeriod());
            }
        }
        if (isOffset && !this.offsetBillVOs.isEmpty()) {
            Iterator<Map.Entry<Object, BadDebtCalculateVO>> iterator;
            HashSet<Long> removeOffsetBillEntryIds = new HashSet<Long>(this.offsetBillVOs.size());
            for (Map.Entry<Object, BadDebtCalculateVO> next : this.offsetBillVOs.entrySet()) {
                BadDebtCalculateVO billVO = next.getValue();
                String key = billVO.getOffsetKey();
                if (key == null) continue;
                OffsetBillSumVO sumVO = this.offsetBillSumVOs.get(key);
                BigDecimal balance = billVO.getBalance();
                if (sumVO != null) {
                    BigDecimal tempBalance;
                    BadDebtCalculateVO nextVO;
                    Iterator iterator2;
                    sumVO.setEntityKey(billVO.getBillType());
                    BigDecimal lastSumAmt = sumVO.getSumAmt();
                    sumVO.setSumAmt(lastSumAmt.add(balance));
                    if (balance.compareTo(BigDecimal.ZERO) > 0) {
                        sumVO.getPositiveVO().add(billVO);
                    } else {
                        sumVO.getNegativeVO().add(billVO);
                    }
                    BigDecimal sumAmt = sumVO.getSumAmt();
                    if (lastSumAmt.compareTo(BigDecimal.ZERO) < 0 && balance.compareTo(BigDecimal.ZERO) > 0) {
                        if (sumAmt.compareTo(BigDecimal.ZERO) < 0) {
                            for (BadDebtCalculateVO badDebtCalculateVO : sumVO.getPositiveVO()) {
                                removeOffsetBillEntryIds.add(badDebtCalculateVO.getBillEntryId());
                            }
                            sumVO.getPositiveVO().clear();
                            iterator2 = sumVO.getNegativeVO().iterator();
                            while (iterator2.hasNext()) {
                                nextVO = (BadDebtCalculateVO)iterator2.next();
                                tempBalance = nextVO.getBalance().add(balance);
                                if (tempBalance.compareTo(BigDecimal.ZERO) < 0) {
                                    nextVO.setBalance(tempBalance);
                                    logger.info("BadDebtAccrualService -- balance(offsetBillVOs):%s, balance(sumVOList):%s", (Object)billVO.getBalance(), (Object)nextVO.getBalance());
                                    balance = BigDecimal.ZERO;
                                }
                                if (tempBalance.compareTo(BigDecimal.ZERO) == 0) {
                                    iterator2.remove();
                                    removeOffsetBillEntryIds.add(nextVO.getBillEntryId());
                                    balance = BigDecimal.ZERO;
                                }
                                if (tempBalance.compareTo(BigDecimal.ZERO) > 0) {
                                    iterator2.remove();
                                    removeOffsetBillEntryIds.add(nextVO.getBillEntryId());
                                    balance = tempBalance;
                                }
                                if (balance.compareTo(BigDecimal.ZERO) != 0) continue;
                                break;
                            }
                        }
                        if (sumAmt.compareTo(BigDecimal.ZERO) > 0) {
                            for (BadDebtCalculateVO badDebtCalculateVO : sumVO.getNegativeVO()) {
                                removeOffsetBillEntryIds.add(badDebtCalculateVO.getBillEntryId());
                            }
                            sumVO.getNegativeVO().clear();
                            billVO.setBalance(sumAmt);
                        }
                        if (sumAmt.compareTo(BigDecimal.ZERO) == 0) {
                            for (BadDebtCalculateVO badDebtCalculateVO : sumVO.getPositiveVO()) {
                                removeOffsetBillEntryIds.add(badDebtCalculateVO.getBillEntryId());
                            }
                            sumVO.getPositiveVO().clear();
                            for (BadDebtCalculateVO badDebtCalculateVO : sumVO.getNegativeVO()) {
                                removeOffsetBillEntryIds.add(badDebtCalculateVO.getBillEntryId());
                            }
                            sumVO.getNegativeVO().clear();
                        }
                    }
                    if (lastSumAmt.compareTo(BigDecimal.ZERO) <= 0 || balance.compareTo(BigDecimal.ZERO) >= 0) continue;
                    if (sumAmt.compareTo(BigDecimal.ZERO) < 0) {
                        for (BadDebtCalculateVO badDebtCalculateVO : sumVO.getPositiveVO()) {
                            removeOffsetBillEntryIds.add(badDebtCalculateVO.getBillEntryId());
                        }
                        sumVO.getPositiveVO().clear();
                        billVO.setBalance(sumAmt);
                    }
                    if (sumAmt.compareTo(BigDecimal.ZERO) > 0) {
                        for (BadDebtCalculateVO badDebtCalculateVO : sumVO.getNegativeVO()) {
                            removeOffsetBillEntryIds.add(badDebtCalculateVO.getBillEntryId());
                        }
                        sumVO.getNegativeVO().clear();
                        iterator2 = sumVO.getPositiveVO().iterator();
                        while (iterator2.hasNext()) {
                            nextVO = (BadDebtCalculateVO)iterator2.next();
                            tempBalance = nextVO.getBalance().add(balance);
                            if (tempBalance.compareTo(BigDecimal.ZERO) > 0) {
                                nextVO.setBalance(tempBalance);
                                logger.info("BadDebtAccrualService -- balance(offsetBillVOs):%s, balance(sumVOList):%s", (Object)billVO.getBalance(), (Object)nextVO.getBalance());
                                balance = BigDecimal.ZERO;
                            }
                            if (tempBalance.compareTo(BigDecimal.ZERO) == 0) {
                                iterator2.remove();
                                removeOffsetBillEntryIds.add(nextVO.getBillEntryId());
                                balance = BigDecimal.ZERO;
                            }
                            if (tempBalance.compareTo(BigDecimal.ZERO) < 0) {
                                iterator2.remove();
                                removeOffsetBillEntryIds.add(nextVO.getBillEntryId());
                                balance = tempBalance;
                            }
                            if (balance.compareTo(BigDecimal.ZERO) != 0) continue;
                            break;
                        }
                    }
                    if (sumAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                    for (BadDebtCalculateVO badDebtCalculateVO : sumVO.getPositiveVO()) {
                        removeOffsetBillEntryIds.add(badDebtCalculateVO.getBillEntryId());
                    }
                    sumVO.getPositiveVO().clear();
                    for (BadDebtCalculateVO badDebtCalculateVO : sumVO.getNegativeVO()) {
                        removeOffsetBillEntryIds.add(badDebtCalculateVO.getBillEntryId());
                    }
                    sumVO.getNegativeVO().clear();
                    continue;
                }
                OffsetBillSumVO tempSumVO = new OffsetBillSumVO();
                tempSumVO.setKey(key);
                tempSumVO.setEntityKey(billVO.getBillType());
                tempSumVO.setSumAmt(tempSumVO.getSumAmt().add(balance));
                if (balance.compareTo(BigDecimal.ZERO) > 0) {
                    tempSumVO.getPositiveVO().add(billVO);
                }
                if (balance.compareTo(BigDecimal.ZERO) < 0) {
                    tempSumVO.getNegativeVO().add(billVO);
                }
                if (balance.compareTo(BigDecimal.ZERO) == 0) {
                    removeOffsetBillEntryIds.add(billVO.getBillEntryId());
                    continue;
                }
                this.offsetBillSumVOs.put(key, tempSumVO);
            }
            if (this.offsetBillSumVOs != null && !this.offsetBillSumVOs.isEmpty()) {
                iterator = this.offsetBillSumVOs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, BadDebtCalculateVO> next;
                    next = iterator.next();
                    OffsetBillSumVO value = (OffsetBillSumVO)next.getValue();
                    if (value.getSumAmt().compareTo(BigDecimal.ZERO) > 0) continue;
                    List positiveVO = value.getPositiveVO();
                    if (!positiveVO.isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u62b5\u6d88\u5355\u636e\u6784\u5efa\u5b58\u5728\u95ee\u9898\u3002", (String)"BadDebtAccrualService_1", (String)"fi-ar-business", (Object[])new Object[0]));
                    }
                    iterator.remove();
                }
            }
            if (EmptyUtils.isNotEmpty(removeOffsetBillEntryIds)) {
                iterator = this.offsetBillVOs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, BadDebtCalculateVO> voMap = iterator.next();
                    BadDebtCalculateVO vo = voMap.getValue();
                    Long entryId = vo.getBillEntryId();
                    if (!removeOffsetBillEntryIds.remove(entryId)) continue;
                    iterator.remove();
                }
            }
        }
        return isSelectOffsetBill;
    }

    private void updateOffsetField(boolean includePeriod) {
        for (BadDebtCalculateVO badDebtCalculateVO : this.offsetBillVOs.values()) {
            String key;
            HashMap allOffsetFieldMap = badDebtCalculateVO.getAllOffsetFieldMap();
            if (allOffsetFieldMap == null) {
                return;
            }
            AccrualScheme accrualScheme = this.context.getAccrualScheme();
            List offsetVoList = accrualScheme.getOffsetVoList();
            HashMap<String, Boolean> nullMatch = new HashMap<String, Boolean>(8);
            String entityType = badDebtCalculateVO.getBillType();
            DateTimeFormatter dateToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            StringBuilder offsetKey = new StringBuilder();
            ArrayList offsetFields = new ArrayList(8);
            if ("cas_recbill".equals(entityType)) {
                offsetFields = accrualScheme.getOffsetFieldForRecBill();
                for (AccrualOffsetVo offsetVo : offsetVoList) {
                    nullMatch.put(offsetVo.getRecbillfield(), offsetVo.isNullmatch());
                }
            }
            if (includePeriod && "ar_receivedbill".equals(entityType)) {
                offsetFields = accrualScheme.getOffsetFieldForReceivedBill();
                for (AccrualOffsetVo offsetVo : offsetVoList) {
                    nullMatch.put(offsetVo.getReceivedfield(), offsetVo.isNullmatch());
                }
            }
            for (String field : offsetFields) {
                Object dimensionValue = allOffsetFieldMap.get(field);
                if (dimensionValue != null) {
                    if (dimensionValue instanceof BigDecimal) {
                        offsetKey.append(((BigDecimal)dimensionValue).stripTrailingZeros().toPlainString());
                        continue;
                    }
                    if (dimensionValue instanceof Date) {
                        LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)dimensionValue).toInstant(), ZoneId.systemDefault());
                        offsetKey.append(localDateTime.format(dateToStringFormatter));
                        continue;
                    }
                    offsetKey.append(dimensionValue);
                    continue;
                }
                if (((Boolean)nullMatch.get(field)).booleanValue()) {
                    offsetKey.append("NULL");
                    continue;
                }
                offsetKey = new StringBuilder();
                break;
            }
            if ("".equals(key = offsetKey.toString())) continue;
            badDebtCalculateVO.setOffsetKey(offsetKey.toString());
        }
    }

    private void deleteDatas(Long orgId, Long periodId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter periodFilter = new QFilter("period", "=", (Object)periodId);
        List badDebtBillProvisionIds = QueryServiceHelper.queryPrimaryKeys((String)"ar_baddebtpreparebill", (QFilter[])new QFilter[]{orgFilter, periodFilter}, (String)"", (int)-1);
        if (badDebtBillProvisionIds.size() < 1) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ar_baddebtpreparebill", (Object[])badDebtBillProvisionIds.toArray(), (OperateOption)option);
        logger.info("----- \u5220\u9664\u574f\u8d26\u51c6\u5907\u5355\uff1a\u7ec4\u7ec7\uff1a%s\uff0c\u671f\u95f4\uff1a%s ------ ", (Object)orgId, (Object)periodId);
        if (!deleteResult.isSuccess()) {
            logger.info("------badDebtProvisionBill:operationResult.Message------" + deleteResult.getMessage());
            OperationHelper.assertResult((OperationResult)deleteResult);
        }
    }

    private Map<Object, BadDebtCalculateVO> getOffsetBill(AbstractBadDebtOffsetHandler billHandler) {
        Map<Object, BadDebtCalculateVO> billVOs = new HashMap<Object, BadDebtCalculateVO>(32);
        Map<Object, BadDebtCalculateVO> processBills = billHandler.getProcessBills();
        List<BadDebtCommonVO> billIds = billHandler.getBillIds();
        if (billIds.isEmpty()) {
            return new HashMap<Object, BadDebtCalculateVO>(8);
        }
        for (int i = 0; i < billIds.size(); i += this.context.getBillCount()) {
            boolean lastTime = i + this.context.getBillCount() > billIds.size();
            List<BadDebtCommonVO> subBillIds = billIds.subList(i, lastTime ? billIds.size() : i + this.context.getBillCount());
            billVOs = billHandler.getBills(subBillIds);
            this.correctAllBillVO(billVOs, processBills);
            for (Map.Entry<Object, BadDebtCalculateVO> badDebtVOEntry : billVOs.entrySet()) {
                BadDebtCalculateVO badDebtVO = badDebtVOEntry.getValue();
                badDebtVO.setRecamount(badDebtVO.getBalance());
            }
        }
        Iterator iterator = billVOs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            BadDebtCalculateVO value = (BadDebtCalculateVO)next.getValue();
            if (value.getBalance().compareTo(BigDecimal.ZERO) != 0) continue;
            iterator.remove();
        }
        return billVOs;
    }

    /*
     * WARNING - void declaration
     */
    private void accrualBill(AbstractBadDebtBillHandler billHandler, boolean firstTime, boolean groupLastTime) {
        void var18_23;
        String entityKey = billHandler.getEntityKey();
        AccrualScheme accrualScheme = this.context.getAccrualScheme();
        Set<Long> preparebillIdSet = this.preparebillIds.get(entityKey);
        Set<Long> schemePreparebillEntryIdSet = this.schemePrepareBillSrcEntryIds.get(entityKey);
        Set<Long> individualPrepareBillSrcEntryIdSet = this.individualPrepareBillSrcEntryIds.get(entityKey);
        HashMap<Object, BadDebtCalculateVO> processBills = new HashMap(8);
        if (!accrualScheme.isOnlyByLastPrepareBill()) {
            processBills = billHandler.getProcessBills();
        }
        if (firstTime) {
            if ("ar_finarbill".equals(entityKey)) {
                this.lossBillCalculateVO = billHandler.getBadDebtLossBill();
            }
            this.lastBillsSrcAndIdMap = billHandler.getLastBadDebtPrepareBillIds();
        }
        boolean isIndividualAccrual = "1".equals(accrualScheme.getAccrualType());
        boolean isPlanAccrual = "2".equals(accrualScheme.getAccrualType());
        Set<Object> existIdSet = new HashSet(8);
        HashSet<Long> existEntryIdSet = new HashSet<Long>(8);
        if (isPlanAccrual) {
            existIdSet = preparebillIdSet;
        } else if (isIndividualAccrual) {
            if (individualPrepareBillSrcEntryIdSet != null) {
                existEntryIdSet.addAll(individualPrepareBillSrcEntryIdSet);
            }
        } else {
            if (preparebillIdSet != null) {
                existIdSet.addAll(preparebillIdSet);
            }
            if (schemePreparebillEntryIdSet != null) {
                existEntryIdSet.addAll(schemePreparebillEntryIdSet);
            }
        }
        List<Object> billIds = new ArrayList(8);
        if (!accrualScheme.isOnlyByLastPrepareBill()) {
            billIds = billHandler.getBillIds(existIdSet, existEntryIdSet);
        }
        HashSet entryIdCollect = new HashSet(8);
        HashSet<Long> billIdCollect = new HashSet<Long>(8);
        for (BadDebtCommonVO badDebtCommonVO : billIds) {
            billIdCollect.add(badDebtCommonVO.getId());
            entryIdCollect.addAll(badDebtCommonVO.getEntryIds());
        }
        for (Long l : entryIdCollect) {
            if (schemePreparebillEntryIdSet == null || !schemePreparebillEntryIdSet.contains(l)) continue;
            logger.info(String.format("----- \u91cd\u590d\u5355\u636eentryid\uff1a%s;\u5355\u636e\u6807\u8bc6\uff1a%s;\u65b9\u6848id\uff1a%s\u3002", l, entityKey, accrualScheme.getAccrualSchemeId()));
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u7ec4\u8ba1\u63d0\u4e2d\u5b58\u5728\u4e00\u7b14\u4e1a\u52a1\u88ab\u591a\u4e2a\u65b9\u6848\u591a\u6b21\u8ba1\u63d0\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\u8ba1\u63d0\u65b9\u6848\u5e76\u4fee\u6539\u6240\u9009\u65b9\u6848\u540e\u91cd\u65b0\u8fdb\u884c\u8ba1\u63d0\u3002", (String)"BadDebtAccrualService_8", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        int billCount = this.context.getBillCount();
        boolean bl = false;
        while (var18_23 < billIds.size()) {
            boolean lastTime = var18_23 + billCount > billIds.size();
            List<Object> subBillIds = billIds.subList((int)var18_23, lastTime ? billIds.size() : var18_23 + billCount);
            LinkedHashMap<Object, BadDebtCalculateVO> bills = billHandler.getBills(subBillIds);
            Map<Object, BadDebtPrepareBillEntryVO> lastBadDebtPrepareBill = billHandler.getLastBadDebtPrepareBill(this.lastBillsSrcAndIdMap, subBillIds, false, this.mappingMap);
            this.batchAccrual(bills, processBills, lastBadDebtPrepareBill, this.mappingMap, this.lossBillCalculateVO);
            var18_23 += billCount;
        }
        if (isPlanAccrual) {
            if (schemePreparebillEntryIdSet != null) {
                schemePreparebillEntryIdSet.addAll(entryIdCollect);
            } else {
                this.schemePrepareBillSrcEntryIds.put(entityKey, entryIdCollect);
            }
        } else {
            if (preparebillIdSet != null) {
                preparebillIdSet.addAll(billIdCollect);
            } else {
                this.preparebillIds.put(entityKey, billIdCollect);
            }
            if (isIndividualAccrual) {
                if (individualPrepareBillSrcEntryIdSet != null) {
                    individualPrepareBillSrcEntryIdSet.addAll(entryIdCollect);
                } else {
                    this.individualPrepareBillSrcEntryIds.put(entityKey, entryIdCollect);
                }
            }
        }
        if (groupLastTime) {
            Iterator<Map.Entry<Long, Long>> iterator = this.lastBillsSrcAndIdMap.entrySet().iterator();
            int i = 0;
            int maxSize = this.lastBillsSrcAndIdMap.size();
            HashMap<Long, Long> subBillIdMap = new HashMap<Long, Long>(8);
            while (iterator.hasNext()) {
                Map.Entry<Long, Long> nextEntry = iterator.next();
                subBillIdMap.put(nextEntry.getKey(), nextEntry.getValue());
                if (++i != billCount && --maxSize != 0) continue;
                Map<Object, BadDebtPrepareBillEntryVO> lastBadDebtPrepareBill = billHandler.getLastBadDebtPrepareBill(subBillIdMap, new ArrayList<BadDebtCommonVO>(8), true, this.mappingMap);
                HashMap<Object, BadDebtPrepareBillVO> badDebtPrepareBillVOMap = new HashMap<Object, BadDebtPrepareBillVO>(8);
                this.writeOffLastBadDebtBill(badDebtPrepareBillVOMap, lastBadDebtPrepareBill, this.lossBillCalculateVO);
                ArrayList<BadDebtPrepareBillVO> badDebtVOs = new ArrayList<BadDebtPrepareBillVO>(badDebtPrepareBillVOMap.values());
                List<DynamicObject> badDebtBills = this.convertVOList(badDebtVOs);
                if (!badDebtBills.isEmpty()) {
                    this.saveBadDebtPrepareBills(badDebtBills);
                }
                subBillIdMap.clear();
                i = 0;
            }
            this.mappingMap.clear();
        }
        this.offsetBillSumVOs.clear();
        if (groupLastTime) {
            this.lossBillCalculateVO.clear();
            this.lastBillsSrcAndIdMap.clear();
            this.preparebillIds.clear();
            this.schemePrepareBillSrcEntryIds.clear();
            this.individualPrepareBillSrcEntryIds.clear();
            this.handlerEntryMerge(this.needMergeSrcBillIds, entityKey, billHandler);
            this.schemePreparebillIds.clear();
            this.needMergeSrcBillIds.clear();
            if ("ar_finarbill".equals(entityKey)) {
                this.handleEasBill(billHandler);
            }
        }
    }

    private void batchAccrual(LinkedHashMap<Object, BadDebtCalculateVO> bills, Map<Object, BadDebtCalculateVO> processBills, Map<Object, BadDebtPrepareBillEntryVO> lastBadDebtPrepareBill, Map<String, List<Long>> mappingMap, Map<Object, BadDebtCalculateVO> lossBillCalculateVO) {
        this.correctAllBillVO(bills, processBills);
        HashMap<Object, BadDebtPrepareBillVO> badDebtPrepareBillVOMap = new HashMap<Object, BadDebtPrepareBillVO>(bills.size());
        AccrualScheme accrualScheme = this.context.getAccrualScheme();
        for (Map.Entry<Object, BadDebtCalculateVO> bill : bills.entrySet()) {
            BadDebtCalculateVO lossBillVO;
            Object entryId = bill.getKey();
            BadDebtCalculateVO calculateVO = bill.getValue();
            String offsetKey = calculateVO.getOffsetKey();
            OffsetBillSumVO offsetBillSumVO = this.offsetBillSumVOs.get(offsetKey);
            BigDecimal balance = calculateVO.getBalance();
            BigDecimal offsetAmt = null;
            if (offsetBillSumVO != null && accrualScheme.isOffset() && balance.compareTo(BigDecimal.ZERO) > 0) {
                offsetAmt = offsetBillSumVO.getSumAmt();
                BigDecimal balanceTemp = offsetAmt.subtract(balance);
                if (balanceTemp.compareTo(BigDecimal.ZERO) == 0) {
                    for (BadDebtCalculateVO badDebtCalculateVO : offsetBillSumVO.getPositiveVO()) {
                        badDebtCalculateVO.setBalance(BigDecimal.ZERO);
                    }
                    this.offsetBillSumVOs.remove(offsetKey);
                    offsetAmt = balanceTemp;
                } else if (balanceTemp.compareTo(BigDecimal.ZERO) < 0) {
                    for (BadDebtCalculateVO badDebtCalculateVO : offsetBillSumVO.getPositiveVO()) {
                        badDebtCalculateVO.setBalance(BigDecimal.ZERO);
                    }
                    this.offsetBillSumVOs.remove(offsetKey);
                } else {
                    offsetAmt = balance;
                    offsetBillSumVO.setSumAmt(balanceTemp);
                    for (BadDebtCalculateVO badDebtCalculateVO : offsetBillSumVO.getPositiveVO()) {
                        BigDecimal offsetVOBalance = badDebtCalculateVO.getBalance();
                        if (balanceTemp.compareTo(BigDecimal.ZERO) == 0) {
                            badDebtCalculateVO.setBalance(BigDecimal.ZERO);
                        }
                        if (balanceTemp.compareTo(offsetVOBalance) >= 0) {
                            balanceTemp = balanceTemp.subtract(offsetVOBalance);
                        }
                        if (balanceTemp.compareTo(offsetVOBalance) >= 0) continue;
                        badDebtCalculateVO.setBalance(balanceTemp);
                        balanceTemp = BigDecimal.ZERO;
                    }
                }
            }
            BadDebtPrepareBillVO badDebtPrepareBillVO = this.buildBadDebtPrepareBillVO(calculateVO);
            BadDebtPrepareBillEntryVO badDebtPrepareBillEntryVO = this.buildBadDebtPrepareBillEntryVO(badDebtPrepareBillVO, calculateVO);
            if (offsetAmt != null) {
                badDebtPrepareBillVO.setOffset(true);
                badDebtPrepareBillEntryVO.setOffsetAmt(offsetAmt);
                if ("0".equals(badDebtPrepareBillVO.getQuotation())) {
                    badDebtPrepareBillEntryVO.setOffsetAmtLocal(offsetAmt.multiply(calculateVO.getExchangeRate()).setScale(this.context.getPrecision(), 4));
                } else {
                    badDebtPrepareBillEntryVO.setOffsetAmtLocal(offsetAmt.divide(calculateVO.getExchangeRate(), this.context.getPrecision(), 4));
                }
            } else {
                badDebtPrepareBillVO.setOffset(false);
            }
            BadDebtPrepareBillEntryVO lastBadDebtVO = lastBadDebtPrepareBill.get(entryId);
            if (lastBadDebtVO != null) {
                badDebtPrepareBillEntryVO.setLastAccruedAmt(lastBadDebtVO.getCurAccruedAmt());
                badDebtPrepareBillEntryVO.setLastAccruedAmtLocal(lastBadDebtVO.getCurAccruedAmtLocal());
                lastBadDebtPrepareBill.remove(entryId);
            }
            if (lossBillCalculateVO != null && "ar_finarbill".equals(calculateVO.getBillType()) && (lossBillVO = lossBillCalculateVO.get(entryId)) != null) {
                badDebtPrepareBillEntryVO.setLossAmt(lossBillVO.getBalance());
                badDebtPrepareBillEntryVO.setLossAmtLocal(lossBillVO.getLocalBalance());
            }
            this.calculateAccruedAmt(badDebtPrepareBillEntryVO);
            this.calculateAccrualAmt(badDebtPrepareBillEntryVO);
            this.sumBadDebtPrepareBillEntry(badDebtPrepareBillVO, badDebtPrepareBillEntryVO);
            badDebtPrepareBillVO.getEntries().add(badDebtPrepareBillEntryVO);
            this.mergeSameBadDebtPrepareBill(badDebtPrepareBillVOMap, badDebtPrepareBillVO, false);
        }
        this.handleExtendEntry(badDebtPrepareBillVOMap, mappingMap, lastBadDebtPrepareBill);
        ArrayList<BadDebtPrepareBillVO> badDebtVOs = new ArrayList<BadDebtPrepareBillVO>(badDebtPrepareBillVOMap.values());
        List<DynamicObject> badDebtBills = this.convertVOList(badDebtVOs);
        if (!badDebtBills.isEmpty()) {
            this.collectRepeatSrcBillIds(badDebtBills);
            this.saveBadDebtPrepareBills(badDebtBills);
        }
    }

    private void correctAllBillVO(Map<Object, BadDebtCalculateVO> bills, Map<Object, BadDebtCalculateVO> processBills) {
        for (Map.Entry<Object, BadDebtCalculateVO> processBill : processBills.entrySet()) {
            Object entryId = processBill.getKey();
            BadDebtCalculateVO processVO = processBill.getValue();
            BadDebtCalculateVO billVO = bills.get(entryId);
            if (billVO == null) continue;
            String billType = processVO.getBillType();
            if (billType.contains("settle") || billType.contains("verify")) {
                billVO.setBalance(billVO.getBalance().add(processVO.getBalance()));
                billVO.setLocalBalance(billVO.getLocalBalance().add(processVO.getLocalBalance()));
            } else {
                billVO.setBalance(billVO.getBalance().subtract(processVO.getBalance()));
                billVO.setLocalBalance(billVO.getLocalBalance().subtract(processVO.getLocalBalance()));
            }
            if (!"ap_paidbill".equals(billVO.getBillType()) && !"ar_receivedbill".equals(billVO.getBillType())) continue;
            if ("0".equals(billVO.getQuotation())) {
                billVO.setLocalBalance(billVO.getBalance().multiply(billVO.getExchangeRate()).setScale(this.context.getPrecision(), 4));
                continue;
            }
            billVO.setLocalBalance(billVO.getBalance().divide(billVO.getExchangeRate(), this.context.getPrecision(), 4));
        }
    }

    private BadDebtPrepareBillVO buildBadDebtPrepareBillVO(BadDebtCalculateVO calculateVO) {
        AccrualScheme accrualScheme = this.context.getAccrualScheme();
        BadDebtPrepareBillVO badDebtPrepareBillVO = new BadDebtPrepareBillVO();
        badDebtPrepareBillVO.setOrgId(this.context.getOrgId().longValue());
        badDebtPrepareBillVO.setAsstactType(calculateVO.getAsstactType());
        badDebtPrepareBillVO.setAsstactId(calculateVO.getAsstactId());
        badDebtPrepareBillVO.setBillNo(calculateVO.getBillNo());
        badDebtPrepareBillVO.setAccrualDate(DateUtils.getDataFormat((Date)new Date(), (boolean)true));
        badDebtPrepareBillVO.setPeriodId(this.context.getPeriodId().longValue());
        badDebtPrepareBillVO.setAccrualObj(this.context.getAccrualScheme().getAccrualObjId().longValue());
        badDebtPrepareBillVO.setRemark(calculateVO.getRemark());
        badDebtPrepareBillVO.setCurrencyId(calculateVO.getCurrencyId());
        badDebtPrepareBillVO.setExrateTableId(this.context.getExrateTableId().longValue());
        badDebtPrepareBillVO.setExrateDate(this.context.getExrateDate());
        badDebtPrepareBillVO.setQuotation(this.getQuotation(badDebtPrepareBillVO.getBillNo(), badDebtPrepareBillVO.getExrateTableId(), badDebtPrepareBillVO.getCurrencyId()));
        badDebtPrepareBillVO.setExchangeRate(this.getCurExchangeRate(badDebtPrepareBillVO.getBillNo(), badDebtPrepareBillVO.getExrateTableId(), badDebtPrepareBillVO.getCurrencyId(), badDebtPrepareBillVO.getQuotation()));
        badDebtPrepareBillVO.setSourceBillDate(calculateVO.getBizDate());
        badDebtPrepareBillVO.setSourceBillType(calculateVO.getBillType());
        badDebtPrepareBillVO.setSourceBillId(String.valueOf(calculateVO.getBillId()));
        String accrualType = accrualScheme.getAccrualType();
        if ("1".equals(accrualType)) {
            badDebtPrepareBillVO.setAccrualMethod("individual");
            badDebtPrepareBillVO.setAccrualPercent(accrualScheme.getAccrualPercentForIndividual());
            badDebtPrepareBillVO.setIndividualReason(accrualScheme.getIndividualReason());
            logger.info("-- \u4e2a\u522b\u8ba4\u5b9a\u8ba1\u63d0\u6bd4\u4f8b\uff1a" + accrualScheme.getAccrualPercentForIndividual());
        } else if ("2".equals(accrualType)) {
            badDebtPrepareBillVO.setAccrualScheme(accrualScheme.getAccrualSchemeId().longValue());
            badDebtPrepareBillVO.setAccrualMethod("aging");
            badDebtPrepareBillVO.setAccrualFrequency(accrualScheme.getAccrualFrequency());
            int days = DateUtils.getDiffDaysIgnoreTime((Date)calculateVO.getBizDate(), (Date)this.context.getEndDate());
            badDebtPrepareBillVO.setAgingRange(this.getAgingRange(accrualScheme.getAgingRange(), days));
            badDebtPrepareBillVO.setAccrualPercent(this.getAccrualPercent(accrualScheme.getAccrualPercentForScheme(), days));
        } else {
            badDebtPrepareBillVO.setAccrualMethod("expect");
            int days = DateUtils.getDiffDaysIgnoreTime((Date)calculateVO.getBizDate(), (Date)this.context.getEndDate());
            badDebtPrepareBillVO.setAgingRange(this.getAgingRange(accrualScheme.getAgingRange(), days));
            badDebtPrepareBillVO.setAccrualPercent(this.getAccrualPercent(accrualScheme.getAccrualPercentForScheme(), days));
        }
        badDebtPrepareBillVO.setBillMap(calculateVO.getBillMap());
        return badDebtPrepareBillVO;
    }

    private String getAgingRange(Map<Integer, String> agingRange, int days) {
        Set<Integer> rangeSet = agingRange.keySet();
        int target = Integer.MAX_VALUE;
        for (int range : rangeSet) {
            if (range < days || range >= target) continue;
            target = range;
        }
        logger.info("-- \u8ba1\u63d0\u533a\u95f4\uff1a" + agingRange.get(target));
        return agingRange.get(target);
    }

    private BigDecimal getAccrualPercent(Map<Integer, BigDecimal> accrualPercentForScheme, int days) {
        Set<Integer> rangeSet = accrualPercentForScheme.keySet();
        int target = Integer.MAX_VALUE;
        for (int range : rangeSet) {
            if (range < days || range >= target) continue;
            target = range;
        }
        logger.info("-- \u8ba1\u63d0\u65b9\u6848\u8ba1\u63d0\u6bd4\u4f8b\uff1a" + accrualPercentForScheme.get(target));
        return accrualPercentForScheme.get(target) == null ? BigDecimal.ZERO : accrualPercentForScheme.get(target);
    }

    private BadDebtPrepareBillEntryVO buildBadDebtPrepareBillEntryVO(BadDebtPrepareBillVO badDebtPrepareBillVO, BadDebtCalculateVO calculateVO) {
        BadDebtPrepareBillEntryVO badDebtPrepareBillEntryVO = new BadDebtPrepareBillEntryVO();
        badDebtPrepareBillEntryVO.setMaterialId(calculateVO.getMaterialId());
        badDebtPrepareBillEntryVO.setExpenseItemId(calculateVO.getExpenseItemId());
        badDebtPrepareBillEntryVO.setSrcBillId(calculateVO.getBillId());
        badDebtPrepareBillEntryVO.setSrcEntryId(calculateVO.getBillEntryId());
        badDebtPrepareBillEntryVO.setRecAmount(calculateVO.getRecamount());
        badDebtPrepareBillEntryVO.setRecLocalAmt(calculateVO.getRecamountlocal());
        badDebtPrepareBillEntryVO.setStandardAmt(calculateVO.getBalance());
        badDebtPrepareBillEntryVO.setStandardAmtLocal(calculateVO.getLocalBalance());
        badDebtPrepareBillEntryVO.setAccrualPercent(badDebtPrepareBillVO.getAccrualPercent());
        badDebtPrepareBillEntryVO.setExchangeRate(badDebtPrepareBillVO.getExchangeRate());
        badDebtPrepareBillEntryVO.setQuotation(badDebtPrepareBillVO.getQuotation());
        badDebtPrepareBillEntryVO.setAgingRange(badDebtPrepareBillVO.getAgingRange());
        badDebtPrepareBillEntryVO.setCurrencyId(badDebtPrepareBillVO.getCurrencyId());
        badDebtPrepareBillEntryVO.setEntryMap(calculateVO.getEntryMap());
        return badDebtPrepareBillEntryVO;
    }

    private void calculateAccruedAmt(BadDebtPrepareBillEntryVO badDebtPrepareBillEntryVO) {
        BigDecimal standardAmt = badDebtPrepareBillEntryVO.getStandardAmt();
        BigDecimal offsetAmt = badDebtPrepareBillEntryVO.getOffsetAmt();
        BigDecimal accrualPercent = badDebtPrepareBillEntryVO.getAccrualPercent();
        int precision = this.getCurrencyPrecision(badDebtPrepareBillEntryVO);
        badDebtPrepareBillEntryVO.setCurAccruedAmt(standardAmt.subtract(offsetAmt).multiply(accrualPercent.divide(new BigDecimal(100))).setScale(precision, 4));
        if ("0".equals(badDebtPrepareBillEntryVO.getQuotation())) {
            badDebtPrepareBillEntryVO.setCurAccruedAmtLocal(badDebtPrepareBillEntryVO.getCurAccruedAmt().multiply(badDebtPrepareBillEntryVO.getExchangeRate()).setScale(this.context.getPrecision(), 4));
        } else {
            badDebtPrepareBillEntryVO.setCurAccruedAmtLocal(badDebtPrepareBillEntryVO.getCurAccruedAmt().divide(badDebtPrepareBillEntryVO.getExchangeRate(), this.context.getPrecision(), 4));
        }
    }

    private void calculateAccrualAmt(BadDebtPrepareBillEntryVO badDebtPrepareBillEntryVO) {
        BigDecimal curAccruedAmt = badDebtPrepareBillEntryVO.getCurAccruedAmt();
        BigDecimal lastAccruedAmt = badDebtPrepareBillEntryVO.getLastAccruedAmt();
        BigDecimal lossAmt = badDebtPrepareBillEntryVO.getLossAmt();
        badDebtPrepareBillEntryVO.setCurAccrualAmt(curAccruedAmt.subtract(lastAccruedAmt).add(lossAmt));
        if ("0".equals(badDebtPrepareBillEntryVO.getQuotation())) {
            badDebtPrepareBillEntryVO.setCurAccrualAmtLocal(badDebtPrepareBillEntryVO.getCurAccrualAmt().multiply(badDebtPrepareBillEntryVO.getExchangeRate()).setScale(this.context.getPrecision(), 4));
        } else {
            badDebtPrepareBillEntryVO.setCurAccrualAmtLocal(badDebtPrepareBillEntryVO.getCurAccrualAmt().divide(badDebtPrepareBillEntryVO.getExchangeRate(), this.context.getPrecision(), 4));
        }
    }

    private void sumBadDebtPrepareBillEntry(BadDebtPrepareBillVO billVO, BadDebtPrepareBillEntryVO billEntryVO) {
        billVO.setRecAmount(billVO.getRecAmount().add(billEntryVO.getRecAmount()));
        billVO.setRecLocalAmt(billVO.getRecLocalAmt().add(billEntryVO.getRecLocalAmt()));
        billVO.setStandardAmt(billVO.getStandardAmt().add(billEntryVO.getStandardAmt()));
        billVO.setStandardAmtLocal(billVO.getStandardAmtLocal().add(billEntryVO.getStandardAmtLocal()));
        billVO.setOffsetAmt(billVO.getOffsetAmt().add(billEntryVO.getOffsetAmt()));
        billVO.setOffsetAmtLocal(billVO.getOffsetAmtLocal().add(billEntryVO.getOffsetAmtLocal()));
        billVO.setCurAccruedAmt(billVO.getCurAccruedAmt().add(billEntryVO.getCurAccruedAmt()));
        billVO.setCurAccruedAmtLocal(billVO.getCurAccruedAmtLocal().add(billEntryVO.getCurAccruedAmtLocal()));
        billVO.setLastAccruedAmt(billVO.getLastAccruedAmt().add(billEntryVO.getLastAccruedAmt()));
        billVO.setLastAccruedAmtLocal(billVO.getLastAccruedAmtLocal().add(billEntryVO.getLastAccruedAmtLocal()));
        billVO.setLossAmt(billVO.getLossAmt().add(billEntryVO.getLossAmt()));
        billVO.setLossAmtLocal(billVO.getLossAmtLocal().add(billEntryVO.getLossAmtLocal()));
        billVO.setCurAccrualAmt(billVO.getCurAccrualAmt().add(billEntryVO.getCurAccrualAmt()));
        billVO.setCurAccrualAmtLocal(billVO.getCurAccrualAmtLocal().add(billEntryVO.getCurAccrualAmtLocal()));
    }

    private void mergeSameBadDebtPrepareBill(Map<Object, BadDebtPrepareBillVO> badDebtPrepareBillVOMap, BadDebtPrepareBillVO newBillVO, boolean isLastBill) {
        BadDebtPrepareBillVO vo = badDebtPrepareBillVOMap.get(newBillVO.getSourceBillId());
        if (vo != null) {
            BadDebtPrepareBillEntryVO newBillEntryVO = (BadDebtPrepareBillEntryVO)newBillVO.getEntries().get(0);
            if (isLastBill && this.context.isHandleHistoryDataForPlans() && "ar_finarbill".equals(this.context.getAccrualScheme().getEntityKey())) {
                newBillEntryVO.setRecAmount(BigDecimal.ZERO);
                newBillEntryVO.setRecLocalAmt(BigDecimal.ZERO);
            }
            vo.getEntries().add(newBillEntryVO);
            this.sumBadDebtPrepareBillEntry(vo, newBillEntryVO);
        } else {
            badDebtPrepareBillVOMap.put(newBillVO.getSourceBillId(), newBillVO);
        }
    }

    private void handleExtendEntry(Map<Object, BadDebtPrepareBillVO> badDebtPrepareBillVOMap, Map<String, List<Long>> mappingMap, Map<Object, BadDebtPrepareBillEntryVO> lastBadDebtPrepareBillMap) {
        for (Map.Entry<Object, BadDebtPrepareBillVO> BadDebtPrepareBillVOEntry : badDebtPrepareBillVOMap.entrySet()) {
            BadDebtPrepareBillVO badDebtPrepareBillVO = BadDebtPrepareBillVOEntry.getValue();
            String sourceBillId = badDebtPrepareBillVO.getSourceBillId();
            List<Long> entryIds = mappingMap.get(sourceBillId);
            if (!EmptyUtils.isNotEmpty(entryIds)) continue;
            for (Long entryId : entryIds) {
                BadDebtPrepareBillEntryVO badDebtPrepareBillEntryVO = lastBadDebtPrepareBillMap.get(entryId);
                if (!EmptyUtils.isNotEmpty((Object)badDebtPrepareBillEntryVO)) continue;
                BadDebtPrepareBillVO billVO = this.writeOffBadDebtBill(badDebtPrepareBillEntryVO);
                this.mergeSameBadDebtPrepareBill(badDebtPrepareBillVOMap, billVO, true);
                lastBadDebtPrepareBillMap.remove(entryId);
            }
        }
    }

    private BadDebtPrepareBillVO writeOffBadDebtBill(BadDebtPrepareBillEntryVO lastBadDebtPrepareBillEntryVO) {
        return this.writeOffBadDebtBill(lastBadDebtPrepareBillEntryVO, true);
    }

    private BadDebtPrepareBillVO writeOffBadDebtBill(BadDebtPrepareBillEntryVO lastBadDebtPrepareBillEntryVO, boolean isCalculateAgingAndPercent) {
        BadDebtPrepareBillVO vo = new BadDebtPrepareBillVO();
        vo.setOrgId(this.context.getOrgId().longValue());
        vo.setAsstactType(lastBadDebtPrepareBillEntryVO.getAsstactType());
        vo.setAsstactId(lastBadDebtPrepareBillEntryVO.getAsstactId());
        vo.setBillNo(lastBadDebtPrepareBillEntryVO.getBillNo());
        vo.setAccrualDate(DateUtils.getDataFormat((Date)new Date(), (boolean)true));
        vo.setPeriodId(this.context.getPeriodId().longValue());
        vo.setOffset(false);
        vo.setRemark(lastBadDebtPrepareBillEntryVO.getRemark());
        vo.setCurrencyId(lastBadDebtPrepareBillEntryVO.getCurrencyId());
        vo.setExrateTableId(lastBadDebtPrepareBillEntryVO.getExrateTableId());
        vo.setExrateDate(lastBadDebtPrepareBillEntryVO.getExrateDate());
        vo.setQuotation(lastBadDebtPrepareBillEntryVO.getQuotation());
        vo.setExchangeRate(lastBadDebtPrepareBillEntryVO.getExchangeRate());
        vo.setAccrualScheme(lastBadDebtPrepareBillEntryVO.getAccrualScheme());
        vo.setAccrualObj(lastBadDebtPrepareBillEntryVO.getAccrualObj());
        vo.setAccrualMethod(lastBadDebtPrepareBillEntryVO.getAccrualMethod());
        vo.setAccrualFrequency(lastBadDebtPrepareBillEntryVO.getAccrualFrequency());
        vo.setAgingRange(lastBadDebtPrepareBillEntryVO.getAgingRange());
        vo.setAccrualPercent(lastBadDebtPrepareBillEntryVO.getAccrualPercent());
        vo.setSourceBillType(lastBadDebtPrepareBillEntryVO.getSourceBillType());
        vo.setSourceBillDate(lastBadDebtPrepareBillEntryVO.getSourceBillDate());
        vo.setSourceBillId(lastBadDebtPrepareBillEntryVO.getSourceBillId());
        vo.setIndividualReason(lastBadDebtPrepareBillEntryVO.getIndividualReason());
        vo.setBillSrcType(lastBadDebtPrepareBillEntryVO.getBillSrcType());
        vo.setBillMap(lastBadDebtPrepareBillEntryVO.getBillMap());
        BadDebtPrepareBillEntryVO entryVO = new BadDebtPrepareBillEntryVO();
        entryVO.setMaterialId(lastBadDebtPrepareBillEntryVO.getMaterialId());
        entryVO.setExpenseItemId(lastBadDebtPrepareBillEntryVO.getExpenseItemId());
        entryVO.setAgingRange(lastBadDebtPrepareBillEntryVO.getAgingRange());
        entryVO.setAccrualPercent(lastBadDebtPrepareBillEntryVO.getAccrualPercent());
        if (isCalculateAgingAndPercent) {
            int days = DateUtils.getDiffDaysIgnoreTime((Date)lastBadDebtPrepareBillEntryVO.getSourceBillDate(), (Date)this.context.getEndDate());
            AccrualScheme accrualScheme = this.context.getAccrualScheme();
            Map agingRange = accrualScheme.getAgingRange();
            Map accrualPercentForScheme = accrualScheme.getAccrualPercentForScheme();
            if (agingRange == null || accrualPercentForScheme == null) {
                entryVO.setAgingRange(lastBadDebtPrepareBillEntryVO.getAgingRange());
                entryVO.setAccrualPercent(lastBadDebtPrepareBillEntryVO.getAccrualPercent());
            } else {
                entryVO.setAgingRange(this.getAgingRange(agingRange, days));
                entryVO.setAccrualPercent(this.getAccrualPercent(accrualPercentForScheme, days));
            }
        }
        entryVO.setLastAccruedAmt(lastBadDebtPrepareBillEntryVO.getCurAccruedAmt());
        entryVO.setLastAccruedAmtLocal(lastBadDebtPrepareBillEntryVO.getCurAccruedAmtLocal());
        entryVO.setExchangeRate(lastBadDebtPrepareBillEntryVO.getExchangeRate());
        entryVO.setSrcEntryId(lastBadDebtPrepareBillEntryVO.getSrcEntryId());
        entryVO.setSrcBillId(lastBadDebtPrepareBillEntryVO.getSrcBillId());
        entryVO.setQuotation(lastBadDebtPrepareBillEntryVO.getQuotation());
        entryVO.setRecAmount(lastBadDebtPrepareBillEntryVO.getRecAmount());
        entryVO.setRecLocalAmt(lastBadDebtPrepareBillEntryVO.getRecLocalAmt());
        entryVO.setLossAmt(lastBadDebtPrepareBillEntryVO.getLossAmt());
        entryVO.setLossAmtLocal(lastBadDebtPrepareBillEntryVO.getLossAmtLocal());
        entryVO.setEntryMap(lastBadDebtPrepareBillEntryVO.getEntryMap());
        this.calculateAccrualAmt(entryVO);
        this.sumBadDebtPrepareBillEntry(vo, entryVO);
        vo.getEntries().add(entryVO);
        return vo;
    }

    private void writeOffLastBadDebtBill(Map<Object, BadDebtPrepareBillVO> badDebtPrepareBillVOMap, Map<Object, BadDebtPrepareBillEntryVO> lastBadDebtPrepareBill, Map<Object, BadDebtCalculateVO> lossBillCalculateVO) {
        for (Map.Entry<Object, BadDebtPrepareBillEntryVO> entry : lastBadDebtPrepareBill.entrySet()) {
            BadDebtCalculateVO lossBillVO;
            Object entryId = entry.getKey();
            BadDebtPrepareBillEntryVO lastBadDebtEntryVO = entry.getValue();
            if (lossBillCalculateVO != null && "ar_finarbill".equals(lastBadDebtEntryVO.getSourceBillType()) && (lossBillVO = lossBillCalculateVO.get(entryId)) != null) {
                lastBadDebtEntryVO.setLossAmt(lossBillVO.getBalance());
                lastBadDebtEntryVO.setLossAmtLocal(lossBillVO.getLocalBalance());
            }
            this.mergeSameBadDebtPrepareBill(badDebtPrepareBillVOMap, this.writeOffBadDebtBill(lastBadDebtEntryVO), true);
        }
    }

    private List<DynamicObject> convertVOList(List<BadDebtPrepareBillVO> badDebtVOs) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(badDebtVOs.size());
        DynamicObjectType dt = null;
        for (BadDebtPrepareBillVO vo : badDebtVOs) {
            if (BigDecimal.ZERO.compareTo(vo.getCurAccrualAmt()) == 0 && BigDecimal.ZERO.compareTo(vo.getCurAccruedAmt()) == 0 && vo.getEntries().size() < 1 && BigDecimal.ZERO.compareTo(vo.getOffsetAmt()) == 0) continue;
            DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"ar_baddebtpreparebill");
            result.set("org", (Object)vo.getOrgId());
            result.set("asstacttype", (Object)vo.getAsstactType());
            result.set("asstact", (Object)vo.getAsstactId());
            result.set("billno", (Object)vo.getBillNo());
            result.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            result.set("accrualdate", (Object)vo.getAccrualDate());
            result.set("accrualscheme", (Object)vo.getAccrualScheme());
            result.set("accrualobj", (Object)vo.getAccrualObj());
            result.set("accrualmethod", (Object)vo.getAccrualMethod());
            result.set("period", (Object)vo.getPeriodId());
            result.set("accrualfrequency", (Object)vo.getAccrualFrequency());
            result.set("agingrange", (Object)vo.getAgingRange());
            result.set("accrualpercent", (Object)vo.getAccrualPercent());
            if (BigDecimal.ZERO.compareTo(vo.getOffsetAmt()) != 0) {
                vo.setOffset(true);
            }
            result.set("isoffset", (Object)vo.isOffset());
            result.set("remark", (Object)vo.getRemark());
            result.set("currency", (Object)vo.getCurrencyId());
            result.set("basecurrency", (Object)this.context.getStandardCurrencyId());
            result.set("exratetable", (Object)vo.getExrateTableId());
            result.set("exratedate", (Object)vo.getExrateDate());
            result.set("quotation", (Object)vo.getQuotation());
            result.set("exchangerate", (Object)vo.getExchangeRate());
            result.set("recamount", (Object)vo.getRecAmount());
            result.set("reclocalamt", (Object)vo.getRecLocalAmt());
            result.set("standardamt", (Object)vo.getStandardAmt());
            result.set("standardlocalamt", (Object)vo.getStandardAmtLocal());
            result.set("offsetamt", (Object)vo.getOffsetAmt());
            result.set("offsetlocalamt", (Object)vo.getOffsetAmtLocal());
            result.set("curaccruedamt", (Object)vo.getCurAccruedAmt());
            result.set("curaccruedlocalamt", (Object)vo.getCurAccruedAmtLocal());
            result.set("lastaccruedamt", (Object)vo.getLastAccruedAmt());
            result.set("lastaccruedlocalamt", (Object)vo.getLastAccruedAmtLocal());
            result.set("lossamt", (Object)vo.getLossAmt());
            result.set("losslocalamt", (Object)vo.getLossAmtLocal());
            result.set("curaccrualamt", (Object)vo.getCurAccrualAmt());
            result.set("curaccruallocalamt", (Object)vo.getCurAccrualAmtLocal());
            result.set("sourcebilltype", (Object)vo.getSourceBillType());
            result.set("sourcebillid", (Object)vo.getSourceBillId());
            result.set("sourcebilldate", (Object)vo.getSourceBillDate());
            result.set("individualreason", (Object)vo.getIndividualReason());
            result.set("billsrctype", (Object)vo.getBillSrcType());
            Map headExtendFieldMap = vo.getBillMap();
            if (EmptyUtils.isNotEmpty((Object)headExtendFieldMap)) {
                for (Map.Entry headMap : headExtendFieldMap.entrySet()) {
                    String key = (String)headMap.getKey();
                    Object value = headMap.getValue();
                    result.set(key, value);
                }
            }
            if (dt == null) {
                EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)result.getDataEntityType().getName()).findProperty("entry");
                dt = prop.getDynamicCollectionItemPropertyType();
            }
            List entryVOS = vo.getEntries();
            int invalidEntryCount = 0;
            int i = 0;
            BigDecimal recAmount = BigDecimal.ZERO;
            BigDecimal recAmountLoc = BigDecimal.ZERO;
            for (BadDebtPrepareBillEntryVO entryVO : entryVOS) {
                if (BigDecimal.ZERO.compareTo(entryVO.getCurAccrualAmt()) == 0 && BigDecimal.ZERO.compareTo(entryVO.getCurAccruedAmt()) == 0 && BigDecimal.ZERO.compareTo(entryVO.getOffsetAmt()) == 0) {
                    ++invalidEntryCount;
                    continue;
                }
                DynamicObject entriesResult = new DynamicObject(dt);
                entriesResult.set("seq", (Object)(++i));
                entriesResult.set("e_material", (Object)entryVO.getMaterialId());
                entriesResult.set("e_expenseitem", (Object)entryVO.getExpenseItemId());
                entriesResult.set("e_agingrange", (Object)entryVO.getAgingRange());
                entriesResult.set("e_accrualpercent", (Object)entryVO.getAccrualPercent());
                entriesResult.set("e_recamount", (Object)entryVO.getRecAmount());
                entriesResult.set("e_reclocalamt", (Object)entryVO.getRecLocalAmt());
                recAmount = recAmount.add(entryVO.getRecAmount());
                recAmountLoc = recAmountLoc.add(entryVO.getRecLocalAmt());
                entriesResult.set("e_standardamt", (Object)entryVO.getStandardAmt());
                entriesResult.set("e_standardlocalamt", (Object)entryVO.getStandardAmtLocal());
                entriesResult.set("e_offsetamt", (Object)entryVO.getOffsetAmt());
                entriesResult.set("e_offsetlocalamt", (Object)entryVO.getOffsetAmtLocal());
                entriesResult.set("e_curaccruedamt", (Object)entryVO.getCurAccruedAmt());
                entriesResult.set("e_curaccruedlocalamt", (Object)entryVO.getCurAccruedAmtLocal());
                entriesResult.set("e_lastaccruedamt", (Object)entryVO.getLastAccruedAmt());
                entriesResult.set("e_lastaccruedlocalamt", (Object)entryVO.getLastAccruedAmtLocal());
                entriesResult.set("e_lossamt", (Object)entryVO.getLossAmt());
                entriesResult.set("e_losslocalamt", (Object)entryVO.getLossAmtLocal());
                entriesResult.set("e_curaccrualamt", (Object)entryVO.getCurAccrualAmt());
                entriesResult.set("e_curaccruallocalamt", (Object)entryVO.getCurAccrualAmtLocal());
                entriesResult.set("e_srcbillid", (Object)entryVO.getSrcBillId());
                entriesResult.set("e_srcentryid", (Object)entryVO.getSrcEntryId());
                Map entryMap = entryVO.getEntryMap();
                if (!entryMap.isEmpty()) {
                    for (Map.Entry mapEntry : entryMap.entrySet()) {
                        String key = (String)mapEntry.getKey();
                        if (key.contains(".")) {
                            key = key.split("\\.")[1];
                        }
                        Object value = mapEntry.getValue();
                        entriesResult.set(key, value);
                    }
                }
                result.getDynamicObjectCollection("entry").add((Object)entriesResult);
            }
            result.set("recamount", (Object)recAmount);
            result.set("reclocalamt", (Object)recAmountLoc);
            if (invalidEntryCount == entryVOS.size()) continue;
            billList.add(result);
        }
        return billList;
    }

    private void saveBadDebtPrepareBills(List<DynamicObject> badDebtBills) {
        try (TXHandle tx = TX.requiresNew((String)"BadDebtAccrual");){
            try {
                DynamicObject[] gainLossBillArr = badDebtBills.toArray(new DynamicObject[0]);
                SaveServiceHelper.save((DynamicObject[])gainLossBillArr);
                HashSet<Object> pkSet = new HashSet<Object>(8);
                for (DynamicObject bill : gainLossBillArr) {
                    Object id = bill.getPkValue();
                    Long sourceBillId = bill.getLong("sourcebillid");
                    if (this.needMergeSrcBillIds.contains(sourceBillId)) continue;
                    pkSet.add(id);
                }
                OperationResult auditResult = this.invokePrepareBillAudit(pkSet);
                if (auditResult != null && !auditResult.isSuccess()) {
                    logger.info("------badDebt.operationResult.Message------" + auditResult.getMessage());
                    OperationHelper.assertResult((OperationResult)auditResult);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                throw new KDException((Throwable)e, new ErrorCode("BadDebtAccrualService", ResManager.loadKDString((String)"\u574f\u8d26\u51c6\u5907\u5355\u4fdd\u5b58\u5931\u8d25\uff0c%s\u3002", (String)"BadDebtAccrualService_4", (String)"fi-arapcommon", (Object[])new Object[]{e.getMessage()})), new Object[0]);
            }
        }
    }

    private String validate() {
        QFilter exitFilter = new QFilter("period.id", "=", (Object)this.periodId);
        exitFilter.and(new QFilter("org.id", "=", (Object)this.orgId));
        QFilter isVoucherFilter = new QFilter("isvoucher", "=", (Object)Boolean.TRUE);
        boolean isVoucher = QueryServiceHelper.exists((String)"ar_baddebtpreparebill", (QFilter[])new QFilter[]{exitFilter, isVoucherFilter});
        if (isVoucher) {
            return ResManager.loadKDString((String)"\u672c\u671f\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u574f\u8d26\u51c6\u5907\u5355\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u91cd\u8bd5\u3002", (String)"BadDebtAccrualService_7", (String)"fi-ar-business", (Object[])new Object[0]);
        }
        return null;
    }

    public String getQuotation(String billNo, Long exratetableId, Long currencyId) {
        StringBuilder exchangeRateMapKey = new StringBuilder();
        exchangeRateMapKey.append(currencyId);
        String quotation = this.context.getQuotationMap().get(exchangeRateMapKey.toString());
        if (quotation != null) {
            return quotation;
        }
        Map exchangeRateMap = BaseDataHelper.getExchangeRateMap((Long)exratetableId, (Long)currencyId, (Long)this.context.getStandardCurrencyId(), (Date)this.context.getExrateDate());
        if (EmptyUtils.isNotEmpty((Object)exchangeRateMap) && EmptyUtils.isNotEmpty(exchangeRateMap.get("quoteType"))) {
            String string = quotation = (Boolean)exchangeRateMap.get("quoteType") != false ? "1" : "0";
        }
        if (EmptyUtils.isEmpty((Object)quotation)) {
            logger.info(String.format("BadDebtAccrualService -- getQuotation(exratetableId -- %s),(billNo -- %s),(currencyId -- %s)", exratetableId, billNo, currencyId));
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u7ef4\u62a4\u6362\u7b97\u65b9\u5f0f\u7684\u7ed3\u7b97\u5e01\uff1a%s\uff0c\u8ba1\u63d0\u5931\u8d25\u3002", (String)"BadDebtAccrualService_10", (String)"fi-ar-business", (Object[])new Object[]{billNo}));
        }
        this.context.getQuotationMap().put(exchangeRateMapKey.toString(), quotation);
        return quotation;
    }

    protected BigDecimal getCurExchangeRate(String billNo, Long exratetableId, Long currencyId, String quotation) {
        StringBuilder exchangeRateMapKey = new StringBuilder();
        exchangeRateMapKey.append(currencyId);
        BigDecimal exchangeRate = this.context.getExchangeRateMap().get(exchangeRateMapKey.toString());
        if (exchangeRate != null) {
            return exchangeRate;
        }
        exchangeRate = BaseDataHelper.getExchangeRate((Long)exratetableId, (Long)currencyId, (Long)this.context.getStandardCurrencyId(), (String)quotation, (Date)this.context.getExrateDate());
        if (exchangeRate == null) {
            logger.info(String.format("BadDebtAccrualService -- getCurExchangeRate(exratetableId -- %s): %s (currencyId -- %s)", exratetableId, billNo, currencyId));
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u7ef4\u62a4\u6c47\u7387\u7684\u5e01\u79cd\uff1a%s\uff0c\u8ba1\u63d0\u5931\u8d25\u3002", (String)"BadDebtAccrualService_11", (String)"fi-ar-business", (Object[])new Object[]{billNo}));
        }
        this.context.getExchangeRateMap().put(exchangeRateMapKey.toString(), exchangeRate);
        return exchangeRate;
    }

    private int getCurrencyPrecision(BadDebtPrepareBillEntryVO badDebtPrepareBillEntryVO) {
        Long currencyId = badDebtPrepareBillEntryVO.getCurrencyId();
        Integer precision = this.currencyAndPrecision.get(currencyId);
        if (precision == null) {
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currencyId)});
            precision = currency != null ? Integer.valueOf(currency.getInt("amtprecision")) : Integer.valueOf(this.context.getPrecision());
            this.currencyAndPrecision.put(currencyId, precision);
        }
        return precision;
    }

    private void collectRepeatSrcBillIds(List<DynamicObject> badDebtBills) {
        for (DynamicObject bill : badDebtBills) {
            String sourceBillType = bill.getString("sourcebilltype");
            Long sourceBillId = bill.getLong("sourcebillid");
            Set srcBillIds = this.schemePreparebillIds.getOrDefault(sourceBillType, new HashSet(32));
            if (srcBillIds.contains(sourceBillId)) {
                this.needMergeSrcBillIds.add(sourceBillId);
            } else {
                srcBillIds.add(sourceBillId);
            }
            this.schemePreparebillIds.put(sourceBillType, srcBillIds);
        }
    }

    private void handlerEntryMerge(Set<Long> needMergeSrcBillIds, String entityKey, AbstractBadDebtBillHandler billHandler) {
        if (needMergeSrcBillIds.isEmpty()) {
            return;
        }
        int billCount = this.context.getBillCount();
        int i = 0;
        int maxSize = needMergeSrcBillIds.size();
        HashSet<Long> batchMergeSrcBillIds = new HashSet<Long>(16);
        for (Long needMergeSrcBillId : needMergeSrcBillIds) {
            batchMergeSrcBillIds.add(needMergeSrcBillId);
            if (++i != billCount && --maxSize != 0) continue;
            i = 0;
            QFilter filter = new QFilter("org.id", "=", (Object)this.context.getOrgId());
            filter.and(new QFilter("period.id", "=", (Object)this.context.getPeriodId()));
            filter.and(new QFilter("sourcebilltype", "=", (Object)entityKey));
            filter.and(new QFilter("sourcebillid", "in", batchMergeSrcBillIds));
            DynamicObject[] prepareBills = BusinessDataServiceHelper.load((String)"ar_baddebtpreparebill", (String)StringUtils.join(this.getBadDebtPMergeBillSelector(entityKey, billHandler), (String)","), (QFilter[])filter.toArray());
            if (prepareBills == null || prepareBills.length < 2) {
                batchMergeSrcBillIds.clear();
                break;
            }
            HashMap<Long, List<DynamicObject>> sourceBillIdAndBillsMap = new HashMap<Long, List<DynamicObject>>(8);
            for (DynamicObject bill : prepareBills) {
                Long sourceBillId = bill.getLong("sourcebillid");
                List mergeBills = sourceBillIdAndBillsMap.getOrDefault(sourceBillId, new ArrayList(8));
                mergeBills.add(bill);
                sourceBillIdAndBillsMap.put(sourceBillId, mergeBills);
            }
            this.excuteMerge(sourceBillIdAndBillsMap);
            batchMergeSrcBillIds.clear();
        }
    }

    private List<String> getBadDebtPMergeBillSelector(String entityKey, AbstractBadDebtBillHandler billHandler) {
        ArrayList<String> selector = new ArrayList<String>(32);
        selector.add("id");
        selector.add("isoffset");
        selector.add("sourcebilltype");
        selector.add("sourcebillid");
        selector.add("recamount");
        selector.add("reclocalamt");
        selector.add("standardamt");
        selector.add("standardlocalamt");
        selector.add("offsetamt");
        selector.add("offsetlocalamt");
        selector.add("curaccruedamt");
        selector.add("curaccruedlocalamt");
        selector.add("lastaccruedamt");
        selector.add("lastaccruedlocalamt");
        selector.add("lossamt");
        selector.add("losslocalamt");
        selector.add("curaccrualamt");
        selector.add("curaccruallocalamt");
        selector.add("entry.seq");
        selector.add("e_material");
        selector.add("e_expenseitem");
        selector.add("e_agingrange");
        selector.add("e_accrualpercent");
        selector.add("e_recamount");
        selector.add("e_reclocalamt");
        selector.add("e_standardamt");
        selector.add("e_standardlocalamt");
        selector.add("e_offsetamt");
        selector.add("e_offsetlocalamt");
        selector.add("e_curaccruedamt");
        selector.add("e_curaccruedlocalamt");
        selector.add("e_lastaccruedamt");
        selector.add("e_lastaccruedlocalamt");
        selector.add("e_lossamt");
        selector.add("e_losslocalamt");
        selector.add("e_curaccrualamt");
        selector.add("e_curaccruallocalamt");
        selector.add("e_srcbillid");
        selector.add("e_srcentryid");
        for (BillFieldMappingVO billFieldMappingVO : billHandler.billFieldMappingVOMap.get(entityKey)) {
            if ("ar_baddebtpreparebill".equals(billFieldMappingVO.getTargetFieldSite())) {
                selector.add(billFieldMappingVO.getTargetField());
                continue;
            }
            selector.add(billFieldMappingVO.getTargetFieldSite() + "." + billFieldMappingVO.getTargetField());
        }
        return selector;
    }

    private void excuteMerge(Map<Long, List<DynamicObject>> sourceBillIdAndBillsMap) {
        HashSet<Long> deleteId = new HashSet<Long>(8);
        ArrayList<DynamicObject> saveBillDO = new ArrayList<DynamicObject>(8);
        for (Map.Entry<Long, List<DynamicObject>> mapEntry : sourceBillIdAndBillsMap.entrySet()) {
            List<DynamicObject> value = mapEntry.getValue();
            CloneUtils utils = new CloneUtils(false, true);
            DynamicObject baseBill = value.get(0);
            DynamicObjectCollection baseEntries = baseBill.getDynamicObjectCollection("entry");
            Map<Long, DynamicObject> srcEntryIdAndBillEntry = baseEntries.stream().collect(Collectors.toMap(e -> e.getLong("e_srcentryid"), e -> e));
            for (int i = 1; i < value.size(); ++i) {
                DynamicObject bill = value.get(i);
                deleteId.add(bill.getLong("id"));
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    Long srcEntryId = entry.getLong("e_srcentryid");
                    DynamicObject baseEntry = srcEntryIdAndBillEntry.get(srcEntryId);
                    if (baseEntry != null) {
                        this.calculateEntryAmt(baseEntry, entry);
                        continue;
                    }
                    entry.set("seq", (Object)(baseEntries.size() + 1));
                    DynamicObject clone = (DynamicObject)utils.clone((IDataEntityBase)entry);
                    baseEntries.add((Object)clone);
                }
            }
            this.sumBillHeadField(baseBill, baseEntries);
            saveBillDO.add(baseBill);
        }
        this.handleMergeBillSave(saveBillDO, deleteId);
    }

    private void calculateEntryAmt(DynamicObject baseEntry, DynamicObject entry) {
        baseEntry.set("e_recamount", (Object)entry.getBigDecimal("e_recamount"));
        baseEntry.set("e_reclocalamt", (Object)entry.getBigDecimal("e_reclocalamt"));
        baseEntry.set("e_standardamt", (Object)baseEntry.getBigDecimal("e_standardamt").add(entry.getBigDecimal("e_standardamt")));
        baseEntry.set("e_standardlocalamt", (Object)baseEntry.getBigDecimal("e_standardlocalamt").add(entry.getBigDecimal("e_standardlocalamt")));
        baseEntry.set("e_offsetamt", (Object)baseEntry.getBigDecimal("e_offsetamt").add(entry.getBigDecimal("e_offsetamt")));
        baseEntry.set("e_offsetlocalamt", (Object)baseEntry.getBigDecimal("e_offsetlocalamt").add(entry.getBigDecimal("e_offsetlocalamt")));
        baseEntry.set("e_curaccruedamt", (Object)baseEntry.getBigDecimal("e_curaccruedamt").add(entry.getBigDecimal("e_curaccruedamt")));
        baseEntry.set("e_curaccruedlocalamt", (Object)baseEntry.getBigDecimal("e_curaccruedlocalamt").add(entry.getBigDecimal("e_curaccruedlocalamt")));
        baseEntry.set("e_lastaccruedamt", (Object)baseEntry.getBigDecimal("e_lastaccruedamt").add(entry.getBigDecimal("e_lastaccruedamt")));
        baseEntry.set("e_lastaccruedlocalamt", (Object)baseEntry.getBigDecimal("e_lastaccruedlocalamt").add(entry.getBigDecimal("e_lastaccruedlocalamt")));
        baseEntry.set("e_lossamt", (Object)baseEntry.getBigDecimal("e_lossamt").add(entry.getBigDecimal("e_lossamt")));
        baseEntry.set("e_losslocalamt", (Object)baseEntry.getBigDecimal("e_losslocalamt").add(entry.getBigDecimal("e_losslocalamt")));
        baseEntry.set("e_curaccrualamt", (Object)baseEntry.getBigDecimal("e_curaccrualamt").add(entry.getBigDecimal("e_curaccrualamt")));
        baseEntry.set("e_curaccruallocalamt", (Object)baseEntry.getBigDecimal("e_curaccruallocalamt").add(entry.getBigDecimal("e_curaccruallocalamt")));
    }

    private void sumBillHeadField(DynamicObject baseBill, DynamicObjectCollection baseEntries) {
        BigDecimal recAmount = BigDecimal.ZERO;
        BigDecimal recAmountLoc = BigDecimal.ZERO;
        BigDecimal standardAmt = BigDecimal.ZERO;
        BigDecimal standardAmtLoc = BigDecimal.ZERO;
        BigDecimal offsetAmt = BigDecimal.ZERO;
        BigDecimal offsetAmtLoc = BigDecimal.ZERO;
        BigDecimal accruedAmt = BigDecimal.ZERO;
        BigDecimal accruedAmtLoc = BigDecimal.ZERO;
        BigDecimal lastAccruedAmt = BigDecimal.ZERO;
        BigDecimal lastAccruedAmtLoc = BigDecimal.ZERO;
        BigDecimal lossAmt = BigDecimal.ZERO;
        BigDecimal lossAmtLoc = BigDecimal.ZERO;
        BigDecimal accrualAmt = BigDecimal.ZERO;
        BigDecimal accrualAmtLoc = BigDecimal.ZERO;
        for (DynamicObject baseEntry : baseEntries) {
            recAmount = recAmount.add(baseEntry.getBigDecimal("e_recamount"));
            recAmountLoc = recAmountLoc.add(baseEntry.getBigDecimal("e_reclocalamt"));
            standardAmt = standardAmt.add(baseEntry.getBigDecimal("e_standardamt"));
            standardAmtLoc = standardAmtLoc.add(baseEntry.getBigDecimal("e_standardlocalamt"));
            offsetAmt = offsetAmt.add(baseEntry.getBigDecimal("e_offsetamt"));
            offsetAmtLoc = offsetAmtLoc.add(baseEntry.getBigDecimal("e_offsetlocalamt"));
            accruedAmt = accruedAmt.add(baseEntry.getBigDecimal("e_curaccruedamt"));
            accruedAmtLoc = accruedAmtLoc.add(baseEntry.getBigDecimal("e_curaccruedlocalamt"));
            lastAccruedAmt = lastAccruedAmt.add(baseEntry.getBigDecimal("e_lastaccruedamt"));
            lastAccruedAmtLoc = lastAccruedAmtLoc.add(baseEntry.getBigDecimal("e_lastaccruedlocalamt"));
            lossAmt = lossAmt.add(baseEntry.getBigDecimal("e_lossamt"));
            lossAmtLoc = lossAmtLoc.add(baseEntry.getBigDecimal("e_losslocalamt"));
            accrualAmt = accrualAmt.add(baseEntry.getBigDecimal("e_curaccrualamt"));
            accrualAmtLoc = accrualAmtLoc.add(baseEntry.getBigDecimal("e_curaccruallocalamt"));
        }
        baseBill.set("recamount", (Object)recAmount);
        baseBill.set("reclocalamt", (Object)recAmountLoc);
        baseBill.set("standardamt", (Object)standardAmt);
        baseBill.set("standardlocalamt", (Object)standardAmtLoc);
        baseBill.set("offsetamt", (Object)offsetAmt);
        baseBill.set("offsetlocalamt", (Object)offsetAmtLoc);
        baseBill.set("curaccruedamt", (Object)accruedAmt);
        baseBill.set("curaccruedlocalamt", (Object)accruedAmtLoc);
        baseBill.set("lastaccruedamt", (Object)lastAccruedAmt);
        baseBill.set("lastaccruedlocalamt", (Object)lastAccruedAmtLoc);
        baseBill.set("lossamt", (Object)lossAmt);
        baseBill.set("losslocalamt", (Object)lossAmtLoc);
        baseBill.set("curaccrualamt", (Object)accrualAmt);
        baseBill.set("curaccruallocalamt", (Object)accrualAmtLoc);
        if (BigDecimal.ZERO.compareTo(offsetAmt) != 0) {
            baseBill.set("isoffset", (Object)Boolean.TRUE);
        }
    }

    private void handleMergeBillSave(List<DynamicObject> saveBillDO, Set<Long> deleteId) {
        if (deleteId.isEmpty() || saveBillDO.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"BadDebtAccrualMerge");){
            try {
                SaveServiceHelper.save((DynamicObject[])saveBillDO.toArray(new DynamicObject[0]));
                DeleteServiceHelper.delete((IDataEntityType)saveBillDO.get(0).getDataEntityType(), (Object[])deleteId.toArray());
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                throw new KDException((Throwable)e, new ErrorCode("BadDebtAccrualService", ResManager.loadKDString((String)"\u574f\u8d26\u51c6\u5907\u5355\u5408\u5e76\u65f6\u4fdd\u5b58\u5931\u8d25\uff0c%s\u3002", (String)"BadDebtAccrualService_12", (String)"fi-arapcommon", (Object[])new Object[]{e.getMessage()})), new Object[0]);
            }
        }
    }

    private OperationResult invokePrepareBillAudit(Set<Object> pkSet) {
        if (pkSet.isEmpty()) {
            return null;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        return OperationServiceHelper.executeOperate((String)"audit", (String)"ar_baddebtpreparebill", (Object[])pkSet.toArray(), (OperateOption)option);
    }

    private void handleEasBill(AbstractBadDebtBillHandler billHandler) {
        QFilter filter = new QFilter("org.id", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("period.id", "=", (Object)this.context.getLastPeriodId()));
        filter.and(new QFilter("billsrctype", "=", (Object)"fromeas"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)"ar_baddebtpreparebill", (String)"id", (QFilter[])filter.toArray(), (String)"accrualdate");
        ArrayList<Long> billIds = new ArrayList<Long>(8);
        for (Row row : dataSet) {
            billIds.add(row.getLong("id"));
        }
        List<BadDebtPrepareBillEntryVO> badDebtVOList = billHandler.getLastBadDebtPrepareBillForEas(billIds);
        if (badDebtVOList.isEmpty()) {
            return;
        }
        HashMap<Object, BadDebtPrepareBillVO> badDebtPrepareBillVOMap = new HashMap<Object, BadDebtPrepareBillVO>(8);
        for (BadDebtPrepareBillEntryVO badDebtPrepareBillEntryVO : badDebtVOList) {
            this.mergeSameBadDebtPrepareBill(badDebtPrepareBillVOMap, this.writeOffBadDebtBill(badDebtPrepareBillEntryVO, false), false);
        }
        ArrayList<BadDebtPrepareBillVO> badDebtVOs = new ArrayList<BadDebtPrepareBillVO>(badDebtPrepareBillVOMap.values());
        List<DynamicObject> badDebtBills = this.convertVOList(badDebtVOs);
        if (!badDebtBills.isEmpty()) {
            this.saveBadDebtPrepareBills(badDebtBills);
        }
    }
}

