/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.baddebtnew;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.SettingMapperHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.UpgradeConfigHelper;
import kd.fi.arapcommon.util.DateUtils;

public class BadDebtContext {
    private Long orgId;
    private Long periodId;
    private Date startDate;
    private Date endDate;
    private Long lastPeriodId;
    private AccrualScheme accrualScheme;
    private Long standardCurrencyId;
    private int precision;
    private int billCount = 1000;
    private boolean isPeriod = false;
    private boolean isMaterialSettle;
    private Set<String> offsetFieldSelectorForRec = new HashSet<String>(32);
    private Set<String> offsetFieldSelectorForReceived = new HashSet<String>(32);
    private Long exrateTableId;
    private Date exrateDate;
    private Map<String, BigDecimal> exchangeRateMap = new HashMap<String, BigDecimal>(16);
    private Map<String, String> quotationMap = new HashMap<String, String>(16);
    private boolean handleHistoryDataForPlans = false;

    public BadDebtContext(Long orgId, Long periodId, Long preperiodId, AccrualScheme accrualScheme, boolean isPeriod) {
        if (accrualScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u65b9\u6848\u4e3a\u7a7a\uff0c\u7ec4\u7ec7id\uff1a%s\u3002", (String)"BadDebtContext_0", (String)"fi-ar-business", (Object[])new Object[]{orgId}));
        }
        InitHelper init = new InitHelper(orgId.longValue(), "ar_init");
        DynamicObject startPeriod = init.getStartPeriod();
        this.orgId = orgId;
        this.periodId = periodId;
        this.accrualScheme = accrualScheme;
        this.isPeriod = isPeriod;
        if (isPeriod) {
            Date startPeriodFirstDate = startPeriod.getDate("begindate");
            this.endDate = DateUtils.getLastDay((Date)startPeriodFirstDate, (int)1);
        } else {
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
            this.startDate = period.getDate("begindate");
            this.endDate = period.getDate("enddate");
        }
        this.lastPeriodId = preperiodId;
        this.standardCurrencyId = init.getStandardCurrency().getLong("id");
        this.precision = BusinessDataServiceHelper.loadSingleFromCache((Object)this.standardCurrencyId, (String)"bd_currency").getInt("amtprecision");
        this.isMaterialSettle = "1".equals(SystemParameterHelper.getARAppParameter((Long)orgId, (String)"ar_003"));
        String batchCount = SettingMapperHelper.getValueFromCache((String)"badDebtContext", (String)"batchcount");
        if (!ObjectUtils.isEmpty((Object)batchCount) && batchCount.trim().matches("^[0-9]*$")) {
            this.billCount = Integer.parseInt(batchCount.trim());
        }
        DynamicObject badDebtAccrue = BusinessDataServiceHelper.loadSingle((String)"ar_baddebtaccrue", (String)"createtime", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("period", "=", (Object)periodId)});
        Date upgradeTime = UpgradeConfigHelper.getUpgradeTime((String)"BIZ_V6.0.4_DataUpgrade");
        Date recordCreateDate = badDebtAccrue.getDate("createtime");
        if (!this.isMaterialSettle && upgradeTime != null && recordCreateDate != null && recordCreateDate.before(upgradeTime)) {
            this.handleHistoryDataForPlans = true;
        }
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getLastPeriodId() {
        return this.lastPeriodId;
    }

    public void setLastPeriodId(Long lastPeriodId) {
        this.lastPeriodId = lastPeriodId;
    }

    public AccrualScheme getAccrualScheme() {
        return this.accrualScheme;
    }

    public void setAccrualScheme(AccrualScheme accrualScheme) {
        this.accrualScheme = accrualScheme;
    }

    public Long getStandardCurrencyId() {
        return this.standardCurrencyId;
    }

    public void setStandardCurrencyId(Long standardCurrencyId) {
        this.standardCurrencyId = standardCurrencyId;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getBillCount() {
        return this.billCount;
    }

    public void setBillCount(int billCount) {
        this.billCount = billCount;
    }

    public boolean isPeriod() {
        return this.isPeriod;
    }

    public void setPeriod(boolean period) {
        this.isPeriod = period;
    }

    public boolean isMaterialSettle() {
        return this.isMaterialSettle;
    }

    public void setMaterialSettle(boolean materialSettle) {
        this.isMaterialSettle = materialSettle;
    }

    public Set<String> getOffsetFieldSelectorForRec() {
        return this.offsetFieldSelectorForRec;
    }

    public void setOffsetFieldSelectorForRec(Set<String> offsetFieldSelectorForRec) {
        this.offsetFieldSelectorForRec = offsetFieldSelectorForRec;
    }

    public Set<String> getOffsetFieldSelectorForReceived() {
        return this.offsetFieldSelectorForReceived;
    }

    public void setOffsetFieldSelectorForReceived(Set<String> offsetFieldSelectorForReceived) {
        this.offsetFieldSelectorForReceived = offsetFieldSelectorForReceived;
    }

    public Long getExrateTableId() {
        return this.exrateTableId;
    }

    public void setExrateTableId(Long exrateTableId) {
        this.exrateTableId = exrateTableId;
    }

    public Date getExrateDate() {
        return this.exrateDate;
    }

    public void setExrateDate(Date exrateDate) {
        this.exrateDate = exrateDate;
    }

    public Map<String, BigDecimal> getExchangeRateMap() {
        return this.exchangeRateMap;
    }

    public void setExchangeRateMap(Map<String, BigDecimal> exchangeRateMap) {
        this.exchangeRateMap = exchangeRateMap;
    }

    public Map<String, String> getQuotationMap() {
        return this.quotationMap;
    }

    public void setQuotationMap(Map<String, String> quotationMap) {
        this.quotationMap = quotationMap;
    }

    public boolean isHandleHistoryDataForPlans() {
        return this.handleHistoryDataForPlans;
    }

    public void setHandleHistoryDataForPlans(boolean handleHistoryDataForPlans) {
        this.handleHistoryDataForPlans = handleHistoryDataForPlans;
    }
}

