/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.baddebtnew;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.service.baddebtnew.AbstractBadDebtBillHandler;
import kd.fi.ar.business.service.baddebtnew.BadDebtContext;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.ar.vo.baddebtnew.BadDebtCalculateVO;
import kd.fi.ar.vo.baddebtnew.BadDebtCommonVO;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class BusArBadDebtBillHandler
extends AbstractBadDebtBillHandler {
    public BusArBadDebtBillHandler(BadDebtContext badDebtContext) {
        super(badDebtContext);
    }

    @Override
    public List<BadDebtCommonVO> getBillIds(Set<Long> prepareBillIds) {
        ArrayList<BadDebtCommonVO> resultOfBadDebtCommonVOs = new ArrayList<BadDebtCommonVO>(32);
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        QFilter accrualSchemeFilter = accrualScheme.getCondition();
        QFilter accruedBillIdFilter = new QFilter("id", "not in", prepareBillIds);
        String agingDate = accrualScheme.getAgingDateEntity();
        QFilter agingDateFilter = new QFilter(agingDate, "<=", (Object)DateUtils.getLastDay((Date)this.badDebtContext.getEndDate(), (int)accrualScheme.getAgingStartDay()));
        QFilter busFilter = this.getBusFilter();
        DataSet busDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{busFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        DataSet unexpectedBusDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedBusFilter = this.getUnexpectedBusFilter(this.inverseBillIdSet);
            unexpectedBusDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{unexpectedBusFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        }
        DataSet allDataSet = EmptyUtils.isNotEmpty((Object)busDataSet) ? (EmptyUtils.isNotEmpty(unexpectedBusDataSet) ? busDataSet.union(unexpectedBusDataSet).orderBy(new String[]{agingDate}) : busDataSet) : unexpectedBusDataSet;
        resultOfBadDebtCommonVOs.addAll(this.buildCommonBillVOByBus(allDataSet, new LinkedHashMap<Object, BadDebtCommonVO>(32)));
        return resultOfBadDebtCommonVOs;
    }

    @Override
    public List<BadDebtCommonVO> getBillIds(Set<Long> prepareBillIds, Set<Long> prepareBillEntryIds) {
        ArrayList<BadDebtCommonVO> resultOfBadDebtCommonVOs = new ArrayList<BadDebtCommonVO>(32);
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        QFilter accrualSchemeFilter = accrualScheme.getCondition();
        QFilter accruedBillIdFilter = new QFilter("id", "not in", prepareBillIds);
        accruedBillIdFilter.and("entry.id", "not in", prepareBillEntryIds);
        String agingDate = accrualScheme.getAgingDateEntity();
        QFilter agingDateFilter = new QFilter(agingDate, "<=", (Object)DateUtils.getLastDay((Date)this.badDebtContext.getEndDate(), (int)accrualScheme.getAgingStartDay()));
        QFilter busFilter = this.getBusFilter();
        DataSet busDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{busFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        DataSet unexpectedBusDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedBusFilter = this.getUnexpectedBusFilter(this.inverseBillIdSet);
            unexpectedBusDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{unexpectedBusFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        }
        DataSet allDataSet = EmptyUtils.isNotEmpty((Object)busDataSet) ? (EmptyUtils.isNotEmpty(unexpectedBusDataSet) ? busDataSet.union(unexpectedBusDataSet).orderBy(new String[]{agingDate}) : busDataSet) : unexpectedBusDataSet;
        resultOfBadDebtCommonVOs.addAll(this.buildCommonBillVOByBus(allDataSet, new LinkedHashMap<Object, BadDebtCommonVO>(32)));
        return resultOfBadDebtCommonVOs;
    }

    @Override
    public LinkedHashMap<Object, BadDebtCalculateVO> getBills(List<BadDebtCommonVO> subBillIds) {
        Set<String> selector = this.getSelector();
        String agingDate = this.badDebtContext.getAccrualScheme().getAgingDateEntity();
        selector.add(agingDate);
        QFilter idAndEntryIdFilter = this.getFilterByCommonVO(subBillIds);
        DataSet busDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)AdjustExchHelper.generateSelector(new ArrayList<String>(selector)), (QFilter[])idAndEntryIdFilter.toArray(), (String)agingDate);
        return this.convertBusBillToVO(busDataSet);
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getProcessBills() {
        ArrayList<BadDebtCalculateVO> badDebtCalculateVOs = new ArrayList<BadDebtCalculateVO>(8);
        String adjustBusSelector = this.getAdjustBusSelector();
        QFilter adjustBusFilter = this.getAdjustBusFilter();
        DataSet adjustBusDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)adjustBusSelector, (QFilter[])new QFilter[]{adjustBusFilter}, (String)"");
        badDebtCalculateVOs.addAll(this.convertAdjustBusBillToVO(adjustBusDataSet, this.inverseBillIdSet));
        String currentPeriodAdjustBusSelector = this.getCurrentPeriodAdjustBusSelector();
        QFilter currentPeriodAdjustBusFilter = this.getCurrentPeriodAdjustBusFliter(this.inverseBillIdSet);
        DataSet currentPeriodAdjustBusDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)currentPeriodAdjustBusSelector, (QFilter[])new QFilter[]{currentPeriodAdjustBusFilter}, (String)"bizdate");
        badDebtCalculateVOs.addAll(this.convertCurrentPeriodAdjustBusBillToVO(currentPeriodAdjustBusDataSet));
        HashMap<Object, BadDebtCalculateVO> processBillVOMap = new HashMap<Object, BadDebtCalculateVO>(64);
        for (BadDebtCalculateVO badDebtCalculateVO : badDebtCalculateVOs) {
            BadDebtCalculateVO vo = (BadDebtCalculateVO)processBillVOMap.get(badDebtCalculateVO.getBillEntryId());
            if (vo != null) {
                vo.getWoffBillEntryIdSet().add(badDebtCalculateVO.getWoffBillEntryId());
                vo.setBalance(vo.getBalance().add(badDebtCalculateVO.getBalance()));
                vo.setLocalBalance(vo.getLocalBalance().add(badDebtCalculateVO.getLocalBalance()));
                logger.info(String.format("BusArBadDebtBillHandler -- getProcessBillVO \u8fc7\u7a0b\u5355\u636e\u91d1\u989d\u7d2f\u52a0\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                continue;
            }
            processBillVOMap.put(badDebtCalculateVO.getBillEntryId(), badDebtCalculateVO);
        }
        for (Map.Entry entry : processBillVOMap.entrySet()) {
            BadDebtCalculateVO calculateVO = (BadDebtCalculateVO)entry.getValue();
            this.recursionWoffBill(processBillVOMap, calculateVO, calculateVO);
        }
        return processBillVOMap;
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getOffsetBill() {
        return null;
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getBadDebtLossBill() {
        return null;
    }

    @Override
    public Set<String> getOriginSelector() {
        Set<String> selector = BusArBadDebtBillHandler.getBaseBillSelector();
        selector.add("isadjust");
        selector.add("entry.id");
        selector.add("entry.e_recamount");
        selector.add("entry.e_reclocalamt");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unwoffamt");
        selector.add("entry.e_unwofflocamt");
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        if (accrualScheme.isOffset() && accrualScheme.getOffsetedField() != null && "ar_busbill".equals(accrualScheme.getOffsetBillEntity())) {
            selector.addAll(accrualScheme.getOffsetedField());
        }
        return selector;
    }

    @Override
    public String getEntityKey() {
        return "ar_busbill";
    }

    private QFilter getBusFilter() {
        QFilter filter;
        if (this.badDebtContext.isPeriod()) {
            filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
            filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filter.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
            filter.and(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("entry.e_unwoffamt", "<>", (Object)0));
        } else {
            filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
            filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filter.and(new QFilter("bookdate", "<=", (Object)this.badDebtContext.getEndDate()));
            filter.and(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("entry.e_unwoffamt", "<>", (Object)0));
        }
        return filter;
    }

    private String getAdjustBusSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("entry.id");
        selector.add("entry.e_srcbillid");
        selector.add("entry.e_srcentryid");
        selector.add("entry.e_recamount");
        selector.add("entry.e_reclocalamt");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getAdjustBusFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("bookdate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        return filter;
    }

    private Set<BadDebtCalculateVO> convertAdjustBusBillToVO(DataSet adjustBusDataSet, Set<Object> busbillEntryIdSet) {
        HashSet<BadDebtCalculateVO> voList = new HashSet<BadDebtCalculateVO>(64);
        if (adjustBusDataSet != null) {
            for (Row row : adjustBusDataSet) {
                BadDebtCalculateVO vo = new BadDebtCalculateVO();
                vo.setBillType("ar_busbill");
                vo.setWoffBillEntryId(row.getLong("entry.id").longValue());
                vo.setBillId(row.getLong("entry.e_srcbillid").longValue());
                vo.setBillEntryId(row.getLong("entry.e_srcentryid").longValue());
                vo.setBalance(row.getBigDecimal("entry.e_recamount"));
                vo.setLocalBalance(row.getBigDecimal("entry.e_reclocalamt"));
                voList.add(vo);
                logger.info(String.format("BusArBadDebtBillHandler -- convertAdjustBusBillToVO \u51b2\u56de\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                busbillEntryIdSet.add(row.get("entry.e_srcentryid"));
            }
        }
        return voList;
    }

    private QFilter getUnexpectedBusFilter(Set<Object> busbillIdSet) {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filter.and(new QFilter("bookdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("entry.id", "in", busbillIdSet));
        return filter;
    }

    private String getCurrentPeriodAdjustBusSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("entry.id");
        selector.add("entry.e_srcbillid");
        selector.add("entry.e_srcentryid");
        selector.add("entry.e_recamount");
        selector.add("entry.e_reclocalamt");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getCurrentPeriodAdjustBusFliter(Set<Object> busbillIdSet) {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("entry.id", "in", busbillIdSet));
        filter.and(new QFilter("bookdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        return filter;
    }

    private Set<BadDebtCalculateVO> convertCurrentPeriodAdjustBusBillToVO(DataSet currentPeriodAdjustBusDataSet) {
        HashSet<BadDebtCalculateVO> voList = new HashSet<BadDebtCalculateVO>(64);
        if (currentPeriodAdjustBusDataSet != null) {
            for (Row row : currentPeriodAdjustBusDataSet) {
                BadDebtCalculateVO vo = new BadDebtCalculateVO();
                vo.setBillType("ar_busbill");
                vo.setWoffBillEntryId(row.getLong("entry.id").longValue());
                vo.setBillId(row.getLong("entry.e_srcbillid").longValue());
                vo.setBillEntryId(row.getLong("entry.e_srcentryid").longValue());
                vo.setBalance(BigDecimal.ZERO);
                vo.setLocalBalance(BigDecimal.ZERO);
                voList.add(vo);
                logger.info(String.format("BusArBadDebtBillHandler -- convertCurrentPeriodAdjustBusBillToVO \u5f53\u671f\u51b2\u56de\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
            }
        }
        return voList;
    }

    private List<BadDebtCommonVO> buildCommonBillVOByBus(DataSet busDataSet, LinkedHashMap<Object, BadDebtCommonVO> temporaryVOMap) {
        if (EmptyUtils.isNotEmpty((Object)busDataSet)) {
            for (Row row : busDataSet) {
                Object billId = row.get("id");
                Object entryId = row.get("entry.id");
                if (EmptyUtils.isEmpty((Object)temporaryVOMap.get(billId))) {
                    BadDebtCommonVO badDebtCommonVO = new BadDebtCommonVO(Long.valueOf(Long.parseLong(billId.toString())));
                    badDebtCommonVO.getEntryIds().add(Long.parseLong(entryId.toString()));
                    temporaryVOMap.put(billId, badDebtCommonVO);
                    continue;
                }
                temporaryVOMap.get(billId).getEntryIds().add(Long.parseLong(entryId.toString()));
            }
        }
        return new ArrayList<BadDebtCommonVO>(temporaryVOMap.values());
    }

    private QFilter getFilterByCommonVO(List<BadDebtCommonVO> subBillIds) {
        HashSet<Long> idSet = new HashSet<Long>(subBillIds.size());
        HashSet entryIdSet = new HashSet(subBillIds.size());
        for (BadDebtCommonVO badDebtCommonVO : subBillIds) {
            idSet.add(badDebtCommonVO.getId());
            entryIdSet.addAll(badDebtCommonVO.getEntryIds());
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and(new QFilter("entry.id", "in", entryIdSet));
        return filter;
    }

    private LinkedHashMap<Object, BadDebtCalculateVO> convertBusBillToVO(DataSet busDataSet) {
        LinkedHashMap<Object, BadDebtCalculateVO> billVOMap = new LinkedHashMap<Object, BadDebtCalculateVO>(64);
        if (busDataSet != null) {
            for (Row row : busDataSet) {
                BadDebtCalculateVO vo = new BadDebtCalculateVO();
                vo.setBillType("ar_busbill");
                vo.setBillId(row.getLong("id").longValue());
                vo.setBillEntryId(row.getLong("entry.id").longValue());
                vo.setBillNo(row.getString("billno"));
                vo.setAsstactType(row.getString("asstacttype"));
                vo.setAsstactId(row.getLong("asstact").longValue());
                vo.setRemark(row.getString("remark"));
                vo.setBizDate(row.getDate(this.badDebtContext.getAccrualScheme().getAgingDateEntity()));
                vo.setCurrencyId(row.getLong("currency").longValue());
                vo.setExrateTableId(row.getLong("exratetable").longValue());
                vo.setLocalBalance(row.getBigDecimal("entry.e_unwofflocamt"));
                vo.setMaterialId(row.getLong("entry.e_material").longValue());
                vo.setExpenseItemId(row.getLong("entry.e_expenseitem").longValue());
                vo.setBalance(row.getBigDecimal("entry.e_unwoffamt"));
                vo.setExchangeRate(row.getBigDecimal("exchangerate"));
                vo.setQuotation(row.getString("quotation"));
                vo.setRecamount(row.getBigDecimal("entry.e_recamount"));
                vo.setRecamountlocal(row.getBigDecimal("entry.e_reclocalamt"));
                vo.setExrateDate(row.getDate("exratedate"));
                AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
                DateTimeFormatter dateToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                StringBuilder offsetKey = new StringBuilder();
                if (accrualScheme.isOffset() && accrualScheme.getOffsetedField() != null && "ar_busbill".equals(accrualScheme.getOffsetBillEntity())) {
                    String key;
                    List offsetVoList = accrualScheme.getOffsetVoList();
                    HashMap<String, Boolean> nullMatch = new HashMap<String, Boolean>(8);
                    for (AccrualOffsetVo offsetVo : offsetVoList) {
                        nullMatch.put(offsetVo.getOffsetbillfield(), offsetVo.isNullmatch());
                    }
                    for (String ruleField : accrualScheme.getOffsetedField()) {
                        Object dimensionValue = row.get(ruleField);
                        if (EmptyUtils.isNotEmpty((Object)dimensionValue)) {
                            if (dimensionValue instanceof BigDecimal) {
                                offsetKey.append(((BigDecimal)dimensionValue).stripTrailingZeros().toPlainString());
                                continue;
                            }
                            if (dimensionValue instanceof Date) {
                                LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)dimensionValue).toInstant(), ZoneId.systemDefault());
                                offsetKey.append(localDateTime.format(dateToStringFormatter));
                                continue;
                            }
                            offsetKey.append(dimensionValue);
                            continue;
                        }
                        if (((Boolean)nullMatch.get(ruleField)).booleanValue()) {
                            offsetKey.append("NULL");
                            continue;
                        }
                        offsetKey = new StringBuilder();
                        break;
                    }
                    if (!"".equals(key = offsetKey.toString())) {
                        vo.setOffsetKey(offsetKey.toString());
                    }
                }
                this.extendFieldVoluation(vo, row);
                billVOMap.put(vo.getBillEntryId(), vo);
                logger.info(String.format("BusArBadDebtBillHandler -- convertBusBillToVO \u6682\u4f30\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
            }
        }
        return billVOMap;
    }

    private void recursionWoffBill(Map<Object, BadDebtCalculateVO> calculateVOMap, BadDebtCalculateVO recursionVO, BadDebtCalculateVO calculateVO) {
        Set woffBillEntryIdSet = recursionVO.getWoffBillEntryIdSet();
        woffBillEntryIdSet.add(recursionVO.getWoffBillEntryId());
        for (Long woffBillEntryId : woffBillEntryIdSet) {
            BadDebtCalculateVO woffVO = calculateVOMap.get(woffBillEntryId);
            if (woffVO == null) continue;
            this.recursionWoffBill(calculateVOMap, woffVO, calculateVO);
            calculateVO.setBalance(calculateVO.getBalance().add(woffVO.getBalance()));
            calculateVO.setLocalBalance(calculateVO.getLocalBalance().add(woffVO.getLocalBalance()));
            woffVO.setBalance(BigDecimal.ZERO);
            woffVO.setLocalBalance(BigDecimal.ZERO);
            logger.info(String.format("BusArBadDebtBillHandler -- recursionWoffBill \u591a\u6b21\u51b2\u56de\u91d1\u989d\u7d2f\u52a0\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", calculateVO.getBillType(), calculateVO.getBillId(), calculateVO.getBillEntryId(), calculateVO.getBalance(), calculateVO.getLocalBalance()));
        }
    }
}

