/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.baddebtnew;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.service.baddebtnew.AbstractBadDebtBillHandler;
import kd.fi.ar.business.service.baddebtnew.BadDebtContext;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.ar.vo.baddebtnew.BadDebtCalculateVO;
import kd.fi.ar.vo.baddebtnew.BadDebtCommonVO;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class FinArBadDebtBillHandler
extends AbstractBadDebtBillHandler {
    public FinArBadDebtBillHandler(BadDebtContext badDebtContext) {
        super(badDebtContext);
    }

    @Override
    public List<BadDebtCommonVO> getBillIds(Set<Long> prepareBillIds) {
        ArrayList<BadDebtCommonVO> resultOfBadDebtCommonVOs = new ArrayList<BadDebtCommonVO>(32);
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        QFilter accrualSchemeFilter = accrualScheme.getCondition();
        QFilter accruedBillIdFilter = new QFilter("id", "not in", prepareBillIds);
        String agingDate = accrualScheme.getAgingDateEntity();
        QFilter agingDateFilter = new QFilter(agingDate, "<=", (Object)DateUtils.getLastDay((Date)this.badDebtContext.getEndDate(), (int)accrualScheme.getAgingStartDay()));
        QFilter finFilter = this.getFinFilter();
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)(this.getFinIdSelector() + "," + agingDate), (QFilter[])new QFilter[]{finFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        DataSet unexpectedFinDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedFinFilter = this.getUnexpectedFinFilter(this.inverseBillIdSet);
            unexpectedFinDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)(this.getFinIdSelector() + "," + agingDate), (QFilter[])new QFilter[]{unexpectedFinFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        }
        DataSet allDataSet = EmptyUtils.isNotEmpty((Object)finDataSet) ? (EmptyUtils.isNotEmpty(unexpectedFinDataSet) ? finDataSet.union(unexpectedFinDataSet).orderBy(new String[]{agingDate}) : finDataSet) : unexpectedFinDataSet;
        resultOfBadDebtCommonVOs.addAll(this.buildCommonBillVOByBus(allDataSet, new LinkedHashMap<Object, BadDebtCommonVO>(32)));
        return resultOfBadDebtCommonVOs;
    }

    @Override
    public List<BadDebtCommonVO> getBillIds(Set<Long> prepareBillIds, Set<Long> prepareBillEntryIds) {
        ArrayList<BadDebtCommonVO> resultOfBadDebtCommonVOs = new ArrayList<BadDebtCommonVO>(32);
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        QFilter accrualSchemeFilter = accrualScheme.getCondition();
        QFilter accruedBillIdFilter = new QFilter("id", "not in", prepareBillIds);
        accruedBillIdFilter.and(this.getEntryIdKey(), "not in", prepareBillEntryIds);
        String agingDate = accrualScheme.getAgingDateEntity();
        QFilter agingDateFilter = new QFilter(agingDate, "<=", (Object)DateUtils.getLastDay((Date)this.badDebtContext.getEndDate(), (int)accrualScheme.getAgingStartDay()));
        QFilter finFilter = this.getFinFilter();
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)(this.getFinIdSelector() + "," + agingDate), (QFilter[])new QFilter[]{finFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        DataSet unexpectedFinDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedFinFilter = this.getUnexpectedFinFilter(this.inverseBillIdSet);
            unexpectedFinDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)(this.getFinIdSelector() + "," + agingDate), (QFilter[])new QFilter[]{unexpectedFinFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        }
        DataSet allDataSet = EmptyUtils.isNotEmpty((Object)finDataSet) ? (EmptyUtils.isNotEmpty(unexpectedFinDataSet) ? finDataSet.union(unexpectedFinDataSet).orderBy(new String[]{agingDate}) : finDataSet) : unexpectedFinDataSet;
        resultOfBadDebtCommonVOs.addAll(this.buildCommonBillVOByBus(allDataSet, new LinkedHashMap<Object, BadDebtCommonVO>(32)));
        return resultOfBadDebtCommonVOs;
    }

    @Override
    public LinkedHashMap<Object, BadDebtCalculateVO> getBills(List<BadDebtCommonVO> subBillIds) {
        Set<String> selector = this.getSelector();
        String agingDate = this.badDebtContext.getAccrualScheme().getAgingDateEntity();
        selector.add(agingDate);
        QFilter idAndEntryIdFilter = this.getFilterByCommonVO(subBillIds);
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)AdjustExchHelper.generateSelector(new ArrayList<String>(selector)), (QFilter[])idAndEntryIdFilter.toArray(), (String)agingDate);
        return this.convertFinBillToVO(finDataSet);
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getProcessBills() {
        ArrayList<BadDebtCalculateVO> badDebtCalculateVOs = new ArrayList<BadDebtCalculateVO>(8);
        String settleSelector = this.getSettleSelector();
        QFilter settleMainFilter = this.getSettleMainFilter();
        Object[] settleMainDatas = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleSelector, (QFilter[])settleMainFilter.toArray());
        Set<Object> settleMainDataSetIds = this.getSettleMainDataSetIds((DynamicObject[])settleMainDatas);
        QFilter settleAssistFilter = this.getSettleAssistFilter(settleMainDataSetIds);
        Object[] settleAssistDatas = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleSelector, (QFilter[])settleAssistFilter.toArray());
        DynamicObject[] settleRecordArr = (DynamicObject[])ArrayUtils.addAll((Object[])settleMainDatas, (Object[])settleAssistDatas);
        badDebtCalculateVOs.addAll(this.convertSettleBillToVO(settleRecordArr, this.inverseBillIdSet));
        HashMap<Object, BadDebtCalculateVO> processBillVOMap = new HashMap<Object, BadDebtCalculateVO>(64);
        for (BadDebtCalculateVO calculateVO : badDebtCalculateVOs) {
            BadDebtCalculateVO vo = (BadDebtCalculateVO)processBillVOMap.get(calculateVO.getBillEntryId());
            if (vo != null) {
                vo.setBalance(vo.getBalance().add(calculateVO.getBalance()));
                vo.setLocalBalance(vo.getLocalBalance().add(calculateVO.getLocalBalance()));
                logger.info(String.format("FinArBadDebtBillHandler -- getProcessBillVO \u8fc7\u7a0b\u5355\u636e\u91d1\u989d\u7d2f\u52a0\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                continue;
            }
            processBillVOMap.put(calculateVO.getBillEntryId(), calculateVO);
        }
        return processBillVOMap;
    }

    @Override
    public Set<String> getOriginSelector() {
        Set<String> selector = FinArBadDebtBillHandler.getBaseBillSelector();
        if (this.badDebtContext.isMaterialSettle()) {
            selector.add("entry.id");
            selector.add("entry.e_recamount");
            selector.add("entry.e_reclocalamt");
            selector.add("entry.e_material");
            selector.add("entry.e_expenseitem");
            selector.add("entry.e_unsettleamt");
            selector.add("entry.e_unsettlelocalamt");
        } else {
            selector.add("planentity.id");
            selector.add("planentity.unplansettleamt");
            selector.add("planentity.unplansettlelocamt");
            selector.add("planentity.planpricetax");
            selector.add("planentity.planpricetaxloc");
        }
        return selector;
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getBadDebtLossBill() {
        HashMap<Object, BadDebtCalculateVO> lossBillVOMap = new HashMap<Object, BadDebtCalculateVO>(64);
        String settleSelector = this.getSettleSelector();
        QFilter settleFilter = this.getSettleFilter();
        DynamicObject[] settleDatas = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleSelector, (QFilter[])new QFilter[]{settleFilter});
        if (settleDatas != null) {
            for (DynamicObject bill : settleDatas) {
                if (!"ar_finarbill".equals(bill.get("billentity"))) continue;
                BadDebtCalculateVO vo = new BadDebtCalculateVO();
                vo.setBillType("ap_settlerecord");
                vo.setBillId(bill.getLong("mainbillid"));
                vo.setBillEntryId(bill.getLong("mainbillentryid"));
                vo.setBalance(bill.getBigDecimal("totalsettleamt"));
                vo.setLocalBalance(bill.getBigDecimal("localtotalsettleamt"));
                BadDebtCalculateVO tempVO = (BadDebtCalculateVO)lossBillVOMap.get(vo.getBillEntryId());
                if (tempVO != null) {
                    tempVO.setBalance(tempVO.getBalance().add(vo.getBalance()));
                    tempVO.setLocalBalance(tempVO.getLocalBalance().add(vo.getLocalBalance()));
                    logger.info(String.format("FinArBadDebtBillHandler -- getBadDebtLossBill loss\u5355\u636e\u91d1\u989d\u7d2f\u52a0\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                    continue;
                }
                lossBillVOMap.put(vo.getBillEntryId(), vo);
            }
        }
        return lossBillVOMap;
    }

    private QFilter getSettleFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("settledate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("mainbizdate", "<", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("settlerelation", "=", (Object)SettleRelationEnum.BADDEBTLOSS.getValue()));
        if (!this.badDebtContext.isPeriod()) {
            filter.and(new QFilter("settledate", ">=", (Object)this.badDebtContext.getStartDate()));
        }
        return filter;
    }

    private QFilter getFilterByCommonVOForSettle(List<BadDebtCommonVO> badDebtCommonVOs) {
        HashSet<Long> idSet = new HashSet<Long>(badDebtCommonVOs.size());
        HashSet entryIdSet = new HashSet(badDebtCommonVOs.size());
        for (BadDebtCommonVO badDebtCommonVO : badDebtCommonVOs) {
            idSet.add(badDebtCommonVO.getId());
            entryIdSet.addAll(badDebtCommonVO.getEntryIds());
        }
        QFilter filter = new QFilter("mainbillid", "in", idSet);
        if (this.badDebtContext.isMaterialSettle()) {
            filter.and(new QFilter("mainbillentryid", "in", entryIdSet));
        }
        return filter;
    }

    private Set<BadDebtCalculateVO> convertSettleBillToVO(DynamicObject[] settleRecordArr, Set<Object> inverseBillIdSet) {
        HashSet<BadDebtCalculateVO> voList = new HashSet<BadDebtCalculateVO>(64);
        if (settleRecordArr != null) {
            for (DynamicObject bill : settleRecordArr) {
                if ("ar_finarbill".equals(bill.get("billentity"))) {
                    BadDebtCalculateVO vo = new BadDebtCalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(bill.getLong("mainbillid"));
                    vo.setBillEntryId(bill.getLong("mainbillentryid"));
                    vo.setBalance(bill.getBigDecimal("totalsettleamt"));
                    vo.setLocalBalance(bill.getBigDecimal("localtotalsettleamt"));
                    voList.add(vo);
                    logger.info(String.format("FinArBadDebtBillHandler -- convertSettleBillToVO \u8d22\u52a1\u7ed3\u7b97\u4e3b\u65b9\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                    inverseBillIdSet.add(vo.getBillEntryId());
                }
                ArrayList<String> notParticipateSettleRelation = new ArrayList<String>(3);
                notParticipateSettleRelation.add(SettleRelationEnum.PAYTRANS.getValue());
                notParticipateSettleRelation.add(SettleRelationEnum.ARTRANSFER.getValue());
                notParticipateSettleRelation.add(SettleRelationEnum.PREMSETTLE.getValue());
                if (notParticipateSettleRelation.contains(bill.getString("settlerelation"))) continue;
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    if (!"ar_finarbill".equals(entry.get("e_billentity"))) continue;
                    BadDebtCalculateVO vo = new BadDebtCalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(entry.getLong("billid"));
                    vo.setBillEntryId(entry.getLong("billentryid"));
                    vo.setBalance(entry.getBigDecimal("settleamt"));
                    vo.setLocalBalance(entry.getBigDecimal("localsettleamt"));
                    voList.add(vo);
                    logger.info(String.format("FinArBadDebtBillHandler -- convertSettleBillToVO \u8d22\u52a1\u7ed3\u7b97\u8f85\u65b9\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                    inverseBillIdSet.add(vo.getBillEntryId());
                }
            }
        }
        return voList;
    }

    @Override
    public String getEntityKey() {
        return "ar_finarbill";
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getOffsetBill() {
        return null;
    }

    private QFilter getFinFilter() {
        QFilter filter;
        if (this.badDebtContext.isPeriod()) {
            filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
            filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filter.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
            if (this.badDebtContext.isMaterialSettle()) {
                filter.and(new QFilter("entry.e_unsettleamt", "<>", (Object)0));
            } else {
                filter.and(new QFilter("planentity.unplansettleamt", "<>", (Object)0));
            }
        } else {
            filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
            filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filter.and(new QFilter("bookdate", "<=", (Object)this.badDebtContext.getEndDate()));
            if (this.badDebtContext.isMaterialSettle()) {
                filter.and(new QFilter("entry.e_unsettleamt", "<>", (Object)0));
            } else {
                filter.and(new QFilter("planentity.unplansettleamt", "<>", (Object)0));
            }
        }
        return filter;
    }

    private QFilter getUnexpectedFinFilter(Set<Object> finBillIdSet) {
        QFilter filter = new QFilter(this.getEntryIdKey(), "in", finBillIdSet);
        filter.and(new QFilter("bookdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("org", "=", (Object)this.badDebtContext.getOrgId()));
        return filter;
    }

    private List<BadDebtCommonVO> buildCommonBillVOByBus(DataSet finDataSet, LinkedHashMap<Object, BadDebtCommonVO> temporaryVOMap) {
        if (EmptyUtils.isNotEmpty((Object)finDataSet)) {
            for (Row row : finDataSet) {
                String idKey = this.getEntryIdKey();
                Object billId = row.get("id");
                Object entryId = row.get(idKey);
                if (EmptyUtils.isEmpty((Object)temporaryVOMap.get(billId))) {
                    BadDebtCommonVO badDebtCommonVO = new BadDebtCommonVO(Long.valueOf(Long.parseLong(billId.toString())));
                    badDebtCommonVO.getEntryIds().add(Long.parseLong(entryId.toString()));
                    temporaryVOMap.put(billId, badDebtCommonVO);
                    continue;
                }
                temporaryVOMap.get(billId).getEntryIds().add(Long.parseLong(entryId.toString()));
            }
        }
        return new ArrayList<BadDebtCommonVO>(temporaryVOMap.values());
    }

    private QFilter getFilterByCommonVO(List<BadDebtCommonVO> subBillIds) {
        HashSet<Long> idSet = new HashSet<Long>(subBillIds.size());
        HashSet entryIdSet = new HashSet(subBillIds.size());
        for (BadDebtCommonVO badDebtCommonVO : subBillIds) {
            idSet.add(badDebtCommonVO.getId());
            entryIdSet.addAll(badDebtCommonVO.getEntryIds());
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and(new QFilter(this.getEntryIdKey(), "in", entryIdSet));
        return filter;
    }

    private LinkedHashMap<Object, BadDebtCalculateVO> convertFinBillToVO(DataSet finDataSet) {
        LinkedHashMap<Object, BadDebtCalculateVO> billVOMap = new LinkedHashMap<Object, BadDebtCalculateVO>(64);
        if (finDataSet != null) {
            for (Row row : finDataSet) {
                BadDebtCalculateVO vo = new BadDebtCalculateVO();
                vo.setBillType("ar_finarbill");
                vo.setBillId(row.getLong("id").longValue());
                vo.setBillEntryId(row.getLong(this.getEntryIdKey()).longValue());
                vo.setBillNo(row.getString("billno"));
                vo.setAsstactType(row.getString("asstacttype"));
                vo.setAsstactId(row.getLong("asstact").longValue());
                vo.setRemark(row.getString("remark"));
                vo.setBizDate(row.getDate(this.badDebtContext.getAccrualScheme().getAgingDateEntity()));
                vo.setCurrencyId(row.getLong("currency").longValue());
                vo.setExrateTableId(row.getLong("exratetable").longValue());
                vo.setExchangeRate(row.getBigDecimal("exchangerate"));
                vo.setQuotation(row.getString("quotation"));
                vo.setExrateDate(row.getDate("exratedate"));
                if (this.badDebtContext.isMaterialSettle()) {
                    vo.setBalance(row.getBigDecimal("entry.e_unsettleamt"));
                    vo.setLocalBalance(row.getBigDecimal("entry.e_unsettlelocalamt"));
                    vo.setMaterialId(row.getLong("entry.e_material").longValue());
                    vo.setExpenseItemId(row.getLong("entry.e_expenseitem").longValue());
                    vo.setRecamount(row.getBigDecimal("entry.e_recamount"));
                    vo.setRecamountlocal(row.getBigDecimal("entry.e_reclocalamt"));
                } else {
                    vo.setLocalBalance(row.getBigDecimal("planentity.unplansettlelocamt"));
                    vo.setBalance(row.getBigDecimal("planentity.unplansettleamt"));
                    vo.setRecamount(row.getBigDecimal("planentity.planpricetax"));
                    vo.setRecamountlocal(row.getBigDecimal("planentity.planpricetaxloc"));
                }
                AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
                DateTimeFormatter dateToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                StringBuilder offsetKey = new StringBuilder();
                if (accrualScheme.isOffset() && accrualScheme.getOffsetedField() != null && "ar_finarbill".equals(accrualScheme.getOffsetBillEntity())) {
                    String key;
                    List offsetVoList = accrualScheme.getOffsetVoList();
                    HashMap<String, Boolean> nullMatch = new HashMap<String, Boolean>(8);
                    for (AccrualOffsetVo offsetVo : offsetVoList) {
                        nullMatch.put(offsetVo.getOffsetbillfield(), offsetVo.isNullmatch());
                    }
                    for (String ruleField : accrualScheme.getOffsetedField()) {
                        Object dimensionValue = row.get(ruleField);
                        if (EmptyUtils.isNotEmpty((Object)dimensionValue)) {
                            if (dimensionValue instanceof BigDecimal) {
                                offsetKey.append(((BigDecimal)dimensionValue).stripTrailingZeros().toPlainString());
                                continue;
                            }
                            if (dimensionValue instanceof Date) {
                                LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)dimensionValue).toInstant(), ZoneId.systemDefault());
                                offsetKey.append(localDateTime.format(dateToStringFormatter));
                                continue;
                            }
                            offsetKey.append(dimensionValue);
                            continue;
                        }
                        if (((Boolean)nullMatch.get(ruleField)).booleanValue()) {
                            offsetKey.append("NULL");
                            continue;
                        }
                        offsetKey = new StringBuilder();
                        break;
                    }
                    if (!"".equals(key = offsetKey.toString())) {
                        vo.setOffsetKey(offsetKey.toString());
                    }
                }
                this.extendFieldVoluation(vo, row);
                billVOMap.put(vo.getBillEntryId(), vo);
            }
        }
        return billVOMap;
    }

    private String getSettleSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("billentity");
        selector.add("settledate");
        selector.add("totalsettleamt");
        selector.add("localtotalsettleamt");
        selector.add("mainbillid");
        selector.add("mainbillentryid");
        selector.add("settlerelation");
        selector.add("entry.e_billentity");
        selector.add("entry.settleamt");
        selector.add("entry.localsettleamt");
        selector.add("entry.billid");
        selector.add("entry.billentryid");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getSettleMainFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("settledate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("mainbizdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    private Set<Object> getSettleMainDataSetIds(DynamicObject[] settleMainDatas) {
        HashSet<Object> set = new HashSet<Object>(16);
        if (EmptyUtils.isNotEmpty((Object)settleMainDatas)) {
            for (DynamicObject data : settleMainDatas) {
                Object billId = data.getPkValue();
                set.add(billId);
            }
        }
        return set;
    }

    private QFilter getSettleAssistFilter(Set<Object> settleMainDataSetIds) {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("id", "not in", settleMainDataSetIds));
        filter.and(new QFilter("settledate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.e_billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("entry.billdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    private String getFinIdSelector() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("id");
        selectors.add(this.getEntryIdKey());
        return StringUtils.join(selectors, (String)",");
    }

    private String getEntryIdKey() {
        return this.badDebtContext.isMaterialSettle() ? "entry.id" : "planentity.id";
    }
}

