/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.baddebtnew;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.service.baddebtnew.AbstractBadDebtBillHandler;
import kd.fi.ar.business.service.baddebtnew.BadDebtContext;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.ar.vo.baddebtnew.BadDebtCalculateVO;
import kd.fi.ar.vo.baddebtnew.BadDebtCommonVO;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class PaymentBadDebtBillHandler
extends AbstractBadDebtBillHandler {
    public PaymentBadDebtBillHandler(BadDebtContext badDebtContext) {
        super(badDebtContext);
    }

    @Override
    public List<BadDebtCommonVO> getBillIds(Set<Long> prepareBillIds) {
        ArrayList<BadDebtCommonVO> resultOfCommonBillVOS = new ArrayList<BadDebtCommonVO>(32);
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        QFilter accrualSchemeFilter = accrualScheme.getCondition();
        QFilter accruedBillIdFilter = new QFilter("id", "not in", prepareBillIds);
        String agingDate = accrualScheme.getAgingDateEntity();
        QFilter agingDateFilter = new QFilter(agingDate, "<=", (Object)DateUtils.getLastDay((Date)this.badDebtContext.getEndDate(), (int)accrualScheme.getAgingStartDay()));
        QFilter paymentFilter = this.getPaymentFilter();
        DataSet paymentDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{accrualSchemeFilter, paymentFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        DataSet unexpectedPaymentDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedPaymentFilter = this.getUnexpectedPaymentFilter(this.inverseBillIdSet);
            unexpectedPaymentDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{accrualSchemeFilter, unexpectedPaymentFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        }
        DataSet allDataSet = EmptyUtils.isNotEmpty((Object)paymentDataSet) ? (EmptyUtils.isNotEmpty(unexpectedPaymentDataSet) ? paymentDataSet.union(unexpectedPaymentDataSet).orderBy(new String[]{agingDate}) : paymentDataSet) : unexpectedPaymentDataSet;
        resultOfCommonBillVOS.addAll(this.buildCommonBillVOByPayment(allDataSet, new LinkedHashMap<Object, BadDebtCommonVO>(32)));
        return resultOfCommonBillVOS;
    }

    @Override
    public List<BadDebtCommonVO> getBillIds(Set<Long> prepareBillIds, Set<Long> prepareBillEntryIds) {
        ArrayList<BadDebtCommonVO> resultOfCommonBillVOS = new ArrayList<BadDebtCommonVO>(32);
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        QFilter accrualSchemeFilter = accrualScheme.getCondition();
        QFilter accruedBillIdFilter = new QFilter("id", "not in", prepareBillIds);
        accruedBillIdFilter.and("entry.id", "not in", prepareBillEntryIds);
        String agingDate = accrualScheme.getAgingDateEntity();
        QFilter agingDateFilter = new QFilter(agingDate, "<=", (Object)DateUtils.getLastDay((Date)this.badDebtContext.getEndDate(), (int)accrualScheme.getAgingStartDay()));
        QFilter paymentFilter = this.getPaymentFilter();
        DataSet paymentDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{accrualSchemeFilter, paymentFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        DataSet unexpectedPaymentDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedPaymentFilter = this.getUnexpectedPaymentFilter(this.inverseBillIdSet);
            unexpectedPaymentDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{accrualSchemeFilter, unexpectedPaymentFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        }
        DataSet allDataSet = EmptyUtils.isNotEmpty((Object)paymentDataSet) ? (EmptyUtils.isNotEmpty(unexpectedPaymentDataSet) ? paymentDataSet.union(unexpectedPaymentDataSet).orderBy(new String[]{agingDate}) : paymentDataSet) : unexpectedPaymentDataSet;
        resultOfCommonBillVOS.addAll(this.buildCommonBillVOByPayment(allDataSet, new LinkedHashMap<Object, BadDebtCommonVO>(32)));
        return resultOfCommonBillVOS;
    }

    @Override
    public LinkedHashMap<Object, BadDebtCalculateVO> getBills(List<BadDebtCommonVO> subBillIds) {
        Set<String> selector = this.getSelector();
        String agingDate = this.badDebtContext.getAccrualScheme().getAgingDateEntity();
        selector.add(agingDate);
        QFilter idAndEntryIdFilter = this.getFilterByCommonVO(subBillIds);
        DataSet paymentDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)AdjustExchHelper.generateSelector(new ArrayList<String>(selector)), (QFilter[])idAndEntryIdFilter.toArray(), (String)agingDate);
        return this.convertPaymentBillToVO(paymentDataSet);
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getProcessBills() {
        ArrayList<BadDebtCalculateVO> badDebtCalculateVOs = new ArrayList<BadDebtCalculateVO>(8);
        String settleSelector = this.getSettleSelector();
        QFilter settleMainFilter = this.getSettleMainFilter();
        Object[] settleMainDatas = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleSelector, (QFilter[])settleMainFilter.toArray());
        Set<Object> settleMainDataSetIds = this.getSettleMainDataSetIds((DynamicObject[])settleMainDatas);
        QFilter settleAssistFilter = this.getSettleAssistFilter(settleMainDataSetIds);
        Object[] settleAssistDatas = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleSelector, (QFilter[])settleAssistFilter.toArray());
        DynamicObject[] settleRecordArr = (DynamicObject[])ArrayUtils.addAll((Object[])settleMainDatas, (Object[])settleAssistDatas);
        badDebtCalculateVOs.addAll(this.convertSettleBillToVO(settleRecordArr, this.inverseBillIdSet));
        HashMap<Object, BadDebtCalculateVO> processBillVOMap = new HashMap<Object, BadDebtCalculateVO>(64);
        for (BadDebtCalculateVO calculateVO : badDebtCalculateVOs) {
            BadDebtCalculateVO vo = (BadDebtCalculateVO)processBillVOMap.get(calculateVO.getBillEntryId());
            if (vo != null) {
                vo.setBalance(vo.getBalance().add(calculateVO.getBalance()));
                vo.setLocalBalance(vo.getLocalBalance().add(calculateVO.getLocalBalance()));
                logger.info(String.format("PaymentBadDebtBillHandler -- getProcessBillVO \u8fc7\u7a0b\u5355\u636e\u91d1\u989d\u7d2f\u52a0\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                continue;
            }
            processBillVOMap.put(calculateVO.getBillEntryId(), calculateVO);
        }
        return processBillVOMap;
    }

    @Override
    public Set<String> getOriginSelector() {
        HashSet<String> selector = new HashSet<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("exratetable");
        selector.add("exratedate");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("payeetype");
        selector.add("payee");
        selector.add("description");
        selector.add("payquotation");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unsettledamt");
        selector.add("entry.e_unsettledlocalamt");
        selector.add("entry.e_payableamt");
        selector.add("entry.e_payablelocamt");
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        if (accrualScheme.isOffset() && accrualScheme.getOffsetedField() != null && "cas_paybill".equals(accrualScheme.getOffsetBillEntity())) {
            selector.addAll(accrualScheme.getOffsetedField());
        }
        return selector;
    }

    @Override
    public String getEntityKey() {
        return "cas_paybill";
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getOffsetBill() {
        return null;
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getBadDebtLossBill() {
        return null;
    }

    private QFilter getPaymentFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"D");
        filter.and(new QFilter("bizdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.e_paymenttype.biztype", "=", (Object)"202"));
        filter.and(new QFilter("entry.e_paymenttype.ispartpayment", "=", (Object)"1"));
        filter.and(new QFilter("entry.settleorg", "=", (Object)this.badDebtContext.getOrgId()));
        filter.and(new QFilter("entry.e_unsettledamt", "<>", (Object)0));
        return filter;
    }

    private QFilter getUnexpectedPaymentFilter(Set<Object> paymentBillIdSet) {
        QFilter filter = new QFilter("entry.id", "in", paymentBillIdSet);
        filter.and(new QFilter("bizdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("org", "=", (Object)this.badDebtContext.getOrgId()));
        return filter;
    }

    private List<BadDebtCommonVO> buildCommonBillVOByPayment(DataSet paymentDataSet, LinkedHashMap<Object, BadDebtCommonVO> temporaryVOMap) {
        if (EmptyUtils.isNotEmpty((Object)paymentDataSet)) {
            for (Row row : paymentDataSet) {
                Object billId = row.get("id");
                Object entryId = row.get("entry.id");
                if (EmptyUtils.isEmpty((Object)temporaryVOMap.get(billId))) {
                    BadDebtCommonVO commonBillVO = new BadDebtCommonVO(Long.valueOf(Long.parseLong(billId.toString())));
                    commonBillVO.getEntryIds().add(Long.parseLong(entryId.toString()));
                    temporaryVOMap.put(billId, commonBillVO);
                    continue;
                }
                temporaryVOMap.get(billId).getEntryIds().add(Long.parseLong(entryId.toString()));
            }
        }
        return new ArrayList<BadDebtCommonVO>(temporaryVOMap.values());
    }

    private QFilter getFilterByCommonVO(List<BadDebtCommonVO> subbillids) {
        HashSet<Long> idSet = new HashSet<Long>(subbillids.size());
        HashSet entryIdSet = new HashSet(subbillids.size());
        for (BadDebtCommonVO commonBillVO : subbillids) {
            idSet.add(commonBillVO.getId());
            entryIdSet.addAll(commonBillVO.getEntryIds());
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and(new QFilter("entry.id", "in", entryIdSet));
        return filter;
    }

    private LinkedHashMap<Object, BadDebtCalculateVO> convertPaymentBillToVO(DataSet paymentDataSet) {
        LinkedHashMap<Object, BadDebtCalculateVO> billVOMap = new LinkedHashMap<Object, BadDebtCalculateVO>(64);
        if (paymentDataSet != null) {
            for (Row row : paymentDataSet) {
                BadDebtCalculateVO vo = new BadDebtCalculateVO();
                vo.setBillType("cas_paybill");
                vo.setBillId(row.getLong("id").longValue());
                vo.setBillEntryId(row.getLong("entry.id").longValue());
                vo.setBillNo(row.getString("billno"));
                vo.setAsstactType(row.getString("payeetype"));
                vo.setAsstactId(row.getLong("payee").longValue());
                vo.setRemark(row.getString("description"));
                vo.setBizDate(row.getDate(this.badDebtContext.getAccrualScheme().getAgingDateEntity()));
                vo.setCurrencyId(row.getLong("currency").longValue());
                vo.setExrateTableId(row.getLong("exratetable").longValue());
                vo.setMaterialId(row.getLong("entry.e_material").longValue());
                vo.setExpenseItemId(row.getLong("entry.e_expenseitem").longValue());
                vo.setBalance(row.getBigDecimal("entry.e_unsettledamt"));
                vo.setLocalBalance(row.getBigDecimal("entry.e_unsettledlocalamt"));
                vo.setExchangeRate(row.getBigDecimal("exchangerate"));
                vo.setQuotation(row.getString("payquotation"));
                vo.setRecamount(row.getBigDecimal("entry.e_payableamt"));
                vo.setRecamountlocal(row.getBigDecimal("entry.e_payablelocamt"));
                vo.setExrateDate(row.getDate("exratedate"));
                AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
                DateTimeFormatter dateToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                StringBuilder offsetKey = new StringBuilder();
                if (accrualScheme.isOffset() && accrualScheme.getOffsetedField() != null && "cas_paybill".equals(accrualScheme.getOffsetBillEntity())) {
                    String key;
                    List offsetVoList = accrualScheme.getOffsetVoList();
                    HashMap<String, Boolean> nullMatch = new HashMap<String, Boolean>(8);
                    for (AccrualOffsetVo offsetVo : offsetVoList) {
                        nullMatch.put(offsetVo.getOffsetbillfield(), offsetVo.isNullmatch());
                    }
                    for (String ruleField : accrualScheme.getOffsetedField()) {
                        Object dimensionValue = row.get(ruleField);
                        if (EmptyUtils.isNotEmpty((Object)dimensionValue)) {
                            if (dimensionValue instanceof BigDecimal) {
                                offsetKey.append(((BigDecimal)dimensionValue).stripTrailingZeros().toPlainString());
                                continue;
                            }
                            if (dimensionValue instanceof Date) {
                                LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)dimensionValue).toInstant(), ZoneId.systemDefault());
                                offsetKey.append(localDateTime.format(dateToStringFormatter));
                                continue;
                            }
                            offsetKey.append(dimensionValue);
                            continue;
                        }
                        if (((Boolean)nullMatch.get(ruleField)).booleanValue()) {
                            offsetKey.append("NULL");
                            continue;
                        }
                        offsetKey = new StringBuilder();
                        break;
                    }
                    if (!"".equals(key = offsetKey.toString())) {
                        vo.setOffsetKey(offsetKey.toString());
                    }
                }
                this.extendFieldVoluation(vo, row);
                billVOMap.put(vo.getBillEntryId(), vo);
                logger.info(String.format("PaymentBadDebtBillHandler -- convertPaymentBillToVO \u4ed8\u6b3e: (BillId -- %s),(BillEntryId -- %s),(Balance -- %s),(ExchangeRate -- %s),(CalculateResult(\u65e0\u622a\u53d6) -- %s),(LoaclBalance -- %s)", vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getExchangeRate(), vo.getBalance().multiply(vo.getExchangeRate()), vo.getLocalBalance()));
            }
        }
        return billVOMap;
    }

    private String getSettleSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("billentity");
        selector.add("settledate");
        selector.add("totalsettleamt");
        selector.add("localtotalsettleamt");
        selector.add("mainbillid");
        selector.add("mainbillentryid");
        selector.add("settlerelation");
        selector.add("paypropertyfield");
        selector.add("paypropertytype");
        selector.add("entry.e_billentity");
        selector.add("entry.settleamt");
        selector.add("entry.localsettleamt");
        selector.add("entry.billid");
        selector.add("entry.billentryid");
        selector.add("entry.e_paypropertyfield");
        selector.add("entry.e_paypropertytype");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getSettleMainFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("settledate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("mainbizdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    private Set<Object> getSettleMainDataSetIds(DynamicObject[] settleMainDatas) {
        HashSet<Object> set = new HashSet<Object>(16);
        if (EmptyUtils.isNotEmpty((Object)settleMainDatas)) {
            for (DynamicObject data : settleMainDatas) {
                Object billId = data.getPkValue();
                set.add(billId);
            }
        }
        return set;
    }

    private QFilter getSettleAssistFilter(Set<Object> settleMainDataSetIds) {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("id", "not in", settleMainDataSetIds));
        filter.and(new QFilter("settledate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.e_billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("entry.billdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    private Set<BadDebtCalculateVO> convertSettleBillToVO(DynamicObject[] settleRecordArr, Set<Object> inverseBillIdSet) {
        HashSet<BadDebtCalculateVO> voList = new HashSet<BadDebtCalculateVO>(64);
        if (settleRecordArr != null) {
            for (DynamicObject bill : settleRecordArr) {
                String paypropertyType;
                DynamicObject paypropertyField;
                if ("cas_paybill".equals(bill.get("billentity")) && this.isPaidBillType(paypropertyField = bill.getDynamicObject("paypropertyfield"), paypropertyType = bill.getString("paypropertytype"))) {
                    BadDebtCalculateVO vo = new BadDebtCalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(bill.getLong("mainbillid"));
                    vo.setBillEntryId(bill.getLong("mainbillentryid"));
                    vo.setBalance(bill.getBigDecimal("totalsettleamt"));
                    vo.setLocalBalance(bill.getBigDecimal("localtotalsettleamt"));
                    voList.add(vo);
                    logger.info(String.format("PaymentBadDebtBillHandler -- convertSettleBillToVO \u4ed8\u6b3e\u7ed3\u7b97\u4e3b\u65b9\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                    inverseBillIdSet.add(vo.getBillEntryId());
                }
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    if (!"cas_paybill".equals(entry.get("e_billentity"))) continue;
                    String paypropertyType2 = entry.getString("e_paypropertytype");
                    DynamicObject paypropertyField2 = entry.getDynamicObject("e_paypropertyfield");
                    if (!this.isPaidBillType(paypropertyField2, paypropertyType2)) continue;
                    BadDebtCalculateVO vo = new BadDebtCalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(entry.getLong("billid"));
                    vo.setBillEntryId(entry.getLong("billentryid"));
                    vo.setBalance(entry.getBigDecimal("settleamt"));
                    vo.setLocalBalance(entry.getBigDecimal("localsettleamt"));
                    voList.add(vo);
                    logger.info(String.format("PaymentBadDebtBillHandler -- convertSettleBillToVO \u4ed8\u6b3e\u7ed3\u7b97\u8f85\u65b9\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                    inverseBillIdSet.add(vo.getBillEntryId());
                }
            }
        }
        return voList;
    }

    private boolean isPaidBillType(DynamicObject paypropertyField, String paypropertyType) {
        if (paypropertyField == null || paypropertyType == null) {
            return false;
        }
        if ("cas_paymentbilltype".equals(paypropertyType)) {
            return "202".equals(paypropertyField.getString("number"));
        }
        return false;
    }
}

