/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.baddebtnew;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.service.baddebtnew.AbstractBadDebtOffsetHandler;
import kd.fi.ar.business.service.baddebtnew.BadDebtContext;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.ar.vo.baddebtnew.BadDebtCalculateVO;
import kd.fi.ar.vo.baddebtnew.BadDebtCommonVO;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class RecBillOffsetHandler
extends AbstractBadDebtOffsetHandler {
    public RecBillOffsetHandler(BadDebtContext badDebtContext) {
        super(badDebtContext);
    }

    @Override
    public List<BadDebtCommonVO> getBillIds() {
        ArrayList<BadDebtCommonVO> resultOfBadDebtCommonVOs = new ArrayList<BadDebtCommonVO>(32);
        HashMap<Object, BadDebtCommonVO> temporaryVOMap = new HashMap<Object, BadDebtCommonVO>(32);
        QFilter recFilter = this.getRecFilter();
        DataSet recDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)"id,entry.id", (QFilter[])recFilter.toArray(), (String)"bizdate");
        DataSet unexpectedRecDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedRecFilter = this.getUnexpectedRecFilter(this.inverseBillIdSet);
            unexpectedRecDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)"id,entry.id", (QFilter[])unexpectedRecFilter.toArray(), (String)"");
        }
        this.buildCommonBillVOByRec(recDataSet, temporaryVOMap);
        this.buildCommonBillVOByRec(unexpectedRecDataSet, temporaryVOMap);
        resultOfBadDebtCommonVOs.addAll(temporaryVOMap.values());
        return resultOfBadDebtCommonVOs;
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getBills(List<BadDebtCommonVO> subBillIds) {
        Set<String> selector = this.getSelector();
        QFilter idAndEntryIdFilter = this.getFilterByCommonBillVO(subBillIds);
        DataSet recDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)AdjustExchHelper.generateSelector(new ArrayList<String>(selector)), (QFilter[])idAndEntryIdFilter.toArray(), (String)"bizdate");
        return this.convertRecBillToVO(recDataSet);
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getProcessBills() {
        String settleSelector = this.getSettleSelector();
        QFilter settleMainFilter = this.getSettleMainFilter();
        Object[] settleMainDatas = BusinessDataServiceHelper.load((String)"ar_settlerecord", (String)settleSelector, (QFilter[])settleMainFilter.toArray());
        Set<Object> settleMainDataSetIds = this.getSettleMainDataSetIds((DynamicObject[])settleMainDatas);
        QFilter settleAssistFilter = this.getSettleAssistFilter(settleMainDataSetIds);
        Object[] settleAssistDatas = BusinessDataServiceHelper.load((String)"ar_settlerecord", (String)settleSelector, (QFilter[])settleAssistFilter.toArray());
        DynamicObject[] settleRecordArr = (DynamicObject[])ArrayUtils.addAll((Object[])settleMainDatas, (Object[])settleAssistDatas);
        HashMap<Object, BadDebtCalculateVO> processBillVOMap = new HashMap<Object, BadDebtCalculateVO>(64);
        List<BadDebtCalculateVO> calculateVOS = this.convertSettleBillToVO(settleRecordArr, this.inverseBillIdSet);
        for (BadDebtCalculateVO calculateVO : calculateVOS) {
            BadDebtCalculateVO vo = (BadDebtCalculateVO)processBillVOMap.get(calculateVO.getBillEntryId());
            if (vo != null) {
                vo.setBalance(vo.getBalance().add(calculateVO.getBalance()));
                vo.setLocalBalance(vo.getLocalBalance().add(calculateVO.getLocalBalance()));
                logger.info(String.format("RecBillOffsetHandler -- getProcessBills \u8fc7\u7a0b\u5355\u636e\u91d1\u989d\u7d2f\u52a0\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                continue;
            }
            processBillVOMap.put(calculateVO.getBillEntryId(), calculateVO);
        }
        return processBillVOMap;
    }

    @Override
    public Set<String> getOriginSelector() {
        HashSet<String> selector = new HashSet<String>(8);
        selector.add("id");
        selector.add("billno");
        selector.add("entry.id");
        selector.add("entry.e_unsettledamt");
        selector.addAll(this.badDebtContext.getOffsetFieldSelectorForRec());
        return selector;
    }

    @Override
    public String getEntityKey() {
        return "cas_recbill";
    }

    private QFilter getRecFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"D");
        filter.and(new QFilter("bizdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.e_receivingtype.biztype", "=", (Object)"101"));
        filter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)"1"));
        filter.and(new QFilter("entry.e_settleorg", "=", (Object)this.badDebtContext.getOrgId()));
        filter.and(new QFilter("entry.e_unsettledamt", "<>", (Object)0));
        return filter;
    }

    private String getSettleSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("billentity");
        selector.add("settledate");
        selector.add("totalsettleamt");
        selector.add("localtotalsettleamt");
        selector.add("mainbillid");
        selector.add("mainbillentryid");
        selector.add("settlerelation");
        selector.add("paypropertyfield");
        selector.add("paypropertytype");
        selector.add("entry.e_billentity");
        selector.add("entry.settleamt");
        selector.add("entry.localsettleamt");
        selector.add("entry.billid");
        selector.add("entry.billentryid");
        selector.add("entry.e_paypropertyfield");
        selector.add("entry.e_paypropertytype");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getSettleMainFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("settledate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("mainbizdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    private Set<Object> getSettleMainDataSetIds(DynamicObject[] settleMainDatas) {
        HashSet<Object> set = new HashSet<Object>(16);
        if (EmptyUtils.isNotEmpty((Object)settleMainDatas)) {
            for (DynamicObject data : settleMainDatas) {
                Object billId = data.getPkValue();
                set.add(billId);
            }
        }
        return set;
    }

    private QFilter getSettleAssistFilter(Set<Object> settleMainDataSetIds) {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("id", "not in", settleMainDataSetIds));
        filter.and(new QFilter("settledate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.e_billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("entry.billdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    private List<BadDebtCalculateVO> convertSettleBillToVO(DynamicObject[] settleRecordArr, Set<Object> inverseBillIdSet) {
        ArrayList<BadDebtCalculateVO> voList = new ArrayList<BadDebtCalculateVO>(8);
        if (settleRecordArr != null) {
            for (DynamicObject bill : settleRecordArr) {
                String paypropertyType;
                DynamicObject paypropertyField;
                if ("cas_recbill".equals(bill.get("billentity")) && this.isReceivedBillType(paypropertyField = bill.getDynamicObject("paypropertyfield"), paypropertyType = bill.getString("paypropertytype"))) {
                    BadDebtCalculateVO vo = new BadDebtCalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(bill.getLong("mainbillid"));
                    vo.setBillEntryId(bill.getLong("mainbillentryid"));
                    vo.setBalance(bill.getBigDecimal("totalsettleamt"));
                    vo.setLocalBalance(bill.getBigDecimal("localtotalsettleamt"));
                    voList.add(vo);
                    logger.info(String.format("RecBillOffsetHandler -- convertSettleBillToVO \u9884\u6536\u7ed3\u7b97\u4e3b\u65b9\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                    inverseBillIdSet.add(vo.getBillEntryId());
                }
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    String paypropertyType2;
                    DynamicObject paypropertyField2;
                    if (!"cas_recbill".equals(entry.get("e_billentity")) || !this.isReceivedBillType(paypropertyField2 = entry.getDynamicObject("e_paypropertyfield"), paypropertyType2 = entry.getString("e_paypropertytype"))) continue;
                    BadDebtCalculateVO vo = new BadDebtCalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(entry.getLong("billid"));
                    vo.setBillEntryId(entry.getLong("billentryid"));
                    vo.setBalance(entry.getBigDecimal("settleamt"));
                    vo.setLocalBalance(entry.getBigDecimal("localsettleamt"));
                    voList.add(vo);
                    logger.info(String.format("RecBillOffsetHandler -- convertSettleBillToVO \u9884\u6536\u7ed3\u7b97\u8f85\u65b9\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                    inverseBillIdSet.add(vo.getBillEntryId());
                }
            }
        }
        return voList;
    }

    private QFilter getUnexpectedRecFilter(Set<Object> recBillIdSet) {
        QFilter filter = new QFilter("entry.id", "in", recBillIdSet);
        filter.and(new QFilter("bizdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("org", "=", (Object)this.badDebtContext.getOrgId()));
        return filter;
    }

    private List<BadDebtCommonVO> buildCommonBillVOByRec(DataSet recDataSet, Map<Object, BadDebtCommonVO> temporaryVOMap) {
        if (EmptyUtils.isNotEmpty((Object)recDataSet)) {
            for (Row row : recDataSet) {
                Object billId = row.get("id");
                Object entryId = row.get("entry.id");
                if (EmptyUtils.isEmpty((Object)temporaryVOMap.get(billId))) {
                    BadDebtCommonVO commonBillVO = new BadDebtCommonVO(Long.valueOf(Long.parseLong(billId.toString())));
                    commonBillVO.getEntryIds().add(Long.parseLong(entryId.toString()));
                    temporaryVOMap.put(billId, commonBillVO);
                    continue;
                }
                temporaryVOMap.get(billId).getEntryIds().add(Long.parseLong(entryId.toString()));
            }
        }
        return new ArrayList<BadDebtCommonVO>(temporaryVOMap.values());
    }

    private QFilter getFilterByCommonBillVO(List<BadDebtCommonVO> subbillids) {
        HashSet<Long> idSet = new HashSet<Long>(subbillids.size());
        HashSet entryIdSet = new HashSet(subbillids.size());
        for (BadDebtCommonVO commonBillVO : subbillids) {
            idSet.add(commonBillVO.getId());
            entryIdSet.addAll(commonBillVO.getEntryIds());
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and(new QFilter("entry.id", "in", entryIdSet));
        return filter;
    }

    private Map<Object, BadDebtCalculateVO> convertRecBillToVO(DataSet recDataSet) {
        HashMap<Object, BadDebtCalculateVO> billVOMap = new HashMap<Object, BadDebtCalculateVO>(64);
        if (recDataSet != null) {
            for (Row row : recDataSet) {
                String key;
                BadDebtCalculateVO vo = new BadDebtCalculateVO();
                vo.setBillType("cas_recbill");
                vo.setBillId(row.getLong("id").longValue());
                vo.setBillNo(row.getString("billno"));
                vo.setBillEntryId(row.getLong("entry.id").longValue());
                vo.setBalance(row.getBigDecimal("entry.e_unsettledamt"));
                vo.setLocalBalance(BigDecimal.ZERO);
                vo.setExchangeRate(BigDecimal.ONE);
                vo.setRecamount(row.getBigDecimal("entry.e_unsettledamt"));
                AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
                DateTimeFormatter dateToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                StringBuilder offsetKey = new StringBuilder();
                List offsetVoList = accrualScheme.getOffsetVoList();
                HashMap<String, Boolean> nullMatch = new HashMap<String, Boolean>(8);
                for (AccrualOffsetVo offsetVo : offsetVoList) {
                    nullMatch.put(offsetVo.getRecbillfield(), offsetVo.isNullmatch());
                }
                for (String ruleField : accrualScheme.getOffsetFieldForRecBill()) {
                    Object dimensionValue = row.get(ruleField);
                    if (EmptyUtils.isNotEmpty((Object)dimensionValue)) {
                        if (dimensionValue instanceof BigDecimal) {
                            offsetKey.append(((BigDecimal)dimensionValue).stripTrailingZeros().toPlainString());
                            continue;
                        }
                        if (dimensionValue instanceof Date) {
                            LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)dimensionValue).toInstant(), ZoneId.systemDefault());
                            offsetKey.append(localDateTime.format(dateToStringFormatter));
                            continue;
                        }
                        offsetKey.append(dimensionValue);
                        continue;
                    }
                    if (((Boolean)nullMatch.get(ruleField)).booleanValue()) {
                        offsetKey.append("NULL");
                        continue;
                    }
                    offsetKey = new StringBuilder();
                    break;
                }
                if (!"".equals(key = offsetKey.toString())) {
                    vo.setOffsetKey(offsetKey.toString());
                }
                for (String field : this.badDebtContext.getOffsetFieldSelectorForRec()) {
                    vo.getAllOffsetFieldMap().put(field, row.get(field));
                }
                logger.info(String.format("RecBillHandler -- convertRecBillToVO \u6536\u6b3e\uff1a (BillId -- %s),(BillEntryId -- %s),(Balance -- %s),(offset -- %s)", vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getOffsetKey()));
                billVOMap.put(vo.getBillEntryId(), vo);
            }
        }
        return billVOMap;
    }

    private boolean isReceivedBillType(DynamicObject paypropertyField, String paypropertyType) {
        if (paypropertyField == null || paypropertyType == null) {
            return false;
        }
        if ("cas_receivingbilltype".equals(paypropertyType)) {
            return "101".equals(paypropertyField.getString("number"));
        }
        return false;
    }
}

