/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.baddebtnew;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.service.baddebtnew.AbstractBadDebtOffsetHandler;
import kd.fi.ar.business.service.baddebtnew.BadDebtContext;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.ar.vo.baddebtnew.BadDebtCalculateVO;
import kd.fi.ar.vo.baddebtnew.BadDebtCommonVO;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class ReceivedBillOffsetHandler
extends AbstractBadDebtOffsetHandler {
    public ReceivedBillOffsetHandler(BadDebtContext badDebtContext) {
        super(badDebtContext);
    }

    @Override
    public List<BadDebtCommonVO> getBillIds() {
        ArrayList<BadDebtCommonVO> resultOfBadDebtCommonVOs = new ArrayList<BadDebtCommonVO>(32);
        HashMap<Object, BadDebtCommonVO> temporaryVOMap = new HashMap<Object, BadDebtCommonVO>(32);
        QFilter receivedFilter = this.getReceivedFilter();
        DataSet receivedDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)"id,entry.id", (QFilter[])receivedFilter.toArray(), (String)"");
        DataSet unexpectedReceivedDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedReceivedFilter = this.getUnexpectedReceivedFilter(this.inverseBillIdSet);
            unexpectedReceivedDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)"id,entry.id", (QFilter[])unexpectedReceivedFilter.toArray(), (String)"");
        }
        this.buildCommonBillVOByReceived(receivedDataSet, temporaryVOMap);
        this.buildCommonBillVOByReceived(unexpectedReceivedDataSet, temporaryVOMap);
        resultOfBadDebtCommonVOs.addAll(temporaryVOMap.values());
        return resultOfBadDebtCommonVOs;
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getBills(List<BadDebtCommonVO> subBillIds) {
        Set<String> selector = this.getSelector();
        QFilter idAndEntryIdFilter = this.getFilterByCommonBillVO(subBillIds);
        DataSet receivedDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)AdjustExchHelper.generateSelector(new ArrayList<String>(selector)), (QFilter[])idAndEntryIdFilter.toArray(), (String)"bizdate");
        return this.convertReceivedBillToVO(receivedDataSet);
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getProcessBills() {
        String settleSelector = this.getSettleSelector();
        QFilter settleMainFilter = this.getSettleMainFilter();
        Object[] settleMainDatas = BusinessDataServiceHelper.load((String)"ar_settlerecord", (String)settleSelector, (QFilter[])settleMainFilter.toArray());
        Set<Object> settleMainDataSetIds = this.getSettleMainDataSetIds((DynamicObject[])settleMainDatas);
        QFilter settleAssistFilter = this.getSettleAssistFilter(settleMainDataSetIds);
        Object[] settleAssistDatas = BusinessDataServiceHelper.load((String)"ar_settlerecord", (String)settleSelector, (QFilter[])settleAssistFilter.toArray());
        DynamicObject[] settleRecordArr = (DynamicObject[])ArrayUtils.addAll((Object[])settleMainDatas, (Object[])settleAssistDatas);
        this.inverseBillIdSet = this.getIdOrEntryIdBySettle(settleRecordArr);
        HashMap<Object, BadDebtCalculateVO> processBillVOMap = new HashMap<Object, BadDebtCalculateVO>(64);
        List<BadDebtCalculateVO> calculateVOS = this.convertSettleBillToVO(settleRecordArr);
        for (BadDebtCalculateVO calculateVO : calculateVOS) {
            BadDebtCalculateVO vo = (BadDebtCalculateVO)processBillVOMap.get(calculateVO.getBillEntryId());
            if (vo != null) {
                vo.setBalance(vo.getBalance().add(calculateVO.getBalance()));
                vo.setLocalBalance(vo.getLocalBalance().add(calculateVO.getLocalBalance()));
                logger.info(String.format("ReceivedBillOffsetHandler -- getProcessBills \u8fc7\u7a0b\u5355\u636e\u91d1\u989d\u7d2f\u52a0\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                continue;
            }
            processBillVOMap.put(calculateVO.getBillEntryId(), calculateVO);
        }
        return processBillVOMap;
    }

    @Override
    public Set<String> getOriginSelector() {
        HashSet<String> selector = new HashSet<String>(8);
        selector.add("id");
        selector.add("billno");
        selector.add("entry.id");
        selector.add("entry.e_unsettledamt");
        selector.addAll(this.badDebtContext.getOffsetFieldSelectorForReceived());
        return selector;
    }

    @Override
    public String getEntityKey() {
        return "ar_receivedbill";
    }

    private QFilter getReceivedFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and(new QFilter("org", "=", (Object)this.badDebtContext.getOrgId()));
        filter.and(new QFilter("entry.e_unsettledamt", "<>", (Object)0));
        return filter;
    }

    private String getSettleSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("billentity");
        selector.add("settledate");
        selector.add("totalsettleamt");
        selector.add("localtotalsettleamt");
        selector.add("mainbillid");
        selector.add("mainbillentryid");
        selector.add("settlerelation");
        selector.add("entry.e_billentity");
        selector.add("entry.settleamt");
        selector.add("entry.localsettleamt");
        selector.add("entry.billid");
        selector.add("entry.billentryid");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getSettleMainFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("settledate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("mainbizdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    private Set<Object> getSettleMainDataSetIds(DynamicObject[] settleMainDatas) {
        HashSet<Object> set = new HashSet<Object>(16);
        if (EmptyUtils.isNotEmpty((Object)settleMainDatas)) {
            for (DynamicObject data : settleMainDatas) {
                Object billId = data.getPkValue();
                set.add(billId);
            }
        }
        return set;
    }

    private QFilter getSettleAssistFilter(Set<Object> settleMainDataSetIds) {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("id", "not in", settleMainDataSetIds));
        filter.and(new QFilter("settledate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.e_billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("entry.billdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    private Set<Object> getIdOrEntryIdBySettle(DynamicObject[] settleRecordArr) {
        HashSet<Object> billIdSet = new HashSet<Object>();
        for (DynamicObject settleRecord : settleRecordArr) {
            if ("ar_receivedbill".equals(settleRecord.get("billentity"))) {
                billIdSet.add(settleRecord.get("mainbillentryid"));
            }
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                if (!"ar_receivedbill".equals(entry.get("e_billentity"))) continue;
                billIdSet.add(entry.get("billentryid"));
            }
        }
        return billIdSet;
    }

    private List<BadDebtCalculateVO> convertSettleBillToVO(DynamicObject[] settleRecordArr) {
        ArrayList<BadDebtCalculateVO> voList = new ArrayList<BadDebtCalculateVO>(8);
        if (settleRecordArr != null) {
            for (DynamicObject bill : settleRecordArr) {
                if ("ar_receivedbill".equals(bill.get("billentity"))) {
                    BadDebtCalculateVO vo = new BadDebtCalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(bill.getLong("mainbillid"));
                    vo.setBillEntryId(bill.getLong("mainbillentryid"));
                    vo.setBalance(bill.getBigDecimal("totalsettleamt"));
                    vo.setLocalBalance(bill.getBigDecimal("localtotalsettleamt"));
                    voList.add(vo);
                    logger.info(String.format("ReceivedBillOffsetHandler -- convertSettleBillToVO \u9884\u6536\u7ed3\u7b97\u4e3b\u65b9\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                }
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    if (!"ar_receivedbill".equals(entry.get("e_billentity"))) continue;
                    BadDebtCalculateVO vo = new BadDebtCalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(entry.getLong("billid"));
                    vo.setBillEntryId(entry.getLong("billentryid"));
                    vo.setBalance(entry.getBigDecimal("settleamt"));
                    vo.setLocalBalance(entry.getBigDecimal("localsettleamt"));
                    voList.add(vo);
                    logger.info(String.format("ReceivedBillOffsetHandler -- convertSettleBillToVO \u9884\u6536\u7ed3\u7b97\u8f85\u65b9\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                }
            }
        }
        return voList;
    }

    private QFilter getUnexpectedReceivedFilter(Set<Object> receivedBillIdSet) {
        QFilter filter = new QFilter("entry.id", "in", receivedBillIdSet);
        filter.and(new QFilter("bizdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("org", "=", (Object)this.badDebtContext.getOrgId()));
        return filter;
    }

    private void buildCommonBillVOByReceived(DataSet receivedDataSet, Map<Object, BadDebtCommonVO> temporaryVOMap) {
        if (EmptyUtils.isNotEmpty((Object)receivedDataSet)) {
            for (Row row : receivedDataSet) {
                Object billId = row.get("id");
                Object entryId = row.get("entry.id");
                if (EmptyUtils.isEmpty((Object)temporaryVOMap.get(billId))) {
                    BadDebtCommonVO badDebtCommonVO = new BadDebtCommonVO(Long.valueOf(Long.parseLong(billId.toString())));
                    badDebtCommonVO.getEntryIds().add(Long.parseLong(entryId.toString()));
                    temporaryVOMap.put(billId, badDebtCommonVO);
                    continue;
                }
                temporaryVOMap.get(billId).getEntryIds().add(Long.parseLong(entryId.toString()));
            }
        }
    }

    private QFilter getFilterByCommonBillVO(List<BadDebtCommonVO> subBillIds) {
        HashSet<Long> idSet = new HashSet<Long>(subBillIds.size());
        HashSet entryIdSet = new HashSet(subBillIds.size());
        for (BadDebtCommonVO badDebtCommonVO : subBillIds) {
            idSet.add(badDebtCommonVO.getId());
            entryIdSet.addAll(badDebtCommonVO.getEntryIds());
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and(new QFilter("entry.id", "in", entryIdSet));
        return filter;
    }

    private Map<Object, BadDebtCalculateVO> convertReceivedBillToVO(DataSet receivedDataSet) {
        HashMap<Object, BadDebtCalculateVO> billVOMap = new HashMap<Object, BadDebtCalculateVO>(64);
        if (receivedDataSet != null) {
            for (Row row : receivedDataSet) {
                String key;
                BadDebtCalculateVO vo = new BadDebtCalculateVO();
                vo.setBillType("ar_receivedbill");
                vo.setBillId(row.getLong("id").longValue());
                vo.setBillNo(row.getString("billno"));
                vo.setBillEntryId(row.getLong("entry.id").longValue());
                vo.setBalance(row.getBigDecimal("entry.e_unsettledamt"));
                vo.setLocalBalance(BigDecimal.ZERO);
                vo.setExchangeRate(BigDecimal.ONE);
                vo.setRecamount(row.getBigDecimal("entry.e_unsettledamt"));
                AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
                DateTimeFormatter dateToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                StringBuilder offsetKey = new StringBuilder();
                List offsetVoList = accrualScheme.getOffsetVoList();
                HashMap<String, Boolean> nullMatch = new HashMap<String, Boolean>(8);
                for (AccrualOffsetVo offsetVo : offsetVoList) {
                    nullMatch.put(offsetVo.getReceivedfield(), offsetVo.isNullmatch());
                }
                for (String ruleField : accrualScheme.getOffsetFieldForReceivedBill()) {
                    Object dimensionValue = row.get(ruleField);
                    if (EmptyUtils.isNotEmpty((Object)dimensionValue)) {
                        if (dimensionValue instanceof BigDecimal) {
                            offsetKey.append(((BigDecimal)dimensionValue).stripTrailingZeros().toPlainString());
                            continue;
                        }
                        if (dimensionValue instanceof Date) {
                            LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)dimensionValue).toInstant(), ZoneId.systemDefault());
                            offsetKey.append(localDateTime.format(dateToStringFormatter));
                            continue;
                        }
                        offsetKey.append(dimensionValue);
                        continue;
                    }
                    if (((Boolean)nullMatch.get(ruleField)).booleanValue()) {
                        offsetKey.append("NULL");
                        continue;
                    }
                    offsetKey = new StringBuilder();
                    break;
                }
                if (!"".equals(key = offsetKey.toString())) {
                    vo.setOffsetKey(offsetKey.toString());
                }
                for (String field : this.badDebtContext.getOffsetFieldSelectorForReceived()) {
                    vo.getAllOffsetFieldMap().put(field, row.get(field));
                }
                logger.info(String.format("ReceivedBillOffsetHandler -- convertReceivedBillToVO \u9884\u6536\uff1a (BillId -- %s),(BillEntryId -- %s),(Balance -- %s),(offset -- %s)", vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getOffsetKey()));
                billVOMap.put(vo.getBillEntryId(), vo);
            }
        }
        return billVOMap;
    }
}

