/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.baddebtnew;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.business.service.baddebtnew.AbstractBadDebtBillHandler;
import kd.fi.ar.business.service.baddebtnew.BadDebtContext;
import kd.fi.ar.vo.AccrualOffsetVo;
import kd.fi.ar.vo.baddebtnew.AccrualScheme;
import kd.fi.ar.vo.baddebtnew.BadDebtCalculateVO;
import kd.fi.ar.vo.baddebtnew.BadDebtCommonVO;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class RevcfmBadDebtBillHandler
extends AbstractBadDebtBillHandler {
    public RevcfmBadDebtBillHandler(BadDebtContext badDebtContext) {
        super(badDebtContext);
    }

    @Override
    public List<BadDebtCommonVO> getBillIds(Set<Long> prepareBillIds) {
        ArrayList<BadDebtCommonVO> resultOfCommonBillVOS = new ArrayList<BadDebtCommonVO>(32);
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        QFilter accrualSchemeFilter = accrualScheme.getCondition();
        QFilter accruedBillIdFilter = new QFilter("id", "not in", prepareBillIds);
        String agingDate = accrualScheme.getAgingDateEntity();
        QFilter agingDateFilter = new QFilter(agingDate, "<=", (Object)DateUtils.getLastDay((Date)this.badDebtContext.getEndDate(), (int)accrualScheme.getAgingStartDay()));
        QFilter revcfmFilter = this.getRevcfmFilter();
        DataSet revcfmDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{revcfmFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        DataSet unexpectedRevcfmDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedRevcfmFilter = this.getUnexpectedRevcfmFilter(this.inverseBillIdSet);
            unexpectedRevcfmDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{unexpectedRevcfmFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        }
        DataSet allDataSet = EmptyUtils.isNotEmpty((Object)revcfmDataSet) ? (EmptyUtils.isNotEmpty(unexpectedRevcfmDataSet) ? revcfmDataSet.union(unexpectedRevcfmDataSet).orderBy(new String[]{agingDate}) : revcfmDataSet) : unexpectedRevcfmDataSet;
        resultOfCommonBillVOS.addAll(this.buildCommonBillVOByRevcfm(allDataSet, new LinkedHashMap<Object, BadDebtCommonVO>(32)));
        return resultOfCommonBillVOS;
    }

    @Override
    public List<BadDebtCommonVO> getBillIds(Set<Long> prepareBillIds, Set<Long> prepareBillEntryIds) {
        ArrayList<BadDebtCommonVO> resultOfCommonBillVOS = new ArrayList<BadDebtCommonVO>(32);
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        QFilter accrualSchemeFilter = accrualScheme.getCondition();
        QFilter accruedBillIdFilter = new QFilter("id", "not in", prepareBillIds);
        accruedBillIdFilter.and("entry.id", "not in", prepareBillEntryIds);
        String agingDate = accrualScheme.getAgingDateEntity();
        QFilter agingDateFilter = new QFilter(agingDate, "<=", (Object)DateUtils.getLastDay((Date)this.badDebtContext.getEndDate(), (int)accrualScheme.getAgingStartDay()));
        QFilter revcfmFilter = this.getRevcfmFilter();
        DataSet revcfmDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{revcfmFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        DataSet unexpectedRevcfmDataSet = null;
        if (!this.inverseBillIdSet.isEmpty()) {
            QFilter unexpectedRevcfmFilter = this.getUnexpectedRevcfmFilter(this.inverseBillIdSet);
            unexpectedRevcfmDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)("id,entry.id," + agingDate), (QFilter[])new QFilter[]{unexpectedRevcfmFilter, accrualSchemeFilter, accruedBillIdFilter, agingDateFilter}, (String)agingDate);
        }
        DataSet allDataSet = EmptyUtils.isNotEmpty((Object)revcfmDataSet) ? (EmptyUtils.isNotEmpty(unexpectedRevcfmDataSet) ? revcfmDataSet.union(unexpectedRevcfmDataSet).orderBy(new String[]{agingDate}) : revcfmDataSet) : unexpectedRevcfmDataSet;
        resultOfCommonBillVOS.addAll(this.buildCommonBillVOByRevcfm(allDataSet, new LinkedHashMap<Object, BadDebtCommonVO>(32)));
        return resultOfCommonBillVOS;
    }

    @Override
    public LinkedHashMap<Object, BadDebtCalculateVO> getBills(List<BadDebtCommonVO> subBillIds) {
        Set<String> selector = this.getSelector();
        String agingDate = this.badDebtContext.getAccrualScheme().getAgingDateEntity();
        selector.add(agingDate);
        QFilter idAndEntryIdFilter = this.getFilterByCommonVO(subBillIds);
        DataSet revcfmDataSet = QueryServiceHelper.queryDataSet((String)"baddebtaccrual", (String)this.getEntityKey(), (String)AdjustExchHelper.generateSelector(new ArrayList<String>(selector)), (QFilter[])new QFilter[]{idAndEntryIdFilter}, (String)agingDate);
        return this.convertRevcfmBillToVO(revcfmDataSet);
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getProcessBills() {
        ArrayList<BadDebtCalculateVO> badDebtCalculateVOs = new ArrayList<BadDebtCalculateVO>(8);
        String verifySelector = this.getVerifySelector();
        QFilter verifyFilter = this.getVerifyMainFilter();
        DynamicObject[] verifyAssistDatas = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)verifySelector, (QFilter[])verifyFilter.toArray());
        badDebtCalculateVOs.addAll(this.convertVerifyBillToVO(verifyAssistDatas, this.inverseBillIdSet));
        HashMap<Object, BadDebtCalculateVO> processBillVOMap = new HashMap<Object, BadDebtCalculateVO>(64);
        for (BadDebtCalculateVO calculateVO : badDebtCalculateVOs) {
            BadDebtCalculateVO vo = (BadDebtCalculateVO)processBillVOMap.get(calculateVO.getBillEntryId());
            if (vo != null) {
                vo.setBalance(vo.getBalance().add(calculateVO.getBalance()));
                vo.setLocalBalance(vo.getLocalBalance().add(calculateVO.getLocalBalance()));
                logger.info(String.format("RevcfmBadDebtBillHandler -- getProcessBillVO \u8fc7\u7a0b\u5355\u636e\u91d1\u989d\u7d2f\u52a0\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                continue;
            }
            processBillVOMap.put(calculateVO.getBillEntryId(), calculateVO);
        }
        return processBillVOMap;
    }

    @Override
    public Set<String> getOriginSelector() {
        Set<String> selector = RevcfmBadDebtBillHandler.getBaseBillSelector();
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unrecamt");
        selector.add("entry.e_amount");
        selector.add("entry.e_localamt");
        AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
        if (accrualScheme.isOffset() && accrualScheme.getOffsetedField() != null && "ar_revcfmbill".equals(accrualScheme.getOffsetBillEntity())) {
            selector.addAll(accrualScheme.getOffsetedField());
        }
        return selector;
    }

    @Override
    public String getEntityKey() {
        return "ar_revcfmbill";
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getOffsetBill() {
        return null;
    }

    @Override
    public Map<Object, BadDebtCalculateVO> getBadDebtLossBill() {
        return null;
    }

    private QFilter getRevcfmFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and(new QFilter("org", "=", (Object)this.badDebtContext.getOrgId()));
        filter.and(new QFilter("bookdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.e_unrecamt", "<>", (Object)0));
        return filter;
    }

    private QFilter getUnexpectedRevcfmFilter(Set<Object> inverseBillIdSet) {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filter.and(new QFilter("bookdate", "<=", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.id", "in", inverseBillIdSet));
        return filter;
    }

    private List<BadDebtCommonVO> buildCommonBillVOByRevcfm(DataSet allDataSet, LinkedHashMap<Object, BadDebtCommonVO> temporaryVOMap) {
        if (EmptyUtils.isNotEmpty((Object)allDataSet)) {
            for (Row row : allDataSet) {
                Object billId = row.get("id");
                Object entryId = row.get("entry.id");
                if (EmptyUtils.isEmpty((Object)temporaryVOMap.get(billId))) {
                    BadDebtCommonVO commonBillVO = new BadDebtCommonVO(Long.valueOf(Long.parseLong(billId.toString())));
                    commonBillVO.getEntryIds().add(Long.parseLong(entryId.toString()));
                    temporaryVOMap.put(billId, commonBillVO);
                    continue;
                }
                temporaryVOMap.get(billId).getEntryIds().add(Long.parseLong(entryId.toString()));
            }
        }
        return new ArrayList<BadDebtCommonVO>(temporaryVOMap.values());
    }

    private QFilter getFilterByCommonVO(List<BadDebtCommonVO> subbillids) {
        HashSet<Long> idSet = new HashSet<Long>(subbillids.size());
        HashSet entryIdSet = new HashSet(subbillids.size());
        for (BadDebtCommonVO commonBillVO : subbillids) {
            idSet.add(commonBillVO.getId());
            entryIdSet.addAll(commonBillVO.getEntryIds());
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and(new QFilter("entry.id", "in", entryIdSet));
        return filter;
    }

    private LinkedHashMap<Object, BadDebtCalculateVO> convertRevcfmBillToVO(DataSet revcfmDataSet) {
        LinkedHashMap<Object, BadDebtCalculateVO> billVOMap = new LinkedHashMap<Object, BadDebtCalculateVO>(64);
        if (revcfmDataSet != null) {
            for (Row row : revcfmDataSet) {
                BadDebtCalculateVO vo = new BadDebtCalculateVO();
                vo.setBillType("ar_revcfmbill");
                vo.setBillId(row.getLong("id").longValue());
                vo.setBillEntryId(row.getLong("entry.id").longValue());
                vo.setBillNo(row.getString("billno"));
                vo.setAsstactType(row.getString("asstacttype"));
                vo.setAsstactId(row.getLong("asstact").longValue());
                vo.setRemark(row.getString("remark"));
                vo.setBizDate(row.getDate(this.badDebtContext.getAccrualScheme().getAgingDateEntity()));
                vo.setCurrencyId(row.getLong("currency").longValue());
                vo.setExrateTableId(row.getLong("exratetable").longValue());
                vo.setMaterialId(row.getLong("entry.e_material").longValue());
                vo.setExpenseItemId(row.getLong("entry.e_expenseitem").longValue());
                vo.setBalance(row.getBigDecimal("entry.e_unrecamt"));
                vo.setExchangeRate(row.getBigDecimal("exchangerate"));
                if ("0".equals(row.getString("quotation"))) {
                    vo.setLocalBalance(vo.getBalance().multiply(vo.getExchangeRate()).setScale(this.badDebtContext.getPrecision(), 4));
                } else {
                    vo.setLocalBalance(vo.getBalance().divide(vo.getExchangeRate(), this.badDebtContext.getPrecision(), 4));
                }
                vo.setQuotation(row.getString("quotation"));
                vo.setRecamount(row.getBigDecimal("entry.e_amount"));
                vo.setRecamountlocal(row.getBigDecimal("entry.e_localamt"));
                vo.setExrateDate(row.getDate("exratedate"));
                AccrualScheme accrualScheme = this.badDebtContext.getAccrualScheme();
                DateTimeFormatter dateToStringFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                StringBuilder offsetKey = new StringBuilder();
                if (accrualScheme.isOffset() && accrualScheme.getOffsetedField() != null && "ar_revcfmbill".equals(accrualScheme.getOffsetBillEntity())) {
                    String key;
                    List offsetVoList = accrualScheme.getOffsetVoList();
                    HashMap<String, Boolean> nullMatch = new HashMap<String, Boolean>(8);
                    for (AccrualOffsetVo offsetVo : offsetVoList) {
                        nullMatch.put(offsetVo.getOffsetbillfield(), offsetVo.isNullmatch());
                    }
                    for (String ruleField : accrualScheme.getOffsetedField()) {
                        Object dimensionValue = row.get(ruleField);
                        if (EmptyUtils.isNotEmpty((Object)dimensionValue)) {
                            if (dimensionValue instanceof BigDecimal) {
                                offsetKey.append(((BigDecimal)dimensionValue).stripTrailingZeros().toPlainString());
                                continue;
                            }
                            if (dimensionValue instanceof Date) {
                                LocalDateTime localDateTime = LocalDateTime.ofInstant(((Date)dimensionValue).toInstant(), ZoneId.systemDefault());
                                offsetKey.append(localDateTime.format(dateToStringFormatter));
                                continue;
                            }
                            offsetKey.append(dimensionValue);
                            continue;
                        }
                        if (((Boolean)nullMatch.get(ruleField)).booleanValue()) {
                            offsetKey.append("NULL");
                            continue;
                        }
                        offsetKey = new StringBuilder();
                        break;
                    }
                    if (!"".equals(key = offsetKey.toString())) {
                        vo.setOffsetKey(offsetKey.toString());
                    }
                }
                this.extendFieldVoluation(vo, row);
                billVOMap.put(vo.getBillEntryId(), vo);
                logger.info(String.format("RevcfmBadDebtBillHandler -- convertRevcfmBillToVO \u4ed8\u6b3e: (BillId -- %s),(BillEntryId -- %s),(Balance -- %s),(ExchangeRate -- %s),(CalculateResult(\u65e0\u622a\u53d6) -- %s),(LoaclBalance -- %s)", vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getExchangeRate(), vo.getBalance().multiply(vo.getExchangeRate()), vo.getLocalBalance()));
            }
        }
        return billVOMap;
    }

    private String getVerifySelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("entry.assverifyamt");
        selector.add("entry.assverifylocamt");
        selector.add("entry.assbillid");
        selector.add("entry.assbillentryid");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getVerifyMainFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("createtime", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.assbookdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    @Deprecated
    private Set<Object> getVerifyMainDataSetIds(DynamicObject[] settleMainDatas) {
        HashSet<Object> set = new HashSet<Object>(16);
        if (EmptyUtils.isNotEmpty((Object)settleMainDatas)) {
            for (DynamicObject data : settleMainDatas) {
                Object billId = data.getPkValue();
                set.add(billId);
            }
        }
        return set;
    }

    @Deprecated
    private QFilter getVerifyAssistFilter(Set<Object> verifyMainDataSetIds) {
        QFilter filter = new QFilter("org", "=", (Object)this.badDebtContext.getOrgId());
        filter.and(new QFilter("id", "not in", verifyMainDataSetIds));
        filter.and(new QFilter("verifydate", ">", (Object)this.badDebtContext.getEndDate()));
        filter.and(new QFilter("entry.e_billtype", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("entry.e_billdate", "<=", (Object)this.badDebtContext.getEndDate()));
        return filter;
    }

    private Set<BadDebtCalculateVO> convertVerifyBillToVO(DynamicObject[] verifyRecordArr, Set<Object> inverseBillIdSet) {
        HashSet<BadDebtCalculateVO> voList = new HashSet<BadDebtCalculateVO>(64);
        if (verifyRecordArr != null) {
            for (DynamicObject bill : verifyRecordArr) {
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    BadDebtCalculateVO vo = new BadDebtCalculateVO();
                    vo.setBillType("ar_verifyrecord");
                    vo.setBillId(entry.getLong("assbillid"));
                    vo.setBillEntryId(entry.getLong("assbillentryid"));
                    vo.setBalance(entry.getBigDecimal("assverifyamt"));
                    vo.setLocalBalance(entry.getBigDecimal("assverifylocamt"));
                    voList.add(vo);
                    logger.info(String.format("RevcfmBadDebtBillHandler -- convertVerifyBillToVO \u6536\u5165\u786e\u8ba4\u5355\u6838\u9500\u8f85\u65b9\uff1a(BillType -- %s), (BillId -- %s), (BillEntryId -- %s),(Balance -- %s),(LoaclBalance -- %s)", vo.getBillType(), vo.getBillId(), vo.getBillEntryId(), vo.getBalance(), vo.getLocalBalance()));
                    inverseBillIdSet.add(vo.getBillEntryId());
                }
            }
        }
        return voList;
    }
}

