/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.business.baddebt.impl.AccrualImpl;
import kd.fi.ar.business.baddebt.info.AccrualSchemeInfo;
import kd.fi.ar.enums.BillStatusEnum;
import kd.fi.ar.errorcode.BaddebtErrorCode;
import kd.fi.arapcommon.service.AbstractOpService;

public class AccrualReserveImpl
extends AbstractOpService {
    private Date currentDate = new Date();

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("org");
        lst.add("policytype");
        lst.add("period");
        lst.add("isfirst");
        lst.add("billstatus");
        lst.add("policyid");
        lst.add("creator");
        lst.add("createtime");
        return lst;
    }

    public void validate(DynamicObject info) throws KDException {
        super.validate(info);
        String billStatus = info.getString("billstatus");
        if (!billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            throw new KDBizException(BaddebtErrorCode.STATUS_CANNOT_ACCRUAL(), new Object[0]);
        }
        DynamicObject org = info.getDynamicObject("org");
        DynamicObject policy = BusinessDataServiceHelper.loadSingle((Object)info.getLong("policyid"), (String)"ar_policy", (String)"accrualscheme");
        DynamicObject scheme = policy.getDynamicObject("accrualscheme");
        if (ObjectUtils.isEmpty((Object)scheme)) {
            throw new KDBizException(BaddebtErrorCode.NOTEXISTS_SCHEME_CANNOT_ACCRUAL(), new Object[0]);
        }
        DynamicObject accrualScheme = BusinessDataServiceHelper.loadSingle((Object)scheme.getPkValue(), (String)"ar_accrualscheme");
        DynamicObject nextPeriod = BaddebtHelper.getNextPeriod(accrualScheme.getString("accrualfrequency"), info.getDynamicObject("period").getPkValue());
        if (ObjectUtils.isEmpty((Object)nextPeriod)) {
            throw new KDBizException(BaddebtErrorCode.NEXTPERIOD_NOTEXISTS_CANNOT_ACCRUAL(), new Object[0]);
        }
        long orgPk = (Long)org.getPkValue();
        QFilter qFilter = new QFilter("org", "=", (Object)orgPk);
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (QueryServiceHelper.exists((String)"ar_baddebtreservebill", (QFilter[])new QFilter[]{qFilter})) {
            throw new KDBizException(BaddebtErrorCode.EXISTS_AUDIT_INITRESERVE(), new Object[0]);
        }
    }

    public void process(DynamicObject info, DynamicObject policy) {
        AccrualImpl iAccrual = new AccrualImpl();
        AccrualSchemeInfo schemeInfo = iAccrual.getSchemeInfo(policy.getDynamicObject("accrualscheme").getPkValue(), policy.getDynamicObject("org").getPkValue());
        Object periodPk = info.getDynamicObject("period").getPkValue();
        iAccrual.genTargetBills(schemeInfo, periodPk, policy, info.getBoolean("isfirst"));
        DynamicObject[] infos = new DynamicObject[1];
        info.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        infos[0] = info;
        SaveServiceHelper.save((DynamicObject[])infos);
        DynamicObject nextPeriod = BaddebtHelper.getNextPeriod(schemeInfo.getFrequency(), periodPk);
        this.deleteDup(info, nextPeriod);
        DynamicObject nextObj = (DynamicObject)OrmUtils.clone((IDataEntityBase)info, (boolean)false, (boolean)true);
        nextObj.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        nextObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        nextObj.set("createtime", (Object)this.currentDate);
        nextObj.set("period", (Object)nextPeriod);
        nextObj.set("isfirst", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{nextObj});
    }

    private void deleteDup(DynamicObject info, DynamicObject nextPeriod) {
        QFilter qFilter = new QFilter("org", "=", info.getDynamicObject("org").getPkValue());
        qFilter.and(new QFilter("policytype", "=", info.getDynamicObject("policytype").getPkValue()));
        qFilter.and(new QFilter("policyid", "=", (Object)info.getLong("policyid")));
        qFilter.and(new QFilter("period", "=", nextPeriod.getPkValue()));
        DynamicObjectCollection results = QueryServiceHelper.query((String)"ar_baddebtresult", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object)results)) {
            List<Object> nextPks = results.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            DeleteServiceHelper.delete((IDataEntityType)info.getDataEntityType(), (Object[])nextPks.toArray(new Object[0]));
        }
    }
}

