/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.enums.BillStatusEnum;
import kd.fi.ar.errorcode.BaddebtErrorCode;
import kd.fi.arapcommon.service.AbstractOpService;

public class AntiAccrualReserveImpl
extends AbstractOpService {
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("org");
        lst.add("policytype");
        lst.add("period");
        lst.add("billstatus");
        lst.add("policyid");
        return lst;
    }

    public void validate(DynamicObject info) throws KDException {
        super.validate(info);
        String billStatus = info.getString("billstatus");
        if (!BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            throw new KDBizException(BaddebtErrorCode.STATUS_CANNOT_ANTIACCRUAL(), new Object[0]);
        }
        DynamicObject policy = BusinessDataServiceHelper.loadSingleFromCache((Object)info.getLong("policyid"), (String)"ar_policy", (String)"accrualscheme");
        if (ObjectUtils.isEmpty((Object)policy.get("accrualscheme"))) {
            throw new KDBizException(BaddebtErrorCode.NOTEXISTS_SCHEME_CANNOT_ANTIACCRUAL(), new Object[0]);
        }
        DynamicObject nextObj = this.getNextPeriodInfo(info);
        if (nextObj != null && BillStatusEnum.SUBMIT.getValue().equals(nextObj.getString("billstatus"))) {
            DynamicObject nextPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)nextObj.getDynamicObject("period").getLong("id"), (String)"bd_period", (String)"name");
            throw new KDBizException(BaddebtErrorCode.ANTIACCRUAL_NEXT_PERIOD(), new Object[]{nextPeriod.getLocaleString("name").getLocaleValue()});
        }
        QFilter qFilter = new QFilter("org", "=", info.getDynamicObject("org").getPkValue());
        qFilter.and(new QFilter("policytype", "=", info.getDynamicObject("policytype").getPkValue()));
        qFilter.and(new QFilter("arpolicy", "=", (Object)info.getLong("policyid")));
        qFilter.and(new QFilter("period", "=", info.getDynamicObject("period").getPkValue()));
        qFilter.and(new QFilter("isvoucher", "=", (Object)Boolean.TRUE));
        if (QueryServiceHelper.exists((String)"ar_baddebtreserve", (QFilter[])new QFilter[]{qFilter})) {
            throw new KDBizException(BaddebtErrorCode.ANTIACCRUAL_EXISTS_GENVOUCHER(), new Object[0]);
        }
    }

    public void process(DynamicObject[] infos) throws KDException {
        super.process(infos);
        ArrayList<Object> nextPks = new ArrayList<Object>();
        for (DynamicObject info : infos) {
            QFilter qFilter = new QFilter("org", "=", info.getDynamicObject("org").getPkValue());
            qFilter.and(new QFilter("policytype", "=", info.getDynamicObject("policytype").getPkValue()));
            qFilter.and(new QFilter("arpolicy", "=", (Object)info.getLong("policyid")));
            qFilter.and(new QFilter("period", "=", info.getDynamicObject("period").getPkValue()));
            DeleteServiceHelper.delete((String)"ar_baddebtreserve", (QFilter[])new QFilter[]{qFilter});
            DynamicObject nextObj = this.getNextPeriodInfo(info);
            if (nextObj != null) {
                nextPks.add(nextObj.getPkValue());
            }
            info.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])infos);
        if (!nextPks.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)infos[0].getDataEntityType(), (Object[])nextPks.toArray(new Object[0]));
        }
    }

    private DynamicObject getNextPeriodInfo(DynamicObject info) {
        DynamicObject nextObj = null;
        DynamicObject policy = BusinessDataServiceHelper.loadSingleFromCache((Object)info.getLong("policyid"), (String)"ar_policy", (String)"accrualscheme");
        DynamicObject accrualScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)policy.getDynamicObject("accrualscheme").getLong("id"), (String)"ar_accrualscheme", (String)"accrualfrequency");
        Object periodPk = info.getDynamicObject("period").getPkValue();
        DynamicObject nextPeriod = BaddebtHelper.getNextPeriod(accrualScheme.getString("accrualfrequency"), periodPk);
        if (nextPeriod != null) {
            QFilter qFilter = new QFilter("org", "=", info.getDynamicObject("org").getPkValue());
            qFilter.and(new QFilter("policytype", "=", info.getDynamicObject("policytype").getPkValue()));
            qFilter.and(new QFilter("policyid", "=", (Object)info.getLong("policyid")));
            qFilter.and(new QFilter("period", "=", nextPeriod.getPkValue()));
            nextObj = BusinessDataServiceHelper.loadSingle((String)"ar_baddebtresult", (String)"id, billstatus, period", (QFilter[])new QFilter[]{qFilter});
        }
        return nextObj;
    }
}

