/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.enums.BillStatusEnum;
import kd.fi.ar.errorcode.BaddebtErrorCode;
import kd.fi.ar.errorcode.SystemErrorCode;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.init.InitServiceHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.AbstractOpService;
import kd.fi.arapcommon.service.BalanceService;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class InitAntiCloseImpl
extends AbstractOpService {
    private int BATCHCOUNT = 0;

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("org");
        lst.add("isfinishinit");
        lst.add("startperiod");
        lst.add("curperiod");
        lst.add("startdate");
        lst.add("currentdate");
        lst.add("policyid");
        lst.add("policytype");
        lst.add("entryentity.e_asstacttype");
        return lst;
    }

    public void validate(DynamicObject info) throws KDException {
        super.validate(info);
        DynamicObject org = info.getDynamicObject("org");
        Date currentDate = info.getDate("currentdate");
        Date startDate = info.getDate("startdate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String startDateStr = sdf.format(startDate);
        if (!ObjectUtils.isEmpty((Object)currentDate) && startDate.compareTo(currentDate) < 0 || info.getDynamicObject("curperiod") != null && !info.getDynamicObject("startperiod").getPkValue().equals(info.getDynamicObject("curperiod").getPkValue())) {
            throw new KDBizException(SystemErrorCode.EXISTS_CLOSEACC_CANNOT_ANITCLOSE(), new Object[]{org.getLocaleString("name").getLocaleValue(), startDateStr});
        }
        QFilter badFilter = new QFilter("policyid", "=", (Object)info.getLong("policyid"));
        badFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
        if (QueryServiceHelper.exists((String)"ar_baddebtresult", (QFilter[])new QFilter[]{badFilter})) {
            throw new KDBizException(BaddebtErrorCode.EXISTS_BIZBILL_CANNOT_ANITCLOSE(), new Object[0]);
        }
    }

    public void process(DynamicObject info) {
        super.process(info);
        long orgPk = info.getDynamicObject("org").getLong("id");
        this.updateArBill("ar_finarbill", orgPk, true, null);
        this.updateArBill("ar_busbill", orgPk, true, null);
        this.updateArBill("ar_receivedbill", orgPk, false, null);
        this.updateArBill("ar_baddebtlossbill", orgPk, true, null);
        this.updateArBill("ar_baddebtreservebill", orgPk, false, info.getPkValue());
        info.set("curperiod", null);
        info.set("currentdate", null);
        info.set("isfinishinit", (Object)Boolean.FALSE);
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
        if (!entrys.isEmpty()) {
            entrys.clear();
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
        CloseRecordService closeRecordService = new CloseRecordService(false);
        closeRecordService.deleteCloseRecordByAntiInit(Long.valueOf(orgPk));
        BalanceService balanceService = new BalanceService("ar");
        balanceService.deleteBalanceByInit(Long.valueOf(orgPk));
    }

    private void updateArBill(String entityKey, Object orgPk, boolean isPeriod, Object initPk) {
        QFilter qFilter = new QFilter("org", "=", orgPk);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (isPeriod) {
            qFilter.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        }
        if (initPk != null) {
            qFilter.and(new QFilter("initbaddebtid", "=", initPk));
        }
        LinkedList<Long> ids = new LinkedList<Long>();
        if (this.BATCHCOUNT == 0) {
            this.BATCHCOUNT = InitServiceHelper.getInitBatchHandleCount();
        }
        try (DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"fi.ar.InitAntiCloseImpl", (String)entityKey, (String)"id", (QFilter[])qFilter.toArray(), null);){
            for (Row bill : billDataSet) {
                ids.add(bill.getLong("id"));
                if (ids.size() != this.BATCHCOUNT) continue;
                this.doUpdateStatus(ids, entityKey);
                ids.clear();
            }
        }
        if (!ids.isEmpty()) {
            this.doUpdateStatus(ids, entityKey);
        }
    }

    private void doUpdateStatus(List<Long> ids, String entityKey) {
        DynamicObjectType subEntityType = EntityMetadataUtils.getSubEntityType((String)entityKey, (String)"id,billstatus, auditdate,auditor,bookdate,isvoucher");
        DynamicObjectCollection bills = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)subEntityType);
        List pks = ArApHelper.getPks((Object)bills);
        HashSet<Long> idSetHadRecords = new HashSet<Long>(64);
        List mainSettleIds = SettleRecordQueryHelper.getBillIdsHadSettlesByMain((String)"ar_settlerecord", (String)entityKey, (Object[])ids.toArray());
        idSetHadRecords.addAll(mainSettleIds);
        List asstSettleIds = SettleRecordQueryHelper.getBillIdsHadSettlesByAsst((String)"ar_settlerecord", (String)entityKey, (Object[])ids.toArray());
        idSetHadRecords.addAll(asstSettleIds);
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ar_saloutwfrecord", "entry.billid"));
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ar_saloutwfrecord", "entry.assbillid"));
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ar_revcrm_verifyrecord", "entry.billid"));
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ar_revcrm_verifyrecord", "entry.assbillid"));
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ar_originalwfrecord", "entry.billid"));
        idSetHadRecords.addAll(this.getBillIdSetHadRecords(ids, "ar_originalwfrecord", "entry.assbillid"));
        Map pushMap = BFTrackerServiceHelper.findDirtTargetBills((String)entityKey, (Long[])pks.toArray(new Long[0]));
        if (!ObjectUtils.isEmpty((Object)pushMap) && "ar_finarbill".equals(entityKey)) {
            QFilter qf = new QFilter("sourcebillid", "in", pushMap.keySet());
            qf.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
            DynamicObjectCollection losses = QueryServiceHelper.query((String)"ar_baddebtlossbill", (String)"sourcebillid", (QFilter[])new QFilter[]{qf});
            for (DynamicObject loss : losses) {
                pushMap.remove(loss.getLong("sourcebillid"));
            }
        }
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>();
        for (DynamicObject bill : bills) {
            Object pk = bill.getPkValue();
            boolean exists = !ObjectUtils.isEmpty((Object)pushMap) && !ObjectUtils.isEmpty(pushMap.get(pk));
            boolean isVucher = false;
            if (EmptyUtils.isNotEmpty((Object)bill.getDataEntityType().getProperties().get((Object)"isvoucher"))) {
                isVucher = bill.getBoolean("isvoucher");
            }
            if (isVucher || idSetHadRecords.contains(pk) || exists) continue;
            bill.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            bill.set("auditdate", null);
            bill.set("auditor", null);
            billList.add(bill);
        }
        if (!ObjectUtils.isEmpty(billList)) {
            DynamicObject[] billArrays = billList.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])billArrays);
            Object[] idArr = billList.stream().map(v -> v.get("id")).toArray(Object[]::new);
            if (!"ar_baddebtlossbill".equals(entityKey) && !"ar_baddebtreservebill".equals(entityKey)) {
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"periodunaudit", (String)entityKey, (Object[])idArr, (OperateOption)OperateOption.create());
                OperationHelper.assertResult((OperationResult)opResult);
                new JournalService().deleteJournals(billArrays);
            }
        }
    }

    private Set<Long> getBillIdSetHadRecords(List<Long> ids, String recordNameKey, String column) {
        QFilter filter = new QFilter(column, "in", ids);
        DynamicObjectCollection records = QueryServiceHelper.query((String)recordNameKey, (String)column, (QFilter[])filter.toArray());
        return records.stream().map(bill -> bill.getLong(column)).collect(Collectors.toSet());
    }
}

