/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.business.baddebt.BaddebtHelper;
import kd.fi.ar.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.init.InitServiceHelper;
import kd.fi.arapcommon.service.AbstractOpService;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class InitCloseImpl
extends AbstractOpService {
    private int BATCHCOUNT = 0;
    private Date currentDate = new Date();

    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(32);
        lst.add("org");
        lst.add("policytype");
        lst.add("isfinishinit");
        lst.add("periodtype");
        lst.add("startperiod");
        lst.add("curperiod");
        lst.add("startdate");
        lst.add("currentdate");
        lst.add("policyid");
        lst.add("standardcurrency");
        lst.add("exratetable");
        lst.add("entryentity.e_asstacttype");
        lst.add("entryentity.e_asstact");
        lst.add("entryentity.e_currency");
        lst.add("entryentity.e_finrecamt");
        lst.add("entryentity.e_recamt");
        lst.add("entryentity.e_balanceamt");
        lst.add("entryentity.e_baddebtamt");
        lst.add("entryentity.businessamount");
        return lst;
    }

    public void validate(DynamicObject info) throws KDException {
        super.validate(info);
    }

    public void process(DynamicObject info) {
        super.process(info);
        long orgPk = info.getDynamicObject("org").getLong("id");
        this.updateArBill("ar_finarbill", orgPk, true, null);
        this.updateArBill("ar_busbill", orgPk, true, null);
        this.updateArBill("ar_receivedbill", orgPk, false, null);
        this.updateArBill("ar_baddebtlossbill", orgPk, true, null);
        this.updateArBill("ar_baddebtreservebill", orgPk, false, info.getPkValue());
        info.set("curperiod", (Object)info.getDynamicObject("startperiod"));
        info.set("currentdate", (Object)info.getDate("startdate"));
        info.set("isfinishinit", (Object)Boolean.TRUE);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{info});
        ArrayList<DynamicObject> destList = new ArrayList<DynamicObject>();
        DynamicObject policy = BusinessDataServiceHelper.loadSingleFromCache((Object)info.getLong("policyid"), (String)"ar_policy", (String)"baddebtpolicy, accrualscheme");
        DynamicObject accrualScheme = policy.getDynamicObject("accrualscheme");
        if ("allowance".equals(policy.getString("baddebtpolicy"))) {
            DynamicObject baddebtResult = this.buildBaddebtResult(info, accrualScheme);
            destList.add(baddebtResult);
        }
        if (!destList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])destList.toArray(new DynamicObject[0]));
        }
    }

    private void updateArBill(String entityKey, Object orgPk, boolean isPeriod, Object pk) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("org", "=", orgPk);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()));
        qFilters.add(qFilter);
        if (isPeriod) {
            qFilters.add(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        }
        if (pk != null) {
            qFilters.add(new QFilter("initbaddebtid", "=", pk));
        }
        LinkedList<Long> ids = new LinkedList<Long>();
        if (this.BATCHCOUNT == 0) {
            this.BATCHCOUNT = InitServiceHelper.getInitBatchHandleCount();
        }
        try (DataSet billDataSet = QueryServiceHelper.queryDataSet((String)"fi.ar.InitCloseImpl", (String)entityKey, (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row bill : billDataSet) {
                ids.add(bill.getLong("id"));
                if (ids.size() != this.BATCHCOUNT) continue;
                this.doUpdateStatus(ids, entityKey);
                ids.clear();
            }
        }
        if (!ids.isEmpty()) {
            this.doUpdateStatus(ids, entityKey);
        }
    }

    private void doUpdateStatus(List<Long> ids, String entityKey) {
        DynamicObject[] bills;
        DynamicObjectType subEntityType = EntityMetadataUtils.getSubEntityType((String)entityKey, (String)"billstatus, auditdate,auditor,bizdate,bookdate");
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)subEntityType)) {
            bill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            bill.set("auditdate", (Object)new Date());
            bill.set("auditor", (Object)RequestContext.get().getCurrUserId());
            if (!this.hasBookDateFieldBills(entityKey) || bill.getDate("bookdate") != null) continue;
            Date bizDate = bill.getDate("bizdate");
            bill.set("bookdate", (Object)bizDate);
        }
        SaveServiceHelper.save((DynamicObject[])bills);
        if (!"ar_baddebtlossbill".equals(entityKey) && !"ar_baddebtreservebill".equals(entityKey)) {
            OperationResult opResult = OperationServiceHelper.executeOperate((String)"periodaudit", (String)entityKey, (Object[])ids.toArray(new Long[0]), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)opResult);
        }
    }

    private boolean hasBookDateFieldBills(String entityKey) {
        return !"ar_baddebtlossbill".equals(entityKey) && !"ar_baddebtreservebill".equals(entityKey) && !"ar_receivedbill".equals(entityKey);
    }

    private DynamicObject buildBaddebtResult(DynamicObject init, DynamicObject accrualScheme) {
        DynamicObject obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ar_baddebtresult"));
        obj.set("org", init.getDynamicObject("org").getPkValue());
        obj.set("policytype", (Object)init.getDynamicObject("policytype"));
        if (ObjectUtils.isEmpty((Object)accrualScheme)) {
            obj.set("period", init.getDynamicObject("startperiod").getPkValue());
        } else {
            accrualScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)accrualScheme.getLong("id"), (String)"ar_accrualscheme", (String)"accrualfrequency");
            obj.set("period", (Object)BaddebtHelper.getCurrentPeriod(accrualScheme.getString("accrualfrequency"), init.getDynamicObject("startperiod").getLong("id")));
        }
        obj.set("isfirst", (Object)Boolean.TRUE);
        obj.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        obj.set("createtime", (Object)this.currentDate);
        obj.set("policyid", (Object)init.getLong("policyid"));
        return obj;
    }
}

