/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.servicehelper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.ar.mservice.verify.ArSaloutAutoVerifyService;
import kd.fi.ar.mservice.verify.VerifyServiceFactory;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.enums.ARVerifyStatusEnum;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.Settle4ScmcHelper;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.service.helper.ValidOperationServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class RevCfmBillSerivceHelper {
    private static RevCfmBillSerivceHelper instance = new RevCfmBillSerivceHelper();
    private static final Log logger = LogFactory.getLog(RevCfmBillSerivceHelper.class);

    public static RevCfmBillSerivceHelper getInstance() {
        return instance;
    }

    public void genRevCfmBill(DynamicObject[] finbills) {
        ArrayList<Long> srcPks = new ArrayList<Long>();
        HashMap<Long, Boolean> orgMap = new HashMap<Long, Boolean>();
        long sum = 0L;
        ArrayList srcPksList = new ArrayList(10);
        int maxRow = Integer.parseInt(ArApHelper.getMaxPushRows());
        for (int i = 0; i < finbills.length; ++i) {
            ArrayList<Long> pk;
            DynamicObject finbill = finbills[i];
            DynamicObjectCollection dynamicObjectCollection = finbill.getDynamicObjectCollection("entry");
            if (finbill.getBoolean("istransfer") || finbill.getBoolean("iswrittenoff") || finbill.getBoolean("ispremium")) continue;
            long orgPk = finbill.getDynamicObject("org").getLong("id");
            boolean ar005 = false;
            if (!orgMap.containsKey(orgPk)) {
                ar005 = SystemParameterHelper.getParameterBoolean((long)orgPk, (String)"ar_005");
                orgMap.put(orgPk, ar005);
            } else {
                ar005 = (Boolean)orgMap.get(orgPk);
            }
            if (!ar005) continue;
            DynamicObject billType = finbill.getDynamicObject("billtype");
            if (!ObjectUtils.isEmpty((Object)billType)) {
                BigDecimal amount = finbill.getBigDecimal("amount");
                if ("arfin_borrowar_BT_S".equals(billType.getString("number")) && amount.compareTo(BigDecimal.ZERO) == 0) continue;
            }
            if (dynamicObjectCollection.size() >= maxRow) {
                pk = new ArrayList<Long>(1);
                pk.add(finbill.getLong("id"));
                srcPksList.add(pk);
                continue;
            }
            if ((sum += (long)dynamicObjectCollection.size()) >= (long)maxRow) {
                pk = new ArrayList(srcPks);
                srcPksList.add(pk);
                srcPks.clear();
                --i;
                sum = 0L;
                continue;
            }
            srcPks.add(finbill.getLong("id"));
        }
        if (!srcPks.isEmpty()) {
            srcPksList.add(srcPks);
        }
        ArrayList<DynamicObject> trgBills = new ArrayList<DynamicObject>(srcPksList.size());
        for (List list : srcPksList) {
            Map map = BOTPHelper.push4Result((String)"ar_finarbill", (String)"ar_revcfmbill", null, (List)list);
            Object target = map.get("convertResult");
            String msg = null;
            if (target != null) {
                ConvertOperationResult result = (ConvertOperationResult)target;
                msg = BOTPHelper.getConvertReport((ConvertOperationResult)result);
                logger.info("------botp.ConvertReport------" + msg);
                ErrorCode ec = new ErrorCode("botp", msg);
                throw new KDBizException(ec, new Object[0]);
            }
            trgBills.addAll((List)map.get("trgBills"));
        }
        if (trgBills.isEmpty()) {
            return;
        }
        this.buildRevCfmBill(trgBills);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"noprotocolsubmit", (String)"ar_revcfmbill", (DynamicObject[])trgBills.toArray(new DynamicObject[0]), (OperateOption)option);
        if (!operationResult.isSuccess()) {
            logger.info("------submitResult.Message------" + operationResult.getMessage());
            OperationHelper.assertResult((OperationResult)operationResult);
        } else {
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ar_revcfmbill", (Object[])operationResult.getSuccessPkIds().toArray(), (OperateOption)option);
            if (!auditResult.isSuccess()) {
                logger.info("------auditResult.Message------" + auditResult.getMessage());
                OperationHelper.assertResult((OperationResult)auditResult);
            }
        }
    }

    private List<DynamicObject> buildRevCfmBill(List<DynamicObject> trgBills) {
        BigDecimal confirmRate = new BigDecimal("100");
        Date currentDate = DateUtils.truncateDate((Date)new Date());
        DynamicObject trgBill = trgBills.get(0);
        String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"ar_revcfmbill", (DynamicObject)trgBill, (String)trgBill.getDynamicObject("org").getPkValue().toString(), (int)trgBills.size());
        int i = 0;
        for (DynamicObject trgbill : trgBills) {
            trgbill.set("billsrctype", (Object)BillSrcTypeEnum.PARAM.getValue());
            if (EmptyUtils.isEmpty((Object)trgbill.getString("billno"))) {
                trgbill.set("billno", (Object)numbers[i]);
            }
            trgbill.set("confirmrate", (Object)confirmRate);
            if (EmptyUtils.isEmpty((Object)trgbill.getDate("bizdate"))) {
                trgbill.set("bizdate", (Object)currentDate);
            }
            ++i;
        }
        BookDateHelper.setBookDate((DynamicObject[])trgBills.toArray(new DynamicObject[0]), (boolean)true);
        return trgBills;
    }

    public void delRevCfmBill(DynamicObject[] finbills) {
        QFilter qFilter = new QFilter("sourcebillid", "in", (Object)ArApHelper.getPks((Object)finbills));
        Object[] cfmBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"id,org,iswrittenoff,sourcebilltype,sourcebillid,asstacttype,asstact,verifystatus,currency,entry.e_corebilltype,billsrctype,entry.e_confirmqty,entry.e_confirmamt,entry.e_corebillid,entry.e_unitcoefficient,entry.linetype,entry.e_corebillentryid,entry.e_conbillentity,entry.e_conbillid,entry.e_conbillentryid,id, isvoucher, billtype,iswrittenoff", (QFilter[])new QFilter[]{qFilter});
        if (!ObjectUtils.isEmpty((Object[])cfmBills)) {
            ArrayList<Long> pks = new ArrayList<Long>();
            HashMap<Long, Boolean> orgMap = new HashMap<Long, Boolean>();
            for (Object cfmbill : cfmBills) {
                long orgPk = cfmbill.getDynamicObject("org").getLong("id");
                Boolean isvoucher = cfmbill.getBoolean("isvoucher");
                boolean ar005 = false;
                if (!orgMap.containsKey(orgPk)) {
                    ar005 = SystemParameterHelper.getParameterBoolean((long)orgPk, (String)"ar_005");
                    orgMap.put(orgPk, ar005);
                } else {
                    ar005 = (Boolean)orgMap.get(orgPk);
                }
                if (!ar005 || isvoucher.booleanValue()) continue;
                pks.add(cfmbill.getLong("id"));
            }
            DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"UnWriteOffCheckService", (String)"batchCheck", (Object[])new Object[]{"ar_revcfmbill", pks, "unaudit"});
            if (!pks.isEmpty()) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("nochk", "true");
                long end = System.currentTimeMillis();
                OperationResult result = OperationServiceHelper.executeOperate((String)"fakeunaudit", (String)"ar_revcfmbill", (Object[])pks.toArray(), (OperateOption)option);
                if (!result.isSuccess()) {
                    logger.info("------result.Message------" + result.getMessage());
                    OperationHelper.assertResult((OperationResult)result);
                }
                long userId = RequestContext.get().getCurrUserId();
                Date date = new Date();
                String pksString = pks.stream().map(Object::toString).collect(Collectors.joining(","));
                DB.execute((DBRoute)DBRouteConst.AR, (String)("update t_ar_revcfmbill set FBILLSTATUS = ?,fauditorid = ?, fauditdate = ? where FID in (" + pksString + ");"), (Object[])new Object[]{BillStatusEnum.SAVE.getValue(), userId, date});
                logger.info("------unaudit------" + (end - System.currentTimeMillis()));
                ArrayList<Object> entitiesList = new ArrayList<Object>(pks.size());
                for (Object e : pks) {
                    for (Object trgBill : cfmBills) {
                        if (!e.equals(trgBill.getPkValue())) continue;
                        entitiesList.add(trgBill);
                    }
                }
                ArrayList params = new ArrayList();
                ArApProcessParamsHelper.processRevcfmToSmParams(params, (DynamicObject[])cfmBills, (boolean)false);
                Settle4ScmcHelper.disposeArRevcfmToSalOrder(params);
                DynamicObject[] dynamicObjectArray = entitiesList.toArray(new DynamicObject[0]);
                ArrayList<Object> canUnVerifyPks = new ArrayList<Object>();
                ArrayList<Long> noVerifyPks = new ArrayList<Long>(2);
                for (DynamicObject entity : dynamicObjectArray) {
                    String verifyStatus = entity.getString("verifystatus");
                    if (!ARVerifyStatusEnum.UNVERIFY.getValue().equals(verifyStatus) && !entity.getBoolean("iswrittenoff")) {
                        canUnVerifyPks.add(entity.getPkValue());
                        continue;
                    }
                    noVerifyPks.add(entity.getLong("id"));
                }
                List<Long> fiVerifyRevcfmBillIds = this.getFiVerifyRevcfmBillId(pks);
                if (canUnVerifyPks.size() > 0) {
                    ArSaloutAutoVerifyService service = new ArSaloutAutoVerifyService();
                    service.unAutoVerify(canUnVerifyPks.toArray(), false);
                }
                noVerifyPks.addAll(fiVerifyRevcfmBillIds);
                if (noVerifyPks.size() > 0) {
                    logger.info("\u9700\u8981\u5e94\u6536\u6267\u884c\u5220\u9664\u6536\u5165\u786e\u8ba4\u5355\u7684id\u4e3a\uff1a" + fiVerifyRevcfmBillIds.size());
                    OperateOption optionDel = OperateOption.create();
                    optionDel.setVariableValue("ishasright", "true");
                    optionDel.setVariableValue("isStrict", "false");
                    optionDel.setVariableValue("ignoreValidation", "true");
                    optionDel.setVariableValue("mutex_writeback", "false");
                    OperationResult delResult = OperationServiceHelper.executeOperate((String)"stddel", (String)"ar_revcfmbill", (Object[])noVerifyPks.toArray(), (OperateOption)optionDel);
                    OperationHelper.assertResult((OperationResult)delResult);
                    Boolean isSuccess = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)"ar_revcfmbill", (String)"stddel", noVerifyPks, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.DELETEWRITE);
                    logger.info("Voucher Delete White List result: " + isSuccess);
                }
            }
        }
    }

    private List<Long> getFiVerifyRevcfmBillId(List<Long> revcfmBillIds) {
        ArrayList<Long> revcfmBills = new ArrayList<Long>(2);
        QFilter asstFilter = new QFilter("entry.e_billid", "in", revcfmBillIds);
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ar_revcfmbill", (Object[])revcfmBillIds.toArray(), (boolean)true);
        if (commonFilter != null) {
            asstFilter.and(commonFilter);
        }
        DataSet recordAssts = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ar_verifyrecord", (String)"id,writeofftypeid,entry.e_billid", (QFilter[])new QFilter[]{asstFilter}, null);
        for (Row record : recordAssts) {
            Long writeoffTypeId = record.getLong("writeofftypeid");
            if (writeoffTypeId != null && writeoffTypeId != 0L) continue;
            revcfmBills.add(record.getLong("entry.e_billid"));
        }
        return revcfmBills;
    }

    public void delRedRevcfmBill(DynamicObject[] finArBills) {
        HashSet<Long> srcFinBillIds = new HashSet<Long>(finArBills.length);
        ArrayList<Long> orgIds = new ArrayList<Long>(finArBills.length);
        for (DynamicObject finArBill : finArBills) {
            if (!finArBill.getBoolean("iswrittenoff")) continue;
            Long orgId = finArBill.getLong("org.id");
            orgIds.add(orgId);
            srcFinBillIds.add(Long.parseLong(finArBill.getString("sourcebillid")));
        }
        DynamicObject[] revcfmBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", srcFinBillIds), new QFilter("org", "in", orgIds), new QFilter("hadwrittenoff", "=", (Object)Boolean.TRUE)});
        HashSet<Long> revcfmBillIds = new HashSet<Long>(revcfmBills.length);
        for (DynamicObject dynamicObject : revcfmBills) {
            revcfmBillIds.add(dynamicObject.getLong("id"));
        }
        HashSet redRevcfmBillIds = new HashSet(revcfmBillIds.size());
        DynamicObjectCollection redRevcfmBills = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", revcfmBillIds), new QFilter("org", "in", orgIds), new QFilter("billsrctype", "=", (Object)"11")});
        redRevcfmBills.stream().forEach(redRevcfmBill -> redRevcfmBillIds.add(redRevcfmBill.getLong("id")));
        Set sourceBillIdSet = redRevcfmBills.stream().map(redRevcfmBill -> redRevcfmBill.getLong("sourcebillid")).collect(Collectors.toSet());
        for (DynamicObject dynamicObject : revcfmBills) {
            long srcId = dynamicObject.getLong("id");
            if (!sourceBillIdSet.contains(srcId)) continue;
            dynamicObject.set("hadwrittenoff", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.save((DynamicObject[])revcfmBills);
        if (!ObjectUtils.isEmpty(redRevcfmBillIds)) {
            DynamicObject[] verifyRecords;
            DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"org,iswrittenoff,sourcebillid,sourcebilltype,asstacttype,asstact,verifystatus,currency,entry.e_corebilltype,billsrctype,entry.e_confirmqty,entry.e_confirmamt,entry.e_corebillid,entry.e_unitcoefficient,entry.e_corebillentryid,entry.e_conbillentity,entry.e_conbillid,entry.e_conbillentryid,entry.linetype", (QFilter[])new QFilter[]{new QFilter("id", "in", redRevcfmBillIds)});
            ArrayList params = new ArrayList();
            ArApProcessParamsHelper.processRevcfmToSmParams(params, (DynamicObject[])dynamicObjectArray, (boolean)false);
            Settle4ScmcHelper.disposeArRevcfmToSalOrder(params);
            for (DynamicObject result : verifyRecords = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)this.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("billid", "in", revcfmBillIds), new QFilter("entry.e_billid", "in", redRevcfmBillIds)})) {
                if (!result.getBoolean("isvoucher")) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"RevCfmBillSerivceHelper_1", (String)"fi-ar-business", (Object[])new Object[0]));
            }
            Map map = VerifyServiceHelper.classfyByRelation((DynamicObject[])verifyRecords);
            for (Map.Entry entry : map.entrySet()) {
                AbstractVerifyTemplate verifyTemplate = VerifyServiceFactory.getService((String)((String)entry.getKey()));
                verifyTemplate.unVerify(((List)entry.getValue()).toArray(new DynamicObject[0]));
            }
            Object[] pkIds = redRevcfmBills.stream().map(redRevCfmBill -> redRevCfmBill.getLong("sourcebillid")).toArray();
            ValidOperationServiceHelper.valid((String)"ar_revcfmbill", (Object[])pkIds);
            OperationServiceHelper.executeOperate((String)"nocheckdel", (String)"ar_revcfmbill", (Object[])redRevcfmBillIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
            Boolean isSuccess = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)"ar_revcfmbill", (String)"nocheckdel", new ArrayList(redRevcfmBillIds), (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.DELETEWRITE);
            logger.info("Voucher Delete White List result: " + isSuccess);
        }
    }

    private String getVerifyRecordSelects() {
        return "org,billid,billno,billtype,billentryid,qty,measureunit,verifyqty,verifybaseqty,payableamount,verifyamount,verifytype,isvoucher,verifyrelation,e_billtype,e_qty,e_measureunit,e_verifyqty,e_verifybaseqty,e_payableamount,e_verifyamount,e_billid,e_billno,e_billentryid,currency,e_currency,e_verifytaxamount,verifytaxamount,e_writtenoffremark,e_iswrittenoff,e_hadwrittenoff";
    }
}

