/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.business.warn;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.service.earlywarn.impl.DefaultEarlyWarnBillDataSource;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArAdjustEarlyWarnDataSource
extends DefaultEarlyWarnBillDataSource {
    public List<QFilter> buildFilter(String dataSource, FilterCondition filterCondition, EarlyWarnContext context) {
        List filterList = super.buildFilter(dataSource, filterCondition, context);
        HashSet<Long> needWarnFinArBill = new HashSet<Long>(64);
        DynamicObjectCollection allFinArBill = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,org,entry.id entryId,entry.e_amount e_amount,entry.e_localamt e_localamt,exchangerate,entry.e_invoicedamt einvamtm,entry.e_invoicedlocalamt elocalinvamt", (QFilter[])filterList.toArray(new QFilter[0]));
        if (EmptyUtils.isNotEmpty((Object)allFinArBill)) {
            Long[] arEntryIdArray = (Long[])allFinArBill.stream().map(finar -> finar.getLong("entryId")).toArray(Long[]::new);
            List<Long> finArOrgIds = allFinArBill.stream().map(finar -> finar.getLong("org")).distinct().collect(Collectors.toList());
            Map ar026Map = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, finArOrgIds, (String)"ar_026");
            Map targetRowIdsMap = BOTPHelper.loadTargetRowIdsMap((String)"ar_finarbill", (String)"entry", (Long[])arEntryIdArray, (String)"sim_original_bill");
            Set<Long> botpExistOriIdSet = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            Map<Long, DynamicObject> recordEntryIdOriginalMap = this.getRecordEntryIdOriginalMap(arEntryIdArray, targetRowIdsMap);
            Map<Long, DynamicObject> simEntryObjMap = this.prepareSimBills(targetRowIdsMap);
            this.updateSimEntryObj(simEntryObjMap, recordEntryIdOriginalMap, botpExistOriIdSet);
            ArrayList<Long> finArEntryIds = new ArrayList<Long>(allFinArBill.size());
            if (EmptyUtils.isNotEmpty(simEntryObjMap)) {
                for (DynamicObject finAr : allFinArBill) {
                    Set simEntryIds = (Set)targetRowIdsMap.get(finAr.getLong("entryId"));
                    Object ar026 = ar026Map.get(finAr.getLong("org"));
                    if (EmptyUtils.isEmpty((Object)simEntryIds) || ar026 == null || !((Boolean)ar026).booleanValue()) continue;
                    BigDecimal hasOpenInvAmt = BigDecimal.ZERO;
                    BigDecimal hasOpenInvLocAmt = BigDecimal.ZERO;
                    for (Long simEntryId : simEntryIds) {
                        DynamicObject simEntry = simEntryObjMap.get(simEntryId);
                        if (simEntry == null) continue;
                        hasOpenInvAmt = hasOpenInvAmt.add(simEntry.getBigDecimal("issuedamount"));
                        hasOpenInvLocAmt = hasOpenInvLocAmt.add(simEntry.getBigDecimal("fromissuedamount"));
                    }
                    if (hasOpenInvAmt.compareTo(finAr.getBigDecimal("e_amount")) == 0 && hasOpenInvLocAmt.compareTo(finAr.getBigDecimal("e_localamt")) == 0) continue;
                    needWarnFinArBill.add(finAr.getLong("id"));
                    finArEntryIds.add(finAr.getLong("entryId"));
                }
            }
            Map<Long, DynamicObject> adjustMap = this.prepareAdjustBill(finArOrgIds, needWarnFinArBill, finArEntryIds);
            Map targetInvRowIdsMap = BOTPHelper.loadTargetRowIdsMap((String)"ar_finarbill", (String)"entry", (Long[])arEntryIdArray, (String)"ar_invoice");
            Map<Long, DynamicObject> invEntryObjMap = this.prepareInvBills(targetInvRowIdsMap);
            if (EmptyUtils.isNotEmpty(invEntryObjMap)) {
                for (DynamicObject finAr : allFinArBill) {
                    Set invEntryIds = (Set)targetInvRowIdsMap.get(finAr.getLong("entryId"));
                    Object ar026 = ar026Map.get(finAr.getLong("org"));
                    if (EmptyUtils.isEmpty((Object)invEntryIds) || ar026 == null || !((Boolean)ar026).booleanValue() || adjustMap.get(finAr.getLong("entryId")) != null) continue;
                    BigDecimal hasOpenInvAmt = BigDecimal.ZERO;
                    for (Long invEntryId : invEntryIds) {
                        DynamicObject invEntry = invEntryObjMap.get(invEntryId);
                        if (invEntry == null) continue;
                        BigDecimal exchangerate = invEntry.getBigDecimal("exchangerate");
                        BigDecimal diffAmt = invEntry.getBigDecimal("ediffamount");
                        if (exchangerate.compareTo(BigDecimal.ONE) == 0) {
                            BigDecimal eamount = invEntry.getBigDecimal("eamount");
                            hasOpenInvAmt = hasOpenInvAmt.add(eamount).subtract(diffAmt);
                            continue;
                        }
                        BigDecimal eLocalAmount = invEntry.getBigDecimal("elocalamt");
                        hasOpenInvAmt = hasOpenInvAmt.add(eLocalAmount).subtract(diffAmt);
                    }
                    BigDecimal exRate = finAr.getBigDecimal("exchangerate");
                    if ((exRate.compareTo(BigDecimal.ONE) != 0 || hasOpenInvAmt.compareTo(finAr.getBigDecimal("e_amount")) == 0) && (exRate.compareTo(BigDecimal.ONE) == 0 || hasOpenInvAmt.compareTo(finAr.getBigDecimal("e_localamt")) == 0)) continue;
                    needWarnFinArBill.add(finAr.getLong("id"));
                }
            }
        }
        filterList.add(new QFilter("id", "in", needWarnFinArBill));
        return filterList;
    }

    private Map<Long, DynamicObject> prepareAdjustBill(List<Long> finArOrgIds, Set<Long> finArIds, List<Long> finArEntryIds) {
        String selector = "entry.e_srcid,entry.e_srcentryid";
        DynamicObjectCollection adjustBillColl = QueryServiceHelper.query((String)"ar_finarbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("org.id", "in", finArOrgIds), new QFilter("entry.e_srcid", "in", finArIds), new QFilter("entry.e_srcentryid", "in", finArEntryIds), new QFilter("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue()), new QFilter("billtype.number", "=", (Object)"arfin_borrowar_BT_S"), new QFilter("adjusttype", "=", (Object)"adjustinv"), new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE)});
        return adjustBillColl.stream().collect(Collectors.toMap(bill -> bill.getLong("entry.e_srcentryid"), bill -> bill, (m, n) -> n));
    }

    public DynamicObjectCollection getData(String dataSource, List<QFilter> filterList, EarlyWarnContext context) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"billno,creator", (QFilter[])filterList.toArray(new QFilter[0]));
        collection.addAll(Arrays.asList(datas));
        return collection;
    }

    private Map<Long, DynamicObject> prepareSimBills(Map<Long, Set<Long>> targetRowIdsMap) {
        if (EmptyUtils.isEmpty(targetRowIdsMap)) {
            return null;
        }
        Set simBillEntryId = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObjectCollection simBillEntry = QueryServiceHelper.query((String)"sim_original_bill", (String)"sim_original_bill_item.id entryId,sim_original_bill_item.issuedamount issuedamount,sim_original_bill_item.fromissuedamount fromissuedamount", (QFilter[])new QFilter[]{new QFilter("sim_original_bill_item.id", "in", simBillEntryId)});
        return simBillEntry.stream().collect(Collectors.toMap(sim -> sim.getLong("entryId"), sim -> sim));
    }

    private Map<Long, DynamicObject> prepareInvBills(Map<Long, Set<Long>> targetRowIdsMap) {
        if (EmptyUtils.isEmpty(targetRowIdsMap)) {
            return null;
        }
        Set invoiceEntryId = targetRowIdsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObjectCollection invBillEntry = QueryServiceHelper.query((String)"ar_invoice", (String)"entry.id entryId,exchangerate,entry.e_amount eamount,entry.e_localamt elocalamt,entry.e_diffamount ediffamount", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", invoiceEntryId)});
        return invBillEntry.stream().collect(Collectors.toMap(inv -> inv.getLong("entryId"), inv -> inv));
    }

    private Map<Long, DynamicObject> getRecordEntryIdOriginalMap(Long[] finArEntryIds, Map<Long, Set<Long>> targetRowIdsMap) {
        HashMap<Long, DynamicObject> recordEntryIdOriginalMap = new HashMap<Long, DynamicObject>(8);
        HashSet<Long> hxlbSet = new HashSet<Long>(2);
        Long HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP = 1693748335779055616L;
        Long HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP = 1693749472343164928L;
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_QTY_BOTP);
        hxlbSet.add(HXLB_AR_ORIGINAL_VERIFY_AMOUNT_BOTP);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"ar_originalwfrecord", (String)"id,entry.billentryid,entry.assbillentryid,entry.assverifyamt,entry.assverifylocamt", (QFilter[])new QFilter[]{new QFilter("writeofftypeid", "not in", hxlbSet), new QFilter("entry.billentryid", "in", (Object)finArEntryIds)});
        for (DynamicObject record : records) {
            Long arEntryId = record.getLong("entry.billentryid");
            long oriId = record.getLong("entry.assbillentryid");
            Set originalEntryIdSet = targetRowIdsMap.getOrDefault(arEntryId, new HashSet(8));
            originalEntryIdSet.add(oriId);
            recordEntryIdOriginalMap.put(oriId, record);
            targetRowIdsMap.put(arEntryId, originalEntryIdSet);
        }
        return recordEntryIdOriginalMap;
    }

    private void updateSimEntryObj(Map<Long, DynamicObject> simEntryObjMap, Map<Long, DynamicObject> recordEntryIdOriginalMap, Set<Long> botpExistOriIdSet) {
        if (ObjectUtils.isEmpty(recordEntryIdOriginalMap) || botpExistOriIdSet == null) {
            return;
        }
        for (Map.Entry<Long, DynamicObject> entry : recordEntryIdOriginalMap.entrySet()) {
            Long oriId = entry.getKey();
            DynamicObject recordOriginal = recordEntryIdOriginalMap.get(oriId);
            DynamicObject botpOriginal = simEntryObjMap.get(oriId);
            if (recordOriginal == null || botpOriginal == null) continue;
            BigDecimal recordAmount = recordOriginal.getBigDecimal("entry.assverifyamt");
            BigDecimal recordLocAmount = recordOriginal.getBigDecimal("entry.assverifylocamt");
            BigDecimal issuedAmount = botpOriginal.getBigDecimal("issuedamount");
            BigDecimal issuedLocAmount = botpOriginal.getBigDecimal("fromissuedamount");
            if (botpExistOriIdSet.contains(oriId)) {
                botpOriginal.set("issuedamount", (Object)issuedAmount.add(recordAmount));
                botpOriginal.set("fromissuedamount", (Object)issuedLocAmount.add(recordLocAmount));
                simEntryObjMap.put(oriId, botpOriginal);
                continue;
            }
            botpOriginal.set("issuedamount", (Object)recordAmount);
            botpOriginal.set("fromissuedamount", (Object)recordLocAmount);
            simEntryObjMap.put(oriId, botpOriginal);
        }
    }
}

