/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.InitServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ArPlanSplitAndBuilder;
import kd.bos.ext.fi.util.QueryUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.convert.InitConvertHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.LineTypeHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;

public class InvoiceToFinArConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(InvoiceToFinArConvertPlugin.class);
    private Map<Long, DynamicObject> orgInitMap;
    private Map<Object, DynamicObject> customerMap;
    private Map<Long, List<Long>> invoiceIdToBusIdsMap;
    private Map<Long, Object> orgIsEnableLineTypeMap;
    private final Map<Long, Map<DynamicObject, DynamicObject>> billTypeToBizTypeMap = new HashMap<Long, Map<DynamicObject, DynamicObject>>(1);
    private DynamicObject[] needMatchSplitSchemes;
    private final QueryUtil queryUtil = new QueryUtil();
    private final Map<Long, List<DynamicObject>> detailEntriesCache = new HashMap<Long, List<DynamicObject>>(1);

    public void initVariable(InitVariableEventArgs e) {
    }

    public void afterConvert(AfterConvertEventArgs e) {
        logger.info("InvoiceToFinArConvertPlugin.afterConvert start");
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        this.prepareData(entities);
        for (DynamicObject finArBill : entities) {
            DynamicObject org = finArBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitServiceHelper.checkOrgInit((DynamicObject)org, this.orgInitMap, (boolean)true);
            this.setHeadValue(finArBill);
            this.setDetailEntryValue(finArBill);
        }
        for (DynamicObject finArBill : entities) {
            this.setHeadAmtValue(finArBill);
            this.setPlanEntryValue(finArBill);
        }
        logger.info("InvoiceToFinArConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        logger.info("InvoiceToFinArConvertPlugin.prepareData start");
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> asstactIds = new HashSet<Long>(1);
        HashSet<Long> srcInvSet = new HashSet<Long>(1);
        HashSet<Long> srcInvEntrySet = new HashSet<Long>(1);
        HashSet<Long> billTypeIds = new HashSet<Long>(1);
        for (DynamicObject entity : entities) {
            long orgId = entity.getLong("org.id");
            if (orgId != 0L) {
                orgIds.add(orgId);
            }
            asstactIds.add(entity.getLong("asstact.id"));
            if ("ar_invoice".equals(entity.getString("sourcebilltype"))) {
                srcInvSet.add(entity.getLong("sourcebillid"));
                DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entryColl) {
                    srcInvEntrySet.add(entry.getLong("e_srcentryid"));
                }
            }
            billTypeIds.add(entity.getLong("billtype.id"));
        }
        this.orgInitMap = InitServiceHelper.loadInitInfos(orgIds, (boolean)true);
        this.orgIsEnableLineTypeMap = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.TRUE, new ArrayList(orgIds), (String)"ar_025");
        this.customerMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"delivercustomerid,invoicecustomerid,paymentcustomerid", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        this.invoiceIdToBusIdsMap = BOTPHelper.loadNearUpBillIds((String)"ar_invoice", (String)"entry", (Long[])srcInvSet.toArray(new Long[0]), (Long[])srcInvEntrySet.toArray(new Long[0]), (String)"ar_busbill");
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes((String)"ar_finarbill");
        for (Long billTypeId : billTypeIds) {
            HashMap<DynamicObject, DynamicObject> paramMap = new HashMap<DynamicObject, DynamicObject>(1);
            DynamicObject bizType = LineTypeHelper.getDefaultBizType((long)billTypeId);
            long bizTypeId = bizType == null ? 0L : bizType.getLong("id");
            DynamicObject lineType = LineTypeHelper.getDefaultLineType((Long)bizTypeId);
            paramMap.put(bizType, lineType);
            this.billTypeToBizTypeMap.put(billTypeId, paramMap);
        }
        logger.info("InvoiceToFinArConvertPlugin.prepareData end");
    }

    private void setHeadValue(DynamicObject finArBill) {
        long billTypeId;
        Map<DynamicObject, DynamicObject> bizTypeToLineType;
        Boolean isEnableLineType;
        boolean isOnlyFromInv;
        logger.info("InvoiceToFinArConvertPlugin.setHeadValue start");
        DynamicObject org = finArBill.getDynamicObject("org");
        InitServiceHelper.setBizDate((DynamicObject)finArBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (ConvertRuleElement)this.getRule());
        boolean isSettingForExchange = BOTPHelper.ruleIsSetting((ConvertRuleElement)this.getRule(), (boolean)true, (String)"exchangerate");
        InitServiceHelper.setInitValue((DynamicObject)finArBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (boolean)isSettingForExchange);
        DynamicObject recorg = finArBill.getDynamicObject("recorg");
        if (ObjectUtils.isEmpty((Object)recorg) || !recorg.getBoolean("fisbankroll")) {
            finArBill.set("recorg", (Object)org);
            recorg = org;
        }
        if (!ObjectUtils.isEmpty((Object)recorg) && !recorg.getBoolean("fisbankroll")) {
            finArBill.set("recorg", null);
        }
        Long asstactId = finArBill.getLong("asstact.id");
        DynamicObject customer = this.customerMap.get(asstactId);
        Long invId = finArBill.getLong("sourcebillid");
        List<Long> busIds = this.invoiceIdToBusIdsMap.get(invId);
        boolean bl = isOnlyFromInv = busIds == null && "ar_invoice".equals(finArBill.getString("sourcebilltype"));
        if (customer != null && isOnlyFromInv) {
            DynamicObject payCusId = customer.getDynamicObject("paymentcustomerid");
            finArBill.set("paymentcustomerid", (Object)payCusId);
        }
        if ((isEnableLineType = (Boolean)this.orgIsEnableLineTypeMap.get(org.getLong("id"))).booleanValue() && (bizTypeToLineType = this.billTypeToBizTypeMap.get(billTypeId = finArBill.getLong("billtype.id"))) != null) {
            for (Map.Entry<DynamicObject, DynamicObject> entry : bizTypeToLineType.entrySet()) {
                finArBill.set("biztype", (Object)entry.getKey());
            }
        }
        logger.info("InvoiceToFinArConvertPlugin.setHeadValue end");
    }

    private void setDetailEntryValue(DynamicObject finArBill) {
        logger.info("InvoiceToFinArConvertPlugin.setDetailEntryValue start");
        this.calculateDetailEntry(finArBill);
        this.setDetailEntryOtherValue(finArBill);
        if (this.isPushAndSave(finArBill)) {
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finArBill.getLong("id"));
            if (detailEntries == null) {
                ArrayList finArDetailEntries = new ArrayList(8);
                finArDetailEntries.addAll(finArBill.getDynamicObjectCollection("entry"));
                this.detailEntriesCache.put(finArBill.getLong("id"), finArDetailEntries);
            } else {
                detailEntries.addAll((Collection<DynamicObject>)finArBill.getDynamicObjectCollection("entry"));
            }
        }
        logger.info("InvoiceToFinArConvertPlugin.setDetailEntryValue end");
    }

    private void setHeadAmtValue(DynamicObject finArBill) {
        logger.info("InvoiceToFinArConvertPlugin.setHeadAmtValue start");
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        Object detailEntries = this.isPushAndSave(finArBill) ? this.detailEntriesCache.get(finArBill.getLong("id")) : finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_recamount"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_reclocalamt"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_localamt"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finArBill.set("recamount", (Object)priceTaxTotal);
        finArBill.set("reclocalamt", (Object)priceTaxTotalBase);
        finArBill.set("amount", (Object)amount);
        finArBill.set("localamt", (Object)amountBase);
        finArBill.set("tax", (Object)tax);
        finArBill.set("taxlocamt", (Object)taxLocAmt);
        finArBill.set("unverifyamount", (Object)amount);
        finArBill.set("unsettleamount", (Object)priceTaxTotal);
        finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBase);
        finArBill.set("adjustamount", (Object)adjustamt);
        finArBill.set("adjustlocalamt", (Object)adjustamtlocal);
        finArBill.set("invoicedamt", (Object)priceTaxTotal);
        finArBill.set("invoicedlocalamt", (Object)priceTaxTotalBase);
        logger.info("InvoiceToFinArConvertPlugin.setHeadAmtValue end");
    }

    private void setPlanEntryValue(DynamicObject finArBill) {
        logger.info("InvoiceToFinArConvertPlugin.setPlanEntryValue start");
        DynamicObject matchSplitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme((DynamicObject)finArBill, (DynamicObject[])this.needMatchSplitSchemes);
        finArBill.set("splitscheme", (Object)matchSplitScheme);
        if (this.isPushAndSave(finArBill)) {
            this.calculatePlanEntryByPushAndSave(finArBill, matchSplitScheme);
        } else {
            ArPlanSplitAndBuilder.splitAndBuild((DynamicObject)finArBill, (DynamicObject)matchSplitScheme);
        }
        this.setHeadDueDate(finArBill);
        logger.info("InvoiceToFinArConvertPlugin.setPlanEntryValue end");
    }

    private void calculatePlanEntryByPushAndSave(DynamicObject finArBill, DynamicObject matchSplitScheme) {
        DynamicObject[] dbFinArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"e_splitdimensionid,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finArBill.getLong("id"))});
        if (dbFinArBills == null || dbFinArBills.length == 0) {
            ArPlanSplitAndBuilder.splitAndBuild((DynamicObject)finArBill, (DynamicObject)matchSplitScheme);
        } else {
            DynamicObject dbFinArBill = dbFinArBills[0];
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finArBill.getLong("id"));
            Map detailEntryIndexToSplitDimensionId = ArPlanSplitAndBuilder.splitAndBuildByPushAndSave((DynamicObject)finArBill, detailEntries, (DynamicObject)matchSplitScheme);
            DynamicObjectCollection dbDetailEntries = dbFinArBill.getDynamicObjectCollection("entry");
            DynamicObjectCollection curDetailEntries = finArBill.getDynamicObjectCollection("entry");
            int dbDetailEntrySize = dbDetailEntries.size();
            for (int i = 0; i < dbDetailEntrySize; ++i) {
                DynamicObject dbDetailEntry = (DynamicObject)dbDetailEntries.get(i);
                dbDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i));
            }
            int curDetailEntrySize = curDetailEntries.size();
            for (int i = 0; i < curDetailEntrySize; ++i) {
                DynamicObject curDetailEntry = (DynamicObject)curDetailEntries.get(i);
                curDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i + dbDetailEntrySize));
            }
            DynamicObjectCollection dbPlanEntries = dbFinArBill.getDynamicObjectCollection("planentity");
            dbPlanEntries.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbFinArBill});
        }
    }

    private void setHeadDueDate(DynamicObject finArBill) {
        Date planMaxDuedate = finArBill.getDate("duedate");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finArBill.set("duedate", (Object)planMaxDuedate);
    }

    private void setDetailEntryOtherValue(DynamicObject finArBill) {
        long billTypeId = finArBill.getLong("billtype.id");
        Map<DynamicObject, DynamicObject> bizTypeToLineType = this.billTypeToBizTypeMap.get(billTypeId);
        Long asstactId = finArBill.getLong("asstact.id");
        DynamicObject customer = this.customerMap.get(asstactId);
        Long invId = finArBill.getLong("sourcebillid");
        List<Long> busIds = this.invoiceIdToBusIdsMap.get(invId);
        boolean isOnlyFromInv = busIds == null && "ar_invoice".equals(finArBill.getString("sourcebilltype"));
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            if (customer != null && isOnlyFromInv) {
                DynamicObject invCusId = customer.getDynamicObject("invoicecustomerid");
                DynamicObject delCusId = customer.getDynamicObject("delivercustomerid");
                detailEntry.set("e_invoicecustomerid", (Object)invCusId);
                detailEntry.set("e_delivercustomerid", (Object)delCusId);
            }
            if (bizTypeToLineType == null) continue;
            for (Map.Entry<DynamicObject, DynamicObject> bizTypeToLineTypeEntrySet : bizTypeToLineType.entrySet()) {
                DynamicObject lineType = detailEntry.getDynamicObject("linetype");
                if (!ObjectUtils.isEmpty((Object)lineType)) continue;
                detailEntry.set("linetype", (Object)bizTypeToLineTypeEntrySet.getValue());
            }
        }
    }

    private void calculateDetailEntry(DynamicObject finArBill) {
        BigDecimal exchangerate = finArBill.getBigDecimal("exchangerate");
        String quotation = finArBill.getString("quotation");
        if (exchangerate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int baseprecision = finArBill.getInt("basecurrency.amtprecision");
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal e_baseunitqty;
            boolean isPresent = detailEntry.getBoolean("e_ispresent");
            BigDecimal price = detailEntry.getBigDecimal("e_unitprice");
            BigDecimal priceTax = detailEntry.getBigDecimal("e_taxunitprice");
            boolean ispricetotal = finArBill.getBoolean("ispricetotal");
            if (ispricetotal && isPresent && (BigDecimal.ZERO.compareTo(price) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                BigDecimal e_baseunitqty2;
                BigDecimal covertRate;
                BigDecimal quantity = detailEntry.getBigDecimal("e_quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                boolean covertRateIsEmpty = (covertRate = detailEntry.getBigDecimal("e_unitcoefficient")) == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
                DynamicObject material = detailEntry.getDynamicObject("e_material");
                DynamicObject measureUnit = detailEntry.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                        detailEntry.set("e_baseunit", (Object)baseUnit);
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRateIsEmpty) {
                        covertRate = this.queryUtil.getConvertRate(Long.valueOf(material.getLong("id")), Long.valueOf(measureUnit.getLong("id")), Long.valueOf(baseUnit.getLong("id")));
                    }
                } else if (covertRateIsEmpty) {
                    covertRate = BigDecimal.ONE;
                }
                if (covertRateIsEmpty) {
                    detailEntry.set("e_unitcoefficient", (Object)covertRate);
                }
                if ((e_baseunitqty2 = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty2.compareTo(BigDecimal.ZERO) == 0) {
                    detailEntry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit));
                }
                detailEntry.set("e_unverifyqty", (Object)quantity);
                detailEntry.set("e_unconfirmqty", (Object)quantity);
                detailEntry.set("e_invoicedqty", (Object)quantity);
                detailEntry.set("e_uninvoicedqty", (Object)BigDecimal.ZERO);
                continue;
            }
            BigDecimal e_recAmount = detailEntry.getBigDecimal("e_recamount");
            BigDecimal e_reclocalamt = detailEntry.getBigDecimal("e_reclocalamt");
            BigDecimal e_amount = detailEntry.getBigDecimal("e_amount");
            BigDecimal e_tax = detailEntry.getBigDecimal("e_tax");
            BigDecimal e_adjustamount = detailEntry.getBigDecimal("e_adjustamount");
            BigDecimal e_adjustlocalamt = detailEntry.getBigDecimal("e_adjustlocalamt");
            if (detailEntry.getBigDecimal("e_unitprice").compareTo(BigDecimal.ZERO) == 0 || detailEntry.getBigDecimal("e_taxunitprice").compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("e_ispresent", (Object)Boolean.TRUE);
            }
            detailEntry.set("e_reclocalamt", (Object)e_reclocalamt);
            detailEntry.set("e_unverifyamt", (Object)e_amount);
            detailEntry.set("e_unlockamt", (Object)e_recAmount);
            detailEntry.set("e_unsettleamt", (Object)e_recAmount);
            detailEntry.set("e_unsettlelocalamt", (Object)e_reclocalamt);
            detailEntry.set("e_unconfirmamt", (Object)e_amount);
            detailEntry.set("e_invoicedamt", (Object)e_recAmount);
            detailEntry.set("e_invoicedlocalamt", (Object)e_reclocalamt);
            detailEntry.set("e_adjustamount", (Object)e_adjustamount);
            detailEntry.set("e_adjustlocalamt", (Object)e_adjustlocalamt);
            BigDecimal quantity = detailEntry.getBigDecimal("e_quantity");
            if (quantity == null) {
                quantity = BigDecimal.ZERO;
            }
            BigDecimal e_taxlocal = "1".equals(quotation) ? e_tax.divide(exchangerate, baseprecision, RoundingMode.HALF_UP) : e_tax.multiply(exchangerate).setScale(baseprecision, RoundingMode.HALF_UP);
            detailEntry.set("e_taxlocalamt", (Object)e_taxlocal);
            detailEntry.set("e_invoicedqty", (Object)quantity);
            detailEntry.set("e_uninvoicedqty", (Object)BigDecimal.ZERO);
            BigDecimal covertRate = detailEntry.getBigDecimal("e_unitcoefficient");
            boolean covertRateIsEmpty = covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
            DynamicObject material = detailEntry.getDynamicObject("e_material");
            DynamicObject measureUnit = detailEntry.getDynamicObject("e_measureunit");
            DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    detailEntry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRateIsEmpty) {
                    covertRate = this.queryUtil.getConvertRate(Long.valueOf(material.getLong("id")), Long.valueOf(measureUnit.getLong("id")), Long.valueOf(baseUnit.getLong("id")));
                }
            } else if (covertRateIsEmpty) {
                covertRate = BigDecimal.ONE;
            }
            if (covertRateIsEmpty) {
                detailEntry.set("e_unitcoefficient", (Object)covertRate);
            }
            if ((e_baseunitqty = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty.compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty((BigDecimal)quantity, (BigDecimal)covertRate, (DynamicObject)baseUnit));
            }
            detailEntry.set("e_unverifyqty", (Object)quantity);
            detailEntry.set("e_unconfirmqty", (Object)quantity);
        }
    }

    private boolean isPushAndSave(DynamicObject finArBill) {
        return BOTPHelper.isPushAndSave((ConvertRuleElement)this.getRule(), (DynamicObject)finArBill);
    }
}

