/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang.StringUtils;

public class BadDebtAccrualHelper {
    protected static Log logger = LogFactory.getLog(BadDebtAccrualHelper.class);
    protected static final String BADDEBT = "ar_baddebtpreparebill";

    public static DynamicObject getNextAccrualPeriod(Long periodId, String accrualFrequency) {
        DynamicObject result = null;
        DynamicObject curPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
        int periodYear = curPeriod.getInt("periodyear");
        int periodNumber = curPeriod.getInt("periodnumber");
        Long typePk = (Long)curPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)typePk);
        periodTypeFilter.and("isadjustperiod", "=", (Object)Boolean.FALSE);
        if ("quarter".equals(accrualFrequency)) {
            if (periodNumber < 3) {
                periodNumber = 3;
            } else if (periodNumber < 6) {
                periodNumber = 6;
            } else if (periodNumber < 9) {
                periodNumber = 9;
            } else if (periodNumber < 12) {
                periodNumber = 12;
            } else {
                periodNumber = 3;
                ++periodYear;
            }
        } else if ("semiannual".equals(accrualFrequency)) {
            if (periodNumber < 6) {
                periodNumber = 6;
            } else if (periodNumber < 12) {
                periodNumber = 12;
            } else {
                ++periodYear;
                periodNumber = 6;
            }
        } else if ("year".equals(accrualFrequency)) {
            if (periodNumber < 12) {
                periodNumber = 12;
            } else {
                ++periodYear;
                periodNumber = 12;
            }
        } else if (periodNumber < 12) {
            ++periodNumber;
        } else {
            ++periodYear;
            periodNumber = 1;
        }
        QFilter dateFilter = new QFilter("periodyear", "=", (Object)periodYear);
        dateFilter.and(new QFilter("periodnumber", "=", (Object)periodNumber));
        result = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter[]{periodTypeFilter, dateFilter});
        return result;
    }

    public static void insertNextPeriodBadDebtAccrue(Long orgId, Long periodId, Long prePeriodId, Long accrualSchemeId, Boolean isPeriod, String periodName, Long exratetableId) {
        DynamicObject badDebtAccrue = BusinessDataServiceHelper.newDynamicObject((String)"ar_baddebtaccrue");
        badDebtAccrue.set("org", (Object)orgId);
        badDebtAccrue.set("period", (Object)periodId);
        badDebtAccrue.set("preperiod", (Object)prePeriodId);
        badDebtAccrue.set("accrualstatus", (Object)"0");
        badDebtAccrue.set("isperiod", (Object)isPeriod);
        badDebtAccrue.set("listperiod", (Object)periodName);
        badDebtAccrue.set("accrualscheme", (Object)accrualSchemeId);
        badDebtAccrue.set("exratetable", (Object)exratetableId);
        Set<Long> oldDataIds = BadDebtAccrualHelper.validateBadDebtRecord(orgId, periodId);
        if (!oldDataIds.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ar_baddebtaccrue", (Object[])oldDataIds.toArray(new Long[0]), (OperateOption)option);
            if (!deleteResult.isSuccess()) {
                logger.info("------insertBadDebtRecord:operationResult.Message------" + deleteResult.getMessage());
                OperationHelper.assertResult((OperationResult)deleteResult);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{badDebtAccrue});
    }

    public static Set<Long> validateBadDebtRecord(Long orgId, Long periodId) {
        HashSet<Long> oldDataIds = new HashSet<Long>(8);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        QFilter periodfilter = new QFilter("period", "=", (Object)periodId);
        DynamicObject[] validateDatas = BusinessDataServiceHelper.load((String)"ar_baddebtaccrue", (String)"id,accrualstatus", (QFilter[])new QFilter[]{filter, periodfilter});
        if (EmptyUtils.isEmpty((Object)validateDatas)) {
            return oldDataIds;
        }
        for (DynamicObject validateData : validateDatas) {
            if ("1".equals(validateData.getString("accrualstatus"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u671f\u5b58\u5728\u5df2\u8ba1\u63d0\u6570\u636e\uff0c\u8bf7\u53cd\u8ba1\u63d0\u540e\u91cd\u8bd5\u3002", (String)"BadDebtAccrueHelper_0", (String)"fi-ar-common", (Object[])new Object[0]), new Object[0]));
            }
            oldDataIds.add(validateData.getLong("id"));
        }
        return oldDataIds;
    }

    public static List<String> getAgingGroupCols(Set<String> showQtyCols, List<AcctageGroup> groups) {
        ArrayList<String> balanceCols = new ArrayList<String>(2);
        for (String showQtyCol : showQtyCols) {
            if (!StringUtils.contains((String)showQtyCol, (String)"standard")) continue;
            for (AcctageGroup group : groups) {
                balanceCols.add(AcctageHelper.getAmountFieldName((AcctageGroup)group, (String)showQtyCol));
            }
        }
        return balanceCols;
    }

    public static void cancelAccrual(DynamicObject org, DynamicObject period, Boolean isDeleteRecord) {
        OperationResult deleteResult;
        OperateOption option;
        logger.info("\u5220\u9664\u7684\u7ec4\u7ec7\uff1a%s\uff0c\u671f\u95f4id\uff1a%s\uff0c\u671f\u95f4\u540d\u79f0\uff1a%s\uff0c\u662f\u5426\u5220\u8ba1\u63d0\u8bb0\u5f55\uff1a%s", new Object[]{org.getString("name"), EmptyUtils.isEmpty((Object)period) ? "0L" : period.getPkValue(), EmptyUtils.isEmpty((Object)period) ? "0L" : period.getString("name"), isDeleteRecord});
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter periodFilter = new QFilter("period", "=", EmptyUtils.isEmpty((Object)period) ? Long.valueOf(0L) : period.getPkValue());
        DynamicObject[] badDebtPrepareBill = BusinessDataServiceHelper.load((String)BADDEBT, (String)"id", (QFilter[])new QFilter[]{orgFilter, periodFilter});
        if (EmptyUtils.isNotEmpty((Object)badDebtPrepareBill)) {
            Object[] badDebtPrepareBillIds = (Long[])Arrays.stream(badDebtPrepareBill).map(bill -> bill.getLong("id")).toArray(Long[]::new);
            option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)BADDEBT, (Object[])badDebtPrepareBillIds, (OperateOption)option);
            if (!deleteResult.isSuccess()) {
                logger.info("------cancelAccrual:operationResult.Message------" + deleteResult.getMessage());
                OperationHelper.assertResult((OperationResult)deleteResult);
            }
        }
        DynamicObject badDebtRecord = BusinessDataServiceHelper.loadSingle((String)"ar_baddebtaccrue", (String)"id,accrualstatus", (QFilter[])new QFilter[]{orgFilter, periodFilter});
        if (isDeleteRecord.booleanValue()) {
            if (EmptyUtils.isNotEmpty((Object)badDebtRecord)) {
                option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ar_baddebtaccrue", (Object[])new Long[]{badDebtRecord.getLong("id")}, (OperateOption)option);
                if (!deleteResult.isSuccess()) {
                    logger.info("------cancelAccrual:deleteResult.Message------" + deleteResult.getMessage());
                    OperationHelper.assertResult((OperationResult)deleteResult);
                }
            }
        } else if (EmptyUtils.isNotEmpty((Object)badDebtRecord)) {
            badDebtRecord.set("accrualstatus", (Object)"0");
            SaveServiceHelper.update((DynamicObject)badDebtRecord);
        }
    }

    public static boolean validateFinArBillPlanIsSameEntry(MainEntityType entityType, DynamicObject ruleEntry) {
        List filterRow;
        CRCondition conditionObj;
        FilterCondition filterCondition;
        boolean isSame = true;
        boolean existMaterial = false;
        boolean existPlan = false;
        String conditionJson = ruleEntry.getString("c_condition_tag");
        if (conditionJson != null && !"".equals(conditionJson) && (filterCondition = (conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class)).getFilterCondition()) != null && EmptyUtils.isNotEmpty((Object)(filterRow = filterCondition.getFilterRow()))) {
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                String fieldName = simpleFilterRow.getFieldName();
                String[] sp = fieldName.split("\\.");
                IDataEntityProperty property = entityType.findProperty(sp[0]);
                if (property == null) continue;
                String parentName = property.getParent().getName();
                if ("entry".equals(parentName)) {
                    existMaterial = true;
                    continue;
                }
                if (!"planentity".equals(parentName)) continue;
                existPlan = true;
            }
            String c_agingStartDate = ruleEntry.getString("c_agingstartdate");
            if (!existMaterial && c_agingStartDate.startsWith("entry")) {
                existMaterial = true;
            } else if (!existPlan && c_agingStartDate.startsWith("planentity")) {
                existPlan = true;
            }
            if (existMaterial && existPlan) {
                isSame = false;
            }
        }
        return isSame;
    }

    public static boolean validateSchemeFieldIsMatchOrgSettleModel(MainEntityType entityType, DynamicObject ruleEntry, boolean isMaterialSettle) {
        List filterRow;
        CRCondition conditionObj;
        FilterCondition filterCondition;
        boolean isMatch = true;
        String conditionJson = ruleEntry.getString("c_condition_tag");
        String c_agingStartDate = ruleEntry.getString("c_agingstartdate");
        if (isMaterialSettle && c_agingStartDate.startsWith("planentity") || !isMaterialSettle && c_agingStartDate.startsWith("entry")) {
            return false;
        }
        if (conditionJson != null && !"".equals(conditionJson) && (filterCondition = (conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class)).getFilterCondition()) != null && EmptyUtils.isNotEmpty((Object)(filterRow = filterCondition.getFilterRow()))) {
            for (SimpleFilterRow simpleFilterRow : filterRow) {
                String fieldName = simpleFilterRow.getFieldName();
                String[] sp = fieldName.split("\\.");
                IDataEntityProperty property = entityType.findProperty(sp[0]);
                if (property == null) continue;
                String parentName = property.getParent().getName();
                if ((isMaterialSettle || !"entry".equals(parentName)) && (!isMaterialSettle || !"planentity".equals(parentName))) continue;
                return false;
            }
        }
        return isMatch;
    }
}

