/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.helper;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;

public class BaseDataHelper {
    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (date == null) {
            date = new Date();
        }
        if (sourceCurrencyId == 0L || targetCurrencyId == 0L || sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        InitHelper init = new InitHelper(orgId.longValue(), "ar_init");
        Long exchangeRateTableId = init.getExrateTable().getLong("id");
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        return exchangeRate;
    }

    public static DynamicObject getDefaultSettlementType() {
        QFilter[] settlementFilters = new QFilter[]{new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])settlementFilters);
    }

    public static boolean hasViewPermission(long orgId, String entityKey) {
        return BaseDataHelper.checkCurrentUserPermission(orgId, entityKey, "47150e89000000ac");
    }

    public static boolean hasNewPermission(long orgId, String entityKey) {
        return BaseDataHelper.checkCurrentUserPermission(orgId, entityKey, "47156aff000000ac");
    }

    public static boolean checkCurrentUserPermission(long orgId, String entityKey, String permissionItem) {
        return BaseDataHelper.checkPermission(RequestContext.get().getCurrUserId(), orgId, entityKey, permissionItem);
    }

    public static boolean checkPermission(long userId, long orgId, String entityKey, String permissionItemKey) {
        int res = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"ar", (String)entityKey, (String)permissionItemKey);
        return res == 1;
    }
}

