/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArBillHelper {
    public static void setAcctAgeCalcDate(DynamicObject bill, Map<Long, Boolean> orgMap) {
        DynamicObject busbill;
        DynamicObject invoice;
        long orgPk = (Long)bill.getDynamicObject("org").getPkValue();
        boolean ar010 = false;
        if (!orgMap.containsKey(orgPk)) {
            ar010 = SystemParameterHelper.getParameterBoolean(orgPk, "ar_010");
            orgMap.put(orgPk, ar010);
        } else {
            ar010 = orgMap.get(orgPk);
        }
        if (ar010 && "ar_invoice".equals(bill.getString("sourcebilltype")) && "ar_busbill".equals((invoice = BusinessDataServiceHelper.loadSingle((Object)bill.getLong("sourcebillid"), (String)"ar_invoice", (String)"sourcebilltype, sourcebillid")).getString("sourcebilltype")) && !ObjectUtils.isEmpty((Object)(busbill = BusinessDataServiceHelper.loadSingle((Object)invoice.getLong("sourcebillid"), (String)"ar_busbill", (String)"bizdate")))) {
            bill.set("acctagecalcdate", (Object)busbill.getDate("bizdate"));
        }
        if (ObjectUtils.isEmpty((Object)bill.getDate("acctagecalcdate"))) {
            bill.set("acctagecalcdate", (Object)bill.getDate("bizdate"));
        }
    }

    public static void writeOffCheck(IDataModel model, IFormView formView, BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        String message = FinArBillHelper.getWriteOffCheckMessage(operationKey, model.getDataEntity());
        if (EmptyUtils.isEmpty((Object)message)) {
            return;
        }
        formView.showTipNotification(message);
        evt.setCancel(true);
    }

    public static void writeOffCheck(DynamicObject entity, IFormView formView, BeforeDoOperationEventArgs evt) {
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String key = operate.getOperateKey();
        String message = FinArBillHelper.getWriteOffCheckMessage(key, entity);
        if (EmptyUtils.isEmpty((Object)message)) {
            return;
        }
        formView.showTipNotification(message);
        evt.setCancel(true);
    }

    private static String getWriteOffCheckMessage(String operateKey, DynamicObject entity) {
        if (!"writeoff".equals(operateKey)) {
            return "";
        }
        Set invoiceIdList = BOTPHelper.findTarBillIds((String)entity.getDataEntityType().getName(), (Long)entity.getLong("id"), (String)"ar_invoice");
        if (EmptyUtils.isEmpty((Object)invoiceIdList)) {
            return "";
        }
        boolean appointBill = QueryServiceHelper.exists((String)"ar_invoice", (QFilter[])new QFilter("id", "in", (Object)invoiceIdList).and(new QFilter("sourcebillid", "=", (Object)"")).and(new QFilter("sourcebilltype", "=", (Object)"")).toArray());
        if (appointBill) {
            String billNo = entity.getString("billno");
            return ResManager.loadKDString((String)"%s\u5df2\u88ab\u5f00\u7968\u5355\u6307\u5b9a\uff0c\u8bf7\u5148\u53d6\u6d88\u6307\u5b9a\u518d\u51b2\u9500\u3002", (String)"FinArBillHelper_0", (String)"fi-ar-common", (Object[])new Object[]{billNo});
        }
        return "";
    }

    public static String getWriteOffCheckMessage(DynamicObject entity) {
        Set invoiceIdList = BOTPHelper.findTarBillIds((String)entity.getDataEntityType().getName(), (Long)entity.getLong("id"), (String)"ar_invoice");
        if (EmptyUtils.isEmpty((Object)invoiceIdList)) {
            return "";
        }
        boolean appointBill = QueryServiceHelper.exists((String)"ar_invoice", (QFilter[])new QFilter("id", "in", (Object)invoiceIdList).and(new QFilter("sourcebillid", "=", (Object)"")).and(new QFilter("sourcebilltype", "=", (Object)"")).toArray());
        if (appointBill) {
            String billNo = entity.getString("billno");
            return ResManager.loadKDString((String)"%s\u5df2\u88ab\u5f00\u7968\u5355\u6307\u5b9a\uff0c\u8bf7\u5148\u53d6\u6d88\u6307\u5b9a\u518d\u51b2\u9500\u3002", (String)"FinArBillHelper_0", (String)"fi-ar-common", (Object[])new Object[]{billNo});
        }
        return "";
    }

    public static void setImptCustomers(List<DynamicObject> datas) {
        Set asstactIdSet = datas.stream().map(t -> t.getLong("asstact.id")).collect(Collectors.toSet());
        Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"delivercustomerid,invoicecustomerid,paymentcustomerid,bizfunction", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIdSet)});
        for (DynamicObject entity : datas) {
            Object asstactId = entity.get("asstact.id");
            DynamicObject customer = null;
            if (asstactMap != null) {
                customer = (DynamicObject)asstactMap.get(asstactId);
            }
            if (customer == null) continue;
            DynamicObject invCusId = customer.getDynamicObject("invoicecustomerid");
            DynamicObject delCusId = customer.getDynamicObject("delivercustomerid");
            DynamicObject payCusId = customer.getDynamicObject("paymentcustomerid");
            if (entity.get("paymentcustomerid") == null) {
                entity.set("paymentcustomerid", (Object)payCusId);
            }
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("entry");
            String bizFunction = customer.getString("bizfunction");
            for (DynamicObject entry : entries) {
                if (entry.get("e_invoicecustomerid") == null && bizFunction.contains("1")) {
                    entry.set("e_invoicecustomerid", (Object)invCusId);
                }
                if (entry.get("e_delivercustomerid") != null) continue;
                entry.set("e_delivercustomerid", (Object)delCusId);
            }
        }
    }

    @Deprecated
    public static Map<String, Object> setCustomersToViewCash(IDataModel m, IPageCache cash) {
        return FinArBillHelper.setCustomersToViewCash(m);
    }

    public static Map<String, Object> setCustomersToViewCash(IDataModel m) {
        HashMap<String, Object> customersMap = new HashMap<String, Object>(8);
        String asstactType = (String)m.getValue("asstacttype");
        DynamicObject asstact = (DynamicObject)m.getValue("asstact");
        if (asstact == null) {
            return customersMap;
        }
        if ("bd_customer".equals(asstactType)) {
            DynamicObject asstactCache = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)"bd_customer", (String)"invoicecustomerid,paymentcustomerid,delivercustomerid,bizfunction");
            m.setValue("paymentcustomerid", asstactCache.get("paymentcustomerid.id"));
            String bizFunction = asstactCache.getString("bizfunction");
            Long invoiceCustomerId = asstactCache.getLong("invoicecustomerid.id");
            Long deliverCustomerId = asstactCache.getLong("delivercustomerid.id");
            if (bizFunction.contains("1") && invoiceCustomerId != 0L) {
                customersMap.put("invoiceCustomerId", invoiceCustomerId.toString());
            }
            if (deliverCustomerId != 0L) {
                customersMap.put("deliverCustomerId", deliverCustomerId.toString());
            }
        }
        return customersMap;
    }

    public static void setCustomersToBill(DynamicObject finArBill) {
        String asstactType = finArBill.getString("asstacttype");
        DynamicObject asstact = finArBill.getDynamicObject("asstact");
        if (asstact == null) {
            return;
        }
        if ("bd_customer".equals(asstactType)) {
            Long asstactId = asstact.getLong("id");
            Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"delivercustomerid,invoicecustomerid,paymentcustomerid,bizfunction", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)asstactId)});
            DynamicObject customer = (DynamicObject)asstactMap.get(asstactId);
            if (customer == null) {
                return;
            }
            finArBill.set("paymentcustomerid", (Object)customer.getDynamicObject("paymentcustomerid"));
            DynamicObjectCollection targetBillEntries = finArBill.getDynamicObjectCollection("entry");
            for (DynamicObject targetBillEntry : targetBillEntries) {
                String bizFunction = customer.getString("bizfunction");
                if (bizFunction.contains("1")) {
                    targetBillEntry.set("e_invoicecustomerid", (Object)customer.getDynamicObject("invoicecustomerid"));
                }
                targetBillEntry.set("e_delivercustomerid", (Object)customer.getDynamicObject("delivercustomerid"));
            }
        }
    }
}

