/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;

public class FinarPremHelper {
    public static boolean isPushPremiumBill(Object[] pks) {
        List pksString = Arrays.stream(pks).map(Object::toString).collect(Collectors.toList());
        QFilter qf = new QFilter("sourcebillid", "in", pksString);
        qf.and("ispremium", "=", (Object)Boolean.TRUE);
        qf.and("sourcebilltype", "=", (Object)"ar_finarbill");
        qf.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter[]{qf});
    }

    public static List<DynamicObject> gettargetFinPrem(DynamicObject entity) {
        HashSet finBillIds;
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"ar_finarbill", (Long[])new Long[]{(Long)entity.getPkValue()});
        List<Object> finPrems = new ArrayList<DynamicObject>(targetBills.size());
        if (!targetBills.isEmpty() && !ObjectUtils.isEmpty((Object)(finBillIds = (HashSet)targetBills.get("ar_finarbill")))) {
            DynamicObject[] finBills = BusinessDataServiceHelper.load((Object[])finBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ar_finarbill"));
            finPrems = Arrays.stream(finBills).filter(bill -> bill.getBoolean("ispremium")).collect(Collectors.toList());
        }
        return finPrems;
    }

    public static void writeOff(List<Long> srcBillIDs) {
        Long[] srcBillIDArr = srcBillIDs.toArray(new Long[srcBillIDs.size()]);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"ar_finarbill", (Long[])srcBillIDArr);
        if (ObjectUtils.isEmpty((Object)targetBills)) {
            return;
        }
        HashSet targetFinPKSet = (HashSet)targetBills.get("ar_finarbill");
        if (ObjectUtils.isEmpty((Object)targetFinPKSet)) {
            return;
        }
        QFilter premFilter = new QFilter("id", "in", (Object)targetFinPKSet);
        premFilter.and(new QFilter("ispremium", "=", (Object)Boolean.TRUE));
        Object[] premBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,ispremium", (QFilter[])new QFilter[]{premFilter});
        if (ObjectUtils.isEmpty((Object[])premBills)) {
            return;
        }
        HashSet<String> targetFinPremPKSet = new HashSet<String>();
        for (Object premBill : premBills) {
            targetFinPremPKSet.add(premBill.getPkValue().toString());
        }
        QFilter writeFilter = new QFilter("sourcebillid", "in", targetFinPremPKSet);
        writeFilter.and("iswrittenoff", "=", (Object)Boolean.TRUE);
        DynamicObject[] writeOffBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,sourcebillid,iswrittenoff", (QFilter[])new QFilter[]{writeFilter});
        Object[] writeOffPKs = new Object[writeOffBills.length];
        for (int i = 0; i < writeOffBills.length; ++i) {
            writeOffPKs[i] = writeOffBills[i].getPkValue();
        }
        OperateOption unduitop = OperateOption.create();
        unduitop.setVariableValue("fiar_unaduit_mode", "auto");
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ar_finarbill", (Object[])writeOffPKs, (OperateOption)unduitop);
    }
}

