/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ViewverHelper {
    public static void itemClick(ItemClickEvent evt, IDataModel model, IFormView view, boolean isList) {
        ListShowParameter parameter;
        List<Object> vrPKs;
        String verifyRecordName;
        Object[] pks;
        Object pk = 0L;
        String key = evt.getItemKey();
        if (isList) {
            BillList billList = (BillList)view.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            pks = selectedRows.getPrimaryKeyValues();
            if (selectedRows.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ViewverHelper_0", (String)"fi-ar-common", (Object[])new Object[0]));
                return;
            }
            if ("viewver".equals(key) && pks.length != 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8054\u67e5\u3002", (String)"ViewverHelper_1", (String)"fi-ar-common", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow row = selectedRows.get(0);
            pk = row.getPrimaryKeyValue();
        } else {
            pk = model.getDataEntity().getPkValue();
            pks = new Object[]{pk};
        }
        if ("viewver".equals(key)) {
            Set<Long> vrPKs2 = ViewverHelper.getBillVerifyRecordPKs(pk);
            if (!vrPKs2.isEmpty()) {
                ListShowParameter parameter2 = new ListShowParameter();
                String billFormId = CommonVerifyServiceHelper.isFiVerifyRecord(vrPKs2, (boolean)true) ? "ar_verifyrecord" : "cal_salwfrecord";
                parameter2.setBillFormId(billFormId);
                parameter2.setLookUp(true);
                parameter2.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                ListFilterParameter param = new ListFilterParameter();
                param.setFilter(new QFilter("id", "in", vrPKs2));
                parameter2.setListFilterParameter(param);
                parameter2.setCustomParam("billId", pk);
                parameter2.setCustomParam("entity", (Object)"ar_finarbill");
                view.showForm((FormShowParameter)parameter2);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6838\u9500\u8bb0\u5f55\u3002", (String)"ViewverHelper_2", (String)"fi-ar-common", (Object[])new Object[0]));
            }
        } else if ("viewver_arrev".equals(key)) {
            String entityName;
            verifyRecordName = "ar_revcrm_verifyrecord";
            if (isList) {
                String entityId = ((ListView)view).getBillFormId();
                entityName = FormMetadataCache.getFormConfig((String)entityId).getEntityTypeId();
            } else {
                entityName = model.getDataEntityType().getName();
            }
            List<Object> vrPKs3 = ViewverHelper.getVerifyRecordPKs(pks, entityName, verifyRecordName);
            if (!vrPKs3.isEmpty()) {
                ListShowParameter parameter3 = new ListShowParameter();
                parameter3.setBillFormId(verifyRecordName);
                parameter3.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                ListFilterParameter param = new ListFilterParameter();
                param.setFilter(new QFilter("id", "in", vrPKs3));
                parameter3.setListFilterParameter(param);
                parameter3.setCustomParam("isView", (Object)Boolean.TRUE);
                view.showForm((FormShowParameter)parameter3);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6838\u9500\u8bb0\u5f55\u3002", (String)"ViewverHelper_2", (String)"fi-ar-common", (Object[])new Object[0]));
            }
        } else if ("viewvr_oriwf".equals(key)) {
            verifyRecordName = "ar_originalwfrecord";
            vrPKs = ViewverHelper.getVerifyRecordPKs(pks, "ar_finarbill", verifyRecordName);
            if (!vrPKs.isEmpty()) {
                parameter = new ListShowParameter();
                parameter.setBillFormId(verifyRecordName);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                ListFilterParameter param = new ListFilterParameter();
                param.setFilter(new QFilter("id", "in", vrPKs));
                parameter.setListFilterParameter(param);
                parameter.setCustomParam("isView", (Object)Boolean.TRUE);
                view.showForm((FormShowParameter)parameter);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6838\u9500\u8bb0\u5f55\u3002", (String)"ViewverHelper_2", (String)"fi-ar-common", (Object[])new Object[0]));
            }
        } else if ("viewvr_saloutwf".equals(key)) {
            verifyRecordName = "ar_saloutwfrecord";
            vrPKs = ViewverHelper.getVerifyRecordPKs(pks, "ar_finarbill", verifyRecordName);
            if (!vrPKs.isEmpty()) {
                parameter = new ListShowParameter();
                parameter.setBillFormId(verifyRecordName);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                ListFilterParameter param = new ListFilterParameter();
                param.setFilter(new QFilter("id", "in", vrPKs));
                parameter.setListFilterParameter(param);
                parameter.setCustomParam("isView", (Object)Boolean.TRUE);
                view.showForm((FormShowParameter)parameter);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6838\u9500\u8bb0\u5f55\u3002", (String)"ViewverHelper_2", (String)"fi-ar-common", (Object[])new Object[0]));
            }
        }
    }

    private static boolean isMain(String entityName, String verifyRecordName) {
        if ("ar_originalwfrecord".equals(verifyRecordName) || "ar_saloutwfrecord".equals(verifyRecordName)) {
            return true;
        }
        return "ar_revcrm_verifyrecord".equals(verifyRecordName) && "ar_finarbill".equals(entityName);
    }

    private static List<Object> getVerifyRecordPKs(Object[] billIds, String entityName, String verifyRecordName) {
        List<Object> verifyRecordPKs = new ArrayList<Object>(8);
        if (billIds == null || billIds.length == 0 || StringUtils.isEmpty((String)entityName)) {
            return verifyRecordPKs;
        }
        boolean isMain = ViewverHelper.isMain(entityName, verifyRecordName);
        QFilter filter = isMain ? new QFilter("entry.billid", "in", (Object)billIds) : new QFilter("entry.assbillid", "in", (Object)billIds);
        verifyRecordPKs = QueryServiceHelper.queryPrimaryKeys((String)verifyRecordName, (QFilter[])filter.toArray(), (String)"", (int)-1);
        return verifyRecordPKs;
    }

    public static Set<Long> getBillVerifyRecordPKs(Object billId) {
        return ViewverHelper.getBillVerifyRecordPKs(new Object[]{billId}, "ar_revcfmbill");
    }

    public static Set<Long> getBillVerifyRecordPKs(Object[] billIds, String entityName) {
        HashSet<Long> billTypeSet = new HashSet<Long>(8);
        if (billIds == null || billIds.length == 0 || StringUtils.isEmpty((String)entityName)) {
            return billTypeSet;
        }
        QFilter mainFilter = new QFilter("billid", "in", (Object)billIds);
        QFilter asstFilter = new QFilter("entry.e_billid", "in", (Object)billIds);
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)entityName, (Object[])billIds, (boolean)true);
        asstFilter.and(commonFilter);
        DataSet vr4Mains = QueryServiceHelper.queryDataSet((String)"queryVR4Main", (String)"ar_verifyrecord", (String)"id", (QFilter[])new QFilter[]{mainFilter}, null);
        for (Row vr4Main : vr4Mains) {
            billTypeSet.add(vr4Main.getLong("id"));
        }
        DataSet vr4Assts = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ar_verifyrecord", (String)"id", (QFilter[])new QFilter[]{asstFilter}, null);
        for (Row vr4Asst : vr4Assts) {
            billTypeSet.add(vr4Asst.getLong("id"));
        }
        return billTypeSet;
    }

    @Deprecated
    public static Set<Long> getBillVerifyRecordPKs(Object[] billIds) {
        HashSet<Long> billTypeSet = new HashSet<Long>(8);
        if (billIds == null || billIds.length == 0) {
            return billTypeSet;
        }
        DataSet vr4Mains = QueryServiceHelper.queryDataSet((String)"queryVR4Main", (String)"ar_verifyrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("billid", "in", (Object)billIds)}, null);
        for (Row vr4Main : vr4Mains) {
            billTypeSet.add(vr4Main.getLong("id"));
        }
        DataSet vr4Assts = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ar_verifyrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("entry.e_billid", "in", (Object)billIds)}, null);
        for (Row vr4Asst : vr4Assts) {
            billTypeSet.add(vr4Asst.getLong("id"));
        }
        return billTypeSet;
    }
}

