/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.helper.FinArBillHelper;
import kd.fi.ar.helper.SystemParameterHelper;
import kd.fi.ar.vo.CheckResult;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class WriteoffVerify {
    private static final String WRITE_OFF_PROS = "org,id,billno,sourcebilltype,billstatus, settlestatus, iswrittenoff, verifystatus, entry, e_lockedamt, e_settledamt, hadwrittenoff, planentity, planlockedamt, plansettledamt,ispremium,billsrctype";

    public static CheckResult check(Object[] pks, boolean isCheckInv) {
        DynamicObject[] revAdjustBills;
        DynamicObject[] finArBills;
        CheckResult result = new CheckResult();
        if (ObjectUtils.isEmpty((Object[])pks)) {
            result.setMessage(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WriteoffVerify_11", (String)"fi-ar-common", (Object[])new Object[0]));
            result.setIspass(false);
            return result;
        }
        ArrayList<String> billIds4Msmod = new ArrayList<String>(pks.length);
        ArrayList<String> billIds = new ArrayList<String>(pks.length);
        for (Object pk2 : pks) {
            billIds.add(pk2.toString());
            billIds4Msmod.add("ar_finarbill#" + pk2.toString());
        }
        List unFinishedIds = TxCheckUtil.loadUnfinishedTx((String)"ar_verify", billIds);
        List unFinishedIds4Msmod = TxCheckUtil.getLocked(billIds4Msmod);
        HashMap<Long, Integer> settleModelParam = new HashMap<Long, Integer>(2);
        Set<Long> pkSet = Stream.of(pks).map(pk -> (Long)pk).collect(Collectors.toSet());
        Map dirtTargetBillMap = BOTPHelper.findDirtTargetBillMap((String)"ar_finarbill", (Long[])pkSet.toArray(new Long[0]));
        QFilter qf = new QFilter("istransfer", "=", (Object)Boolean.TRUE);
        qf.and("sourcebilltype", "=", (Object)"ar_finarbill");
        List pkList = Stream.of(pks).map(String::valueOf).collect(Collectors.toList());
        qf.and("sourcebillid", "in", pkList);
        DynamicObjectCollection transferBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"sourcebillid", (QFilter[])new QFilter[]{qf});
        Set isTransferPks = transferBills.stream().map(transferBill -> transferBill.getLong("sourcebillid")).collect(Collectors.toSet());
        String[] pksStr = (String[])Arrays.stream(pks).map(Object::toString).toArray(String[]::new);
        QFilter sourceBillFilter = new QFilter("sourcebilltype", "=", (Object)"ar_finarbill");
        sourceBillFilter.and("sourcebillid", "in", (Object)pksStr);
        QFilter premiumFilter = new QFilter("ispremium", "=", (Object)Boolean.TRUE);
        DynamicObject[] premiumBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"sourcebillid,entry.e_settledamt,entry.e_lockedamt", (QFilter[])new QFilter[]{sourceBillFilter, premiumFilter});
        Map<Long, List<DynamicObject>> premiumBillsMap = Stream.of(premiumBills).collect(Collectors.groupingBy(premiumBill -> premiumBill.getLong("sourcebillid")));
        QFilter qFilter = new QFilter("id", "in", (Object)pks);
        for (DynamicObject finArBill : finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)WRITE_OFF_PROS, (QFilter[])new QFilter[]{qFilter})) {
            String message;
            long finPK;
            Map targetBills;
            BigDecimal settledAmt;
            BigDecimal lockedAmt;
            Long id = finArBill.getLong("id");
            String billno = finArBill.getString("billno");
            billno = billno + ":";
            if (BillSrcTypeEnum.FROMEAS.getValue().equals(finArBill.getString("billsrctype"))) {
                result.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u8d22\u52a1\u5e94\u6536\u5355\u4e3aEAS\u96c6\u6210\u65b9\u6848\u540c\u6b65\u7684\u5355\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\u6027\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_14", (String)"fi-ar-common", (Object[])new Object[0]), billno));
                result.setIspass(false);
                return result;
            }
            if (unFinishedIds.contains(String.valueOf(id)) || unFinishedIds4Msmod.contains("ar_finarbill#" + id)) {
                result.setMessage(ResManager.loadKDString((String)"%s\u5b58\u5728\u672a\u5b8c\u6210\u7684\u6838\u9500\u5206\u5e03\u5f0f\u4e8b\u52a1\uff0c\u4e0d\u80fd\u51b2\u9500\uff0c\u8bf7\u901a\u8fc7\u2018\u8054\u67e5-\u8054\u67e5\u4e8b\u52a1\u65e5\u5fd7\u2019\u529f\u80fd\u67e5\u770b\u5bf9\u5e94\u7684\u4fe1\u606f\u6216\u5728\u2018\u914d\u7f6e\u5de5\u5177-\u5206\u5e03\u5f0f\u4e8b\u52a1-\u4e8b\u52a1\u67e5\u8be2\u2019\u83dc\u5355\u67e5\u770b\u76f8\u5173\u4fe1\u606f\u3002", (String)"WriteoffVerify_10", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(finArBill.getString("billstatus"))) {
                result.setMessage(ResManager.loadKDString((String)"%s\u51b2\u9500\u5931\u8d25\uff0c\u8bf7\u5ba1\u6838\u540e\u91cd\u8bd5\u3002", (String)"WriteoffVerify_0", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (finArBill.getBoolean("ispremium")) {
                result.setMessage(ResManager.loadKDString((String)"%s\u8d28\u4fdd\u91d1\u5355\u636e\u4e0d\u80fd\u51b2\u9500\u3002", (String)"WriteoffVerify_12", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (isCheckInv && "sim_original_bill".equals(finArBill.get("sourcebilltype"))) {
                result.setMessage(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u6536\u5355%s\u6839\u636e\u5f00\u7968\u7533\u8bf7\u5355\u751f\u6210\uff0c\u8bf7\u5728\u53d1\u7968\u4e91\u8fdb\u884c\u7ea2\u51b2\u6216\u4f5c\u5e9f\u51b2\u9500\u8d22\u52a1\u5e94\u6536\u5355\u3002", (String)"WriteoffVerify_1", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            long orgId = finArBill.getDynamicObject("org").getLong("id");
            if (finArBill.getBoolean("iswrittenoff")) {
                result.setMessage(ResManager.loadKDString((String)"%s\u51b2\u9500\u5355\u636e\u65e0\u6cd5\u518d\u6b21\u51b2\u9500\u3002", (String)"WriteoffVerify_2", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            if (finArBill.getBoolean("hadwrittenoff")) {
                result.setMessage(ResManager.loadKDString((String)"\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u5df2\u7ecf\u88ab\u51b2\u9500,\u4e0d\u5141\u8bb8\u518d\u6b21\u51b2\u9500\u3002", (String)"WriteoffVerify_3", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                result.setIspass(false);
                return result;
            }
            Integer ar003 = (Integer)settleModelParam.get(orgId);
            if (EmptyUtils.isEmpty((Object)ar003)) {
                ar003 = SystemParameterHelper.getParameterInteger(orgId, "ar_003");
                settleModelParam.put(orgId, ar003);
            }
            if (ar003 == 1) {
                DynamicObjectCollection entries = finArBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry2 : entries) {
                    lockedAmt = entry2.getBigDecimal("e_lockedamt");
                    settledAmt = entry2.getBigDecimal("e_settledamt");
                    if (lockedAmt == null || settledAmt == null || lockedAmt.compareTo(settledAmt) == 0) continue;
                    result.setMessage(ResManager.loadKDString((String)"\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u7684\u4e0b\u6e38\u5355\u636e\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_4", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                    result.setIspass(false);
                    return result;
                }
            } else if (ar003 == 2) {
                DynamicObjectCollection entries = finArBill.getDynamicObjectCollection("planentity");
                for (DynamicObject entry2 : entries) {
                    lockedAmt = entry2.getBigDecimal("planlockedamt");
                    settledAmt = entry2.getBigDecimal("plansettledamt");
                    if (lockedAmt == null || settledAmt == null || lockedAmt.compareTo(settledAmt) == 0) continue;
                    result.setMessage(ResManager.loadKDString((String)"\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u7684\u4e0b\u6e38\u5355\u636e\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_4", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                    result.setIspass(false);
                    return result;
                }
            }
            if ((targetBills = (Map)dirtTargetBillMap.get(finPK = finArBill.getLong("id"))) != null) {
                Set keySet = targetBills.keySet();
                if (keySet.contains("ar_liquidation")) {
                    result.setMessage(ResManager.loadKDString((String)"\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u5df2\u8fdb\u884c\u8fc7\u6e05\u7406\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_5", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                    result.setIspass(false);
                    return result;
                }
                if (keySet.contains("ar_baddebtlossbill")) {
                    result.setMessage(ResManager.loadKDString((String)"\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u5df2\u8fdb\u884c\u8fc7\u574f\u8d26\u635f\u5931\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_6", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                    result.setIspass(false);
                    return result;
                }
                if (isTransferPks.contains(finArBill.getLong("id"))) {
                    result.setMessage(ResManager.loadKDString((String)"\u5355\u636e\uff08\u7f16\u53f7\uff1a%s\uff09\u5df2\u8fdb\u884c\u8fc7\u503a\u6743\u8f6c\u79fb\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_7", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                    result.setIspass(false);
                    return result;
                }
                List<DynamicObject> finprems = premiumBillsMap.get(finPK);
                if (EmptyUtils.isEmpty(finprems)) continue;
                for (DynamicObject finprem : finprems) {
                    DynamicObjectCollection prmentries = finprem.getDynamicObjectCollection("entry");
                    for (DynamicObject entry3 : prmentries) {
                        BigDecimal lockedAmt2 = entry3.getBigDecimal("e_lockedamt");
                        BigDecimal settledAmt2 = entry3.getBigDecimal("e_settledamt");
                        if (lockedAmt2 == null || settledAmt2 == null || lockedAmt2.compareTo(settledAmt2) == 0) continue;
                        result.setMessage(ResManager.loadKDString((String)"%s\u4e0b\u6e38\u8d28\u4fdd\u91d1\u5355\u636e\u5b58\u5728\u4e0b\u6e38\u5355\u636e\u5904\u4e8e\u5728\u9014\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_13", (String)"fi-ar-common", (Object[])new Object[]{billno}));
                        result.setIspass(false);
                        return result;
                    }
                }
            }
            if (!EmptyUtils.isNotEmpty((Object)(message = FinArBillHelper.getWriteOffCheckMessage(finArBill)))) continue;
            result.setMessage(message);
            result.setIspass(false);
            return result;
        }
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"entry.revbillid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", (Object)pks)});
        Set revAdjustBillIds = Arrays.stream(records).map(record -> record.getDynamicObjectCollection("entry")).flatMap(Collection::stream).map(entry -> entry.getLong("revbillid")).collect(Collectors.toSet());
        for (DynamicObject revAdjustBill : revAdjustBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"fbillno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", revAdjustBillIds)})) {
            if ("C".equals(revAdjustBill.getString("billstatus"))) continue;
            result.setMessage(ResManager.loadKDString((String)"\u901a\u8fc7\u5e94\u6536\u6536\u5165\u6838\u9500\u751f\u6210\u7684\u8c03\u6574\u7c7b\u578b\u7684\u6536\u5165\u786e\u8ba4\u5355\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"WriteoffVerify_9", (String)"fi-ar-common", (Object[])new Object[0]));
            result.setIspass(false);
            return result;
        }
        return result;
    }
}

