/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class GBKUtils {
    private static final Log LOGGER = LogFactory.getLog(GBKUtils.class);

    public static Integer getGBKLength(String content) {
        if (null == content || content.length() == 0) {
            return 0;
        }
        try {
            byte[] bs = content.getBytes("GBK");
            ByteBuffer buf = ByteBuffer.wrap(bs);
            return buf.capacity();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u89e3\u7801\u5f02\u5e38", (Throwable)e);
            return 0;
        }
    }

    public static boolean checkValidGbk(String content) {
        return true;
    }

    public static void CheckGBKLength(String content, String propertyName, int maxLength) {
        int gbkLength = GBKUtils.getGBKLength(content);
        if (gbkLength > maxLength) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e%2%d,\u4e00\u4e2a\u6c49\u5b57\u5360\u4e24\u4e2a\u5b57\u8282", (String)"GBKUtils_0", (String)"fi-ar-common", (Object[])new Object[0]), propertyName, maxLength));
        }
    }

    public static String cutGBKString(String str, int len) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        String cutStr = "";
        try {
            byte[] b = str.getBytes("GBK");
            if (b.length < len) {
                return str;
            }
            int count = 0;
            for (int i = len - 1; i >= 0 && b[i] < 0; --i) {
                ++count;
            }
            cutStr = count % 2 == 0 ? new String(b, 0, len, "GBK") : new String(b, 0, len - 1, "GBK");
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u7801\u5f02\u5e38", (Throwable)e);
            return str;
        }
        return cutStr;
    }

    public static String splitAndBuildGbkStr(String str, int gbkLen) {
        if (GBKUtils.getGBKLength(str) < gbkLen) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char aChar : chars) {
            int newGbkLen = GBKUtils.getGBKLength(sb.toString());
            if (newGbkLen - 1 == gbkLen) {
                return sb.toString().substring(0, sb.toString().length() - 1);
            }
            if (GBKUtils.getGBKLength(sb.toString()) == gbkLen) {
                return sb.toString();
            }
            sb.append(aChar);
        }
        return "";
    }
}

