/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.vo;

import java.io.Serializable;
import java.util.Date;
import kd.fi.ar.util.DateUtils;

public class AcctAgeGroup
implements Serializable {
    private static final long serialVersionUID = -6532015739747326977L;
    private String name;
    private Integer beginDay;
    private Integer endDay;
    private String remark;
    private Date compareDate;

    public AcctAgeGroup() {
    }

    public AcctAgeGroup(String name, Integer beginDay, Integer endDay) {
        this(name, beginDay, endDay, null);
    }

    public AcctAgeGroup(String name, Integer beginDay, Integer endDay, Date compareDate) {
        this.name = name;
        this.beginDay = beginDay;
        this.endDay = endDay;
        this.compareDate = compareDate;
    }

    public boolean match(Date date) {
        if (date == null) {
            return this.beginDay == null;
        }
        int diffDays = DateUtils.getDiffDays(date, this.compareDate);
        if (this.beginDay != null && this.endDay != null) {
            return diffDays >= this.beginDay && diffDays <= this.endDay;
        }
        if (this.beginDay == null) {
            return diffDays <= this.endDay;
        }
        if (this.endDay == null) {
            return diffDays >= this.beginDay;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getBeginDay() {
        return this.beginDay;
    }

    public void setBeginDay(Integer beginDay) {
        this.beginDay = beginDay;
    }

    public Integer getEndDay() {
        return this.endDay;
    }

    public void setEndDay(Integer endDay) {
        this.endDay = endDay;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCompareDate() {
        return this.compareDate;
    }

    public void setCompareDate(Date compareDate) {
        this.compareDate = compareDate;
    }
}

