/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.tx.AsyncTx;
import kd.fi.arapcommon.tx.AsyncTxService;

public class AbandonInvoiceService {
    private static Log logger = LogFactory.getLog(AbandonInvoiceService.class);

    public String abandonInvoice(String param) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew((String)"AbandonInvoiceService");){
            logger.info("AbandonInvoiceService_abandonInvoice:" + param);
            List datas = (List)JSONObject.parseObject((String)param, List.class);
            ArrayList<AsyncTx> txs = new ArrayList<AsyncTx>(datas.size());
            for (Map data : datas) {
                AsyncTx asyncTx = new AsyncTx();
                asyncTx.setGroup("ar_invoice");
                asyncTx.setAction("AbandonCallBack");
                asyncTx.setTask("AbandonCallBack");
                asyncTx.setXid((String)data.get("billNo"));
                asyncTx.setParam((Object)data);
                asyncTx.setExecuteClass("kd.fi.ar.business.invoice.AbandonInvoiceApiPlugin");
                txs.add(asyncTx);
            }
            AsyncTxService asyncTxService = new AsyncTxService();
            asyncTxService.save(txs.toArray(new AsyncTx[0]));
            ThreadPools.executeOnceIncludeRequestContext((String)"Invoice.Abandon.CallBack", () -> {
                for (AsyncTx tx : txs) {
                    asyncTxService.executeWithTx(tx);
                }
            });
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(true);
            apiResult.setMessage("Abandon Invoice Success");
            LogUtil.addInvokeLog((String)"AbandonInvoiceService.abandonInvoice", (Object[])new Object[]{param}, null, (boolean)true);
            String string = JSONObject.toJSONString((Object)apiResult);
            return string;
        }
        catch (Exception e) {
            txHandle.markRollback();
            ApiResult apiResult = new ApiResult();
            apiResult.setSuccess(false);
            apiResult.setMessage("Abandon Invoice Fail:" + e.getMessage());
            LogUtil.addInvokeErrorLog((String)"AbandonInvoiceService.abandonInvoice", (Object[])new Object[]{param}, (Throwable)e, (boolean)true);
            String string = JSONObject.toJSONString((Object)apiResult);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }
}

